export declare const RULES: {
    readonly "async-component-flags": "async-component-flags";
    readonly "csp-unsafe-inline-script": "csp-unsafe-inline-script";
    readonly "no-ambiguous-event-handler": "no-ambiguous-event-handler";
    readonly "no-deprecated-api": "no-deprecated-api";
    readonly "no-deprecated-component": "no-deprecated-component";
    readonly "no-deprecated-control-renderer-declaration": "no-deprecated-control-renderer-declaration";
    readonly "no-deprecated-library": "no-deprecated-library";
    readonly "no-deprecated-theme": "no-deprecated-theme";
    readonly "no-globals": "no-globals";
    readonly "no-implicit-globals": "no-implicit-globals";
    readonly "no-pseudo-modules": "no-pseudo-modules";
    readonly "parsing-error": "parsing-error";
    readonly "autofix-error": "autofix-error";
    readonly "ui5-class-declaration": "ui5-class-declaration";
    readonly "unsupported-api-usage": "unsupported-api-usage";
    readonly "prefer-test-starter": "prefer-test-starter";
};
export declare enum LintMessageSeverity {
    Warning = 1,
    Error = 2
}
export declare enum MESSAGE {
    ABANDONED_BOOTSTRAP_PARAM = 0,
    ABANDONED_BOOTSTRAP_PARAM_ERROR = 1,
    COMPONENT_MISSING_ASYNC_INTERFACE = 2,
    COMPONENT_MISSING_MANIFEST_DECLARATION = 3,
    COMPONENT_REDUNDANT_ASYNC_FLAG = 4,
    CSP_UNSAFE_INLINE_SCRIPT = 5,
    DEPRECATED_API_ACCESS = 6,
    DEPRECATED_BOOTSTRAP_PARAM = 7,
    DEPRECATED_CLASS = 8,
    DEPRECATED_INTERFACE = 9,
    DEPRECATED_TYPE = 10,
    DEPRECATED_COMPONENT = 11,
    DEPRECATED_DECLARATIVE_SUPPORT = 12,
    DEPRECATED_FUNCTION_CALL = 13,
    DEPRECATED_LESS_SUPPORT = 14,
    DEPRECATED_LIBRARY = 15,
    DEPRECATED_MANIFEST_JS_RESOURCES = 16,
    DEPRECATED_MODULE_IMPORT_NAMED = 17,
    DEPRECATED_MODULE_IMPORT = 18,
    DEPRECATED_ODATA_MODEL_V4_SYNCHRONIZATION_MODE = 19,
    DEPRECATED_PROPERTY = 20,
    DEPRECATED_PROPERTY_OF_CLASS = 21,
    DEPRECATED_THEME = 22,
    DEPRECATED_VIEW_TYPE = 23,
    DUPLICATE_BOOTSTRAP_PARAM = 24,
    HTML_IN_XML = 25,
    LIB_INIT_API_VERSION = 26,
    MISSING_BOOTSTRAP_PARAM = 27,
    NO_AMBIGUOUS_EVENT_HANDLER = 28,
    NO_CONTROL_RERENDER_OVERRIDE = 29,
    NO_DEPRECATED_RENDERER = 30,
    NO_DIRECT_DATATYPE_ACCESS = 31,
    NO_DIRECT_ENUM_ACCESS = 32,
    NO_EXPORTED_VALUES_BY_LIB = 33,
    NO_GLOBALS = 34,
    NO_ICON_POOL_RENDERER = 35,
    NO_LEGACY_TEMPLATE_REQUIRE_SYNTAX = 36,
    NO_ODATA_GLOBALS = 37,
    NOT_STATIC_CONTROL_RENDERER = 38,
    PARSING_ERROR = 39,
    AUTOFIX_ERROR = 40,
    PARTIALLY_DEPRECATED_CORE_ROUTER = 41,
    PARTIALLY_DEPRECATED_CREATE_COMPONENT = 42,
    PARTIALLY_DEPRECATED_JSON_MODEL_LOAD_DATA = 43,
    PARTIALLY_DEPRECATED_MOBILE_INIT = 44,
    PARTIALLY_DEPRECATED_ODATA_MODEL_V2_CREATE_ENTRY = 45,
    PARTIALLY_DEPRECATED_ODATA_MODEL_V2_CREATE_ENTRY_PROPERTIES_ARRAY = 46,
    PARTIALLY_DEPRECATED_PARAMETERS_GET = 47,
    PARTIALLY_DEPRECATED_VIEW_CREATE = 48,
    PARTIALLY_DEPRECATED_FRAGMENT_LOAD = 49,
    PARTIALLY_DEPRECATED_CONTROLLER_LOAD_FRAGMENT = 50,
    PREFER_TEST_STARTER = 51,
    REDUNDANT_BOOTSTRAP_PARAM = 52,
    REDUNDANT_BOOTSTRAP_PARAM_ERROR = 53,
    REDUNDANT_VIEW_CONFIG_PROPERTY = 54,
    REPLACED_BOOTSTRAP_PARAM = 55,
    SPELLING_BOOTSTRAP_PARAM = 56,
    STRING_FOR_FORMATTER_VALUE_IN_JS = 57,
    SVG_IN_XML = 58,
    MISSING_CONTROL_RENDERER_DECLARATION = 59,
    CONTROL_RENDERER_DECLARATION_STRING = 60
}
export declare const MESSAGE_INFO: {
    readonly 0: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ name }: {
            name: string;
        }) => string;
        readonly details: ({ messageDetails }: {
            messageDetails?: string;
        }) => string | undefined;
    };
    readonly 1: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ name }: {
            name: string;
        }) => string;
        readonly details: ({ messageDetails }: {
            messageDetails?: string;
        }) => string | undefined;
    };
    readonly 2: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "async-component-flags";
        readonly message: () => string;
        readonly details: ({ componentFileName, asyncFlagMissingIn }: {
            componentFileName: string;
            asyncFlagMissingIn: string;
        }) => string;
    };
    readonly 3: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "async-component-flags";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 4: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "async-component-flags";
        readonly message: ({ asyncFlagLocation }: {
            asyncFlagLocation: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 5: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "csp-unsafe-inline-script";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 6: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ apiName }: {
            apiName: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 7: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ name, value }: {
            name: string;
            value: string;
        }) => string;
        readonly details: ({ details }: {
            details?: string;
        }) => string | undefined;
    };
    readonly 8: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ className }: {
            className: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 9: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ interfaceName }: {
            interfaceName: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 10: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ typeName }: {
            typeName: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 11: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-component";
        readonly message: ({ componentName }: {
            componentName: string;
        }) => string;
        readonly details: () => undefined;
    };
    readonly 12: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 13: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ functionName, additionalMessage }: {
            functionName: string;
            additionalMessage: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 14: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 15: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-library";
        readonly message: ({ libraryName }: {
            libraryName: string;
        }) => string;
        readonly details: () => undefined;
    };
    readonly 16: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 17: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ importName, moduleName }: {
            importName: string;
            moduleName: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 18: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ moduleName }: {
            moduleName: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 19: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ modelName }: {
            modelName?: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 20: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ propertyName, namespace }: {
            propertyName: string;
            namespace?: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 21: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ propertyName, className }: {
            propertyName: string;
            className: string;
        }) => string;
        readonly details: ({ details }: {
            details: string;
        }) => string;
    };
    readonly 22: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-theme";
        readonly message: ({ themeName }: {
            themeName: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 23: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ viewType }: {
            viewType: string;
        }) => string;
        readonly details: () => undefined;
    };
    readonly 24: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ name, value }: {
            name: string;
            value: string;
        }) => string;
        readonly details: () => undefined;
    };
    readonly 27: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ name }: {
            name: string;
        }) => string;
        readonly details: ({ details }: {
            details?: string;
        }) => string | undefined;
    };
    readonly 25: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 26: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ libInitFunction }: {
            libInitFunction: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 28: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "no-ambiguous-event-handler";
        readonly message: ({ eventHandler }: {
            eventHandler: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 29: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ className }: {
            className: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 30: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 35: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 36: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ moduleNames }: {
            moduleNames: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 38: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "ui5-class-declaration";
        readonly message: ({ className }: {
            className?: string;
        }) => string;
        readonly details: () => undefined;
    };
    readonly 31: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-pseudo-modules";
        readonly message: ({ moduleName }: {
            moduleName: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 32: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-pseudo-modules";
        readonly message: ({ moduleName }: {
            moduleName: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 34: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-globals";
        readonly message: ({ variableName, namespace }: {
            variableName: string;
            namespace: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 39: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "parsing-error";
        readonly fatal: true;
        readonly message: ({ message }: {
            message: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 40: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "autofix-error";
        readonly message: ({ message }: {
            message: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 41: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 42: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 43: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ paramName }: {
            paramName: string;
        }) => string;
        readonly details: ({ paramName }: {
            paramName: string;
        }) => string;
    };
    readonly 44: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ paramName }: {
            paramName: string;
        }) => string;
        readonly details: ({ paramName }: {
            paramName: string;
        }) => string;
    };
    readonly 45: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 46: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 47: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 48: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ typeValue }: {
            typeValue: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 49: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ typeValue }: {
            typeValue: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 50: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ typeValue }: {
            typeValue: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 52: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ name }: {
            name: string;
        }) => string;
        readonly details: ({ messageDetails }: {
            messageDetails?: string;
        }) => string | undefined;
    };
    readonly 53: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ name }: {
            name: string;
        }) => string;
        readonly details: ({ messageDetails }: {
            messageDetails?: string;
        }) => string | undefined;
    };
    readonly 54: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ propertyName }: {
            propertyName: string;
        }) => string;
        readonly details: () => undefined;
    };
    readonly 56: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ oldName, newName }: {
            oldName: string;
            newName: string;
        }) => string;
        readonly details: () => undefined;
    };
    readonly 57: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "unsupported-api-usage";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 58: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 59: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-control-renderer-declaration";
        readonly message: ({ className }: {
            className: string;
        }) => string;
        readonly details: ({ className }: {
            className: string;
        }) => string;
    };
    readonly 60: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-control-renderer-declaration";
        readonly message: ({ className, rendererName }: {
            className: string;
            rendererName: string | undefined;
        }) => string;
        readonly details: ({ className, rendererName }: {
            className: string;
            rendererName: string | undefined;
        }) => string;
    };
    readonly 51: {
        readonly severity: LintMessageSeverity.Warning;
        readonly ruleId: "prefer-test-starter";
        readonly message: () => string;
        readonly details: () => string;
    };
    readonly 55: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-deprecated-api";
        readonly message: ({ name, replacement }: {
            name: string;
            replacement: string;
        }) => string;
        readonly details: ({ messageDetails }: {
            messageDetails: string;
        }) => string;
    };
    readonly 33: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-implicit-globals";
        readonly message: ({ module, namespace, libraryName }: {
            module: string;
            namespace: string;
            libraryName: string;
        }) => string;
        readonly details: () => string;
    };
    readonly 37: {
        readonly severity: LintMessageSeverity.Error;
        readonly ruleId: "no-implicit-globals";
        readonly message: () => string;
        readonly details: () => string;
    };
};
