import ts from "typescript";
import { PositionInfo } from "../../LinterContext.js";
import BaseFix, { BaseFixParams } from "./BaseFix.js";
import { FixHelpers } from "./Fix.js";
import { Ui5TypeInfo } from "../Ui5TypeInfo.js";
export type AccessExpressionBaseFixParams = BaseFixParams;
/**
 * Fix a property access. This could also be the property access of a call expression, allowing for a more general
 * replacement in cases where the arguments or other conditions of the call expression do not matter.
 */
export default abstract class AccessExpressionBaseFix extends BaseFix {
    protected params: AccessExpressionBaseFixParams;
    protected nodeTypes: ts.SyntaxKind[];
    private containedAccessExpressionCount;
    constructor(params: AccessExpressionBaseFixParams, ui5TypeInfo: Ui5TypeInfo);
    visitLinterNode(node: ts.Node, sourcePosition: PositionInfo, _helpers: FixHelpers): boolean;
    visitAutofixNode(node: ts.Node, position: number, sourceFile: ts.SourceFile): boolean;
}
