declare module "sap/suite/ui/commons/BulletChartMode" {
	import {BulletChartMode} from "sap/suite/ui/commons/library";

	/**
	 * Enumeration of possible BulletChart display modes.
	 *
	 * @deprecated (since 1.34) - Deprecated. sap.suite.ui.microchart.BulletMicroChartModeType should be used.
	 * @public
	*/
	export default BulletChartMode;
}

declare module "sap/suite/ui/commons/CalculationBuilderComparisonOperatorType" {
	import {CalculationBuilderComparisonOperatorType} from "sap/suite/ui/commons/library";

	/**
	 * Comparison operators supported by the calculation builder.
	 *
	 * @public
	*/
	export default CalculationBuilderComparisonOperatorType;
}

declare module "sap/suite/ui/commons/CalculationBuilderFunctionType" {
	import {CalculationBuilderFunctionType} from "sap/suite/ui/commons/library";

	/**
	 * Functions supported by the calculation builder.<br> To add a custom function, use {@link sap.suite.ui.commons.CalculationBuilderFunction}.
	 *
	 * @public
	*/
	export default CalculationBuilderFunctionType;
}

declare module "sap/suite/ui/commons/CalculationBuilderItemType" {
	import {CalculationBuilderItemType} from "sap/suite/ui/commons/library";

	/**
	 * The types of items (operands) that can be used in a calculation builder expression.
	 *
	 * @public
	*/
	export default CalculationBuilderItemType;
}

declare module "sap/suite/ui/commons/CalculationBuilderLayoutType" {
	import {CalculationBuilderLayoutType} from "sap/suite/ui/commons/library";

	/**
	 * Layout of the calculation builder.
	 *
	 * @public
	*/
	export default CalculationBuilderLayoutType;
}

declare module "sap/suite/ui/commons/CalculationBuilderLogicalOperatorType" {
	import {CalculationBuilderLogicalOperatorType} from "sap/suite/ui/commons/library";

	/**
	 * Logical operators supported by the calculation builder.
	 *
	 * @public
	*/
	export default CalculationBuilderLogicalOperatorType;
}

declare module "sap/suite/ui/commons/CalculationBuilderOperatorType" {
	import {CalculationBuilderOperatorType} from "sap/suite/ui/commons/library";

	/**
	 * Arithmetic operators supported by the calculation builder.
	 *
	 * @public
	*/
	export default CalculationBuilderOperatorType;
}

declare module "sap/suite/ui/commons/CalculationBuilderValidationMode" {
	import {CalculationBuilderValidationMode} from "sap/suite/ui/commons/library";

	/**
	 * Types of expression validation that define when the expression entered into the {@link sap.suite.ui.commons.CalculationBuilder} is validated.
	 *
	 * @public
	*/
	export default CalculationBuilderValidationMode;
}

declare module "sap/suite/ui/commons/CommonBackground" {
	import {CommonBackground} from "sap/suite/ui/commons/library";

	/**
	 * Enumeration of possible theme specific background colors.
	 *
	 * @deprecated (since 1.34) - Deprecated. Moved to sapui5.runtime.
	 * @public
	*/
	export default CommonBackground;
}

declare module "sap/suite/ui/commons/ComparisonChartView" {
	import {ComparisonChartView} from "sap/suite/ui/commons/library";

	/**
	 * The view of the ComparisonChart.
	 *
	 * @deprecated (since 1.34) - Deprecated. sap.suite.ui.microchart.ComparisonMicroChartViewType should be used.
	 * @public
	*/
	export default ComparisonChartView;
}

declare module "sap/suite/ui/commons/DeviationIndicator" {
	import {DeviationIndicator} from "sap/suite/ui/commons/library";

	/**
	 * The marker for the deviation trend.
	 *
	 * @deprecated (since 1.34) - Deprecated. Moved to sapui5.runtime.
	 * @public
	*/
	export default DeviationIndicator;
}

declare module "sap/suite/ui/commons/FacetOverviewHeight" {
	import {FacetOverviewHeight} from "sap/suite/ui/commons/library";

	/**
	 * Enumeration of possible FacetOverview height settings.
	 *
	 * @deprecated (since 1.32) - Deprecated. Object page should be used instead.
	 * @public
	*/
	export default FacetOverviewHeight;
}

declare module "sap/suite/ui/commons/FilePickerModes" {
	import {FilePickerModes} from "sap/suite/ui/commons/library";

	/**
	 * Modes for the {@link sap.suite.ui.commons.CloudFilePicker}.
	 *
	 * @public
	*/
	export default FilePickerModes;
}

declare module "sap/suite/ui/commons/FilePickerType" {
	import {FilePickerType} from "sap/suite/ui/commons/library";

	/**
	 * Runtime mode for the {@link sap.suite.ui.commons.CloudFilePicker}.
	 *
	 * @public
	*/
	export default FilePickerType;
}

declare module "sap/suite/ui/commons/FrameType" {
	import {FrameType} from "sap/suite/ui/commons/library";

	/**
	 * Enumeration of possible frame types.
	 *
	 * @deprecated (since 1.34) - Deprecated. Moved to openUI5.
	 * @public
	*/
	export default FrameType;
}

declare module "sap/suite/ui/commons/HeaderContainerView" {
	import {HeaderContainerView} from "sap/suite/ui/commons/library";

	/**
	 * The list of possible HeaderContainer views.
	 *
	 * @deprecated (since 1.48) - This control is deprecated since 1.48. Please use the equivalent sap.ui.core.Orientation.
	 * @public
	*/
	export default HeaderContainerView;
}

declare module "sap/suite/ui/commons/ImageEditorContainerButton" {
	import {ImageEditorContainerButton} from "sap/suite/ui/commons/library";

	/**
	 * Action buttons for the {@link sap.suite.ui.commons.imageeditor.ImageEditorContainer}.
	 *
	 * @public
	*/
	export default ImageEditorContainerButton;
}

declare module "sap/suite/ui/commons/ImageEditorContainerMode" {
	import {ImageEditorContainerMode} from "sap/suite/ui/commons/library";

	/**
	 * Mode types for {@link sap.suite.ui.commons.imageeditor.ImageEditorContainer}.
	 *
	 * @public
	*/
	export default ImageEditorContainerMode;
}

declare module "sap/suite/ui/commons/ImageEditorMode" {
	import {ImageEditorMode} from "sap/suite/ui/commons/library";

	/**
	 * Mode types for {@link sap.suite.ui.commons.imageeditor.ImageEditor}.
	 *
	 * @public
	*/
	export default ImageEditorMode;
}

declare module "sap/suite/ui/commons/ImageFormat" {
	import {ImageFormat} from "sap/suite/ui/commons/library";

	/**
	 * Image file format.
	 *
	 * @public
	*/
	export default ImageFormat;
}

declare module "sap/suite/ui/commons/InfoTileSize" {
	import {InfoTileSize} from "sap/suite/ui/commons/library";

	/**
	 * Enumeration of possible PointTile size settings.
	 *
	 * @deprecated (since 1.34) - Deprecated. sap.m.InfoTileSize should be used.
	 * @public
	*/
	export default InfoTileSize;
}

declare module "sap/suite/ui/commons/InfoTileTextColor" {
	import {InfoTileTextColor} from "sap/suite/ui/commons/library";

	/**
	 * Enumeration of possible InfoTile text color settings.
	 *
	 * @deprecated (since 1.34) - Deprecated. sap.m.InfoTileTextColor should be used.
	 * @public
	*/
	export default InfoTileTextColor;
}

declare module "sap/suite/ui/commons/InfoTileValueColor" {
	import {InfoTileValueColor} from "sap/suite/ui/commons/library";

	/**
	 * Enumeration of possible InfoTile value color settings.
	 *
	 * @deprecated (since 1.34) - Deprecated. sap.m.InfoTileValueColor should be used.
	 * @public
	*/
	export default InfoTileValueColor;
}

declare module "sap/suite/ui/commons/LayoutType" {
	import {LayoutType} from "sap/suite/ui/commons/library";

	/**
	 * Supported Layout Types for {@link sap.suite.ui.commons.BaseContainer}.
	 *
	 * @public
	*/
	export default LayoutType;
}

declare module "sap/suite/ui/commons/LoadState" {
	import {LoadState} from "sap/suite/ui/commons/library";

	/**
	 * Enumeration of possible load states for LoadableView.
	 *
	 * @deprecated (since 1.34) - Deprecated. sap.m.LoadState should be used.
	 * @public
	*/
	export default LoadState;
}

declare module "sap/suite/ui/commons/MicroAreaChartView" {
	import {MicroAreaChartView} from "sap/suite/ui/commons/library";

	/**
	 * The list of possible MicroAreaChart views.
	 *
	 * @deprecated (since 1.34) - Deprecated. sap.suite.ui.microchart.AreaMicroChartViewType should be used.
	 * @public
	*/
	export default MicroAreaChartView;
}

declare module "sap/suite/ui/commons/MicroProcessFlowRenderType" {
	import {MicroProcessFlowRenderType} from "sap/suite/ui/commons/library";

	/**
	 * Options that define how the micro process flow should be rendered inside its parent container. <br>These options can be useful when the width of the parent container does not allow for all nodes in the micro process flow to be displayed on the same line.
	 *
	 * @public
	*/
	export default MicroProcessFlowRenderType;
}

declare module "sap/suite/ui/commons/networkgraph/ActionButtonPosition" {
	import {networkgraph} from "sap/suite/ui/commons/library";

	/**
	 * Position of a custom action button.
	 *
	 * @public
	*/
	export default networkgraph.ActionButtonPosition;
}

declare module "sap/suite/ui/commons/networkgraph/BackgroundColor" {
	import {networkgraph} from "sap/suite/ui/commons/library";

	/**
	 * Background color for the network graph.
	 *
	 * @public
	*/
	export default networkgraph.BackgroundColor;
}

declare module "sap/suite/ui/commons/networkgraph/ElementStatus" {
	import {networkgraph} from "sap/suite/ui/commons/library";

	/**
	 * Semantic type of the node status.
	 *
	 * @public
	*/
	export default networkgraph.ElementStatus;
}

declare module "sap/suite/ui/commons/networkgraph/HeaderCheckboxState" {
	import {networkgraph} from "sap/suite/ui/commons/library";

	/**
	 * States of the Header checkbox.
	 *
	 * @public
	*/
	export default networkgraph.HeaderCheckboxState;
}

declare module "sap/suite/ui/commons/networkgraph/LayoutRenderType" {
	import {networkgraph} from "sap/suite/ui/commons/library";

	/**
	 * Types of layout algorithms that define the visual features and layout of the network graph.
	 *
	 * @public
	*/
	export default networkgraph.LayoutRenderType;
}

declare module "sap/suite/ui/commons/networkgraph/LineArrowOrientation" {
	import {networkgraph} from "sap/suite/ui/commons/library";

	/**
	 * Direction of the arrow on the connector line.
	 *
	 * @public
	*/
	export default networkgraph.LineArrowOrientation;
}

declare module "sap/suite/ui/commons/networkgraph/LineArrowPosition" {
	import {networkgraph} from "sap/suite/ui/commons/library";

	/**
	 * Position of the arrow on a connector line.
	 *
	 * @public
	*/
	export default networkgraph.LineArrowPosition;
}

declare module "sap/suite/ui/commons/networkgraph/LineType" {
	import {networkgraph} from "sap/suite/ui/commons/library";

	/**
	 * Type of connector line used in the network graph.
	 *
	 * @public
	*/
	export default networkgraph.LineType;
}

declare module "sap/suite/ui/commons/networkgraph/NodePlacement" {
	import {networkgraph} from "sap/suite/ui/commons/library";

	/**
	 * Type of node placement for Layered Algorithm. See {@link https://rtsys.informatik.uni-kiel.de/confluence/display/KIELER/KLay+Layered+Layout+Options#KLayLayeredLayoutOptions-nodePlacement}
	 *
	 * @public
	*/
	export default networkgraph.NodePlacement;
}

declare module "sap/suite/ui/commons/networkgraph/NodeShape" {
	import {networkgraph} from "sap/suite/ui/commons/library";

	/**
	 * Shape of a node in a network graph.
	 *
	 * @public
	*/
	export default networkgraph.NodeShape;
}

declare module "sap/suite/ui/commons/networkgraph/Orientation" {
	import {networkgraph} from "sap/suite/ui/commons/library";

	/**
	 * Orientation of layered layout.
	 *
	 * @public
	*/
	export default networkgraph.Orientation;
}

declare module "sap/suite/ui/commons/networkgraph/RenderType" {
	import {networkgraph} from "sap/suite/ui/commons/library";

	/**
	 * Determines how nodes are rendered. For optimal performance and usability, it is recommended that you use HTML, which allows you to avoid dealing with SVG limitations.
	 *
	 * @public
	*/
	export default networkgraph.RenderType;
}

declare module "sap/suite/ui/commons/ProcessFlowConnectionLabelState" {
	import {ProcessFlowConnectionLabelState} from "sap/suite/ui/commons/library";

	/**
	 * Describes the state of a connection label.
	 *
	 * @public
	*/
	export default ProcessFlowConnectionLabelState;
}

declare module "sap/suite/ui/commons/ProcessFlowConnectionState" {
	import {ProcessFlowConnectionState} from "sap/suite/ui/commons/library";

	/**
	 * Describes the state of a connection.
	 *
	 * @public
	*/
	export default ProcessFlowConnectionState;
}

declare module "sap/suite/ui/commons/ProcessFlowConnectionType" {
	import {ProcessFlowConnectionType} from "sap/suite/ui/commons/library";

	/**
	 * Describes the type of a connection.
	 *
	 * @public
	*/
	export default ProcessFlowConnectionType;
}

declare module "sap/suite/ui/commons/ProcessFlowDisplayState" {
	import {ProcessFlowDisplayState} from "sap/suite/ui/commons/library";

	/**
	 * The ProcessFlow calculates the ProcessFlowDisplayState based on the 'focused' and 'highlighted' properties of each node.
	 *
	 * @public
	*/
	export default ProcessFlowDisplayState;
}

declare module "sap/suite/ui/commons/ProcessFlowLaneState" {
	import {ProcessFlowLaneState} from "sap/suite/ui/commons/library";

	/**
	 * This type is used in the 'state' property of the ProcessFlowLaneHeader. For example, app developers can set the status of the lane header if lanes are displayed without documents. If the complete process flow is displayed (that is, if the lane header is displayed with documents underneath), the given state values of the lane header are ignored and will be calculated in the ProcessFlow according to the current state of the documents.
	 *
	 * @public
	*/
	export default ProcessFlowLaneState;
}

declare module "sap/suite/ui/commons/ProcessFlowNodeState" {
	import {ProcessFlowNodeState} from "sap/suite/ui/commons/library";

	/**
	 * Describes the state connected to the content it is representing in the Process Flow Node. The state is also displayed in the Process Flow Lane Header as a color segment of the donut.
	 *
	 * @public
	*/
	export default ProcessFlowNodeState;
}

declare module "sap/suite/ui/commons/ProcessFlowNodeType" {
	import {ProcessFlowNodeType} from "sap/suite/ui/commons/library";

	/**
	 * Describes the type of a node. The type value could be single or aggregated. With this type, the application can define if several nodes should be displayed as one aggregated node in a path per column to represent a grouping of semantically equal nodes.
	 *
	 * @public
	*/
	export default ProcessFlowNodeType;
}

declare module "sap/suite/ui/commons/ProcessFlowZoomLevel" {
	import {ProcessFlowZoomLevel} from "sap/suite/ui/commons/library";

	/**
	 * The zoom level defines level of details for the node and how much space the process flow requires.
	 *
	 * @public
	*/
	export default ProcessFlowZoomLevel;
}

declare module "sap/suite/ui/commons/SelectionModes" {
	import {SelectionModes} from "sap/suite/ui/commons/library";

	/**
	 * File selection mode(Upload) for the {@link sap.suite.ui.commons.CloudFilePicker}.
	 *
	 * @public
	*/
	export default SelectionModes;
}

declare module "sap/suite/ui/commons/SelectionState" {
	import {SelectionState} from "sap/suite/ui/commons/library";

	/**
	 * SelectionState
	 *
	 * @deprecated (since 1.48) - This Enumeration is deprecated as it is not used anywhere.
	 * @public
	*/
	export default SelectionState;
}

declare module "sap/suite/ui/commons/statusindicator/FillingDirectionType" {
	import {statusindicator} from "sap/suite/ui/commons/library";

	/**
	 * The direction of animation.<br>
	 * 
	 * The direction types <code>Up</code>, <code>Down</code>, <code>Left</code>, and <code>Right</code> are available when {@link sap.suite.ui.commons.statusindicator.FillingType} is set to <code>Linear</code>.<br> The direction types <code>Clockwise</code> and <code>Counterclockwise</code> are available when {@link sap.suite.ui.commons.statusindicator.FillingType} is set to <code>Circular</code>.
	 *
	 * @public
	*/
	export default statusindicator.FillingDirectionType;
}

declare module "sap/suite/ui/commons/statusindicator/FillingType" {
	import {statusindicator} from "sap/suite/ui/commons/library";

	/**
	 * The type of filling.
	 *
	 * @public
	*/
	export default statusindicator.FillingType;
}

declare module "sap/suite/ui/commons/statusindicator/HorizontalAlignmentType" {
	import {statusindicator} from "sap/suite/ui/commons/library";

	/**
	 * The horizontal alignment of the status indicator within its parent container.
	 *
	 * @public
	*/
	export default statusindicator.HorizontalAlignmentType;
}

declare module "sap/suite/ui/commons/statusindicator/LabelPositionType" {
	import {statusindicator} from "sap/suite/ui/commons/library";

	/**
	 * Position of the label, relative to the status indicator.
	 *
	 * @public
	*/
	export default statusindicator.LabelPositionType;
}

declare module "sap/suite/ui/commons/statusindicator/SizeType" {
	import {statusindicator} from "sap/suite/ui/commons/library";

	/**
	 * Predefined sizes of the status indicator.
	 *
	 * @public
	*/
	export default statusindicator.SizeType;
}

declare module "sap/suite/ui/commons/statusindicator/VerticalAlignmentType" {
	import {statusindicator} from "sap/suite/ui/commons/library";

	/**
	 * The vertical alignment of the status indicator within its parent container.
	 *
	 * @public
	*/
	export default statusindicator.VerticalAlignmentType;
}

declare module "sap/suite/ui/commons/taccount/TAccountPanelState" {
	import {taccount} from "sap/suite/ui/commons/library";

	/**
	 * The state of the {@link sap.suite.ui.commons.taccount.TAccountPanel} that defines how T accounts included in the panel are displayed.
	 *
	 * @public
	*/
	export default taccount.TAccountPanelState;
}

declare module "sap/suite/ui/commons/ThingGroupDesign" {
	import {ThingGroupDesign} from "sap/suite/ui/commons/library";

	/**
	 * Defines the way how UnifiedThingGroup control is rendered.
	 *
	 * @deprecated (since 1.32) - Deprecated. Object page should be used instead.
	 * @public
	*/
	export default ThingGroupDesign;
}

declare module "sap/suite/ui/commons/TimelineAlignment" {
	import {TimelineAlignment} from "sap/suite/ui/commons/library";

	/**
	 * The alignment of timeline posts relative to the timeline axis.
	 *
	 * @public
	*/
	export default TimelineAlignment;
}

declare module "sap/suite/ui/commons/TimelineAxisOrientation" {
	import {TimelineAxisOrientation} from "sap/suite/ui/commons/library";

	/**
	 * Defines the orientation of the timeline axis.
	 *
	 * @public
	*/
	export default TimelineAxisOrientation;
}

declare module "sap/suite/ui/commons/TimelineFilterType" {
	import {TimelineFilterType} from "sap/suite/ui/commons/library";

	/**
	 * Filter type for the timeline.
	 *
	 * @public
	*/
	export default TimelineFilterType;
}

declare module "sap/suite/ui/commons/TimelineGroupType" {
	import {TimelineGroupType} from "sap/suite/ui/commons/library";

	/**
	 * Type of grouping for timeline entries.
	 *
	 * @public
	*/
	export default TimelineGroupType;
}

declare module "sap/suite/ui/commons/TimelineScrollingFadeout" {
	import {TimelineScrollingFadeout} from "sap/suite/ui/commons/library";

	/**
	 * Type of the fadeout effect applied to the upper and lower margins of the visible timeline area.
	 *
	 * @deprecated (since 1.54.0) - Not Fiori.
	 * @public
	*/
	export default TimelineScrollingFadeout;
}

declare module "sap/suite/ui/commons/ValueStatus" {
	import {ValueStatus} from "sap/suite/ui/commons/library";

	/**
	 * Marker for the key value status.
	 *
	 * @deprecated (since 1.32) - Deprecated. Numeric content or any other standard Fiori control should be used instead.
	 * @public
	*/
	export default ValueStatus;
}
