import ts from "typescript";
import { FixHints } from "../LinterContext.js";
import type { ApiExtract } from "../../utils/ApiExtract.js";
import { AbstractAdapter } from "@ui5/fs";
import type { AmbientModuleCache } from "./AmbientModuleCache.js";
import type TypeLinter from "./TypeLinter.js";
interface DeprecationInfo {
    symbol: ts.Symbol;
    messageDetails: string;
}
export default class SourceFileLinter {
    #private;
    private typeLinter;
    private sourceFile;
    private checker;
    private reportCoverage;
    private messageDetails;
    private fix;
    private apiExtract;
    private filePathsWorkspace;
    private workspace;
    private ambientModuleCache;
    private manifestContent?;
    private resourcePath;
    constructor(typeLinter: TypeLinter, sourceFile: ts.SourceFile, checker: ts.TypeChecker, reportCoverage: boolean | undefined, messageDetails: boolean | undefined, fix: boolean | undefined, apiExtract: ApiExtract, filePathsWorkspace: AbstractAdapter, workspace: AbstractAdapter, ambientModuleCache: AmbientModuleCache, manifestContent?: string | undefined);
    lint(): Promise<void>;
    visitNode(node: ts.Node): void;
    isUi5ClassDeclaration(node: ts.Node, baseClassModule: string | string[]): node is ts.ClassDeclaration;
    analyzeControlRendererDeclaration(node: ts.ClassDeclaration): void;
    analyzeControlRendererInternals(node: ts.Node): void;
    analyzeIconCallInRenderMethod(node: ts.Node): void;
    analyzeControlRerenderMethod(node: ts.ClassDeclaration): void;
    analyzeMetadataProperty(node: ts.PropertyAssignment): void;
    analyzeIdentifier(node: ts.Identifier): boolean;
    analyzeObjectBindingPattern(node: ts.ObjectBindingPattern): void;
    analyzeNewExpression(node: ts.NewExpression): void;
    extractNamespace(node: ts.PropertyAccessExpression | ts.ElementAccessExpression | ts.CallExpression): string;
    /**
     * Extracts the sap.ui API namespace from a symbol name and a module declaration
     * (from @sapui5/types sap.ui.core.d.ts), e.g. sap.ui.view.
     */
    extractSapUiNamespace(symbolName: string, moduleDeclaration: ts.ModuleDeclaration): string | undefined;
    getDeprecationText(deprecatedTag: ts.JSDocTagInfo): string;
    getDeprecationInfo(symbol: ts.Symbol | undefined): DeprecationInfo | null;
    analyzeCallExpression(node: ts.CallExpression): void;
    getSymbolModuleDeclaration(symbol: ts.Symbol): ts.ModuleDeclaration | undefined;
    getDeprecationInfoForAccess(node: ts.AccessExpression): DeprecationInfo | null;
    analyzePropertyAccessExpressionForDeprecation(node: ts.AccessExpression): boolean;
    handleCallExpressionUnknownType(nodeType: ts.Type, node: ts.CallExpression): void;
    isGlobalThis(nodeType: string): boolean;
    analyzeExportedValuesByLib(node: ts.PropertyAccessExpression | ts.ElementAccessExpression): void;
    analyzePropertyAccessExpression(node: ts.AccessExpression | ts.CallExpression): void;
    isAllowedPropertyAccess(node: ts.PropertyAccessExpression | ts.ElementAccessExpression): boolean;
    analyzeImportDeclaration(importDeclarationNode: ts.ImportDeclaration): void;
    isSymbolOfUi5Type(symbol: ts.Symbol): boolean;
    isSymbolOfUi5OrThirdPartyType(symbol: ts.Symbol): boolean;
    isSymbolOfJquerySapType(symbol: ts.Symbol): boolean;
    isSymbolOfPseudoModuleType(symbol: ts.Symbol): boolean;
    checkSymbolDeclarationSourceFile(symbol: ts.Symbol, checkFunction: (sourceFile: ts.SourceFile) => boolean): boolean;
    analyzeTestsuiteThemeProperty(node: ts.PropertyAssignment): void;
    hasQUnitFileExtension(): boolean;
    findModuleForName(moduleName: string): ts.Symbol | undefined;
    isFixable(node: ts.CallExpression | ts.AccessExpression): boolean;
    getFixHints(node: ts.CallExpression | ts.AccessExpression): FixHints | undefined;
    isLibraryExportAccess(moduleSymbol: ts.Symbol, parts: string[]): boolean;
    getImportFromGlobal(node: ts.CallExpression | ts.AccessExpression): {
        fixHints: FixHints;
        propertyAccessNode: ts.Node;
    } | undefined;
}
export {};
