// For Library Version: 1.120.2

declare module "sap/ca/ui/library" {
  export namespace charts {
    /**
     * Enumeration of available color to be used in sap.ca.ui charts.
     *
     * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and VizFrame in 1.24. The UI5
     * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
     * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
     * not be supported anymore from 1.24.
     */
    enum ChartColor {
      /**
       * Sap Ui Chart 1
       */
      sapUiChart1 = "sapUiChart1",
      /**
       * Sap Ui Chart 10
       */
      sapUiChart10 = "sapUiChart10",
      /**
       * Sap Ui Chart 11
       */
      sapUiChart11 = "sapUiChart11",
      /**
       * Sap Ui Chart 2
       */
      sapUiChart2 = "sapUiChart2",
      /**
       * Sap Ui Chart 3
       */
      sapUiChart3 = "sapUiChart3",
      /**
       * Sap Ui Chart 4
       */
      sapUiChart4 = "sapUiChart4",
      /**
       * Sap Ui Chart 5
       */
      sapUiChart5 = "sapUiChart5",
      /**
       * Sap Ui Chart 6
       */
      sapUiChart6 = "sapUiChart6",
      /**
       * Sap Ui Chart 7
       */
      sapUiChart7 = "sapUiChart7",
      /**
       * Sap Ui Chart 8
       */
      sapUiChart8 = "sapUiChart8",
      /**
       * Sap Ui Chart 9
       */
      sapUiChart9 = "sapUiChart9",
    }
    /**
     * Determines the selection mode of a Chart.
     *
     * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and VizFrame in 1.24. The UI5
     * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
     * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
     * not be supported anymore from 1.24.
     */
    enum ChartSelectionMode {
      /**
       * The chart will allow multi selection.
       */
      Multiple = "Multiple",
      /**
       * The chart will not allow any selection
       */
      None = "None",
      /**
       * The chart will only allow single selection
       */
      Single = "Single",
    }
    /**
     * Enumeration of available semantic color to be used in sap.Ca.ui
     *
     * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and VizFrame in 1.24. The UI5
     * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
     * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
     * not be supported anymore from 1.24.
     */
    enum ChartSemanticColor {
      /**
       * Bad color
       */
      Bad = "Bad",
      /**
       * Darker Bad color
       */
      BadDark = "BadDark",
      /**
       * Lighter Bad color
       */
      BadLight = "BadLight",
      /**
       * Critical colro
       */
      Critical = "Critical",
      /**
       * Darker Critical color
       */
      CriticalDark = "CriticalDark",
      /**
       * Lighter Critical color
       */
      CriticalLight = "CriticalLight",
      /**
       * Good color
       */
      Good = "Good",
      /**
       * Darker Good color
       */
      GoodDark = "GoodDark",
      /**
       * Lighter Good color
       */
      GoodLight = "GoodLight",
      /**
       * Neutral color
       */
      Neutral = "Neutral",
      /**
       * Darker Neutral color
       */
      NeutralDark = "NeutralDark",
      /**
       * Lighter Neutral color
       */
      NeutralLight = "NeutralLight",
    }
  }
}

declare module "sap/ca/ui/AddPicture" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import PictureItem from "sap/ca/ui/PictureItem";

  import Event from "sap/ui/base/Event";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { TextAlign, CSSSize } from "sap/ui/core/library";

  /**
   * Enables users to add pictures into a form. Contains PictureItem controls that describe the media. It
   * is designed to be used simultaneously with the PictureViewer control
   *
   * @deprecated (since 1.26) - As per central UX requirements, this control is replaced by sap.m.UploadCollection.
   * Please use the new control if you start developing an application instead of using this AddPicture control.
   */
  export default class AddPicture extends Control {
    /**
     * Constructor for a new AddPicture.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $AddPictureSettings
    );
    /**
     * Constructor for a new AddPicture.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $AddPictureSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.AddPicture with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AddPicture>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.AddPicture.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some picture to the aggregation {@link #getPictures pictures}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addPicture(
      /**
       * The picture to add; if empty, nothing is inserted
       */
      oPicture: PictureItem
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:fileNotSupported fileNotSupported} event of
     * this `sap.ca.ui.AddPicture`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.AddPicture` itself.
     *
     * Image upload failed, only supports image format files
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFileNotSupported(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AddPicture$FileNotSupportedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.AddPicture` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:fileNotSupported fileNotSupported} event of
     * this `sap.ca.ui.AddPicture`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.AddPicture` itself.
     *
     * Image upload failed, only supports image format files
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFileNotSupported(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AddPicture$FileNotSupportedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.AddPicture` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:imageUploadFailed imageUploadFailed} event of
     * this `sap.ca.ui.AddPicture`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.AddPicture` itself.
     *
     * Indicates that the image upload failed, only used as a fallback when FileReader is not supported by the
     * browser
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachImageUploadFailed(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.AddPicture` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:imageUploadFailed imageUploadFailed} event of
     * this `sap.ca.ui.AddPicture`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.AddPicture` itself.
     *
     * Indicates that the image upload failed, only used as a fallback when FileReader is not supported by the
     * browser
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachImageUploadFailed(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.AddPicture` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:maxPictureLimitReached maxPictureLimitReached }
     * event of this `sap.ca.ui.AddPicture`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.AddPicture` itself.
     *
     * Indicates that the limit number of pictures has been reached
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMaxPictureLimitReached(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.AddPicture` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:maxPictureLimitReached maxPictureLimitReached }
     * event of this `sap.ca.ui.AddPicture`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.AddPicture` itself.
     *
     * Indicates that the limit number of pictures has been reached
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMaxPictureLimitReached(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.AddPicture` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pictureAdded pictureAdded} event of this `sap.ca.ui.AddPicture`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.AddPicture` itself.
     *
     * Indicates that the image upload failed, only used as a fallback when FileReader is not supported by the
     * browser
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPictureAdded(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.AddPicture` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pictureAdded pictureAdded} event of this `sap.ca.ui.AddPicture`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.AddPicture` itself.
     *
     * Indicates that the image upload failed, only used as a fallback when FileReader is not supported by the
     * browser
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPictureAdded(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.AddPicture` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:show show} event of this `sap.ca.ui.AddPicture`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.AddPicture` itself.
     *
     * Indicates that the user wishes to view the picture
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShow(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.AddPicture` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:show show} event of this `sap.ca.ui.AddPicture`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.AddPicture` itself.
     *
     * Indicates that the user wishes to view the picture
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShow(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.AddPicture` itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getPictures pictures} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindPictures(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the pictures in the aggregation {@link #getPictures pictures}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPictures(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:fileNotSupported fileNotSupported} event of
     * this `sap.ca.ui.AddPicture`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachFileNotSupported(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: AddPicture$FileNotSupportedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:imageUploadFailed imageUploadFailed} event
     * of this `sap.ca.ui.AddPicture`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachImageUploadFailed(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:maxPictureLimitReached maxPictureLimitReached }
     * event of this `sap.ca.ui.AddPicture`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachMaxPictureLimitReached(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:pictureAdded pictureAdded} event of this `sap.ca.ui.AddPicture`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPictureAdded(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:show show} event of this `sap.ca.ui.AddPicture`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShow(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:fileNotSupported fileNotSupported} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireFileNotSupported(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: AddPicture$FileNotSupportedEventParameters
    ): this;
    /**
     * Fires event {@link #event:imageUploadFailed imageUploadFailed} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireImageUploadFailed(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:maxPictureLimitReached maxPictureLimitReached} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireMaxPictureLimitReached(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:pictureAdded pictureAdded} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePictureAdded(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:show show} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShow(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getButtonPageType buttonPageType}.
     *
     * The page container type in which the button is embedded : Tab or Form
     *
     * Default value is `'Tab'`.
     *
     *
     * @returns Value of property `buttonPageType`
     */
    getButtonPageType(): string;
    /**
     * Gets current value of property {@link #getCompression compression}.
     *
     * Defines whether or not you want to maximize the compression. Possible values : "Low" (thumbnail size)
     * or "High" (screen size)
     *
     * Default value is `'low'`.
     *
     *
     * @returns Value of property `compression`
     */
    getCompression(): string;
    /**
     * Gets current value of property {@link #getEditable editable}.
     *
     * Defines whether the button should appear or not.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `editable`
     */
    getEditable(): boolean;
    /**
     * Gets current value of property {@link #getItemSize itemSize}.
     *
     * Defines thumbnail size (height / width) in Pixels
     *
     * Default value is `64`.
     *
     *
     * @returns Value of property `itemSize`
     */
    getItemSize(): int;
    /**
     * Gets current value of property {@link #getMaxPictureNumber maxPictureNumber}.
     *
     * Defines the maximum number of pictures you can add. Default is set to 10
     *
     * Default value is `10`.
     *
     *
     * @returns Value of property `maxPictureNumber`
     */
    getMaxPictureNumber(): int;
    /**
     * Gets current value of property {@link #getPictureAlign pictureAlign}.
     *
     * The text of the button.
     *
     * Default value is `Left`.
     *
     *
     * @returns Value of property `pictureAlign`
     */
    getPictureAlign(): TextAlign | keyof typeof TextAlign;
    /**
     * Gets content of aggregation {@link #getPictures pictures}.
     *
     * The list of pictures
     */
    getPictures(): PictureItem[];
    /**
     * Gets current value of property {@link #getText text}.
     *
     * The text of the button.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getUploadUrl uploadUrl}.
     *
     * Url of server we wish to upload to, only used as a fallback when FileReader is not supported by the browser
     *
     *
     * @returns Value of property `uploadUrl`
     */
    getUploadUrl(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the control.
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ca.ui.PictureItem` in the aggregation {@link #getPictures pictures}. and
     * returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfPicture(
      /**
       * The picture whose index is looked for
       */
      oPicture: PictureItem
    ): int;
    /**
     * Inserts a picture into the aggregation {@link #getPictures pictures}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertPicture(
      /**
       * The picture to insert; if empty, nothing is inserted
       */
      oPicture: PictureItem,
      /**
       * The `0`-based index the picture should be inserted at; for a negative value of `iIndex`, the picture
       * is inserted at position 0; for a value greater than the current size of the aggregation, the picture
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getPictures pictures}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllPictures(): PictureItem[];
    /**
     * Removes a picture from the aggregation {@link #getPictures pictures}.
     *
     *
     * @returns The removed picture or `null`
     */
    removePicture(
      /**
       * The picture to remove or its index or id
       */
      vPicture: int | string | PictureItem
    ): PictureItem | null;
    /**
     * Sets a new value for property {@link #getButtonPageType buttonPageType}.
     *
     * The page container type in which the button is embedded : Tab or Form
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'Tab'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setButtonPageType(
      /**
       * New value for property `buttonPageType`
       */
      sButtonPageType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getCompression compression}.
     *
     * Defines whether or not you want to maximize the compression. Possible values : "Low" (thumbnail size)
     * or "High" (screen size)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'low'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCompression(
      /**
       * New value for property `compression`
       */
      sCompression?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEditable editable}.
     *
     * Defines whether the button should appear or not.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEditable(
      /**
       * New value for property `editable`
       */
      bEditable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getItemSize itemSize}.
     *
     * Defines thumbnail size (height / width) in Pixels
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `64`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setItemSize(
      /**
       * New value for property `itemSize`
       */
      iItemSize?: int
    ): this;
    /**
     * Sets a new value for property {@link #getMaxPictureNumber maxPictureNumber}.
     *
     * Defines the maximum number of pictures you can add. Default is set to 10
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `10`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxPictureNumber(
      /**
       * New value for property `maxPictureNumber`
       */
      iMaxPictureNumber?: int
    ): this;
    /**
     * Sets a new value for property {@link #getPictureAlign pictureAlign}.
     *
     * The text of the button.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Left`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPictureAlign(
      /**
       * New value for property `pictureAlign`
       */
      sPictureAlign?: TextAlign | keyof typeof TextAlign
    ): this;
    /**
     * Set the text for the button
     */
    setText(sValue: string): void;
    /**
     * Sets a new value for property {@link #getUploadUrl uploadUrl}.
     *
     * Url of server we wish to upload to, only used as a fallback when FileReader is not supported by the browser
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUploadUrl(
      /**
       * New value for property `uploadUrl`
       */
      sUploadUrl?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
    /**
     * Unbinds aggregation {@link #getPictures pictures} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindPictures(): this;
  }
  /**
   * Describes the settings that can be provided to the AddPicture constructor.
   *
   * @deprecated (since 1.26) - As per central UX requirements, this control is replaced by sap.m.UploadCollection.
   * Please use the new control if you start developing an application instead of using this AddPicture control.
   */
  export interface $AddPictureSettings extends $ControlSettings {
    /**
     * The page container type in which the button is embedded : Tab or Form
     */
    buttonPageType?: string | PropertyBindingInfo;

    /**
     * Defines whether the button should appear or not.
     */
    editable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the maximum number of pictures you can add. Default is set to 10
     */
    maxPictureNumber?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Url of server we wish to upload to, only used as a fallback when FileReader is not supported by the browser
     */
    uploadUrl?: string | PropertyBindingInfo;

    /**
     * The width of the control.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The text of the button.
     */
    text?: string | PropertyBindingInfo;

    /**
     * The text of the button.
     */
    pictureAlign?:
      | (TextAlign | keyof typeof TextAlign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines thumbnail size (height / width) in Pixels
     */
    itemSize?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether or not you want to maximize the compression. Possible values : "Low" (thumbnail size)
     * or "High" (screen size)
     */
    compression?: string | PropertyBindingInfo;

    /**
     * The list of pictures
     */
    pictures?:
      | PictureItem[]
      | PictureItem
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Indicates that the user wishes to view the picture
     */
    show?: (oEvent: Event) => void;

    /**
     * Indicates that the image upload failed, only used as a fallback when FileReader is not supported by the
     * browser
     */
    pictureAdded?: (oEvent: Event) => void;

    /**
     * Indicates that the limit number of pictures has been reached
     */
    maxPictureLimitReached?: (oEvent: Event) => void;

    /**
     * Indicates that the image upload failed, only used as a fallback when FileReader is not supported by the
     * browser
     */
    imageUploadFailed?: (oEvent: Event) => void;

    /**
     * Image upload failed, only supports image format files
     */
    fileNotSupported?: (oEvent: AddPicture$FileNotSupportedEvent) => void;
  }

  /**
   * Parameters of the AddPicture#fileNotSupported event.
   */
  export interface AddPicture$FileNotSupportedEventParameters {
    /**
     * An array containing the file names that are not supported
     */
    fileNames?: any;
  }

  /**
   * Event object of the AddPicture#fileNotSupported event.
   */
  export type AddPicture$FileNotSupportedEvent = Event<
    AddPicture$FileNotSupportedEventParameters,
    AddPicture
  >;

  /**
   * Parameters of the AddPicture#imageUploadFailed event.
   */
  export interface AddPicture$ImageUploadFailedEventParameters {}

  /**
   * Event object of the AddPicture#imageUploadFailed event.
   */
  export type AddPicture$ImageUploadFailedEvent = Event<
    AddPicture$ImageUploadFailedEventParameters,
    AddPicture
  >;

  /**
   * Parameters of the AddPicture#maxPictureLimitReached event.
   */
  export interface AddPicture$MaxPictureLimitReachedEventParameters {}

  /**
   * Event object of the AddPicture#maxPictureLimitReached event.
   */
  export type AddPicture$MaxPictureLimitReachedEvent = Event<
    AddPicture$MaxPictureLimitReachedEventParameters,
    AddPicture
  >;

  /**
   * Parameters of the AddPicture#pictureAdded event.
   */
  export interface AddPicture$PictureAddedEventParameters {}

  /**
   * Event object of the AddPicture#pictureAdded event.
   */
  export type AddPicture$PictureAddedEvent = Event<
    AddPicture$PictureAddedEventParameters,
    AddPicture
  >;

  /**
   * Parameters of the AddPicture#show event.
   */
  export interface AddPicture$ShowEventParameters {}

  /**
   * Event object of the AddPicture#show event.
   */
  export type AddPicture$ShowEvent = Event<
    AddPicture$ShowEventParameters,
    AddPicture
  >;
}

declare module "sap/ca/ui/charts/BarListItem" {
  import {
    default as ListItemBase,
    $ListItemBaseSettings,
  } from "sap/m/ListItemBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The display list item consists of a label and a value.
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export default class BarListItem extends ListItemBase {
    /**
     * Constructor for a new charts/BarListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $BarListItemSettings
    );
    /**
     * Constructor for a new charts/BarListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $BarListItemSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.charts.BarListItem with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.ListItemBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BarListItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.charts.BarListItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getAxis axis}.
     *
     * List item label
     *
     *
     * @returns Value of property `axis`
     */
    getAxis(): string;
    /**
     * Gets current value of property {@link #getGroup group}.
     *
     * List item label
     *
     *
     * @returns Value of property `group`
     */
    getGroup(): string;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * List item value
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Sets a new value for property {@link #getAxis axis}.
     *
     * List item label
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAxis(
      /**
       * New value for property `axis`
       */
      sAxis?: string
    ): this;
    /**
     * Sets a new value for property {@link #getGroup group}.
     *
     * List item label
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGroup(
      /**
       * New value for property `group`
       */
      sGroup?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * List item value
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the BarListItem constructor.
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export interface $BarListItemSettings extends $ListItemBaseSettings {
    /**
     * List item label
     */
    axis?: string | PropertyBindingInfo;

    /**
     * List item label
     */
    group?: string | PropertyBindingInfo;

    /**
     * List item value
     */
    value?: string | PropertyBindingInfo;
  }
}

declare module "sap/ca/ui/charts/BubbleChart" {
  import { default as Chart, $ChartSettings } from "sap/ca/ui/charts/Chart";

  import Control from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Bubble chart.
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export default class BubbleChart extends Chart {
    /**
     * Constructor for a new charts/BubbleChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $BubbleChartSettings
    );
    /**
     * Constructor for a new charts/BubbleChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $BubbleChartSettings
    );
    /**
     * Clears the array of saved vertical lines.
     */
    clearVerticalLines: undefined;

    /**
     * Draws a vertical line at the given x axis value. Also display the text.
     */
    drawVerticalLineAt: undefined;

    /**
     * Creates a new subclass of class sap.ca.ui.charts.BubbleChart with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ca.ui.charts.Chart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BubbleChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.charts.BubbleChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Gets current value of property {@link #getAxisFormatFunction axisFormatFunction}.
     *
     * Set the formatter function for the axis labels or tooltips
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the plotAreaAxisTooltipFormatter
     *
     * @returns Value of property `axisFormatFunction`
     */
    getAxisFormatFunction(): object;
    /**
     * Gets current value of property {@link #getAxisTooltipFormatString axisTooltipFormatString}.
     *
     * Flag to set the formatting of the tooltip on x-axis
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the plotAreaAxisTooltipFormatter
     *
     * @returns Value of property `axisTooltipFormatString`
     */
    getAxisTooltipFormatString(): any;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Deprecated aggregation, do not use. Left for compatibility purposes.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     */
    getContent(): Control[];
    /**
     * Gets current value of property {@link #getDataLabelFormat dataLabelFormat}.
     *
     * Defines the formater string for the dataLabel value to be displayed on the bubble
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the dataLabelFormatter for any formatting
     * of data label
     *
     * @returns Value of property `dataLabelFormat`
     */
    getDataLabelFormat(): any;
    /**
     * Gets current value of property {@link #getLabelProperty labelProperty}.
     *
     * Set the binding property values for the labels as array eg. ['property1','property2']. Only 2 labels
     * are supported.
     *
     *
     * @returns Value of property `labelProperty`
     */
    getLabelProperty(): object;
    /**
     * Gets current value of property {@link #getMinimumLabelSize minimumLabelSize}.
     *
     * The minimum size of the bubble before a label gets displayed
     *
     * Default value is `60`.
     *
     *
     * @returns Value of property `minimumLabelSize`
     */
    getMinimumLabelSize(): int;
    /**
     * Gets current value of property {@link #getShowCustomLabels showCustomLabels}.
     *
     * Flag to show custom data labels
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showCustomLabels`
     */
    getShowCustomLabels(): boolean;
    /**
     * Gets current value of property {@link #getShowSizeLegend showSizeLegend}.
     *
     * Show / Hide the visibility the size legend of the chart
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showSizeLegend`
     */
    getShowSizeLegend(): boolean;
    /**
     * Gets current value of property {@link #getShowTitle showTitle}.
     *
     * Flag to display the title for the chart, default is set to false
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showTitle`
     */
    getShowTitle(): boolean;
    /**
     * Gets current value of property {@link #getShowXAxisLabel showXAxisLabel}.
     *
     * Flag to set the visibility of x-axis label, default is set to true.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showXAxisLabel`
     */
    getShowXAxisLabel(): boolean;
    /**
     * Gets current value of property {@link #getShowYAxisLabel showYAxisLabel}.
     *
     * Flag to set the visibility of y-axis label, default is set to true.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showYAxisLabel`
     */
    getShowYAxisLabel(): boolean;
    /**
     * Gets current value of property {@link #getXAxisFixedRange xAxisFixedRange}.
     *
     * Flag to define x-axis scale range.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `xAxisFixedRange`
     */
    getXAxisFixedRange(): boolean;
    /**
     * Gets current value of property {@link #getXAxisFormatFunction xAxisFormatFunction}.
     *
     * Set the formatter function for the x-axis.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the xAxisLabelFormatter for any formatting
     * of the axis labels
     *
     * @returns Value of property `xAxisFormatFunction`
     */
    getXAxisFormatFunction(): object;
    /**
     * Gets current value of property {@link #getXAxisFormatString xAxisFormatString}.
     *
     * Set the format string for x-axis
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the xAxisLabelFormatter for any formatting
     * of the axis labels
     *
     * @returns Value of property `xAxisFormatString`
     */
    getXAxisFormatString(): string;
    /**
     * Gets current value of property {@link #getXAxisMaxValue xAxisMaxValue}.
     *
     * Define the max value for x-axis scale
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `xAxisMaxValue`
     */
    getXAxisMaxValue(): float;
    /**
     * Gets current value of property {@link #getXAxisMinValue xAxisMinValue}.
     *
     * Define the minimum value for x-axis scale
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `xAxisMinValue`
     */
    getXAxisMinValue(): float;
    /**
     * Gets current value of property {@link #getXAxisTitle xAxisTitle}.
     *
     * Set x-axis title
     *
     *
     * @returns Value of property `xAxisTitle`
     */
    getXAxisTitle(): string;
    /**
     * Gets current value of property {@link #getYAxisFixedRange yAxisFixedRange}.
     *
     * Flag to define y-axis scale range.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `yAxisFixedRange`
     */
    getYAxisFixedRange(): boolean;
    /**
     * Gets current value of property {@link #getYAxisFormatFunction yAxisFormatFunction}.
     *
     * Set the formatter function for the y-axis.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the yAxisLabelFormatter for any formatting
     * of the axis labels
     *
     * @returns Value of property `yAxisFormatFunction`
     */
    getYAxisFormatFunction(): object;
    /**
     * Gets current value of property {@link #getYAxisFormatString yAxisFormatString}.
     *
     * Set the format string for y-axis
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the yAxisLabelFormatter for any formatting
     * of the axis labels
     *
     * @returns Value of property `yAxisFormatString`
     */
    getYAxisFormatString(): string;
    /**
     * Gets current value of property {@link #getYAxisMaxValue yAxisMaxValue}.
     *
     * Define the max value for y-axis scale
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `yAxisMaxValue`
     */
    getYAxisMaxValue(): float;
    /**
     * Gets current value of property {@link #getYAxisMinValue yAxisMinValue}.
     *
     * Define the minimum value for y-axis scale
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `yAxisMinValue`
     */
    getYAxisMinValue(): float;
    /**
     * Gets current value of property {@link #getYAxisTitle yAxisTitle}.
     *
     * Set y-axis title
     *
     *
     * @returns Value of property `yAxisTitle`
     */
    getYAxisTitle(): string;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getAxisFormatFunction axisFormatFunction}.
     *
     * Set the formatter function for the axis labels or tooltips
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the plotAreaAxisTooltipFormatter
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAxisFormatFunction(
      /**
       * New value for property `axisFormatFunction`
       */
      oAxisFormatFunction?: object
    ): this;
    /**
     * Sets a new value for property {@link #getAxisTooltipFormatString axisTooltipFormatString}.
     *
     * Flag to set the formatting of the tooltip on x-axis
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the plotAreaAxisTooltipFormatter
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAxisTooltipFormatString(
      /**
       * New value for property `axisTooltipFormatString`
       */
      oAxisTooltipFormatString?: any
    ): this;
    /**
     * Sets a new value for property {@link #getDataLabelFormat dataLabelFormat}.
     *
     * Defines the formater string for the dataLabel value to be displayed on the bubble
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the dataLabelFormatter for any formatting
     * of data label
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabelFormat(
      /**
       * New value for property `dataLabelFormat`
       */
      oDataLabelFormat?: any
    ): this;
    /**
     * Sets a new value for property {@link #getLabelProperty labelProperty}.
     *
     * Set the binding property values for the labels as array eg. ['property1','property2']. Only 2 labels
     * are supported.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabelProperty(
      /**
       * New value for property `labelProperty`
       */
      oLabelProperty?: object
    ): this;
    /**
     * Sets a new value for property {@link #getMinimumLabelSize minimumLabelSize}.
     *
     * The minimum size of the bubble before a label gets displayed
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `60`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinimumLabelSize(
      /**
       * New value for property `minimumLabelSize`
       */
      iMinimumLabelSize?: int
    ): this;
    /**
     * Sets a new value for property {@link #getShowCustomLabels showCustomLabels}.
     *
     * Flag to show custom data labels
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowCustomLabels(
      /**
       * New value for property `showCustomLabels`
       */
      bShowCustomLabels?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowSizeLegend showSizeLegend}.
     *
     * Show / Hide the visibility the size legend of the chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowSizeLegend(
      /**
       * New value for property `showSizeLegend`
       */
      bShowSizeLegend?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowTitle showTitle}.
     *
     * Flag to display the title for the chart, default is set to false
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTitle(
      /**
       * New value for property `showTitle`
       */
      bShowTitle?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowXAxisLabel showXAxisLabel}.
     *
     * Flag to set the visibility of x-axis label, default is set to true.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowXAxisLabel(
      /**
       * New value for property `showXAxisLabel`
       */
      bShowXAxisLabel?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowYAxisLabel showYAxisLabel}.
     *
     * Flag to set the visibility of y-axis label, default is set to true.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowYAxisLabel(
      /**
       * New value for property `showYAxisLabel`
       */
      bShowYAxisLabel?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getXAxisFixedRange xAxisFixedRange}.
     *
     * Flag to define x-axis scale range.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxisFixedRange(
      /**
       * New value for property `xAxisFixedRange`
       */
      bXAxisFixedRange?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getXAxisFormatFunction xAxisFormatFunction}.
     *
     * Set the formatter function for the x-axis.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the xAxisLabelFormatter for any formatting
     * of the axis labels
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxisFormatFunction(
      /**
       * New value for property `xAxisFormatFunction`
       */
      oXAxisFormatFunction?: object
    ): this;
    /**
     * Sets a new value for property {@link #getXAxisFormatString xAxisFormatString}.
     *
     * Set the format string for x-axis
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the xAxisLabelFormatter for any formatting
     * of the axis labels
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxisFormatString(
      /**
       * New value for property `xAxisFormatString`
       */
      sXAxisFormatString?: string
    ): this;
    /**
     * Sets a new value for property {@link #getXAxisMaxValue xAxisMaxValue}.
     *
     * Define the max value for x-axis scale
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxisMaxValue(
      /**
       * New value for property `xAxisMaxValue`
       */
      fXAxisMaxValue?: float
    ): this;
    /**
     * Sets a new value for property {@link #getXAxisMinValue xAxisMinValue}.
     *
     * Define the minimum value for x-axis scale
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxisMinValue(
      /**
       * New value for property `xAxisMinValue`
       */
      fXAxisMinValue?: float
    ): this;
    /**
     * Sets a new value for property {@link #getXAxisTitle xAxisTitle}.
     *
     * Set x-axis title
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxisTitle(
      /**
       * New value for property `xAxisTitle`
       */
      sXAxisTitle?: string
    ): this;
    /**
     * Sets a new value for property {@link #getYAxisFixedRange yAxisFixedRange}.
     *
     * Flag to define y-axis scale range.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxisFixedRange(
      /**
       * New value for property `yAxisFixedRange`
       */
      bYAxisFixedRange?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getYAxisFormatFunction yAxisFormatFunction}.
     *
     * Set the formatter function for the y-axis.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the yAxisLabelFormatter for any formatting
     * of the axis labels
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxisFormatFunction(
      /**
       * New value for property `yAxisFormatFunction`
       */
      oYAxisFormatFunction?: object
    ): this;
    /**
     * Sets a new value for property {@link #getYAxisFormatString yAxisFormatString}.
     *
     * Set the format string for y-axis
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the yAxisLabelFormatter for any formatting
     * of the axis labels
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxisFormatString(
      /**
       * New value for property `yAxisFormatString`
       */
      sYAxisFormatString?: string
    ): this;
    /**
     * Sets a new value for property {@link #getYAxisMaxValue yAxisMaxValue}.
     *
     * Define the max value for y-axis scale
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxisMaxValue(
      /**
       * New value for property `yAxisMaxValue`
       */
      fYAxisMaxValue?: float
    ): this;
    /**
     * Sets a new value for property {@link #getYAxisMinValue yAxisMinValue}.
     *
     * Define the minimum value for y-axis scale
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxisMinValue(
      /**
       * New value for property `yAxisMinValue`
       */
      fYAxisMinValue?: float
    ): this;
    /**
     * Sets a new value for property {@link #getYAxisTitle yAxisTitle}.
     *
     * Set y-axis title
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxisTitle(
      /**
       * New value for property `yAxisTitle`
       */
      sYAxisTitle?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the BubbleChart constructor.
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export interface $BubbleChartSettings extends $ChartSettings {
    /**
     * Defines the formater string for the dataLabel value to be displayed on the bubble
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the dataLabelFormatter for any formatting
     * of data label
     */
    dataLabelFormat?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Flag to display the title for the chart, default is set to false
     */
    showTitle?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Flag to set the visibility of x-axis label, default is set to true.
     */
    showXAxisLabel?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Flag to define x-axis scale range.
     */
    xAxisFixedRange?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Define the minimum value for x-axis scale
     */
    xAxisMinValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Define the max value for x-axis scale
     */
    xAxisMaxValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Flag to set the visibility of y-axis label, default is set to true.
     */
    showYAxisLabel?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Flag to define y-axis scale range.
     */
    yAxisFixedRange?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Define the minimum value for y-axis scale
     */
    yAxisMinValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Define the max value for y-axis scale
     */
    yAxisMaxValue?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * The minimum size of the bubble before a label gets displayed
     */
    minimumLabelSize?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Show / Hide the visibility the size legend of the chart
     */
    showSizeLegend?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Set x-axis title
     */
    xAxisTitle?: string | PropertyBindingInfo;

    /**
     * Set y-axis title
     */
    yAxisTitle?: string | PropertyBindingInfo;

    /**
     * Flag to show custom data labels
     */
    showCustomLabels?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Set the binding property values for the labels as array eg. ['property1','property2']. Only 2 labels
     * are supported.
     */
    labelProperty?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Set the formatter function for the x-axis.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the xAxisLabelFormatter for any formatting
     * of the axis labels
     */
    xAxisFormatFunction?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Set the format string for x-axis
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the xAxisLabelFormatter for any formatting
     * of the axis labels
     */
    xAxisFormatString?: string | PropertyBindingInfo;

    /**
     * Set the formatter function for the y-axis.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the yAxisLabelFormatter for any formatting
     * of the axis labels
     */
    yAxisFormatFunction?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Set the format string for y-axis
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the yAxisLabelFormatter for any formatting
     * of the axis labels
     */
    yAxisFormatString?: string | PropertyBindingInfo;

    /**
     * Flag to set the formatting of the tooltip on x-axis
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the plotAreaAxisTooltipFormatter
     */
    axisTooltipFormatString?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Set the formatter function for the axis labels or tooltips
     *
     * @deprecated (since 1.20.0) - This method is deprecated now. Use the plotAreaAxisTooltipFormatter
     */
    axisFormatFunction?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Deprecated aggregation, do not use. Left for compatibility purposes.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ca/ui/charts/Chart" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import ResponsivePopover from "sap/m/ResponsivePopover";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { charts } from "sap/ca/ui/library";

  import Dataset from "sap/viz/ui5/data/Dataset";

  import Model from "sap/ui/model/Model";

  import Bar from "sap/m/Bar";

  /**
   * Chart implementation on top of sap.viz that takes care of common functionality. - Embedding in a scroll
   * container - Common color palette - Minimum bar / dot / blip ... size - Integration with ChartToolbar
   * and ChartPopover
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export default class Chart extends Control {
    /**
     * Constructor for a new charts/Chart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ChartSettings
    );
    /**
     * Constructor for a new charts/Chart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ChartSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.charts.Chart with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Chart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.charts.Chart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Creates an id for an Element prefixed with the control id
     *
     *
     * @returns id
     */
    _createId(): string;
    /**
     * Setter for property `advancedChartSettings`.
     *
     *
     * @returns `this` to allow method chaining
     */
    advancedChartSettings(
      /**
       * You can specify here any advanced viz chart settings that have not been exposed as a chart property.
       */
      settings: object
    ): Chart;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:popoverAfterOpen popoverAfterOpen} event of
     * this `sap.ca.ui.charts.Chart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.charts.Chart` itself.
     *
     * Event is fired after the popover is opened
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPopoverAfterOpen(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.charts.Chart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:popoverAfterOpen popoverAfterOpen} event of
     * this `sap.ca.ui.charts.Chart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.charts.Chart` itself.
     *
     * Event is fired after the popover is opened
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPopoverAfterOpen(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.charts.Chart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:popoverBeforeOpen popoverBeforeOpen} event of
     * this `sap.ca.ui.charts.Chart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.charts.Chart` itself.
     *
     * Event is fired before the popover is opened
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPopoverBeforeOpen(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.charts.Chart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:popoverBeforeOpen popoverBeforeOpen} event of
     * this `sap.ca.ui.charts.Chart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.charts.Chart` itself.
     *
     * Event is fired before the popover is opened
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPopoverBeforeOpen(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.charts.Chart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectDataPoint selectDataPoint} event of this
     * `sap.ca.ui.charts.Chart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.charts.Chart` itself.
     *
     * Event is fired when the data point is selected/unselected on the chart
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectDataPoint(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.charts.Chart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectDataPoint selectDataPoint} event of this
     * `sap.ca.ui.charts.Chart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.charts.Chart` itself.
     *
     * Event is fired when the data point is selected/unselected on the chart
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectDataPoint(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.charts.Chart` itself
       */
      oListener?: object
    ): this;
    /**
     * Binds property {@link #getLabel label} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindLabel(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Setter for property `dataLabelFormatter`.
     *
     *
     * @returns `this` to allow method chaining
     */
    dataLabelFormatter(
      /**
       * new value for property `dataLabelFormatter` [formatterArray] must be a 2 dimensions array of formatters.
       * [ [ measure 1 of X Axis , ..., [measure n of X Axis] ], [ measure 1 of X Axis 2 , ..., [measure n of
       * X Axis 2] ] Each of these formatters can be: - a custom formatting function - a value of enum sap.ca.ui.charts.DefaultFormatterFunction
       * If for an axis, formatters count < measures count, then first formatter of axis will be used for other
       * measures.
       */
      formatterArray: object
    ): Chart;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:popoverAfterOpen popoverAfterOpen} event of
     * this `sap.ca.ui.charts.Chart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPopoverAfterOpen(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:popoverBeforeOpen popoverBeforeOpen} event
     * of this `sap.ca.ui.charts.Chart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPopoverBeforeOpen(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectDataPoint selectDataPoint} event of
     * this `sap.ca.ui.charts.Chart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectDataPoint(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:popoverAfterOpen popoverAfterOpen} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePopoverAfterOpen(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:popoverBeforeOpen popoverBeforeOpen} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePopoverBeforeOpen(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:selectDataPoint selectDataPoint} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectDataPoint(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAdvancedChartSettings advancedChartSettings}.
     *
     * You can specify here any advanced viz chart settings that have not been exposed as a chart property.
     *
     *
     * @returns Value of property `advancedChartSettings`
     */
    getAdvancedChartSettings(): object;
    /**
     * Getter for property `chartPopOver`. chart PopOver
     *
     * Default value is empty/`undefined`
     *
     *
     * @returns oChartPopOver the value of property `chartPopOver`
     */
    getChartPopOver(): ResponsivePopover;
    /**
     * Gets current value of property {@link #getChartSemanticColorFormatter chartSemanticColorFormatter}.
     *
     * Function that will be called when the chart is rendered in order to let the application decide which
     * color should be use for each bar. The method should take the following parameter as input : - The data
     * context of the current datashape And as output : - One of sap.ca.ui.charts.ChartSemanticColor type
     *
     *
     * @returns Value of property `chartSemanticColorFormatter`
     */
    getChartSemanticColorFormatter(): object;
    /**
     * Gets current value of property {@link #getChartType chartType}.
     *
     * Type of viz chart that will be displayed.
     *
     * Default value is `'Bar'`.
     *
     *
     * @returns Value of property `chartType`
     */
    getChartType(): string;
    /**
     * Gets current value of property {@link #getDataLabelFormatter dataLabelFormatter}.
     *
     * Formatter for Data Label
     *
     *
     * @returns Value of property `dataLabelFormatter`
     */
    getDataLabelFormatter(): object;
    /**
     * Getter for property `dataset`. Viz Dataset that will hold the data to be displayed.
     *
     * Default value is empty/`undefined`
     *
     *
     * @returns oDataset the value of property `dataset`
     */
    getDataset(): object;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Target height for the charting area
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * Icon of the Chart
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): string;
    /**
     * Getter for property `internalVizChart`. internal Viz Chart
     *
     * Default value is empty/`undefined`
     *
     *
     * @returns oInternalVizChart the value of property `internalVizChart`
     */
    getInternalVizChart(): object;
    /**
     * Gets current value of property {@link #getLabel label}.
     *
     * User friendly name for the current chart type
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `label`
     */
    getLabel(): string;
    /**
     * Gets current value of property {@link #getMinShapeSize minShapeSize}.
     *
     * Minimum shape size for touch enabled actions, default and minimum to 48px !
     *
     * Default value is `'48px'`.
     *
     *
     * @returns Value of property `minShapeSize`
     */
    getMinShapeSize(): CSSSize;
    /**
     * Getter for aggregation noData in Viz Chart. Control tree to display when there is no data available
     *
     *
     * @returns the value for aggregation noData
     */
    getNoData(): Control;
    /**
     * Gets current value of property {@link #getPlotAreaAxisTooltipFormatter plotAreaAxisTooltipFormatter}.
     *
     * Formatter for plotArea Axis Tooltip in bubble charts
     *
     *
     * @returns Value of property `plotAreaAxisTooltipFormatter`
     */
    getPlotAreaAxisTooltipFormatter(): object;
    /**
     * Gets current value of property {@link #getPopoverFooter popoverFooter}.
     *
     * custom footer for popover
     *
     *
     * @returns Value of property `popoverFooter`
     */
    getPopoverFooter(): Control;
    /**
     * Gets current value of property {@link #getPopoverFormatter popoverFormatter}.
     *
     * Formatter for popover
     *
     *
     * @returns Value of property `popoverFormatter`
     */
    getPopoverFormatter(): object;
    /**
     * Gets current value of property {@link #getPopoverGroupFormatter popoverGroupFormatter}.
     *
     * Formatter for group label in the popover
     *
     *
     * @returns Value of property `popoverGroupFormatter`
     */
    getPopoverGroupFormatter(): string;
    /**
     * Gets current value of property {@link #getPopoverSubHeader popoverSubHeader}.
     *
     * custom subHeader for popover
     *
     *
     * @returns Value of property `popoverSubHeader`
     */
    getPopoverSubHeader(): Control;
    /**
     * Gets current value of property {@link #getSecondAxisVisible secondAxisVisible}.
     *
     * Flag to show the second axis. Default is true
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `secondAxisVisible`
     */
    getSecondAxisVisible(): boolean;
    /**
     * Getter for property `selectionMode`.
     *
     *
     * @returns The selection mode
     */
    getSelectionMode():
      | charts.ChartSelectionMode
      | keyof typeof charts.ChartSelectionMode;
    /**
     * Gets current value of property {@link #getShowDataLabel showDataLabel}.
     *
     * Flag to display data values on the bar, default is set to true
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showDataLabel`
     */
    getShowDataLabel(): boolean;
    /**
     * Gets current value of property {@link #getShowHoverBackground showHoverBackground}.
     *
     * Hide / Show the hover background
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showHoverBackground`
     */
    getShowHoverBackground(): boolean;
    /**
     * Gets current value of property {@link #getShowLegend showLegend}.
     *
     * Hide / Show the legend of the chart
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showLegend`
     */
    getShowLegend(): boolean;
    /**
     * Gets current value of property {@link #getShowPopover showPopover}.
     *
     * Hide / Show the sap.ca popover that gives information about what is available
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showPopover`
     */
    getShowPopover(): boolean;
    /**
     * Gets current value of property {@link #getShowTooltip showTooltip}.
     *
     * Hide / Show the CVOM tooltip
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showTooltip`
     */
    getShowTooltip(): boolean;
    /**
     * Gets current value of property {@link #getStackedChartWidthEnhancer stackedChartWidthEnhancer}.
     *
     * You can use it if stacked bar width are to big. Disabled by default
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `stackedChartWidthEnhancer`
     */
    getStackedChartWidthEnhancer(): boolean;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Title of the chart
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Gets current value of property {@link #getTooltipFormatter tooltipFormatter}.
     *
     * Formatter for toolTip
     *
     *
     * @returns Value of property `tooltipFormatter`
     */
    getTooltipFormatter(): object;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Target width for the charting area
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Gets current value of property {@link #getXAxis2LabelFormatter xAxis2LabelFormatter}.
     *
     * Formatter for X Axis 2 Label
     *
     *
     * @returns Value of property `xAxis2LabelFormatter`
     */
    getXAxis2LabelFormatter(): string;
    /**
     * Gets current value of property {@link #getXAxisLabelFormatter xAxisLabelFormatter}.
     *
     * Formatter for X Axis Label
     *
     *
     * @returns Value of property `xAxisLabelFormatter`
     */
    getXAxisLabelFormatter(): string;
    /**
     * Gets current value of property {@link #getYAxis2LabelFormatter yAxis2LabelFormatter}.
     *
     * Formatter for Y Axis 2 Label
     *
     *
     * @returns Value of property `yAxis2LabelFormatter`
     */
    getYAxis2LabelFormatter(): string;
    /**
     * Gets current value of property {@link #getYAxisLabelFormatter yAxisLabelFormatter}.
     *
     * Formatter for Y Axis Label
     *
     *
     * @returns Value of property `yAxisLabelFormatter`
     */
    getYAxisLabelFormatter(): string;
    /**
     * Setter for property `minShapeSize`. Note: doesn't work for the bubble chart's bubbles sizes.
     *
     *
     * @returns `this` to allow method chaining
     */
    minShapeSize(
      /**
       * Minimum shape size in pixels.
       */
      sMinShapeSize: string
    ): Chart;
    /**
     * Setter for property `popoverFormatter`.
     *
     *
     * @returns `this` to allow method chaining
     */
    popoverFormatter(
      /**
       * new value for property `popoverFormatter` [formatterArray] must be a 2 dimensions array of formatters.
       * [ [ measure 1 of X Axis , ..., [measure n of X Axis] ], [ measure 1 of X Axis 2 , ..., [measure n of
       * X Axis 2] ] Each of these formatters can be: - a custom formatting function - a value of enum sap.ca.ui.charts.DefaultFormatterFunction
       * If for an axis, formatters count < measures count, then first formatter of axis will be used for other
       * measures.
       */
      formatterArray: object
    ): Chart;
    /**
     * Setter for property `popoverGroupFormatter`.
     *
     *
     * @returns `this` to allow method chaining
     */
    popoverGroupFormatter(
      /**
       * new value for property `popoverGroupFormatter` formatter can be: - a custom formatting function - a value
       * of enum sap.ca.ui.charts.DefaultFormatterFunction
       */
      formatter: object
    ): Chart;
    /**
     * Sets a new value for property {@link #getAdvancedChartSettings advancedChartSettings}.
     *
     * You can specify here any advanced viz chart settings that have not been exposed as a chart property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAdvancedChartSettings(
      /**
       * New value for property `advancedChartSettings`
       */
      oAdvancedChartSettings?: object
    ): this;
    /**
     * Setter for property `chartPopOver`.
     *
     *
     * @returns `this` to allow method chaining
     */
    setChartPopOver(
      /**
       * new value for property `chartPopOver`
       */
      oChartPopOver: ResponsivePopover
    ): ResponsivePopover;
    /**
     * Sets a new value for property {@link #getChartSemanticColorFormatter chartSemanticColorFormatter}.
     *
     * Function that will be called when the chart is rendered in order to let the application decide which
     * color should be use for each bar. The method should take the following parameter as input : - The data
     * context of the current datashape And as output : - One of sap.ca.ui.charts.ChartSemanticColor type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChartSemanticColorFormatter(
      /**
       * New value for property `chartSemanticColorFormatter`
       */
      oChartSemanticColorFormatter?: object
    ): this;
    /**
     * Sets a new value for property {@link #getChartType chartType}.
     *
     * Type of viz chart that will be displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'Bar'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChartType(
      /**
       * New value for property `chartType`
       */
      sChartType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDataLabelFormatter dataLabelFormatter}.
     *
     * Formatter for Data Label
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabelFormatter(
      /**
       * New value for property `dataLabelFormatter`
       */
      oDataLabelFormatter?: object
    ): this;
    /**
     * Setter for property `dataset`.
     *
     * Default value is empty/`undefined`
     *
     *
     * @returns `this` to allow method chaining
     */
    setDataset(
      /**
       * new value for property `dataset`
       */
      oDataset: Dataset
    ): Chart;
    /**
     * Setter for property `height`.
     *
     * Default value is `100%`
     *
     *
     * @returns `this` to allow method chaining
     */
    setHeight(
      /**
       * new value for property `height`
       */
      sHeight: CSSSize
    ): Chart;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * Icon of the Chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: string
    ): this;
    /**
     * Setter for property `internalVizChart`.
     *
     * Default value is `oChart`
     *
     *
     * @returns `this` to allow method chaining
     */
    setInternalVizChart(
      /**
       * new value for property `title`
       */
      oInternalVizChart: /* was: sap.viz.ui5.BaseChart */ any
    ): Chart;
    /**
     * Sets a new value for property {@link #getLabel label}.
     *
     * User friendly name for the current chart type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabel(
      /**
       * New value for property `label`
       */
      sLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMinShapeSize minShapeSize}.
     *
     * Minimum shape size for touch enabled actions, default and minimum to 48px !
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'48px'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinShapeSize(
      /**
       * New value for property `minShapeSize`
       */
      sMinShapeSize?: CSSSize
    ): this;
    /**
     * Catch the setModel call and make sure we refresh the size of the chart.
     *
     *
     * @returns `this` to allow method chaining
     */
    setModel(
      /**
       * the model to be set or `null` or `undefined`
       */
      oModel: Model
    ): this;
    /**
     * setter for aggregation noData in Viz Chart. Control tree to display when there is no data available
     */
    setNoData(
      /**
       * new value for aggregation noData
       */
      oControl: Control
    ): void;
    /**
     * Setter for property `plotAreaAxisTooltipFormatter`.
     *
     *
     * @returns `this` to allow method chaining
     */
    setPlotAreaAxisTooltipFormatter(
      /**
       * new value for property `plotAreaAxisTooltipFormatter` This is the tooltip for "bubbles" of bubble chart.
       * [formatterArray] must be an array of 2 formatters (one for X Axis, one for Y axis). Each of these formatters
       * can be: - a custom formatting function - a value of enum sap.ca.ui.charts.DefaultFormatterFunction
       */
      formatterArray?: object
    ): Chart;
    /**
     * setter for footer in the Popover.
     */
    setPopoverFooter(
      /**
       * new value for footer
       */
      oFooter: Bar
    ): void;
    /**
     * Sets a new value for property {@link #getPopoverFormatter popoverFormatter}.
     *
     * Formatter for popover
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPopoverFormatter(
      /**
       * New value for property `popoverFormatter`
       */
      oPopoverFormatter?: object
    ): this;
    /**
     * Sets a new value for property {@link #getPopoverGroupFormatter popoverGroupFormatter}.
     *
     * Formatter for group label in the popover
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPopoverGroupFormatter(
      /**
       * New value for property `popoverGroupFormatter`
       */
      sPopoverGroupFormatter?: string
    ): this;
    /**
     * setter for subHeader in the Popover.
     */
    setPopoverSubHeader(
      /**
       * new value for sub header
       */
      oSubHeader: Bar
    ): void;
    /**
     * Sets a new value for property {@link #getSecondAxisVisible secondAxisVisible}.
     *
     * Flag to show the second axis. Default is true
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSecondAxisVisible(
      /**
       * New value for property `secondAxisVisible`
       */
      bSecondAxisVisible?: boolean
    ): this;
    /**
     * Setter for property `selectionMode`.
     *
     * Default value is `Multi`
     *
     *
     * @returns `this` to allow method chaining
     */
    setSelectionMode(
      /**
       * new value for property `selectionMode`
       */
      sSelectionMode:
        | charts.ChartSelectionMode
        | keyof typeof charts.ChartSelectionMode
    ): Chart;
    /**
     * Sets a new value for property {@link #getShowDataLabel showDataLabel}.
     *
     * Flag to display data values on the bar, default is set to true
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowDataLabel(
      /**
       * New value for property `showDataLabel`
       */
      bShowDataLabel?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowHoverBackground showHoverBackground}.
     *
     * Hide / Show the hover background
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowHoverBackground(
      /**
       * New value for property `showHoverBackground`
       */
      bShowHoverBackground?: boolean
    ): this;
    /**
     * Setter for property `showLegend`.
     *
     * Default value is `true`
     *
     *
     * @returns `this` to allow method chaining
     */
    setShowLegend(
      /**
       * new value for property `showLegend`
       */
      bShowLegend: boolean
    ): Chart;
    /**
     * Sets a new value for property {@link #getShowPopover showPopover}.
     *
     * Hide / Show the sap.ca popover that gives information about what is available
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowPopover(
      /**
       * New value for property `showPopover`
       */
      bShowPopover?: boolean
    ): this;
    /**
     * Setter for property `showTooltip`.
     *
     * Default value is `false`
     *
     *
     * @returns `this` to allow method chaining
     */
    setShowTooltip(
      /**
       * new value for property `showTooltip`
       */
      bShowTooltip: boolean
    ): Chart;
    /**
     * Sets a new value for property {@link #getStackedChartWidthEnhancer stackedChartWidthEnhancer}.
     *
     * You can use it if stacked bar width are to big. Disabled by default
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStackedChartWidthEnhancer(
      /**
       * New value for property `stackedChartWidthEnhancer`
       */
      bStackedChartWidthEnhancer?: boolean
    ): this;
    /**
     * Setter for property `title`.
     *
     * Default value is `Chart`
     *
     *
     * @returns `this` to allow method chaining
     */
    setTitle(
      /**
       * new value for property `title`
       */
      sTitle: string
    ): Chart;
    /**
     * Sets a new value for property {@link #getTooltipFormatter tooltipFormatter}.
     *
     * Formatter for toolTip
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTooltipFormatter(
      /**
       * New value for property `tooltipFormatter`
       */
      oTooltipFormatter?: object
    ): this;
    /**
     * Setter for property `width`.
     *
     * Default value is `100%`
     *
     *
     * @returns `this` to allow method chaining
     */
    setWidth(
      /**
       * new value for property `width`
       */
      sWidth: CSSSize
    ): Chart;
    /**
     * Sets a new value for property {@link #getXAxis2LabelFormatter xAxis2LabelFormatter}.
     *
     * Formatter for X Axis 2 Label
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxis2LabelFormatter(
      /**
       * New value for property `xAxis2LabelFormatter`
       */
      sXAxis2LabelFormatter?: string
    ): this;
    /**
     * Sets a new value for property {@link #getXAxisLabelFormatter xAxisLabelFormatter}.
     *
     * Formatter for X Axis Label
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXAxisLabelFormatter(
      /**
       * New value for property `xAxisLabelFormatter`
       */
      sXAxisLabelFormatter?: string
    ): this;
    /**
     * Sets a new value for property {@link #getYAxis2LabelFormatter yAxis2LabelFormatter}.
     *
     * Formatter for Y Axis 2 Label
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxis2LabelFormatter(
      /**
       * New value for property `yAxis2LabelFormatter`
       */
      sYAxis2LabelFormatter?: string
    ): this;
    /**
     * Sets a new value for property {@link #getYAxisLabelFormatter yAxisLabelFormatter}.
     *
     * Formatter for Y Axis Label
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYAxisLabelFormatter(
      /**
       * New value for property `yAxisLabelFormatter`
       */
      sYAxisLabelFormatter?: string
    ): this;
    /**
     * Setter for property `tooltipFormatter`.
     *
     *
     * @returns `this` to allow method chaining
     */
    tooltipFormatter(
      /**
       * new value for property `tooltipFormatter` [formatterArray] must be a 2 dimensions array of formatters.
       * [ [ measure 1 of X Axis , ..., [measure n of X Axis] ], [ measure 1 of X Axis 2 , ..., [measure n of
       * X Axis 2] ] Each of these formatters can be: - a custom formatting function - a value of enum sap.ca.ui.charts.DefaultFormatterFunction
       * If for an axis, formatters count < measures count, then first formatter of axis will be used for other
       * measures.
       */
      formatterArray: object
    ): Chart;
    /**
     * Unbinds property {@link #getLabel label} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindLabel(): this;
    /**
     * Setter for property `xAxis2LabelFormatter`.
     *
     *
     * @returns `this` to allow method chaining
     */
    xAxis2LabelFormatter(
      /**
       * new value for property `xAxis2LabelFormatter` formatter can be: - a custom formatting function - a value
       * of enum sap.ca.ui.charts.DefaultFormatterFunction
       */
      formatter: object
    ): Chart;
    /**
     * Setter for property `xAxisLabelFormatter`.
     *
     *
     * @returns `this` to allow method chaining
     */
    xAxisLabelFormatter(
      /**
       * new value for property `xAxisLabelFormatter` formatter can be: - a custom formatting function - a value
       * of enum sap.ca.ui.charts.DefaultFormatterFunction
       */
      formatter: object
    ): Chart;
    /**
     * Setter for property `yAxis2LabelFormatter`.
     *
     *
     * @returns `this` to allow method chaining
     */
    yAxis2LabelFormatter(
      /**
       * new value for property `yAxis2LabelFormatter` formatter can be: - a custom formatting function - a value
       * of enum sap.ca.ui.charts.DefaultFormatterFunction
       */
      formatter: object
    ): Chart;
    /**
     * Setter for property `yAxisLabelFormatter`.
     *
     *
     * @returns `this` to allow method chaining
     */
    yAxisLabelFormatter(
      /**
       * new value for property `yAxisLabelFormatter` formatter can be: - a custom formatting function - a value
       * of enum sap.ca.ui.charts.DefaultFormatterFunction
       */
      formatter: object
    ): Chart;
  }
  /**
   * Describes the settings that can be provided to the Chart constructor.
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export interface $ChartSettings extends $ControlSettings {
    /**
     * Target width for the charting area
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Target height for the charting area
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Viz Dataset that will hold the data to be displayed.
     */
    dataset?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Type of viz chart that will be displayed.
     */
    chartType?: string | PropertyBindingInfo;

    /**
     * Minimum shape size for touch enabled actions, default and minimum to 48px !
     */
    minShapeSize?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * User friendly name for the current chart type
     */
    label?: string | PropertyBindingInfo;

    /**
     * Title of the chart
     */
    title?: string | PropertyBindingInfo;

    /**
     * Icon of the Chart
     */
    icon?: string | PropertyBindingInfo;

    /**
     * Flag to show the second axis. Default is true
     */
    secondAxisVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Hide / Show the legend of the chart
     */
    showLegend?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Define the selection mode for the chart
     */
    selectionMode?:
      | (charts.ChartSelectionMode | keyof typeof charts.ChartSelectionMode)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Hide / Show the hover background
     */
    showHoverBackground?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Hide / Show the CVOM tooltip
     */
    showTooltip?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Hide / Show the sap.ca popover that gives information about what is available
     */
    showPopover?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Flag to display data values on the bar, default is set to true
     */
    showDataLabel?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Formatter for Y Axis Label
     */
    yAxisLabelFormatter?: string | PropertyBindingInfo;

    /**
     * Formatter for Y Axis 2 Label
     */
    yAxis2LabelFormatter?: string | PropertyBindingInfo;

    /**
     * Formatter for X Axis Label
     */
    xAxisLabelFormatter?: string | PropertyBindingInfo;

    /**
     * Formatter for X Axis 2 Label
     */
    xAxis2LabelFormatter?: string | PropertyBindingInfo;

    /**
     * Formatter for plotArea Axis Tooltip in bubble charts
     */
    plotAreaAxisTooltipFormatter?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Formatter for toolTip
     */
    tooltipFormatter?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Formatter for Data Label
     */
    dataLabelFormatter?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Formatter for popover
     */
    popoverFormatter?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Formatter for group label in the popover
     */
    popoverGroupFormatter?: string | PropertyBindingInfo;

    /**
     * Function that will be called when the chart is rendered in order to let the application decide which
     * color should be use for each bar. The method should take the following parameter as input : - The data
     * context of the current datashape And as output : - One of sap.ca.ui.charts.ChartSemanticColor type
     */
    chartSemanticColorFormatter?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Retrieve the internal viz chart to allow some operation on it.
     */
    internalVizChart?: Control | PropertyBindingInfo | `{${string}}`;

    /**
     * Retrieve the chart popover instance to allow some operation on it.
     */
    chartPopOver?: Control | PropertyBindingInfo | `{${string}}`;

    /**
     * custom subHeader for popover
     */
    popoverSubHeader?: Control | PropertyBindingInfo | `{${string}}`;

    /**
     * custom footer for popover
     */
    popoverFooter?: Control | PropertyBindingInfo | `{${string}}`;

    /**
     * You can specify here any advanced viz chart settings that have not been exposed as a chart property.
     */
    advancedChartSettings?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * You can use it if stacked bar width are to big. Disabled by default
     */
    stackedChartWidthEnhancer?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Control tree to display when there is no data available
     */
    noData?: Control | PropertyBindingInfo | `{${string}}`;

    /**
     * Event is fired when the data point is selected/unselected on the chart
     */
    selectDataPoint?: (oEvent: Event) => void;

    /**
     * Event is fired before the popover is opened
     */
    popoverBeforeOpen?: (oEvent: Event) => void;

    /**
     * Event is fired after the popover is opened
     */
    popoverAfterOpen?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Chart#popoverAfterOpen event.
   */
  export interface Chart$PopoverAfterOpenEventParameters {}

  /**
   * Event object of the Chart#popoverAfterOpen event.
   */
  export type Chart$PopoverAfterOpenEvent = Event<
    Chart$PopoverAfterOpenEventParameters,
    Chart
  >;

  /**
   * Parameters of the Chart#popoverBeforeOpen event.
   */
  export interface Chart$PopoverBeforeOpenEventParameters {}

  /**
   * Event object of the Chart#popoverBeforeOpen event.
   */
  export type Chart$PopoverBeforeOpenEvent = Event<
    Chart$PopoverBeforeOpenEventParameters,
    Chart
  >;

  /**
   * Parameters of the Chart#selectDataPoint event.
   */
  export interface Chart$SelectDataPointEventParameters {}

  /**
   * Event object of the Chart#selectDataPoint event.
   */
  export type Chart$SelectDataPointEvent = Event<
    Chart$SelectDataPointEventParameters,
    Chart
  >;
}

declare module "sap/ca/ui/charts/ChartToolBar" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import { ID } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Bar from "sap/m/Bar";

  import Select from "sap/m/Select";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * ToolBar used for displaying one chart amongst several and provide additional features: - 2 select boxes
   * for selecting dimensions - fullscreen toggle - personalization icon - showLegend toggle
   *
   * @deprecated (since 1.24) - Sap.ca charts and the ChartToolBar have been replaced with sap.viz and vizFrame
   * in 1.24. The UI5 control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the
   * new charts. Now that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead!
   * This control will not be supported anymore from 1.24.
   */
  export default class ChartToolBar extends Control {
    /**
     * Constructor for a new charts/ChartToolBar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ChartToolBarSettings
    );
    /**
     * Constructor for a new charts/ChartToolBar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ChartToolBarSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.charts.ChartToolBar with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ChartToolBar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.charts.ChartToolBar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some chart to the aggregation {@link #getCharts charts}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addChart(
      /**
       * The chart to add; if empty, nothing is inserted
       */
      oChart: Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:firstDimensionKeySelected firstDimensionKeySelected }
     * event of this `sap.ca.ui.charts.ChartToolBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.charts.ChartToolBar` itself.
     *
     * Event fired when a user selects an item from the first select box. This event is providing the item selectedKey
     * as parameter
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFirstDimensionKeySelected(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.charts.ChartToolBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:firstDimensionKeySelected firstDimensionKeySelected }
     * event of this `sap.ca.ui.charts.ChartToolBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.charts.ChartToolBar` itself.
     *
     * Event fired when a user selects an item from the first select box. This event is providing the item selectedKey
     * as parameter
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFirstDimensionKeySelected(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.charts.ChartToolBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:personalizationPressed personalizationPressed }
     * event of this `sap.ca.ui.charts.ChartToolBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.charts.ChartToolBar` itself.
     *
     * Event fired when a user clicks on the personalization icon
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPersonalizationPressed(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.charts.ChartToolBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:personalizationPressed personalizationPressed }
     * event of this `sap.ca.ui.charts.ChartToolBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.charts.ChartToolBar` itself.
     *
     * Event fired when a user clicks on the personalization icon
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPersonalizationPressed(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.charts.ChartToolBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:secondDimensionKeySelected secondDimensionKeySelected }
     * event of this `sap.ca.ui.charts.ChartToolBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.charts.ChartToolBar` itself.
     *
     * Event fired when a user selects an item from the second select box. This event is providing the item
     * selectedKey as parameter
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSecondDimensionKeySelected(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.charts.ChartToolBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:secondDimensionKeySelected secondDimensionKeySelected }
     * event of this `sap.ca.ui.charts.ChartToolBar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.charts.ChartToolBar` itself.
     *
     * Event fired when a user selects an item from the second select box. This event is providing the item
     * selectedKey as parameter
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSecondDimensionKeySelected(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.charts.ChartToolBar` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the charts in the aggregation {@link #getCharts charts}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCharts(): this;
    /**
     * Destroys the toolBar in the aggregation {@link #getToolBar toolBar}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolBar(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:firstDimensionKeySelected firstDimensionKeySelected }
     * event of this `sap.ca.ui.charts.ChartToolBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachFirstDimensionKeySelected(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:personalizationPressed personalizationPressed }
     * event of this `sap.ca.ui.charts.ChartToolBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPersonalizationPressed(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:secondDimensionKeySelected secondDimensionKeySelected }
     * event of this `sap.ca.ui.charts.ChartToolBar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSecondDimensionKeySelected(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:firstDimensionKeySelected firstDimensionKeySelected} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireFirstDimensionKeySelected(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:personalizationPressed personalizationPressed} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePersonalizationPressed(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:secondDimensionKeySelected secondDimensionKeySelected} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSecondDimensionKeySelected(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getCharts charts}.
     *
     * The charts to display. Theses charts are sap.ui.core/Control that implements the following properties:
     * - showLegend: boolean - icon: string (expected a string such as "sap-icon://line-chart")
     *
     * If the inserted control is an sap.m.Table, the icon is automatically set to "sap-icon://table-chart"
     */
    getCharts(): Control[];
    /**
     * Gets current value of property {@link #getChartTitle chartTitle}.
     *
     * The string to display instead of the select boxes if there are no dimensions to display
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `chartTitle`
     */
    getChartTitle(): string;
    /**
     * Gets current value of property {@link #getFirstDimensionKeyPath firstDimensionKeyPath}.
     *
     * Model path to the first select box items key
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `firstDimensionKeyPath`
     */
    getFirstDimensionKeyPath(): string;
    /**
     * Gets current value of property {@link #getFirstDimensionPath firstDimensionPath}.
     *
     * Model path to the dimensions to display into the first select box
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `firstDimensionPath`
     */
    getFirstDimensionPath(): string;
    /**
     * ID of the element which is the current target of the association {@link #getFirstDimensionSelect firstDimensionSelect},
     * or `null`.
     */
    getFirstDimensionSelect(): ID;
    /**
     * Gets current value of property {@link #getFirstDimensionTextPath firstDimensionTextPath}.
     *
     * Model path to the first select box items displayed text
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `firstDimensionTextPath`
     */
    getFirstDimensionTextPath(): string;
    /**
     * Gets current value of property {@link #getFullScreen fullScreen}.
     *
     * Display the chart and the toolbar in full screen or normal mode
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `fullScreen`
     */
    getFullScreen(): boolean;
    /**
     * Gets current value of property {@link #getSecondDimensionKeyPath secondDimensionKeyPath}.
     *
     * Model path to the second select box items key
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `secondDimensionKeyPath`
     */
    getSecondDimensionKeyPath(): string;
    /**
     * Gets current value of property {@link #getSecondDimensionPath secondDimensionPath}.
     *
     * Model path to the dimensions to display into the second select box
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `secondDimensionPath`
     */
    getSecondDimensionPath(): string;
    /**
     * ID of the element which is the current target of the association {@link #getSecondDimensionSelect secondDimensionSelect},
     * or `null`.
     */
    getSecondDimensionSelect(): ID;
    /**
     * Gets current value of property {@link #getSecondDimensionTextPath secondDimensionTextPath}.
     *
     * Model path to the displayed select box items displayed text
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `secondDimensionTextPath`
     */
    getSecondDimensionTextPath(): string;
    /**
     * ID of the element which is the current target of the association {@link #getSelectedChart selectedChart},
     * or `null`.
     */
    getSelectedChart(): ID;
    /**
     * Gets current value of property {@link #getShowFullScreen showFullScreen}.
     *
     * Display or not the full screen icon into the ChartToolBar
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showFullScreen`
     */
    getShowFullScreen(): boolean;
    /**
     * Gets current value of property {@link #getShowLegend showLegend}.
     *
     * Display or not the legend on the contained charts.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showLegend`
     */
    getShowLegend(): boolean;
    /**
     * Gets current value of property {@link #getShowPersonalization showPersonalization}.
     *
     * Display or not the personalization icon into the ChartToolBar
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showPersonalization`
     */
    getShowPersonalization(): boolean;
    /**
     * Gets content of aggregation {@link #getToolBar toolBar}.
     *
     * The composite sap.m.Bar used for rendering select boxes and icons.
     */
    getToolBar(): Bar;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getCharts charts}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfChart(
      /**
       * The chart whose index is looked for
       */
      oChart: Control
    ): int;
    /**
     * Inserts a chart into the aggregation {@link #getCharts charts}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertChart(
      /**
       * The chart to insert; if empty, nothing is inserted
       */
      oChart: Control,
      /**
       * The `0`-based index the chart should be inserted at; for a negative value of `iIndex`, the chart is inserted
       * at position 0; for a value greater than the current size of the aggregation, the chart is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getCharts charts}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllCharts(): Control[];
    /**
     * Removes a chart from the aggregation {@link #getCharts charts}.
     *
     *
     * @returns The removed chart or `null`
     */
    removeChart(
      /**
       * The chart to remove or its index or id
       */
      vChart: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getChartTitle chartTitle}.
     *
     * The string to display instead of the select boxes if there are no dimensions to display
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChartTitle(
      /**
       * New value for property `chartTitle`
       */
      sChartTitle?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFirstDimensionKeyPath firstDimensionKeyPath}.
     *
     * Model path to the first select box items key
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFirstDimensionKeyPath(
      /**
       * New value for property `firstDimensionKeyPath`
       */
      sFirstDimensionKeyPath?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFirstDimensionPath firstDimensionPath}.
     *
     * Model path to the dimensions to display into the first select box
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFirstDimensionPath(
      /**
       * New value for property `firstDimensionPath`
       */
      sFirstDimensionPath?: string
    ): this;
    /**
     * Sets the associated {@link #getFirstDimensionSelect firstDimensionSelect}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFirstDimensionSelect(
      /**
       * ID of an element which becomes the new target of this firstDimensionSelect association; alternatively,
       * an element instance may be given
       */
      oFirstDimensionSelect: ID | Select
    ): this;
    /**
     * Sets a new value for property {@link #getFirstDimensionTextPath firstDimensionTextPath}.
     *
     * Model path to the first select box items displayed text
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFirstDimensionTextPath(
      /**
       * New value for property `firstDimensionTextPath`
       */
      sFirstDimensionTextPath?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFullScreen fullScreen}.
     *
     * Display the chart and the toolbar in full screen or normal mode
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFullScreen(
      /**
       * New value for property `fullScreen`
       */
      bFullScreen?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSecondDimensionKeyPath secondDimensionKeyPath}.
     *
     * Model path to the second select box items key
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSecondDimensionKeyPath(
      /**
       * New value for property `secondDimensionKeyPath`
       */
      sSecondDimensionKeyPath?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSecondDimensionPath secondDimensionPath}.
     *
     * Model path to the dimensions to display into the second select box
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSecondDimensionPath(
      /**
       * New value for property `secondDimensionPath`
       */
      sSecondDimensionPath?: string
    ): this;
    /**
     * Sets the associated {@link #getSecondDimensionSelect secondDimensionSelect}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSecondDimensionSelect(
      /**
       * ID of an element which becomes the new target of this secondDimensionSelect association; alternatively,
       * an element instance may be given
       */
      oSecondDimensionSelect: ID | Select
    ): this;
    /**
     * Sets a new value for property {@link #getSecondDimensionTextPath secondDimensionTextPath}.
     *
     * Model path to the displayed select box items displayed text
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSecondDimensionTextPath(
      /**
       * New value for property `secondDimensionTextPath`
       */
      sSecondDimensionTextPath?: string
    ): this;
    /**
     * Sets the associated {@link #getSelectedChart selectedChart}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectedChart(
      /**
       * ID of an element which becomes the new target of this selectedChart association; alternatively, an element
       * instance may be given
       */
      oSelectedChart: ID | Control
    ): this;
    /**
     * Sets a new value for property {@link #getShowFullScreen showFullScreen}.
     *
     * Display or not the full screen icon into the ChartToolBar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowFullScreen(
      /**
       * New value for property `showFullScreen`
       */
      bShowFullScreen?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowLegend showLegend}.
     *
     * Display or not the legend on the contained charts.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowLegend(
      /**
       * New value for property `showLegend`
       */
      bShowLegend?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowPersonalization showPersonalization}.
     *
     * Display or not the personalization icon into the ChartToolBar
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowPersonalization(
      /**
       * New value for property `showPersonalization`
       */
      bShowPersonalization?: boolean
    ): this;
    /**
     * Sets the aggregated {@link #getToolBar toolBar}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolBar(
      /**
       * The toolBar to set
       */
      oToolBar: Bar
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ChartToolBar constructor.
   *
   * @deprecated (since 1.24) - Sap.ca charts and the ChartToolBar have been replaced with sap.viz and vizFrame
   * in 1.24. The UI5 control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the
   * new charts. Now that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead!
   * This control will not be supported anymore from 1.24.
   */
  export interface $ChartToolBarSettings extends $ControlSettings {
    /**
     * Display or not the personalization icon into the ChartToolBar
     */
    showPersonalization?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Display or not the full screen icon into the ChartToolBar
     */
    showFullScreen?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Display the chart and the toolbar in full screen or normal mode
     */
    fullScreen?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Display or not the legend on the contained charts.
     */
    showLegend?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The string to display instead of the select boxes if there are no dimensions to display
     */
    chartTitle?: string | PropertyBindingInfo;

    /**
     * Model path to the dimensions to display into the first select box
     */
    firstDimensionPath?: string | PropertyBindingInfo;

    /**
     * Model path to the first select box items key
     */
    firstDimensionKeyPath?: string | PropertyBindingInfo;

    /**
     * Model path to the first select box items displayed text
     */
    firstDimensionTextPath?: string | PropertyBindingInfo;

    /**
     * Model path to the dimensions to display into the second select box
     */
    secondDimensionPath?: string | PropertyBindingInfo;

    /**
     * Model path to the second select box items key
     */
    secondDimensionKeyPath?: string | PropertyBindingInfo;

    /**
     * Model path to the displayed select box items displayed text
     */
    secondDimensionTextPath?: string | PropertyBindingInfo;

    /**
     * The charts to display. Theses charts are sap.ui.core/Control that implements the following properties:
     * - showLegend: boolean - icon: string (expected a string such as "sap-icon://line-chart")
     *
     * If the inserted control is an sap.m.Table, the icon is automatically set to "sap-icon://table-chart"
     */
    charts?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * The composite sap.m.Bar used for rendering select boxes and icons.
     */
    toolBar?: Bar;

    /**
     * The ui5 control displayed
     */
    selectedChart?: Control | string;

    /**
     * The sap.m.Select inserted into the toolBar for handling the firstDimension selection
     */
    firstDimensionSelect?: Select | string;

    /**
     * The sap.m.Select inserted into the toolBar for handling the secondDimension selection
     */
    secondDimensionSelect?: Select | string;

    /**
     * Event fired when a user clicks on the personalization icon
     */
    personalizationPressed?: (oEvent: Event) => void;

    /**
     * Event fired when a user selects an item from the first select box. This event is providing the item selectedKey
     * as parameter
     */
    firstDimensionKeySelected?: (oEvent: Event) => void;

    /**
     * Event fired when a user selects an item from the second select box. This event is providing the item
     * selectedKey as parameter
     */
    secondDimensionKeySelected?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the ChartToolBar#firstDimensionKeySelected event.
   */
  export interface ChartToolBar$FirstDimensionKeySelectedEventParameters {}

  /**
   * Event object of the ChartToolBar#firstDimensionKeySelected event.
   */
  export type ChartToolBar$FirstDimensionKeySelectedEvent = Event<
    ChartToolBar$FirstDimensionKeySelectedEventParameters,
    ChartToolBar
  >;

  /**
   * Parameters of the ChartToolBar#personalizationPressed event.
   */
  export interface ChartToolBar$PersonalizationPressedEventParameters {}

  /**
   * Event object of the ChartToolBar#personalizationPressed event.
   */
  export type ChartToolBar$PersonalizationPressedEvent = Event<
    ChartToolBar$PersonalizationPressedEventParameters,
    ChartToolBar
  >;

  /**
   * Parameters of the ChartToolBar#secondDimensionKeySelected event.
   */
  export interface ChartToolBar$SecondDimensionKeySelectedEventParameters {}

  /**
   * Event object of the ChartToolBar#secondDimensionKeySelected event.
   */
  export type ChartToolBar$SecondDimensionKeySelectedEvent = Event<
    ChartToolBar$SecondDimensionKeySelectedEventParameters,
    ChartToolBar
  >;
}

declare module "sap/ca/ui/charts/ChartType" {
  /**
   * Types of chart supported in the sap.ca library.
   */
  interface ChartType {
    /**
     * A Bar Chart using "viz/bar" chart
     */
    Bar: undefined;

    /**
     * A Bubble chart using "viz/bubble" chart
     */
    Bubble: undefined;

    /**
     * A Column Chart using "viz/column" chart
     */
    Column: undefined;

    /**
     * A Combination chart using "viz/combination" chart
     */
    Combination: undefined;

    /**
     * A Dual Stacked Bar Chart using "viz/dual_stacked_bar" chart
     */
    DualStackedBar: undefined;

    /**
     * A 100% Dual Stacked Bar Chart using "viz/100_dual_stacked_bar" chart
     */
    DualStackedBar100: undefined;

    /**
     * A Dual Stacked Column Chart using "viz/dual_stacked_column" chart
     */
    DualStackedColumn: undefined;

    /**
     * A 100% Dual Stacked Column Chart using "viz/100_dual_stacked_column" chart
     */
    DualStackedColumn100: undefined;

    /**
     * A Line Chart using "viz/line" chart
     */
    Line: undefined;

    /**
     * A Stacked Bar Chart using "viz/stacked_bar" chart
     */
    StackedBar: undefined;

    /**
     * A 100% Stacked Bar Chart using "viz/100_stacked_bar" chart
     */
    StackedBar100: undefined;

    /**
     * A Stacked Column Chart using "viz/stacked_column" chart
     */
    StackedColumn: undefined;

    /**
     * A 100% Stacked Column Chart using "viz/100_stacked_column" chart
     */
    StackedColumn100: undefined;
  }
  const ChartType: ChartType;
  export default ChartType;
}

declare module "sap/ca/ui/charts/ClusterListItem" {
  import {
    default as ListItemBase,
    $ListItemBaseSettings,
  } from "sap/m/ListItemBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The cluster list item consists of a title and items.
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and VizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export default class ClusterListItem extends ListItemBase {
    /**
     * Constructor for a new charts/ClusterListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ClusterListItemSettings
    );
    /**
     * Constructor for a new charts/ClusterListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ClusterListItemSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.charts.ClusterListItem with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.ListItemBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ClusterListItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.charts.ClusterListItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getItems items}.
     *
     * Items
     *
     *
     * @returns Value of property `items`
     */
    getItems(): object;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Title
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Sets a new value for property {@link #getItems items}.
     *
     * Items
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setItems(
      /**
       * New value for property `items`
       */
      oItems?: object
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * Title
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ClusterListItem constructor.
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and VizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export interface $ClusterListItemSettings extends $ListItemBaseSettings {
    /**
     * Title
     */
    title?: string | PropertyBindingInfo;

    /**
     * Items
     */
    items?: object | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ca/ui/charts/CombinedChart" {
  import { default as Chart, $ChartSettings } from "sap/ca/ui/charts/Chart";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import ScrollContainer from "sap/m/ScrollContainer";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Allows you to create a chart using vertical bars and lines to represent the data
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export default class CombinedChart extends Chart {
    /**
     * Constructor for a new charts/CombinedChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $CombinedChartSettings
    );
    /**
     * Constructor for a new charts/CombinedChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $CombinedChartSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.charts.CombinedChart with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ca.ui.charts.Chart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CombinedChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.charts.CombinedChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the scrollArea in the aggregation {@link #getScrollArea scrollArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyScrollArea(): this;
    /**
     * Gets current value of property {@link #getData data}.
     *
     * Data of the Chart
     *
     *
     * @returns Value of property `data`
     */
    getData(): any;
    /**
     * Gets current value of property {@link #getPrimaryAxis primaryAxis}.
     *
     * Shapes for the internal viz chart primary axis
     *
     *
     * @returns Value of property `primaryAxis`
     */
    getPrimaryAxis(): any;
    /**
     * Gets content of aggregation {@link #getScrollArea scrollArea}.
     *
     * scroll area that contains the graph plot
     */
    getScrollArea(): ScrollContainer;
    /**
     * Gets current value of property {@link #getSecondAxis secondAxis}.
     *
     * Shapes for the internal viz chart second axis
     *
     *
     * @returns Value of property `secondAxis`
     */
    getSecondAxis(): any;
    /**
     * Sets a new value for property {@link #getData data}.
     *
     * Data of the Chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setData(
      /**
       * New value for property `data`
       */
      oData?: any
    ): this;
    /**
     * Sets a new value for property {@link #getPrimaryAxis primaryAxis}.
     *
     * Shapes for the internal viz chart primary axis
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPrimaryAxis(
      /**
       * New value for property `primaryAxis`
       */
      oPrimaryAxis?: any
    ): this;
    /**
     * Sets the aggregated {@link #getScrollArea scrollArea}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setScrollArea(
      /**
       * The scrollArea to set
       */
      oScrollArea: ScrollContainer
    ): this;
    /**
     * Sets a new value for property {@link #getSecondAxis secondAxis}.
     *
     * Shapes for the internal viz chart second axis
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSecondAxis(
      /**
       * New value for property `secondAxis`
       */
      oSecondAxis?: any
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CombinedChart constructor.
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export interface $CombinedChartSettings extends $ChartSettings {
    /**
     * Data of the Chart
     */
    data?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Shapes for the internal viz chart primary axis
     */
    primaryAxis?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Shapes for the internal viz chart second axis
     */
    secondAxis?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * scroll area that contains the graph plot
     */
    scrollArea?: ScrollContainer;
  }
}

declare module "sap/ca/ui/charts/HorizontalBarChart" {
  import { default as Chart, $ChartSettings } from "sap/ca/ui/charts/Chart";

  import Bar from "sap/viz/ui5/Bar";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import ScrollContainer from "sap/m/ScrollContainer";

  import VBox from "sap/m/VBox";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Allows you to create a chart using horizontal bars to represent the data
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export default class HorizontalBarChart extends Chart {
    /**
     * Constructor for a new charts/HorizontalBarChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $HorizontalBarChartSettings
    );
    /**
     * Constructor for a new charts/HorizontalBarChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $HorizontalBarChartSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.charts.HorizontalBarChart with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ca.ui.charts.Chart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, HorizontalBarChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.charts.HorizontalBarChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the horizontalBarChart in the aggregation {@link #getHorizontalBarChart horizontalBarChart}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyHorizontalBarChart(): this;
    /**
     * Destroys the scroll in the aggregation {@link #getScroll scroll}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyScroll(): this;
    /**
     * Destroys the verticalArea in the aggregation {@link #getVerticalArea verticalArea}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyVerticalArea(): this;
    /**
     * Gets current value of property {@link #getBarHeight barHeight}.
     *
     * Minimum shape size for touch enabled actions, default and minimum to 48px !
     *
     * Default value is `48`.
     *
     *
     * @returns Value of property `barHeight`
     */
    getBarHeight(): int;
    /**
     * Gets current value of property {@link #getContainer container}.
     *
     * The DOM ID where the chart will be added. Deprecated
     *
     * Default value is `'chart'`.
     *
     *
     * @returns Value of property `container`
     */
    getContainer(): string;
    /**
     * Gets current value of property {@link #getData data}.
     *
     * The data to be used by the chart
     *
     *
     * @returns Value of property `data`
     */
    getData(): object;
    /**
     * Gets content of aggregation {@link #getHorizontalBarChart horizontalBarChart}.
     *
     * The internal chart
     */
    getHorizontalBarChart(): Bar;
    /**
     * Gets content of aggregation {@link #getScroll scroll}.
     *
     * The scroll container
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     */
    getScroll(): ScrollContainer;
    /**
     * Gets content of aggregation {@link #getVerticalArea verticalArea}.
     *
     * The vertical area within the scroll container
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     */
    getVerticalArea(): VBox;
    /**
     * Sets a new value for property {@link #getBarHeight barHeight}.
     *
     * Minimum shape size for touch enabled actions, default and minimum to 48px !
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `48`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBarHeight(
      /**
       * New value for property `barHeight`
       */
      iBarHeight?: int
    ): this;
    /**
     * Sets a new value for property {@link #getContainer container}.
     *
     * The DOM ID where the chart will be added. Deprecated
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'chart'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContainer(
      /**
       * New value for property `container`
       */
      sContainer?: string
    ): this;
    /**
     * Sets a new value for property {@link #getData data}.
     *
     * The data to be used by the chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setData(
      /**
       * New value for property `data`
       */
      oData?: object
    ): this;
    /**
     * Sets the aggregated {@link #getHorizontalBarChart horizontalBarChart}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHorizontalBarChart(
      /**
       * The horizontalBarChart to set
       */
      oHorizontalBarChart: Bar
    ): this;
    /**
     * Sets the aggregated {@link #getScroll scroll}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setScroll(
      /**
       * The scroll to set
       */
      oScroll: ScrollContainer
    ): this;
    /**
     * Sets the aggregated {@link #getVerticalArea verticalArea}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVerticalArea(
      /**
       * The verticalArea to set
       */
      oVerticalArea: VBox
    ): this;
  }
  /**
   * Describes the settings that can be provided to the HorizontalBarChart constructor.
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export interface $HorizontalBarChartSettings extends $ChartSettings {
    /**
     * The data to be used by the chart
     */
    data?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * The DOM ID where the chart will be added. Deprecated
     */
    container?: string | PropertyBindingInfo;

    /**
     * Minimum shape size for touch enabled actions, default and minimum to 48px !
     */
    barHeight?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * The scroll container
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     */
    scroll?: ScrollContainer;

    /**
     * The internal chart
     */
    horizontalBarChart?: Bar;

    /**
     * The vertical area within the scroll container
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     */
    verticalArea?: VBox;
  }
}

declare module "sap/ca/ui/charts/LineChart" {
  import { default as Chart, $ChartSettings } from "sap/ca/ui/charts/Chart";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import VBox from "sap/m/VBox";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Line Chart for the Fiori Project
   *
   * @since 1.0.0
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export default class LineChart extends Chart {
    /**
     * Constructor for a new charts/LineChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $LineChartSettings
    );
    /**
     * Constructor for a new charts/LineChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $LineChartSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.charts.LineChart with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ca.ui.charts.Chart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, LineChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.charts.LineChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:onDetailsSelected onDetailsSelected} event of
     * this `sap.ca.ui.charts.LineChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.charts.LineChart` itself.
     *
     * Event fired when the details button is pressed on the selected Datapoint Popover
     *
     * @deprecated (since 1.0.0) - Do not use as it will be removed in a future release.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachOnDetailsSelected(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.charts.LineChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:onDetailsSelected onDetailsSelected} event of
     * this `sap.ca.ui.charts.LineChart`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.charts.LineChart` itself.
     *
     * Event fired when the details button is pressed on the selected Datapoint Popover
     *
     * @deprecated (since 1.0.0) - Do not use as it will be removed in a future release.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachOnDetailsSelected(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.charts.LineChart` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the vertical in the aggregation {@link #getVertical vertical}.
     *
     * @deprecated (since 1.0.0) - Do not use as it will be removed in a future release.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyVertical(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:onDetailsSelected onDetailsSelected} event
     * of this `sap.ca.ui.charts.LineChart`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.0.0) - Do not use as it will be removed in a future release.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachOnDetailsSelected(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:onDetailsSelected onDetailsSelected} to attached listeners.
     *
     * @deprecated (since 1.0.0) - Do not use as it will be removed in a future release.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireOnDetailsSelected(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getChartBusinessData chartBusinessData}.
     *
     * Allow the chart data to be set, that is the measure and dimension values
     *
     * @deprecated (since 1.0.0) - This is a copy of the 'data' property, do not use as it will be removed in
     * a future release.
     *
     * @returns Value of property `chartBusinessData`
     */
    getChartBusinessData(): any;
    /**
     * Gets current value of property {@link #getChartDataset chartDataset}.
     *
     * Allow the Dataset for the chart to be set, includes the dimensions, and measures, any data binding is
     * removed, this will disable the chart scroll context view, use the dataset settings if you want the scroll
     * context to work
     *
     * @deprecated (since 1.0.0) - This is a copy of the 'dataset' property, do not use as it will be removed
     * in a future release.
     *
     * @returns Value of property `chartDataset`
     */
    getChartDataset(): any;
    /**
     * Gets current value of property {@link #getChartDatasetSettings chartDatasetSettings}.
     *
     * Allow the Dataset for the chart to be set by providing the settings for the dataset creation, (internally
     * two datasets are created, one for the main chart and one for the scroll context)
     *
     * @deprecated (since 1.0.0) - This is a copy of the 'datasetSettings' property, do not use as it will be
     * removed in a future release.
     *
     * @returns Value of property `chartDatasetSettings`
     */
    getChartDatasetSettings(): any;
    /**
     * Gets current value of property {@link #getChartTitle chartTitle}.
     *
     * The title to display on the chart
     *
     * Default value is `'Line Chart'`.
     *
     * @deprecated (since 1.0.0) - This is a copy of the 'title' property, do not use as it will be removed
     * in a future release.
     *
     * @returns Value of property `chartTitle`
     */
    getChartTitle(): string;
    /**
     * Gets current value of property {@link #getData data}.
     *
     * Allow the chart data to be set, that is the measure and dimension values
     *
     * @deprecated (since 1.0.0) - Please use the binding on 'dataset', do not use as it will be removed in
     * a future release.
     *
     * @returns Value of property `data`
     */
    getData(): any;
    /**
     * Gets current value of property {@link #getDataLabelFormat dataLabelFormat}.
     *
     * The data format string to use to display the data labels on the graph, this is an array of arrays of
     * Format String following the 'sap.viz.ui5.Line' documentation
     *
     * Default value is `'#0'`.
     *
     *
     * @returns Value of property `dataLabelFormat`
     */
    getDataLabelFormat(): any;
    /**
     * Gets current value of property {@link #getDataPath dataPath}.
     *
     * Allow the data path for binding the model to the dimensions and measures to be set
     *
     * @deprecated (since 1.0.0) - Please use the binding on 'dataset', do not use as it will be removed in
     * a future release.
     *
     * @returns Value of property `dataPath`
     */
    getDataPath(): string;
    /**
     * Gets current value of property {@link #getDatasetSettings datasetSettings}.
     *
     * Allow the Dataset for the chart to be set by providing the settings for the dataset creation, (internally
     * two datasets are created, one for the main chart and one for the scroll context)
     *
     * @deprecated (since 1.0.0) - This is property is not needed any more, do not use as it will be removed
     * in a future release.
     *
     * @returns Value of property `datasetSettings`
     */
    getDatasetSettings(): any;
    /**
     * Gets current value of property {@link #getMinTouchSize minTouchSize}.
     *
     * The minimum size (width for a line chart) that a point has to be, so as to be able to touch on a mobile
     * device, only applies if the chart width is not set
     *
     * Default value is `'48px'`.
     *
     * @deprecated (since 1.0.0) - Please use the 'dataLabelFormatter' property, do not use as it will be removed
     * in a future release.
     *
     * @returns Value of property `minTouchSize`
     */
    getMinTouchSize(): string;
    /**
     * Gets current value of property {@link #getMinTouchWidth minTouchWidth}.
     *
     * The minimum size (width for a line chart) that a point has to be, so as to be able to touch on a mobile
     * device, only applies if the chart width is not set
     *
     * Default value is `'48px'`.
     *
     * @deprecated (since 1.0.0) - Please use the 'minShapeSize' property, do not use as it will be removed
     * in a future release.
     *
     * @returns Value of property `minTouchWidth`
     */
    getMinTouchWidth(): string;
    /**
     * Gets current value of property {@link #getShowLabel showLabel}.
     *
     * Show the data label value on the chart
     *
     * Default value is `true`.
     *
     * @deprecated (since 1.0.0) - This is a copy of the 'showDataLabel' property, do not use as it will be
     * removed in a future release.
     *
     * @returns Value of property `showLabel`
     */
    getShowLabel(): boolean;
    /**
     * Gets current value of property {@link #getShowScrollContext showScrollContext}.
     *
     * Show the chart scroll context, (the preview of the whole chart as a small image when scrolling)
     *
     * Default value is `false`.
     *
     * @deprecated (since 1.0.0) - Feature does not work correctly yet.
     *
     * @returns Value of property `showScrollContext`
     */
    getShowScrollContext(): boolean;
    /**
     * Gets current value of property {@link #getUseDelayedResize useDelayedResize}.
     *
     * Use a delayed resize event to cause the chart to render when navigated to after resize when in the background
     *
     * Default value is `false`.
     *
     * @deprecated (since 1.0.0) - Do not use as it will be removed in a future release.
     *
     * @returns Value of property `useDelayedResize`
     */
    getUseDelayedResize(): boolean;
    /**
     * Gets content of aggregation {@link #getVertical vertical}.
     *
     * The vertical layout
     *
     * @deprecated (since 1.0.0) - Do not use as it will be removed in a future release.
     */
    getVertical(): VBox;
    /**
     * Sets a new value for property {@link #getChartBusinessData chartBusinessData}.
     *
     * Allow the chart data to be set, that is the measure and dimension values
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated (since 1.0.0) - This is a copy of the 'data' property, do not use as it will be removed in
     * a future release.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChartBusinessData(
      /**
       * New value for property `chartBusinessData`
       */
      oChartBusinessData?: any
    ): this;
    /**
     * Sets a new value for property {@link #getChartDataset chartDataset}.
     *
     * Allow the Dataset for the chart to be set, includes the dimensions, and measures, any data binding is
     * removed, this will disable the chart scroll context view, use the dataset settings if you want the scroll
     * context to work
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated (since 1.0.0) - This is a copy of the 'dataset' property, do not use as it will be removed
     * in a future release.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChartDataset(
      /**
       * New value for property `chartDataset`
       */
      oChartDataset?: any
    ): this;
    /**
     * Sets a new value for property {@link #getChartDatasetSettings chartDatasetSettings}.
     *
     * Allow the Dataset for the chart to be set by providing the settings for the dataset creation, (internally
     * two datasets are created, one for the main chart and one for the scroll context)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated (since 1.0.0) - This is a copy of the 'datasetSettings' property, do not use as it will be
     * removed in a future release.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChartDatasetSettings(
      /**
       * New value for property `chartDatasetSettings`
       */
      oChartDatasetSettings?: any
    ): this;
    /**
     * Sets a new value for property {@link #getChartTitle chartTitle}.
     *
     * The title to display on the chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'Line Chart'`.
     *
     * @deprecated (since 1.0.0) - This is a copy of the 'title' property, do not use as it will be removed
     * in a future release.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChartTitle(
      /**
       * New value for property `chartTitle`
       */
      sChartTitle?: string
    ): this;
    /**
     * Sets a new value for property {@link #getData data}.
     *
     * Allow the chart data to be set, that is the measure and dimension values
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated (since 1.0.0) - Please use the binding on 'dataset', do not use as it will be removed in
     * a future release.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setData(
      /**
       * New value for property `data`
       */
      oData?: any
    ): this;
    /**
     * Sets a new value for property {@link #getDataLabelFormat dataLabelFormat}.
     *
     * The data format string to use to display the data labels on the graph, this is an array of arrays of
     * Format String following the 'sap.viz.ui5.Line' documentation
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'#0'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabelFormat(
      /**
       * New value for property `dataLabelFormat`
       */
      oDataLabelFormat?: any
    ): this;
    /**
     * Sets a new value for property {@link #getDataPath dataPath}.
     *
     * Allow the data path for binding the model to the dimensions and measures to be set
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated (since 1.0.0) - Please use the binding on 'dataset', do not use as it will be removed in
     * a future release.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataPath(
      /**
       * New value for property `dataPath`
       */
      sDataPath?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDatasetSettings datasetSettings}.
     *
     * Allow the Dataset for the chart to be set by providing the settings for the dataset creation, (internally
     * two datasets are created, one for the main chart and one for the scroll context)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated (since 1.0.0) - This is property is not needed any more, do not use as it will be removed
     * in a future release.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDatasetSettings(
      /**
       * New value for property `datasetSettings`
       */
      oDatasetSettings?: any
    ): this;
    /**
     * Sets a new value for property {@link #getMinTouchSize minTouchSize}.
     *
     * The minimum size (width for a line chart) that a point has to be, so as to be able to touch on a mobile
     * device, only applies if the chart width is not set
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'48px'`.
     *
     * @deprecated (since 1.0.0) - Please use the 'dataLabelFormatter' property, do not use as it will be removed
     * in a future release.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinTouchSize(
      /**
       * New value for property `minTouchSize`
       */
      sMinTouchSize?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMinTouchWidth minTouchWidth}.
     *
     * The minimum size (width for a line chart) that a point has to be, so as to be able to touch on a mobile
     * device, only applies if the chart width is not set
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'48px'`.
     *
     * @deprecated (since 1.0.0) - Please use the 'minShapeSize' property, do not use as it will be removed
     * in a future release.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinTouchWidth(
      /**
       * New value for property `minTouchWidth`
       */
      sMinTouchWidth?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShowLabel showLabel}.
     *
     * Show the data label value on the chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @deprecated (since 1.0.0) - This is a copy of the 'showDataLabel' property, do not use as it will be
     * removed in a future release.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowLabel(
      /**
       * New value for property `showLabel`
       */
      bShowLabel?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowScrollContext showScrollContext}.
     *
     * Show the chart scroll context, (the preview of the whole chart as a small image when scrolling)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @deprecated (since 1.0.0) - Feature does not work correctly yet.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowScrollContext(
      /**
       * New value for property `showScrollContext`
       */
      bShowScrollContext?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getUseDelayedResize useDelayedResize}.
     *
     * Use a delayed resize event to cause the chart to render when navigated to after resize when in the background
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @deprecated (since 1.0.0) - Do not use as it will be removed in a future release.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUseDelayedResize(
      /**
       * New value for property `useDelayedResize`
       */
      bUseDelayedResize?: boolean
    ): this;
    /**
     * Sets the aggregated {@link #getVertical vertical}.
     *
     * @deprecated (since 1.0.0) - Do not use as it will be removed in a future release.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVertical(
      /**
       * The vertical to set
       */
      oVertical: VBox
    ): this;
  }
  /**
   * Describes the settings that can be provided to the LineChart constructor.
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export interface $LineChartSettings extends $ChartSettings {
    /**
     * The title to display on the chart
     *
     * @deprecated (since 1.0.0) - This is a copy of the 'title' property, do not use as it will be removed
     * in a future release.
     */
    chartTitle?: string | PropertyBindingInfo;

    /**
     * The data format string to use to display the data labels on the graph, this is an array of arrays of
     * Format String following the 'sap.viz.ui5.Line' documentation
     */
    dataLabelFormat?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * The minimum size (width for a line chart) that a point has to be, so as to be able to touch on a mobile
     * device, only applies if the chart width is not set
     *
     * @deprecated (since 1.0.0) - Please use the 'dataLabelFormatter' property, do not use as it will be removed
     * in a future release.
     */
    minTouchSize?: string | PropertyBindingInfo;

    /**
     * The minimum size (width for a line chart) that a point has to be, so as to be able to touch on a mobile
     * device, only applies if the chart width is not set
     *
     * @deprecated (since 1.0.0) - Please use the 'minShapeSize' property, do not use as it will be removed
     * in a future release.
     */
    minTouchWidth?: string | PropertyBindingInfo;

    /**
     * Show the data label value on the chart
     *
     * @deprecated (since 1.0.0) - This is a copy of the 'showDataLabel' property, do not use as it will be
     * removed in a future release.
     */
    showLabel?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Show the chart scroll context, (the preview of the whole chart as a small image when scrolling)
     *
     * @deprecated (since 1.0.0) - Feature does not work correctly yet.
     */
    showScrollContext?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Allow the Dataset for the chart to be set, includes the dimensions, and measures, any data binding is
     * removed, this will disable the chart scroll context view, use the dataset settings if you want the scroll
     * context to work
     *
     * @deprecated (since 1.0.0) - This is a copy of the 'dataset' property, do not use as it will be removed
     * in a future release.
     */
    chartDataset?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Allow the Dataset for the chart to be set by providing the settings for the dataset creation, (internally
     * two datasets are created, one for the main chart and one for the scroll context)
     *
     * @deprecated (since 1.0.0) - This is property is not needed any more, do not use as it will be removed
     * in a future release.
     */
    datasetSettings?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Allow the Dataset for the chart to be set by providing the settings for the dataset creation, (internally
     * two datasets are created, one for the main chart and one for the scroll context)
     *
     * @deprecated (since 1.0.0) - This is a copy of the 'datasetSettings' property, do not use as it will be
     * removed in a future release.
     */
    chartDatasetSettings?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Allow the data path for binding the model to the dimensions and measures to be set
     *
     * @deprecated (since 1.0.0) - Please use the binding on 'dataset', do not use as it will be removed in
     * a future release.
     */
    dataPath?: string | PropertyBindingInfo;

    /**
     * Allow the chart data to be set, that is the measure and dimension values
     *
     * @deprecated (since 1.0.0) - Please use the binding on 'dataset', do not use as it will be removed in
     * a future release.
     */
    data?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Allow the chart data to be set, that is the measure and dimension values
     *
     * @deprecated (since 1.0.0) - This is a copy of the 'data' property, do not use as it will be removed in
     * a future release.
     */
    chartBusinessData?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Use a delayed resize event to cause the chart to render when navigated to after resize when in the background
     *
     * @deprecated (since 1.0.0) - Do not use as it will be removed in a future release.
     */
    useDelayedResize?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The vertical layout
     *
     * @deprecated (since 1.0.0) - Do not use as it will be removed in a future release.
     */
    vertical?: VBox;

    /**
     * Event fired when the details button is pressed on the selected Datapoint Popover
     *
     * @deprecated (since 1.0.0) - Do not use as it will be removed in a future release.
     */
    onDetailsSelected?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the LineChart#onDetailsSelected event.
   *
   * @deprecated (since 1.0.0) - Do not use as it will be removed in a future release.
   */
  export interface LineChart$OnDetailsSelectedEventParameters {}

  /**
   * Event object of the LineChart#onDetailsSelected event.
   *
   * @deprecated (since 1.0.0) - Do not use as it will be removed in a future release.
   */
  export type LineChart$OnDetailsSelectedEvent = Event<
    LineChart$OnDetailsSelectedEventParameters,
    LineChart
  >;
}

declare module "sap/ca/ui/charts/StackedHorizontalBarChart" {
  import { default as Chart, $ChartSettings } from "sap/ca/ui/charts/Chart";

  import Control from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { CSSSize } from "sap/ui/core/library";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Stacked Horizontal Bar Chart wrapper around the viz StackedBarChart / MultipleStackedBarChart. To be
   * used in conjunction with the chart toolbar.
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export default class StackedHorizontalBarChart extends Chart {
    /**
     * Constructor for a new charts/StackedHorizontalBarChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $StackedHorizontalBarChartSettings
    );
    /**
     * Constructor for a new charts/StackedHorizontalBarChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $StackedHorizontalBarChartSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.charts.StackedHorizontalBarChart with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ca.ui.charts.Chart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, StackedHorizontalBarChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.charts.StackedHorizontalBarChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     * @deprecated (since 1.16.3) - content has been deprecated since 1.16.3. The only visible content in the
     * chart now is the internalVizChart.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     * @deprecated (since 1.16.3) - content has been deprecated since 1.16.3. The only visible content in the
     * chart now is the internalVizChart.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Deprecated aggregation. Left for compatibility purposes.
     *
     * @deprecated (since 1.16.3) - content has been deprecated since 1.16.3. The only visible content in the
     * chart now is the internalVizChart.
     */
    getContent(): Control[];
    /**
     * Gets current value of property {@link #getDataLabelFormat dataLabelFormat}.
     *
     * Defines the formater string for the dataLabel value to be diaplyed on the bubble e.g [ [##]]
     *
     * Default value is `...see text or source`.
     *
     *
     * @returns Value of property `dataLabelFormat`
     */
    getDataLabelFormat(): any;
    /**
     * Gets current value of property {@link #getMinTouchSize minTouchSize}.
     *
     * Mapped to minShapeSize property.
     *
     * Default value is `'48px'`.
     *
     * @deprecated (since 1.16.3) - minTouchSize has been deprecated since 1.16.3. Please use the minShapeSize
     * instead.
     *
     * @returns Value of property `minTouchSize`
     */
    getMinTouchSize(): CSSSize;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Mapped to charType property.
     *
     * Default value is `'StackedBar'`.
     *
     * @deprecated (since 1.16.3) - type has been deprecated since 1.16.3. Please use the chartType instead.
     *
     * @returns Value of property `type`
     */
    getType(): string;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     * @deprecated (since 1.16.3) - content has been deprecated since 1.16.3. The only visible content in the
     * chart now is the internalVizChart.
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     * @deprecated (since 1.16.3) - content has been deprecated since 1.16.3. The only visible content in the
     * chart now is the internalVizChart.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @deprecated (since 1.16.3) - content has been deprecated since 1.16.3. The only visible content in the
     * chart now is the internalVizChart.
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     * @deprecated (since 1.16.3) - content has been deprecated since 1.16.3. The only visible content in the
     * chart now is the internalVizChart.
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getDataLabelFormat dataLabelFormat}.
     *
     * Defines the formater string for the dataLabel value to be diaplyed on the bubble e.g [ [##]]
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `...see text or source`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabelFormat(
      /**
       * New value for property `dataLabelFormat`
       */
      oDataLabelFormat?: any
    ): this;
    /**
     * Sets a new value for property {@link #getMinTouchSize minTouchSize}.
     *
     * Mapped to minShapeSize property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'48px'`.
     *
     * @deprecated (since 1.16.3) - minTouchSize has been deprecated since 1.16.3. Please use the minShapeSize
     * instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinTouchSize(
      /**
       * New value for property `minTouchSize`
       */
      sMinTouchSize?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Mapped to charType property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'StackedBar'`.
     *
     * @deprecated (since 1.16.3) - type has been deprecated since 1.16.3. Please use the chartType instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the StackedHorizontalBarChart constructor.
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export interface $StackedHorizontalBarChartSettings extends $ChartSettings {
    /**
     * Mapped to charType property.
     *
     * @deprecated (since 1.16.3) - type has been deprecated since 1.16.3. Please use the chartType instead.
     */
    type?: string | PropertyBindingInfo;

    /**
     * Mapped to minShapeSize property.
     *
     * @deprecated (since 1.16.3) - minTouchSize has been deprecated since 1.16.3. Please use the minShapeSize
     * instead.
     */
    minTouchSize?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the formater string for the dataLabel value to be diaplyed on the bubble e.g [ [##]]
     */
    dataLabelFormat?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Deprecated aggregation. Left for compatibility purposes.
     *
     * @deprecated (since 1.16.3) - content has been deprecated since 1.16.3. The only visible content in the
     * chart now is the internalVizChart.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ca/ui/charts/StackedVerticalColumnChart" {
  import { default as Chart, $ChartSettings } from "sap/ca/ui/charts/Chart";

  import Control from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { CSSSize } from "sap/ui/core/library";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Stacked Vertical Column Chart wrapper around the viz StackedColumnChart / MultipleStackedColumnChart.
   * To be used in conjunction with the chart toolbar.
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export default class StackedVerticalColumnChart extends Chart {
    /**
     * Constructor for a new charts/StackedVerticalColumnChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $StackedVerticalColumnChartSettings
    );
    /**
     * Constructor for a new charts/StackedVerticalColumnChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $StackedVerticalColumnChartSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.charts.StackedVerticalColumnChart with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ca.ui.charts.Chart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, StackedVerticalColumnChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.charts.StackedVerticalColumnChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     * @deprecated (since 1.16.3) - content has been deprecated since 1.16.3. The only visible content in the
     * chart now is the internalVizChart.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     * @deprecated (since 1.16.3) - content has been deprecated since 1.16.3. The only visible content in the
     * chart now is the internalVizChart.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Deprecated aggregation. Left for compatibility purposes.
     *
     * @deprecated (since 1.16.3) - content has been deprecated since 1.16.3. The only visible content in the
     * chart now is the internalVizChart.
     */
    getContent(): Control[];
    /**
     * Gets current value of property {@link #getDataLabelFormat dataLabelFormat}.
     *
     * Does not do anything anymore
     *
     * Default value is `...see text or source`.
     *
     * @deprecated (since 1.16.3) - dataLabelFormat has been deprecated since 1.16.3. Please use the dataLabelFormatter
     * instead.
     *
     * @returns Value of property `dataLabelFormat`
     */
    getDataLabelFormat(): any;
    /**
     * Gets current value of property {@link #getMinTouchSize minTouchSize}.
     *
     * Mapped to minShapeSize property.
     *
     * Default value is `'48px'`.
     *
     * @deprecated (since 1.16.3) - minTouchSize has been deprecated since 1.16.3. Please use the minShapeSize
     * instead.
     *
     * @returns Value of property `minTouchSize`
     */
    getMinTouchSize(): CSSSize;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Mapped to charType property.
     *
     * Default value is `'StackedColumn'`.
     *
     * @deprecated (since 1.16.3) - type has been deprecated since 1.16.3. Please use the chartType instead.
     *
     * @returns Value of property `type`
     */
    getType(): string;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     * @deprecated (since 1.16.3) - content has been deprecated since 1.16.3. The only visible content in the
     * chart now is the internalVizChart.
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     * @deprecated (since 1.16.3) - content has been deprecated since 1.16.3. The only visible content in the
     * chart now is the internalVizChart.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @deprecated (since 1.16.3) - content has been deprecated since 1.16.3. The only visible content in the
     * chart now is the internalVizChart.
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     * @deprecated (since 1.16.3) - content has been deprecated since 1.16.3. The only visible content in the
     * chart now is the internalVizChart.
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getDataLabelFormat dataLabelFormat}.
     *
     * Does not do anything anymore
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `...see text or source`.
     *
     * @deprecated (since 1.16.3) - dataLabelFormat has been deprecated since 1.16.3. Please use the dataLabelFormatter
     * instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataLabelFormat(
      /**
       * New value for property `dataLabelFormat`
       */
      oDataLabelFormat?: any
    ): this;
    /**
     * Sets a new value for property {@link #getMinTouchSize minTouchSize}.
     *
     * Mapped to minShapeSize property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'48px'`.
     *
     * @deprecated (since 1.16.3) - minTouchSize has been deprecated since 1.16.3. Please use the minShapeSize
     * instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinTouchSize(
      /**
       * New value for property `minTouchSize`
       */
      sMinTouchSize?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Mapped to charType property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'StackedColumn'`.
     *
     * @deprecated (since 1.16.3) - type has been deprecated since 1.16.3. Please use the chartType instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the StackedVerticalColumnChart constructor.
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export interface $StackedVerticalColumnChartSettings extends $ChartSettings {
    /**
     * Mapped to charType property.
     *
     * @deprecated (since 1.16.3) - type has been deprecated since 1.16.3. Please use the chartType instead.
     */
    type?: string | PropertyBindingInfo;

    /**
     * Mapped to minShapeSize property.
     *
     * @deprecated (since 1.16.3) - minTouchSize has been deprecated since 1.16.3. Please use the minShapeSize
     * instead.
     */
    minTouchSize?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Does not do anything anymore
     *
     * @deprecated (since 1.16.3) - dataLabelFormat has been deprecated since 1.16.3. Please use the dataLabelFormatter
     * instead.
     */
    dataLabelFormat?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Deprecated aggregation. Left for compatibility purposes.
     *
     * @deprecated (since 1.16.3) - content has been deprecated since 1.16.3. The only visible content in the
     * chart now is the internalVizChart.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ca/ui/charts/VerticalBarChart" {
  import { default as Chart, $ChartSettings } from "sap/ca/ui/charts/Chart";

  import Control from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import ScrollContainer from "sap/m/ScrollContainer";

  import VBox from "sap/m/VBox";

  import Column from "sap/viz/ui5/Column";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Allows you to create a chart using vertical bars to represent the data
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export default class VerticalBarChart extends Chart {
    /**
     * Constructor for a new charts/VerticalBarChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $VerticalBarChartSettings
    );
    /**
     * Constructor for a new charts/VerticalBarChart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $VerticalBarChartSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.charts.VerticalBarChart with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ca.ui.charts.Chart.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, VerticalBarChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.charts.VerticalBarChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Destroys the scroll in the aggregation {@link #getScroll scroll}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyScroll(): this;
    /**
     * Destroys the verticalArea in the aggregation {@link #getVerticalArea verticalArea}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyVerticalArea(): this;
    /**
     * Destroys the verticalBarChart in the aggregation {@link #getVerticalBarChart verticalBarChart}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyVerticalBarChart(): this;
    /**
     * Gets current value of property {@link #getBarWidth barWidth}.
     *
     * Minimum shape size for touch enabled actions, default and minimum to 48px !
     *
     * Default value is `48`.
     *
     *
     * @returns Value of property `barWidth`
     */
    getBarWidth(): int;
    /**
     * Gets current value of property {@link #getContainer container}.
     *
     * The DOM ID where the chart will be added. Deprecated
     *
     * Default value is `'chart'`.
     *
     *
     * @returns Value of property `container`
     */
    getContainer(): string;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Deprecated aggregation. Left for compatibility purposes.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     */
    getContent(): Control[];
    /**
     * Gets current value of property {@link #getData data}.
     *
     * The data to be used by the chart
     *
     *
     * @returns Value of property `data`
     */
    getData(): object;
    /**
     * Gets content of aggregation {@link #getScroll scroll}.
     *
     * The scroll container
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     */
    getScroll(): ScrollContainer;
    /**
     * Gets content of aggregation {@link #getVerticalArea verticalArea}.
     *
     * The vertical layout
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     */
    getVerticalArea(): VBox;
    /**
     * Gets content of aggregation {@link #getVerticalBarChart verticalBarChart}.
     *
     * The chart
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     */
    getVerticalBarChart(): Column;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getBarWidth barWidth}.
     *
     * Minimum shape size for touch enabled actions, default and minimum to 48px !
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `48`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBarWidth(
      /**
       * New value for property `barWidth`
       */
      iBarWidth?: int
    ): this;
    /**
     * Sets a new value for property {@link #getContainer container}.
     *
     * The DOM ID where the chart will be added. Deprecated
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'chart'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContainer(
      /**
       * New value for property `container`
       */
      sContainer?: string
    ): this;
    /**
     * Sets a new value for property {@link #getData data}.
     *
     * The data to be used by the chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setData(
      /**
       * New value for property `data`
       */
      oData?: object
    ): this;
    /**
     * Sets the aggregated {@link #getScroll scroll}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setScroll(
      /**
       * The scroll to set
       */
      oScroll: ScrollContainer
    ): this;
    /**
     * Sets the aggregated {@link #getVerticalArea verticalArea}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVerticalArea(
      /**
       * The verticalArea to set
       */
      oVerticalArea: VBox
    ): this;
    /**
     * Sets the aggregated {@link #getVerticalBarChart verticalBarChart}.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVerticalBarChart(
      /**
       * The verticalBarChart to set
       */
      oVerticalBarChart: Column
    ): this;
  }
  /**
   * Describes the settings that can be provided to the VerticalBarChart constructor.
   *
   * @deprecated (since 1.24) - Sap.ca charts have been replaced with sap.viz and vizFrame in 1.24. The UI5
   * control "sap.viz.ui5.controls.VizFrame" serves as a single point of entry for all the new charts. Now
   * that 1.24 is available you are asked to use sap.viz charts and the VizFrame instead! This control will
   * not be supported anymore from 1.24.
   */
  export interface $VerticalBarChartSettings extends $ChartSettings {
    /**
     * The data to be used by the chart
     */
    data?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * The DOM ID where the chart will be added. Deprecated
     */
    container?: string | PropertyBindingInfo;

    /**
     * Minimum shape size for touch enabled actions, default and minimum to 48px !
     */
    barWidth?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Deprecated aggregation. Left for compatibility purposes.
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * The scroll container
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     */
    scroll?: ScrollContainer;

    /**
     * The chart
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     */
    verticalBarChart?: Column;

    /**
     * The vertical layout
     *
     * @deprecated (since 1.20.0) - This method is deprecated now.
     */
    verticalArea?: VBox;
  }
}

declare module "sap/ca/ui/CustomerContext" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * This control allows you to open a dialog containing a list of customers for users to pick. The chosen
   * selected customer is persisted using sap.ushell services that shall be fully configured outside of this
   * control.
   *
   * The dialog can be open following two modes: "select" : exiting without choosing a customer is firing
   * the customerSelected event with a null customer before closing the dialog "change" : exiting without
   * choosing a customer is simply closing the dialog
   *
   * When opening the dialog in "select" mode, if a customer has been persisted in a previous session, it
   * will be retrieved and the dialog won't open at all.
   *
   * @deprecated (since 1.24.3) - This control is not required anymore as per central UX requirements. Please
   * use Contextual Filter design instead! This control will not be supported anymore.
   */
  export default class CustomerContext extends Control {
    /**
     * Constructor for a new CustomerContext.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $CustomerContextSettings
    );
    /**
     * Constructor for a new CustomerContext.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $CustomerContextSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.CustomerContext with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CustomerContext>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.CustomerContext.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:customerSelected customerSelected} event of
     * this `sap.ca.ui.CustomerContext`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.CustomerContext` itself.
     *
     * Fired when a customer is selected in the list. The fired customer can be empty in case the user press
     * the cancel button while the Customer Context has been open using select()
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCustomerSelected(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.CustomerContext` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:customerSelected customerSelected} event of
     * this `sap.ca.ui.CustomerContext`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.CustomerContext` itself.
     *
     * Fired when a customer is selected in the list. The fired customer can be empty in case the user press
     * the cancel button while the Customer Context has been open using select()
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCustomerSelected(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.CustomerContext` itself
       */
      oListener?: object
    ): this;
    /**
     * Open the Customer Context dialog
     */
    change(): void;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:customerSelected customerSelected} event of
     * this `sap.ca.ui.CustomerContext`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCustomerSelected(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:customerSelected customerSelected} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCustomerSelected(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getCustomerIDProperty customerIDProperty}.
     *
     * Property name of the customer ID
     *
     * Default value is `'CustomerID'`.
     *
     *
     * @returns Value of property `customerIDProperty`
     */
    getCustomerIDProperty(): string;
    /**
     * Gets current value of property {@link #getCustomerNameProperty customerNameProperty}.
     *
     * Property name of the customer name
     *
     * Default value is `'CustomerName'`.
     *
     *
     * @returns Value of property `customerNameProperty`
     */
    getCustomerNameProperty(): string;
    /**
     * Gets current value of property {@link #getDialogTitle dialogTitle}.
     *
     * Overrides the default Dialog title
     *
     *
     * @returns Value of property `dialogTitle`
     */
    getDialogTitle(): string;
    /**
     * Gets current value of property {@link #getDistributionChannelNameProperty distributionChannelNameProperty}.
     *
     * Property name of the distribution channel name
     *
     * Default value is `'DistributionChannelName'`.
     *
     *
     * @returns Value of property `distributionChannelNameProperty`
     */
    getDistributionChannelNameProperty(): string;
    /**
     * Gets current value of property {@link #getDivisionNameProperty divisionNameProperty}.
     *
     * Property name of the division name
     *
     * Default value is `'DivisionName'`.
     *
     *
     * @returns Value of property `divisionNameProperty`
     */
    getDivisionNameProperty(): string;
    /**
     * Gets current value of property {@link #getPath path}.
     *
     * Model path to the customer collection to be displayed
     *
     * Default value is `'/Customers'`.
     *
     *
     * @returns Value of property `path`
     */
    getPath(): string;
    /**
     * Gets current value of property {@link #getPersonalizationPageName personalizationPageName}.
     *
     * Name of your app that shall be unique.
     *
     * Default value is `'AppCustomerContext'`.
     *
     *
     * @returns Value of property `personalizationPageName`
     */
    getPersonalizationPageName(): string;
    /**
     * Gets current value of property {@link #getSalesOrganizationNameProperty salesOrganizationNameProperty}.
     *
     * Property name of the sales organization name
     *
     * Default value is `'SalesOrganizationName'`.
     *
     *
     * @returns Value of property `salesOrganizationNameProperty`
     */
    getSalesOrganizationNameProperty(): string;
    /**
     * Gets current value of property {@link #getShowSalesArea showSalesArea}.
     *
     * Display or not the customers sales area as well as its name and id.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showSalesArea`
     */
    getShowSalesArea(): boolean;
    /**
     * Delete the user selected customer
     */
    reset(): void;
    /**
     * Open the Customer Context dialog and fires a null customerSelected if the cancel button is clicked
     */
    select(): void;
    /**
     * Sets a new value for property {@link #getCustomerIDProperty customerIDProperty}.
     *
     * Property name of the customer ID
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'CustomerID'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomerIDProperty(
      /**
       * New value for property `customerIDProperty`
       */
      sCustomerIDProperty?: string
    ): this;
    /**
     * Sets a new value for property {@link #getCustomerNameProperty customerNameProperty}.
     *
     * Property name of the customer name
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'CustomerName'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomerNameProperty(
      /**
       * New value for property `customerNameProperty`
       */
      sCustomerNameProperty?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDialogTitle dialogTitle}.
     *
     * Overrides the default Dialog title
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDialogTitle(
      /**
       * New value for property `dialogTitle`
       */
      sDialogTitle?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDistributionChannelNameProperty distributionChannelNameProperty}.
     *
     * Property name of the distribution channel name
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'DistributionChannelName'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDistributionChannelNameProperty(
      /**
       * New value for property `distributionChannelNameProperty`
       */
      sDistributionChannelNameProperty?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDivisionNameProperty divisionNameProperty}.
     *
     * Property name of the division name
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'DivisionName'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDivisionNameProperty(
      /**
       * New value for property `divisionNameProperty`
       */
      sDivisionNameProperty?: string
    ): this;
    /**
     * Setter for the control model
     */
    setModel(): this;
    /**
     * Sets a new value for property {@link #getPath path}.
     *
     * Model path to the customer collection to be displayed
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'/Customers'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPath(
      /**
       * New value for property `path`
       */
      sPath?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPersonalizationPageName personalizationPageName}.
     *
     * Name of your app that shall be unique.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'AppCustomerContext'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPersonalizationPageName(
      /**
       * New value for property `personalizationPageName`
       */
      sPersonalizationPageName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSalesOrganizationNameProperty salesOrganizationNameProperty}.
     *
     * Property name of the sales organization name
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'SalesOrganizationName'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSalesOrganizationNameProperty(
      /**
       * New value for property `salesOrganizationNameProperty`
       */
      sSalesOrganizationNameProperty?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShowSalesArea showSalesArea}.
     *
     * Display or not the customers sales area as well as its name and id.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowSalesArea(
      /**
       * New value for property `showSalesArea`
       */
      bShowSalesArea?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CustomerContext constructor.
   *
   * @deprecated (since 1.24.3) - This control is not required anymore as per central UX requirements. Please
   * use Contextual Filter design instead! This control will not be supported anymore.
   */
  export interface $CustomerContextSettings extends $ControlSettings {
    /**
     * Name of your app that shall be unique.
     */
    personalizationPageName?: string | PropertyBindingInfo;

    /**
     * Display or not the customers sales area as well as its name and id.
     */
    showSalesArea?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Model path to the customer collection to be displayed
     */
    path?: string | PropertyBindingInfo;

    /**
     * Property name of the customer ID
     */
    customerIDProperty?: string | PropertyBindingInfo;

    /**
     * Property name of the customer name
     */
    customerNameProperty?: string | PropertyBindingInfo;

    /**
     * Property name of the sales organization name
     */
    salesOrganizationNameProperty?: string | PropertyBindingInfo;

    /**
     * Property name of the distribution channel name
     */
    distributionChannelNameProperty?: string | PropertyBindingInfo;

    /**
     * Property name of the division name
     */
    divisionNameProperty?: string | PropertyBindingInfo;

    /**
     * Overrides the default Dialog title
     */
    dialogTitle?: string | PropertyBindingInfo;

    /**
     * Fired when a customer is selected in the list. The fired customer can be empty in case the user press
     * the cancel button while the Customer Context has been open using select()
     */
    customerSelected?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the CustomerContext#customerSelected event.
   */
  export interface CustomerContext$CustomerSelectedEventParameters {}

  /**
   * Event object of the CustomerContext#customerSelected event.
   */
  export type CustomerContext$CustomerSelectedEvent = Event<
    CustomerContext$CustomerSelectedEventParameters,
    CustomerContext
  >;
}

declare module "sap/ca/ui/CustomerControlListItem" {
  import {
    default as CustomListItem,
    $CustomListItemSettings,
  } from "sap/m/CustomListItem";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Extends the ObjectListItem to display a line in the customer context control.
   *
   * @deprecated (since 1.24.3) - This control is not required anymore as per central UX requirements. Please
   * use Contextual Filter design instead! This control will not be supported anymore.
   */
  export default class CustomerControlListItem extends CustomListItem {
    /**
     * Constructor for a new CustomerControlListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $CustomerControlListItemSettings
    );
    /**
     * Constructor for a new CustomerControlListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $CustomerControlListItemSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.CustomerControlListItem with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.CustomListItem.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CustomerControlListItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.CustomerControlListItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getCustomerID customerID}.
     *
     * The ID of the customer
     *
     * Default value is `'CustomerID'`.
     *
     *
     * @returns Value of property `customerID`
     */
    getCustomerID(): string;
    /**
     * Gets current value of property {@link #getCustomerName customerName}.
     *
     * The name of the customer
     *
     * Default value is `'CustomerName'`.
     *
     *
     * @returns Value of property `customerName`
     */
    getCustomerName(): string;
    /**
     * Gets current value of property {@link #getDistributionChannelName distributionChannelName}.
     *
     * The distribution channel name
     *
     * Default value is `'DistributionChannelName'`.
     *
     *
     * @returns Value of property `distributionChannelName`
     */
    getDistributionChannelName(): string;
    /**
     * Gets current value of property {@link #getDivisionName divisionName}.
     *
     * The division name
     *
     * Default value is `'DivisionName'`.
     *
     *
     * @returns Value of property `divisionName`
     */
    getDivisionName(): string;
    /**
     * Gets current value of property {@link #getSalesOrganizationName salesOrganizationName}.
     *
     * The sales organization name
     *
     * Default value is `'SalesOrganizationName'`.
     *
     *
     * @returns Value of property `salesOrganizationName`
     */
    getSalesOrganizationName(): string;
    /**
     * Gets current value of property {@link #getShowSalesArea showSalesArea}.
     *
     * Display or not the customers sales area as well as its name and id.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showSalesArea`
     */
    getShowSalesArea(): boolean;
    /**
     * Sets a new value for property {@link #getCustomerID customerID}.
     *
     * The ID of the customer
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'CustomerID'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomerID(
      /**
       * New value for property `customerID`
       */
      sCustomerID?: string
    ): this;
    /**
     * Sets a new value for property {@link #getCustomerName customerName}.
     *
     * The name of the customer
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'CustomerName'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomerName(
      /**
       * New value for property `customerName`
       */
      sCustomerName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDistributionChannelName distributionChannelName}.
     *
     * The distribution channel name
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'DistributionChannelName'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDistributionChannelName(
      /**
       * New value for property `distributionChannelName`
       */
      sDistributionChannelName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDivisionName divisionName}.
     *
     * The division name
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'DivisionName'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDivisionName(
      /**
       * New value for property `divisionName`
       */
      sDivisionName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSalesOrganizationName salesOrganizationName}.
     *
     * The sales organization name
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'SalesOrganizationName'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSalesOrganizationName(
      /**
       * New value for property `salesOrganizationName`
       */
      sSalesOrganizationName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShowSalesArea showSalesArea}.
     *
     * Display or not the customers sales area as well as its name and id.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowSalesArea(
      /**
       * New value for property `showSalesArea`
       */
      bShowSalesArea?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CustomerControlListItem constructor.
   *
   * @deprecated (since 1.24.3) - This control is not required anymore as per central UX requirements. Please
   * use Contextual Filter design instead! This control will not be supported anymore.
   */
  export interface $CustomerControlListItemSettings
    extends $CustomListItemSettings {
    /**
     * Display or not the customers sales area as well as its name and id.
     */
    showSalesArea?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The ID of the customer
     */
    customerID?: string | PropertyBindingInfo;

    /**
     * The name of the customer
     */
    customerName?: string | PropertyBindingInfo;

    /**
     * The sales organization name
     */
    salesOrganizationName?: string | PropertyBindingInfo;

    /**
     * The distribution channel name
     */
    distributionChannelName?: string | PropertyBindingInfo;

    /**
     * The division name
     */
    divisionName?: string | PropertyBindingInfo;
  }
}

declare module "sap/ca/ui/DatePicker" {
  import { default as InputBase, $InputBaseSettings } from "sap/m/InputBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Allows end users to interact with dates. Entries can directly be written in, or selected from a calendar
   * pad.
   *
   * @deprecated (since 1.22) - This control has been made available in sap.m. Please use the sap.m.DatePicker
   * instead! This control will not be supported anymore.
   */
  export default class DatePicker extends InputBase {
    /**
     * Constructor for a new DatePicker.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DatePickerSettings
    );
    /**
     * Constructor for a new DatePicker.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DatePickerSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.DatePicker with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.InputBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DatePicker>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.DatePicker.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * returns selected date as a Date object
     */
    getDate(): object;
    /**
     * Gets current value of property {@link #getDateValue dateValue}.
     *
     * This is a date string formatted as per the format for the control. If there is no valid input for the
     * control, this value will be null.
     *
     *
     * @returns Value of property `dateValue`
     */
    getDateValue(): string;
    /**
     * Gets current value of property {@link #getFirstDayOffset firstDayOffset}.
     *
     * This property is used to offset the first day of the week (0 = sunday). Returns int, default 0
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `firstDayOffset`
     */
    getFirstDayOffset(): int;
    /**
     * Sets a new value for property {@link #getDateValue dateValue}.
     *
     * This is a date string formatted as per the format for the control. If there is no valid input for the
     * control, this value will be null.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDateValue(
      /**
       * New value for property `dateValue`
       */
      sDateValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFirstDayOffset firstDayOffset}.
     *
     * This property is used to offset the first day of the week (0 = sunday). Returns int, default 0
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFirstDayOffset(
      /**
       * New value for property `firstDayOffset`
       */
      iFirstDayOffset?: int
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DatePicker constructor.
   *
   * @deprecated (since 1.22) - This control has been made available in sap.m. Please use the sap.m.DatePicker
   * instead! This control will not be supported anymore.
   */
  export interface $DatePickerSettings extends $InputBaseSettings {
    /**
     * This property is used to offset the first day of the week (0 = sunday). Returns int, default 0
     */
    firstDayOffset?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * This is a date string formatted as per the format for the control. If there is no valid input for the
     * control, this value will be null.
     */
    dateValue?: string | PropertyBindingInfo;
  }
}

declare module "sap/ca/ui/ExpansibleFeedListItem" {
  import {
    default as FeedListItem,
    $FeedListItemSettings,
  } from "sap/m/FeedListItem";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Extends the FeedListItem to hide text when it is longer than maxLines. When text is hidden a See more
   * link is displayed, clicking on the link displays the entire text.
   *
   * @deprecated (since 1.24) - This control has been made available in sap.m. Please use sap.m.FeedListItem
   * instead! This control will not be supported anymore.
   */
  export default class ExpansibleFeedListItem extends FeedListItem {
    /**
     * Constructor for a new ExpansibleFeedListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ExpansibleFeedListItemSettings
    );
    /**
     * Constructor for a new ExpansibleFeedListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ExpansibleFeedListItemSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.ExpansibleFeedListItem with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.FeedListItem.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ExpansibleFeedListItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.ExpansibleFeedListItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getMaxLines maxLines}.
     *
     * The maximum number of lines to display before adding the "See more" link.
     *
     * Default value is `5`.
     *
     *
     * @returns Value of property `maxLines`
     */
    getMaxLines(): int;
    /**
     * Sets a new value for property {@link #getMaxLines maxLines}.
     *
     * The maximum number of lines to display before adding the "See more" link.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `5`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxLines(
      /**
       * New value for property `maxLines`
       */
      iMaxLines?: int
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ExpansibleFeedListItem constructor.
   *
   * @deprecated (since 1.24) - This control has been made available in sap.m. Please use sap.m.FeedListItem
   * instead! This control will not be supported anymore.
   */
  export interface $ExpansibleFeedListItemSettings
    extends $FeedListItemSettings {
    /**
     * The maximum number of lines to display before adding the "See more" link.
     */
    maxLines?: int | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ca/ui/FileUpload" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Toolbar from "sap/m/Toolbar";

  import Label from "sap/m/Label";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Allows you to display a list of uploaded files. You can also upload a new one, rename or delete them
   *
   * @deprecated (since 1.26) - This control is available in sap.m in 1.26, as sap.m.UploadCollection. Please
   * use UploadCollection, as sap.ca.ui.FileUpload will not be supported anymore from 1.26.
   */
  export default class FileUpload extends Control {
    /**
     * Constructor for a new FileUpload.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $FileUploadSettings
    );
    /**
     * Constructor for a new FileUpload.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $FileUploadSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.FileUpload with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FileUpload>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.FileUpload.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeUploadFile beforeUploadFile} event of
     * this `sap.ca.ui.FileUpload`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.FileUpload` itself.
     *
     * Fired just before the control is about to make a file upload request. The data passed is the file object
     * selected by the user. You may handle this event to attach custom headers for example if your service
     * implementation requires it.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeUploadFile(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.FileUpload` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeUploadFile beforeUploadFile} event of
     * this `sap.ca.ui.FileUpload`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.FileUpload` itself.
     *
     * Fired just before the control is about to make a file upload request. The data passed is the file object
     * selected by the user. You may handle this event to attach custom headers for example if your service
     * implementation requires it.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeUploadFile(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.FileUpload` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cancelClicked cancelClicked} event of this `sap.ca.ui.FileUpload`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.FileUpload` itself.
     *
     * Fired when the cancel button is clicked. The consumer may handle the event if required.
     *
     * @deprecated (since 1.21.1) - This method is deprecated now
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCancelClicked(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.FileUpload` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cancelClicked cancelClicked} event of this `sap.ca.ui.FileUpload`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.FileUpload` itself.
     *
     * Fired when the cancel button is clicked. The consumer may handle the event if required.
     *
     * @deprecated (since 1.21.1) - This method is deprecated now
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCancelClicked(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.FileUpload` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deleteFile deleteFile} event of this `sap.ca.ui.FileUpload`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.FileUpload` itself.
     *
     * Fired when a file deletion event occurs typically by clicking a the delete icon. The file descriptor
     * json for the file to be deleted is passed in the event data
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeleteFile(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.FileUpload` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:deleteFile deleteFile} event of this `sap.ca.ui.FileUpload`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.FileUpload` itself.
     *
     * Fired when a file deletion event occurs typically by clicking a the delete icon. The file descriptor
     * json for the file to be deleted is passed in the event data
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachDeleteFile(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.FileUpload` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:fileUploadFailed fileUploadFailed} event of
     * this `sap.ca.ui.FileUpload`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.FileUpload` itself.
     *
     * Fired when a file fails to upload. The error code and response data is passed in this event. The consumer
     * should handle the error by showing the appropriate message.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFileUploadFailed(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.FileUpload` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:fileUploadFailed fileUploadFailed} event of
     * this `sap.ca.ui.FileUpload`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.FileUpload` itself.
     *
     * Fired when a file fails to upload. The error code and response data is passed in this event. The consumer
     * should handle the error by showing the appropriate message.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachFileUploadFailed(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.FileUpload` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:renameFile renameFile} event of this `sap.ca.ui.FileUpload`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.FileUpload` itself.
     *
     * Fired when a file is renamed. The file descripter json for the file to be renamed is passed in the event
     * data and also a property, newFilename, that contains the new filename.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRenameFile(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.FileUpload` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:renameFile renameFile} event of this `sap.ca.ui.FileUpload`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.FileUpload` itself.
     *
     * Fired when a file is renamed. The file descripter json for the file to be renamed is passed in the event
     * data and also a property, newFilename, that contains the new filename.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRenameFile(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.FileUpload` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:saveClicked saveClicked} event of this `sap.ca.ui.FileUpload`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.FileUpload` itself.
     *
     * Fired when the save button is clicked. The consumer should handle the event and save all the file renames
     * to backend.
     *
     * @deprecated (since 1.21.1) - This method is deprecated now. The rename or delete event is enough and
     * should be use to commit the action immediatly
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSaveClicked(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.FileUpload` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:saveClicked saveClicked} event of this `sap.ca.ui.FileUpload`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.FileUpload` itself.
     *
     * Fired when the save button is clicked. The consumer should handle the event and save all the file renames
     * to backend.
     *
     * @deprecated (since 1.21.1) - This method is deprecated now. The rename or delete event is enough and
     * should be use to commit the action immediatly
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSaveClicked(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.FileUpload` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:uploadFile uploadFile} event of this `sap.ca.ui.FileUpload`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.FileUpload` itself.
     *
     * Fired when a file is uploaded and the response comes back from service. The service response for the
     * file to be added to the list is passed in the event data and the consumer must format it in the correct
     * json structure and pass it back to the control using commitUploadFile method.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachUploadFile(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.FileUpload` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:uploadFile uploadFile} event of this `sap.ca.ui.FileUpload`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.FileUpload` itself.
     *
     * Fired when a file is uploaded and the response comes back from service. The service response for the
     * file to be added to the list is passed in the event data and the consumer must format it in the correct
     * json structure and pass it back to the control using commitUploadFile method.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachUploadFile(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.FileUpload` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the attachmentNumberLabel in the aggregation {@link #getAttachmentNumberLabel attachmentNumberLabel}.
     *
     * @deprecated (since 1.21.0) - This aggregation is deprecatd now. The label is part of the ToolBar
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyAttachmentNumberLabel(): this;
    /**
     * Destroys the toolBar in the aggregation {@link #getToolBar toolBar}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyToolBar(): this;
    /**
     * Destroys the uploadProgressLabel in the aggregation {@link #getUploadProgressLabel uploadProgressLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyUploadProgressLabel(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeUploadFile beforeUploadFile} event of
     * this `sap.ca.ui.FileUpload`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeUploadFile(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:cancelClicked cancelClicked} event of this
     * `sap.ca.ui.FileUpload`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.21.1) - This method is deprecated now
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCancelClicked(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:deleteFile deleteFile} event of this `sap.ca.ui.FileUpload`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachDeleteFile(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:fileUploadFailed fileUploadFailed} event of
     * this `sap.ca.ui.FileUpload`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachFileUploadFailed(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:renameFile renameFile} event of this `sap.ca.ui.FileUpload`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachRenameFile(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:saveClicked saveClicked} event of this `sap.ca.ui.FileUpload`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.21.1) - This method is deprecated now. The rename or delete event is enough and
     * should be use to commit the action immediatly
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSaveClicked(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:uploadFile uploadFile} event of this `sap.ca.ui.FileUpload`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachUploadFile(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:beforeUploadFile beforeUploadFile} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireBeforeUploadFile(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:cancelClicked cancelClicked} to attached listeners.
     *
     * @deprecated (since 1.21.1) - This method is deprecated now
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCancelClicked(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:deleteFile deleteFile} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireDeleteFile(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:fileUploadFailed fileUploadFailed} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireFileUploadFailed(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:renameFile renameFile} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireRenameFile(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:saveClicked saveClicked} to attached listeners.
     *
     * @deprecated (since 1.21.1) - This method is deprecated now. The rename or delete event is enough and
     * should be use to commit the action immediatly
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSaveClicked(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:uploadFile uploadFile} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireUploadFile(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAcceptRequestHeader acceptRequestHeader}.
     *
     * The Accept request header the control should use when sending the upload request
     *
     * Default value is `'application/json'`.
     *
     *
     * @returns Value of property `acceptRequestHeader`
     */
    getAcceptRequestHeader(): string;
    /**
     * Gets current value of property {@link #getContributor contributor}.
     *
     * Relative path in model, pointing to property that stores the name of the person who uploaded the file.
     *
     *
     * @returns Value of property `contributor`
     */
    getContributor(): string;
    /**
     * Gets current value of property {@link #getDeleteEnabled deleteEnabled}.
     *
     * Indicates whether delete functionality should be enabled
     *
     *
     * @returns Value of property `deleteEnabled`
     */
    getDeleteEnabled(): boolean;
    /**
     * Gets current value of property {@link #getEditMode editMode}.
     *
     * Property to allow toggling between edit and view screens.
     *
     * Default value is `false`.
     *
     * @deprecated (since 1.21.0) - This method is deprecatd now. If you want to prevent edit you can use useEditControls
     * property or the deleteEnabled, renameEnabed and uploadEnabled properties
     *
     * @returns Value of property `editMode`
     */
    getEditMode(): boolean;
    /**
     * Gets current value of property {@link #getEncodeUrl encodeUrl}.
     *
     * Url of server that will base64 encode the file
     *
     *
     * @returns Value of property `encodeUrl`
     */
    getEncodeUrl(): string;
    /**
     * Gets current value of property {@link #getFileExtension fileExtension}.
     *
     * Relative path in model, pointing to property that stores the uploaded files extension. Note: either fileExtension
     * or mimeType may be used, but mimeType is preferable.
     *
     *
     * @returns Value of property `fileExtension`
     */
    getFileExtension(): string;
    /**
     * Gets current value of property {@link #getFileId fileId}.
     *
     * An identifier property name that is used to uniquely reference the file on the server.
     *
     *
     * @returns Value of property `fileId`
     */
    getFileId(): string;
    /**
     * Gets current value of property {@link #getFileName fileName}.
     *
     * Relative path in model, pointing to property that stores the name of a file.
     *
     *
     * @returns Value of property `fileName`
     */
    getFileName(): string;
    /**
     * Gets current value of property {@link #getItems items}.
     *
     * The base path in the model for the control. Avoid trailing forward slashes in value, as per default value.
     *
     *
     * @returns Value of property `items`
     */
    getItems(): string;
    /**
     * Gets current value of property {@link #getMimeType mimeType}.
     *
     * Relative path in model, pointing to property that stores the file's mimeType. Note: either fileExtension
     * or mimeType may be used, but mimeType is preferable.
     *
     *
     * @returns Value of property `mimeType`
     */
    getMimeType(): string;
    /**
     * Gets current value of property {@link #getMultipleSelectionEnabled multipleSelectionEnabled}.
     *
     * Indicates whether the user is allowed to select multiple file at once from his desktop
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `multipleSelectionEnabled`
     */
    getMultipleSelectionEnabled(): boolean;
    /**
     * Gets current value of property {@link #getRenameEnabled renameEnabled}.
     *
     * Indicates whether rename functionality should be enabled
     *
     *
     * @returns Value of property `renameEnabled`
     */
    getRenameEnabled(): boolean;
    /**
     * Gets current value of property {@link #getSequentialUploadsEnabled sequentialUploadsEnabled}.
     *
     * Indicates whether file uploads should occur sequentially or in parallel. The default is in parallel.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `sequentialUploadsEnabled`
     */
    getSequentialUploadsEnabled(): boolean;
    /**
     * Gets current value of property {@link #getShowAttachmentsLabel showAttachmentsLabel}.
     *
     * Show the Attachments count label
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showAttachmentsLabel`
     */
    getShowAttachmentsLabel(): boolean;
    /**
     * Gets current value of property {@link #getShowAttachmentsLabelInEditMode showAttachmentsLabelInEditMode}.
     *
     * Show the Attachments label in edit mode
     *
     * Default value is `true`.
     *
     * @deprecated (since 1.21.0) - This method is deprecated now. Use the showAttachmentsLabel instead
     *
     * @returns Value of property `showAttachmentsLabelInEditMode`
     */
    getShowAttachmentsLabelInEditMode(): boolean;
    /**
     * Gets current value of property {@link #getShowNoData showNoData}.
     *
     * Show the label "No data" when the control doesn't have files
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showNoData`
     */
    getShowNoData(): boolean;
    /**
     * Gets current value of property {@link #getSize size}.
     *
     * Relative path in model, pointing to property that stores the size of a file.
     *
     *
     * @returns Value of property `size`
     */
    getSize(): string;
    /**
     * Gets content of aggregation {@link #getToolBar toolBar}.
     *
     * Aggregation that contains the buttons for adding
     */
    getToolBar(): Toolbar;
    /**
     * Gets current value of property {@link #getUploadedDate uploadedDate}.
     *
     * Relative path in model, pointing to property that stores the date at which a file was uploaded.
     *
     *
     * @returns Value of property `uploadedDate`
     */
    getUploadedDate(): string;
    /**
     * Gets current value of property {@link #getUploadEnabled uploadEnabled}.
     *
     * This property enables & disables the ability to upload a file
     *
     *
     * @returns Value of property `uploadEnabled`
     */
    getUploadEnabled(): boolean;
    /**
     * Gets content of aggregation {@link #getUploadProgressLabel uploadProgressLabel}.
     *
     * Aggregation that displays the current number of items that are being uploaded
     */
    getUploadProgressLabel(): Label;
    /**
     * Gets current value of property {@link #getUploadUrl uploadUrl}.
     *
     * Url of server we wish to upload to
     *
     *
     * @returns Value of property `uploadUrl`
     */
    getUploadUrl(): string;
    /**
     * Gets current value of property {@link #getUrl url}.
     *
     * Relative path in model, pointing to property that stores the url at which the file is stored.
     *
     *
     * @returns Value of property `url`
     */
    getUrl(): string;
    /**
     * Gets current value of property {@link #getUseEditControls useEditControls}.
     *
     * Show the edit user controls to rename and delete files (same as deleteEnabled and renameEnabled)
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `useEditControls`
     */
    getUseEditControls(): boolean;
    /**
     * Gets current value of property {@link #getUseMultipart useMultipart}.
     *
     * Indicates if the control should send multipart/form data request when uploading
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `useMultipart`
     */
    getUseMultipart(): boolean;
    /**
     * Gets current value of property {@link #getXsrfToken xsrfToken}.
     *
     * The XSRF token the control should use when making the upload request. If it is not set, the control will
     * not use a security token.
     *
     *
     * @returns Value of property `xsrfToken`
     */
    getXsrfToken(): string;
    /**
     * Sets a new value for property {@link #getAcceptRequestHeader acceptRequestHeader}.
     *
     * The Accept request header the control should use when sending the upload request
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'application/json'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAcceptRequestHeader(
      /**
       * New value for property `acceptRequestHeader`
       */
      sAcceptRequestHeader?: string
    ): this;
    /**
     * Sets the aggregated {@link #getAttachmentNumberLabel attachmentNumberLabel}.
     *
     * @deprecated (since 1.21.0) - This aggregation is deprecatd now. The label is part of the ToolBar
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAttachmentNumberLabel(
      /**
       * The attachmentNumberLabel to set
       */
      oAttachmentNumberLabel: Label
    ): this;
    /**
     * Sets a new value for property {@link #getEncodeUrl encodeUrl}.
     *
     * Url of server that will base64 encode the file
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEncodeUrl(
      /**
       * New value for property `encodeUrl`
       */
      sEncodeUrl?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFileId fileId}.
     *
     * An identifier property name that is used to uniquely reference the file on the server.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFileId(
      /**
       * New value for property `fileId`
       */
      sFileId?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMultipleSelectionEnabled multipleSelectionEnabled}.
     *
     * Indicates whether the user is allowed to select multiple file at once from his desktop
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMultipleSelectionEnabled(
      /**
       * New value for property `multipleSelectionEnabled`
       */
      bMultipleSelectionEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSequentialUploadsEnabled sequentialUploadsEnabled}.
     *
     * Indicates whether file uploads should occur sequentially or in parallel. The default is in parallel.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSequentialUploadsEnabled(
      /**
       * New value for property `sequentialUploadsEnabled`
       */
      bSequentialUploadsEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowNoData showNoData}.
     *
     * Show the label "No data" when the control doesn't have files
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowNoData(
      /**
       * New value for property `showNoData`
       */
      bShowNoData?: boolean
    ): this;
    /**
     * Sets the aggregated {@link #getToolBar toolBar}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolBar(
      /**
       * The toolBar to set
       */
      oToolBar: Toolbar
    ): this;
    /**
     * Sets the aggregated {@link #getUploadProgressLabel uploadProgressLabel}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUploadProgressLabel(
      /**
       * The uploadProgressLabel to set
       */
      oUploadProgressLabel: Label
    ): this;
    /**
     * Sets a new value for property {@link #getUploadUrl uploadUrl}.
     *
     * Url of server we wish to upload to
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUploadUrl(
      /**
       * New value for property `uploadUrl`
       */
      sUploadUrl?: string
    ): this;
    /**
     * Sets a new value for property {@link #getUseMultipart useMultipart}.
     *
     * Indicates if the control should send multipart/form data request when uploading
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUseMultipart(
      /**
       * New value for property `useMultipart`
       */
      bUseMultipart?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getXsrfToken xsrfToken}.
     *
     * The XSRF token the control should use when making the upload request. If it is not set, the control will
     * not use a security token.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXsrfToken(
      /**
       * New value for property `xsrfToken`
       */
      sXsrfToken?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the FileUpload constructor.
   *
   * @deprecated (since 1.26) - This control is available in sap.m in 1.26, as sap.m.UploadCollection. Please
   * use UploadCollection, as sap.ca.ui.FileUpload will not be supported anymore from 1.26.
   */
  export interface $FileUploadSettings extends $ControlSettings {
    /**
     * Url of server we wish to upload to
     */
    uploadUrl?: string | PropertyBindingInfo;

    /**
     * Relative path in model, pointing to property that stores the name of a file.
     */
    fileName?: string | PropertyBindingInfo;

    /**
     * Relative path in model, pointing to property that stores the size of a file.
     */
    size?: string | PropertyBindingInfo;

    /**
     * Relative path in model, pointing to property that stores the url at which the file is stored.
     */
    url?: string | PropertyBindingInfo;

    /**
     * Relative path in model, pointing to property that stores the date at which a file was uploaded.
     */
    uploadedDate?: string | PropertyBindingInfo;

    /**
     * Relative path in model, pointing to property that stores the name of the person who uploaded the file.
     */
    contributor?: string | PropertyBindingInfo;

    /**
     * Relative path in model, pointing to property that stores the uploaded files extension. Note: either fileExtension
     * or mimeType may be used, but mimeType is preferable.
     */
    fileExtension?: string | PropertyBindingInfo;

    /**
     * Relative path in model, pointing to property that stores the file's mimeType. Note: either fileExtension
     * or mimeType may be used, but mimeType is preferable.
     */
    mimeType?: string | PropertyBindingInfo;

    /**
     * The base path in the model for the control. Avoid trailing forward slashes in value, as per default value.
     */
    items?: string | PropertyBindingInfo;

    /**
     * This property enables & disables the ability to upload a file
     */
    uploadEnabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * An identifier property name that is used to uniquely reference the file on the server.
     */
    fileId?: string | PropertyBindingInfo;

    /**
     * The XSRF token the control should use when making the upload request. If it is not set, the control will
     * not use a security token.
     */
    xsrfToken?: string | PropertyBindingInfo;

    /**
     * Indicates if the control should send multipart/form data request when uploading
     */
    useMultipart?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The Accept request header the control should use when sending the upload request
     */
    acceptRequestHeader?: string | PropertyBindingInfo;

    /**
     * Url of server that will base64 encode the file
     */
    encodeUrl?: string | PropertyBindingInfo;

    /**
     * Indicates whether rename functionality should be enabled
     */
    renameEnabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether delete functionality should be enabled
     */
    deleteEnabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether the user is allowed to select multiple file at once from his desktop
     */
    multipleSelectionEnabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Show the label "No data" when the control doesn't have files
     */
    showNoData?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether file uploads should occur sequentially or in parallel. The default is in parallel.
     */
    sequentialUploadsEnabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Show the Attachments count label
     */
    showAttachmentsLabel?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Show the edit user controls to rename and delete files (same as deleteEnabled and renameEnabled)
     */
    useEditControls?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Show the Attachments label in edit mode
     *
     * @deprecated (since 1.21.0) - This method is deprecated now. Use the showAttachmentsLabel instead
     */
    showAttachmentsLabelInEditMode?:
      | boolean
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Property to allow toggling between edit and view screens.
     *
     * @deprecated (since 1.21.0) - This method is deprecatd now. If you want to prevent edit you can use useEditControls
     * property or the deleteEnabled, renameEnabed and uploadEnabled properties
     */
    editMode?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregation that displays the current number of items that are being uploaded
     */
    uploadProgressLabel?: Label;

    /**
     * Aggregation that shows the number of files currently uploaded
     *
     * @deprecated (since 1.21.0) - This aggregation is deprecatd now. The label is part of the ToolBar
     */
    attachmentNumberLabel?: Label;

    /**
     * Aggregation that contains the buttons for adding
     */
    toolBar?: Toolbar;

    /**
     * Fired when a file deletion event occurs typically by clicking a the delete icon. The file descriptor
     * json for the file to be deleted is passed in the event data
     */
    deleteFile?: (oEvent: Event) => void;

    /**
     * Fired when a file is renamed. The file descripter json for the file to be renamed is passed in the event
     * data and also a property, newFilename, that contains the new filename.
     */
    renameFile?: (oEvent: Event) => void;

    /**
     * Fired when a file is uploaded and the response comes back from service. The service response for the
     * file to be added to the list is passed in the event data and the consumer must format it in the correct
     * json structure and pass it back to the control using commitUploadFile method.
     */
    uploadFile?: (oEvent: Event) => void;

    /**
     * Fired when a file fails to upload. The error code and response data is passed in this event. The consumer
     * should handle the error by showing the appropriate message.
     */
    fileUploadFailed?: (oEvent: Event) => void;

    /**
     * Fired just before the control is about to make a file upload request. The data passed is the file object
     * selected by the user. You may handle this event to attach custom headers for example if your service
     * implementation requires it.
     */
    beforeUploadFile?: (oEvent: Event) => void;

    /**
     * Fired when the save button is clicked. The consumer should handle the event and save all the file renames
     * to backend.
     *
     * @deprecated (since 1.21.1) - This method is deprecated now. The rename or delete event is enough and
     * should be use to commit the action immediatly
     */
    saveClicked?: (oEvent: Event) => void;

    /**
     * Fired when the cancel button is clicked. The consumer may handle the event if required.
     *
     * @deprecated (since 1.21.1) - This method is deprecated now
     */
    cancelClicked?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the FileUpload#beforeUploadFile event.
   */
  export interface FileUpload$BeforeUploadFileEventParameters {}

  /**
   * Event object of the FileUpload#beforeUploadFile event.
   */
  export type FileUpload$BeforeUploadFileEvent = Event<
    FileUpload$BeforeUploadFileEventParameters,
    FileUpload
  >;

  /**
   * Parameters of the FileUpload#cancelClicked event.
   *
   * @deprecated (since 1.21.1) - This method is deprecated now
   */
  export interface FileUpload$CancelClickedEventParameters {}

  /**
   * Event object of the FileUpload#cancelClicked event.
   *
   * @deprecated (since 1.21.1) - This method is deprecated now
   */
  export type FileUpload$CancelClickedEvent = Event<
    FileUpload$CancelClickedEventParameters,
    FileUpload
  >;

  /**
   * Parameters of the FileUpload#deleteFile event.
   */
  export interface FileUpload$DeleteFileEventParameters {}

  /**
   * Event object of the FileUpload#deleteFile event.
   */
  export type FileUpload$DeleteFileEvent = Event<
    FileUpload$DeleteFileEventParameters,
    FileUpload
  >;

  /**
   * Parameters of the FileUpload#fileUploadFailed event.
   */
  export interface FileUpload$FileUploadFailedEventParameters {}

  /**
   * Event object of the FileUpload#fileUploadFailed event.
   */
  export type FileUpload$FileUploadFailedEvent = Event<
    FileUpload$FileUploadFailedEventParameters,
    FileUpload
  >;

  /**
   * Parameters of the FileUpload#renameFile event.
   */
  export interface FileUpload$RenameFileEventParameters {}

  /**
   * Event object of the FileUpload#renameFile event.
   */
  export type FileUpload$RenameFileEvent = Event<
    FileUpload$RenameFileEventParameters,
    FileUpload
  >;

  /**
   * Parameters of the FileUpload#saveClicked event.
   *
   * @deprecated (since 1.21.1) - This method is deprecated now. The rename or delete event is enough and
   * should be use to commit the action immediatly
   */
  export interface FileUpload$SaveClickedEventParameters {}

  /**
   * Event object of the FileUpload#saveClicked event.
   *
   * @deprecated (since 1.21.1) - This method is deprecated now. The rename or delete event is enough and
   * should be use to commit the action immediatly
   */
  export type FileUpload$SaveClickedEvent = Event<
    FileUpload$SaveClickedEventParameters,
    FileUpload
  >;

  /**
   * Parameters of the FileUpload#uploadFile event.
   */
  export interface FileUpload$UploadFileEventParameters {}

  /**
   * Event object of the FileUpload#uploadFile event.
   */
  export type FileUpload$UploadFileEvent = Event<
    FileUpload$UploadFileEventParameters,
    FileUpload
  >;
}

declare module "sap/ca/ui/GrowingTileContainer" {
  import {
    default as ScrollContainer,
    $ScrollContainerSettings,
  } from "sap/m/ScrollContainer";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A Tile container for the Overview tile with growing capabilities
   *
   * @deprecated (since 1.24.3) - This control is not required anymore as per central UX requirements. This
   * control will not be supported anymore.
   */
  export default class GrowingTileContainer extends ScrollContainer {
    /**
     * Constructor for a new GrowingTileContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $GrowingTileContainerSettings
    );
    /**
     * Constructor for a new GrowingTileContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $GrowingTileContainerSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.GrowingTileContainer with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.ScrollContainer.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, GrowingTileContainer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.GrowingTileContainer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getGrowing growing}.
     *
     * growing enablement
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `growing`
     */
    getGrowing(): boolean;
    /**
     * Gets current value of property {@link #getGrowingScrollToLoad growingScrollToLoad}.
     *
     * load when scrolling
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `growingScrollToLoad`
     */
    getGrowingScrollToLoad(): boolean;
    /**
     * Gets current value of property {@link #getGrowingThreshold growingThreshold}.
     *
     * growing Threshold
     *
     * Default value is `20`.
     *
     *
     * @returns Value of property `growingThreshold`
     */
    getGrowingThreshold(): int;
    /**
     * Sets a new value for property {@link #getGrowing growing}.
     *
     * growing enablement
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGrowing(
      /**
       * New value for property `growing`
       */
      bGrowing?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getGrowingScrollToLoad growingScrollToLoad}.
     *
     * load when scrolling
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGrowingScrollToLoad(
      /**
       * New value for property `growingScrollToLoad`
       */
      bGrowingScrollToLoad?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getGrowingThreshold growingThreshold}.
     *
     * growing Threshold
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `20`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGrowingThreshold(
      /**
       * New value for property `growingThreshold`
       */
      iGrowingThreshold?: int
    ): this;
  }
  /**
   * Describes the settings that can be provided to the GrowingTileContainer constructor.
   *
   * @deprecated (since 1.24.3) - This control is not required anymore as per central UX requirements. This
   * control will not be supported anymore.
   */
  export interface $GrowingTileContainerSettings
    extends $ScrollContainerSettings {
    /**
     * growing enablement
     */
    growing?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * growing Threshold
     */
    growingThreshold?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * load when scrolling
     */
    growingScrollToLoad?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/ca/ui/HierarchicalSelectDialog" {
  import { default as Dialog, $DialogSettings } from "sap/m/Dialog";

  import HierarchicalSelectDialogItem from "sap/ca/ui/HierarchicalSelectDialogItem";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { AggregationBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Select an item in a dialog from a hierarchical list
   *
   * @deprecated (since 1.24.1) - HierarchicalSelectDialog is deprecated as per central UX requirements. This
   * control will not be supported anymore.
   */
  export default class HierarchicalSelectDialog extends Dialog {
    /**
     * Constructor for a new HierarchicalSelectDialog.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $HierarchicalSelectDialogSettings
    );
    /**
     * Constructor for a new HierarchicalSelectDialog.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $HierarchicalSelectDialogSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.HierarchicalSelectDialog with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.Dialog.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, HierarchicalSelectDialog>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.HierarchicalSelectDialog.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: HierarchicalSelectDialogItem
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cancel cancel} event of this `sap.ca.ui.HierarchicalSelectDialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.HierarchicalSelectDialog` itself.
     *
     * Thrown when user clicks cancel
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCancel(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.HierarchicalSelectDialog`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cancel cancel} event of this `sap.ca.ui.HierarchicalSelectDialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.HierarchicalSelectDialog` itself.
     *
     * Thrown when user clicks cancel
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCancel(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.HierarchicalSelectDialog`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:select select} event of this `sap.ca.ui.HierarchicalSelectDialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.HierarchicalSelectDialog` itself.
     *
     * Thrown when user selects an item
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelect(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.HierarchicalSelectDialog`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:select select} event of this `sap.ca.ui.HierarchicalSelectDialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.HierarchicalSelectDialog` itself.
     *
     * Thrown when user selects an item
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelect(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.HierarchicalSelectDialog`
       * itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:cancel cancel} event of this `sap.ca.ui.HierarchicalSelectDialog`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCancel(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:select select} event of this `sap.ca.ui.HierarchicalSelectDialog`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelect(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:cancel cancel} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCancel(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:select select} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelect(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Type checker, only HierarchicalSelectDialogItem are allowed. Please do NOT use the "content" aggregation
     * of the dialog
     */
    getItems(): HierarchicalSelectDialogItem[];
    /**
     * Checks for the provided `sap.ca.ui.HierarchicalSelectDialogItem` in the aggregation {@link #getItems items}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: HierarchicalSelectDialogItem
    ): int;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): HierarchicalSelectDialogItem[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | HierarchicalSelectDialogItem
    ): HierarchicalSelectDialogItem | null;
  }
  /**
   * Describes the settings that can be provided to the HierarchicalSelectDialog constructor.
   *
   * @deprecated (since 1.24.1) - HierarchicalSelectDialog is deprecated as per central UX requirements. This
   * control will not be supported anymore.
   */
  export interface $HierarchicalSelectDialogSettings extends $DialogSettings {
    /**
     * Type checker, only HierarchicalSelectDialogItem are allowed. Please do NOT use the "content" aggregation
     * of the dialog
     */
    items?:
      | HierarchicalSelectDialogItem[]
      | HierarchicalSelectDialogItem
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Thrown when user selects an item
     */
    select?: (oEvent: Event) => void;

    /**
     * Thrown when user clicks cancel
     */
    cancel?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the HierarchicalSelectDialog#cancel event.
   */
  export interface HierarchicalSelectDialog$CancelEventParameters {}

  /**
   * Event object of the HierarchicalSelectDialog#cancel event.
   */
  export type HierarchicalSelectDialog$CancelEvent = Event<
    HierarchicalSelectDialog$CancelEventParameters,
    HierarchicalSelectDialog
  >;

  /**
   * Parameters of the HierarchicalSelectDialog#select event.
   */
  export interface HierarchicalSelectDialog$SelectEventParameters {}

  /**
   * Event object of the HierarchicalSelectDialog#select event.
   */
  export type HierarchicalSelectDialog$SelectEvent = Event<
    HierarchicalSelectDialog$SelectEventParameters,
    HierarchicalSelectDialog
  >;
}

declare module "sap/ca/ui/HierarchicalSelectDialogItem" {
  import { default as Item, $ItemSettings } from "sap/ui/core/Item";

  import ListItemBase from "sap/m/ListItemBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Kind of item required by the sap.ca.ui.HierarchicalSelectDialog control. An item is actually one page
   * of the Dialog.
   *
   * @deprecated (since 1.24) - This control is deprecated as per central UX requirements. This control will
   * not be supported anymore.
   */
  export default class HierarchicalSelectDialogItem extends Item {
    /**
     * Constructor for a new HierarchicalSelectDialogItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $HierarchicalSelectDialogItemSettings
    );
    /**
     * Constructor for a new HierarchicalSelectDialogItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $HierarchicalSelectDialogItemSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.HierarchicalSelectDialogItem with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Item.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, HierarchicalSelectDialogItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.HierarchicalSelectDialogItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the listItemTemplate in the aggregation {@link #getListItemTemplate listItemTemplate}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyListItemTemplate(): this;
    /**
     * Gets current value of property {@link #getEntityName entityName}.
     *
     * Property used for the binding
     *
     *
     * @returns Value of property `entityName`
     */
    getEntityName(): string;
    /**
     * Gets content of aggregation {@link #getListItemTemplate listItemTemplate}.
     *
     * Used as a template for each list item of the page
     */
    getListItemTemplate(): ListItemBase;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Dialog title for this item
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Sets a new value for property {@link #getEntityName entityName}.
     *
     * Property used for the binding
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEntityName(
      /**
       * New value for property `entityName`
       */
      sEntityName?: string
    ): this;
    /**
     * Sets the aggregated {@link #getListItemTemplate listItemTemplate}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setListItemTemplate(
      /**
       * The listItemTemplate to set
       */
      oListItemTemplate: ListItemBase
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * Dialog title for this item
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the HierarchicalSelectDialogItem constructor.
   *
   * @deprecated (since 1.24) - This control is deprecated as per central UX requirements. This control will
   * not be supported anymore.
   */
  export interface $HierarchicalSelectDialogItemSettings extends $ItemSettings {
    /**
     * Dialog title for this item
     */
    title?: string | PropertyBindingInfo;

    /**
     * Property used for the binding
     */
    entityName?: string | PropertyBindingInfo;

    /**
     * Used as a template for each list item of the page
     */
    listItemTemplate?: ListItemBase;
  }
}

declare module "sap/ca/ui/Hierarchy" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import HierarchyItem from "sap/ca/ui/HierarchyItem";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * Display the Hierarchy of an item. Useful to indicates where an object stand in a chain of hierarchical
   * data. The emphasized item shows the one item to display. Optional item can be hidden using the hideOptionalLevels
   * property. Hidden items will stay accessible with an expand button.
   *
   * @deprecated (since 1.24.3) - This control is not required anymore as per central UX requirements. This
   * control will not be supported anymore.
   */
  export default class Hierarchy extends Control {
    /**
     * Constructor for a new Hierarchy.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $HierarchySettings
    );
    /**
     * Constructor for a new Hierarchy.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $HierarchySettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.Hierarchy with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Hierarchy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.Hierarchy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: HierarchyItem
    ): this;
    /**
     * Binds aggregation {@link #getItems items} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindItems(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Gets current value of property {@link #getHideOptionalLevels hideOptionalLevels}.
     *
     * Hide the levels marked optional. An expand button will appear
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `hideOptionalLevels`
     */
    getHideOptionalLevels(): boolean;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * The array of HierarchyItem ordered and starting from the root hierarchy
     */
    getItems(): HierarchyItem[];
    /**
     * Checks for the provided `sap.ca.ui.HierarchyItem` in the aggregation {@link #getItems items}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: HierarchyItem
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: HierarchyItem,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): HierarchyItem[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | HierarchyItem
    ): HierarchyItem | null;
    /**
     * Sets a new value for property {@link #getHideOptionalLevels hideOptionalLevels}.
     *
     * Hide the levels marked optional. An expand button will appear
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideOptionalLevels(
      /**
       * New value for property `hideOptionalLevels`
       */
      bHideOptionalLevels?: boolean
    ): this;
    /**
     * Unbinds aggregation {@link #getItems items} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindItems(): this;
  }
  /**
   * Describes the settings that can be provided to the Hierarchy constructor.
   *
   * @deprecated (since 1.24.3) - This control is not required anymore as per central UX requirements. This
   * control will not be supported anymore.
   */
  export interface $HierarchySettings extends $ControlSettings {
    /**
     * Hide the levels marked optional. An expand button will appear
     */
    hideOptionalLevels?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The array of HierarchyItem ordered and starting from the root hierarchy
     */
    items?:
      | HierarchyItem[]
      | HierarchyItem
      | AggregationBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/ca/ui/HierarchyItem" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import { URI } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Item that represent a line of the Hierarchy control. The emphasized property should apply to the item
   * that we want to represent in his hierarchy. Optionals item will be hidden if the option is true on the
   * Hierarchy control.
   *
   * @deprecated (since 1.24) - This control is deprecated as per central UX requirements. This control will
   * not be supported anymore.
   */
  export default class HierarchyItem extends Control {
    /**
     * Constructor for a new HierarchyItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $HierarchyItemSettings
    );
    /**
     * Constructor for a new HierarchyItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $HierarchyItemSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.HierarchyItem with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, HierarchyItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.HierarchyItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:linkPress linkPress} event of this `sap.ca.ui.HierarchyItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.HierarchyItem` itself.
     *
     * Event when a link is pressed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLinkPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.HierarchyItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:linkPress linkPress} event of this `sap.ca.ui.HierarchyItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.HierarchyItem` itself.
     *
     * Event when a link is pressed
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLinkPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.HierarchyItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:linkPress linkPress} event of this `sap.ca.ui.HierarchyItem`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachLinkPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:linkPress linkPress} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireLinkPress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getEmphasized emphasized}.
     *
     * Does the item looks emphasized
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `emphasized`
     */
    getEmphasized(): boolean;
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * Icon for the item
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): URI;
    /**
     * Gets current value of property {@link #getIdentifier identifier}.
     *
     * Identifier text
     *
     *
     * @returns Value of property `identifier`
     */
    getIdentifier(): string;
    /**
     * Gets current value of property {@link #getLevelType levelType}.
     *
     * Level type
     *
     *
     * @returns Value of property `levelType`
     */
    getLevelType(): string;
    /**
     * Gets current value of property {@link #getLink link}.
     *
     * Text of the link
     *
     *
     * @returns Value of property `link`
     */
    getLink(): string;
    /**
     * Gets current value of property {@link #getOptional optional}.
     *
     * Is the item optional, so we hide it if option is set on the Hierarchy control
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `optional`
     */
    getOptional(): boolean;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Title
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Sets a new value for property {@link #getEmphasized emphasized}.
     *
     * Does the item looks emphasized
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEmphasized(
      /**
       * New value for property `emphasized`
       */
      bEmphasized?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * Icon for the item
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getIdentifier identifier}.
     *
     * Identifier text
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIdentifier(
      /**
       * New value for property `identifier`
       */
      sIdentifier?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLevelType levelType}.
     *
     * Level type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLevelType(
      /**
       * New value for property `levelType`
       */
      sLevelType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLink link}.
     *
     * Text of the link
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLink(
      /**
       * New value for property `link`
       */
      sLink?: string
    ): this;
    /**
     * Sets a new value for property {@link #getOptional optional}.
     *
     * Is the item optional, so we hide it if option is set on the Hierarchy control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOptional(
      /**
       * New value for property `optional`
       */
      bOptional?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * Title
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the HierarchyItem constructor.
   *
   * @deprecated (since 1.24) - This control is deprecated as per central UX requirements. This control will
   * not be supported anymore.
   */
  export interface $HierarchyItemSettings extends $ControlSettings {
    /**
     * Icon for the item
     */
    icon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Level type
     */
    levelType?: string | PropertyBindingInfo;

    /**
     * Title
     */
    title?: string | PropertyBindingInfo;

    /**
     * Identifier text
     */
    identifier?: string | PropertyBindingInfo;

    /**
     * Text of the link
     */
    link?: string | PropertyBindingInfo;

    /**
     * Does the item looks emphasized
     */
    emphasized?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Is the item optional, so we hide it if option is set on the Hierarchy control
     */
    optional?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Event when a link is pressed
     */
    linkPress?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the HierarchyItem#linkPress event.
   */
  export interface HierarchyItem$LinkPressEventParameters {}

  /**
   * Event object of the HierarchyItem#linkPress event.
   */
  export type HierarchyItem$LinkPressEvent = Event<
    HierarchyItem$LinkPressEventParameters,
    HierarchyItem
  >;
}

declare module "sap/ca/ui/InPlaceEdit" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import TooltipBase from "sap/ui/core/TooltipBase";

  import { ValueState } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * This control is used to switch between readonly and edit modes. A typical use case would be to change
   * the value of a Label.
   *
   * @deprecated (since 1.22) - This control is not required anymore as per central UX requirements. Please
   * use sap.m.Input instead! This control will not be supported anymore.
   */
  export default class InPlaceEdit extends Control {
    /**
     * Constructor for a new InPlaceEdit.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $InPlaceEditSettings
    );
    /**
     * Constructor for a new InPlaceEdit.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $InPlaceEditSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.InPlaceEdit with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, InPlaceEdit>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.InPlaceEdit.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ca.ui.InPlaceEdit`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.InPlaceEdit` itself.
     *
     * Event is fired when the text in the field has changed AND the focus leaves the InPlaceEdit or the Enter
     * key is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: InPlaceEdit$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.InPlaceEdit` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.ca.ui.InPlaceEdit`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.InPlaceEdit` itself.
     *
     * Event is fired when the text in the field has changed AND the focus leaves the InPlaceEdit or the Enter
     * key is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: InPlaceEdit$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.InPlaceEdit` itself
       */
      oListener?: object
    ): this;
    /**
     * Clear the old text after a change to disable the undo functionality. If undoEnabled is false this has
     * no effect.
     */
    clearOldText(): void;
    /**
     * Destroys the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.ca.ui.InPlaceEdit`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: InPlaceEdit$ChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: InPlaceEdit$ChangeEventParameters
    ): this;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Content control of the InPlaceEdit. The following control is allowed: sap.m.Input, sap.m.Link
     */
    getContent(): Control;
    /**
     * Returns the tooltip for this InPlaceEdit if any or an undefined value. The tooltip can either be a simple
     * string or a subclass of {@link sap.ui.core.TooltipBase}.
     *
     * Callers that are only interested in tooltips of type string (e.g. to render them as a `title` attribute),
     * should call the convenience method {@link #getTooltip_AsString} instead. If they want to get a tooltip
     * text no matter where it comes from (be it a string tooltip or the text from a TooltipBase instance) then
     * they could call {@link #getTooltip_Text} instead.
     *
     * If a content control is assigned to the InPlaceEdit the tooltip of this control is used. A directly set
     * tooltip to the InPlaceEdit is ignored in this case.
     *
     *
     * @returns The tooltip for this Element.
     */
    getTooltip(): string | TooltipBase;
    /**
     * Gets current value of property {@link #getUndoEnabled undoEnabled}.
     *
     * If undo is enabled after changing the text an undo button appears.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `undoEnabled`
     */
    getUndoEnabled(): boolean;
    /**
     * Gets current value of property {@link #getValueState valueState}.
     *
     * Visualizes warnings or errors related to the InPlaceEdit. Possible values: Warning, Error, Success. If
     * the content control has a own valueState property this will be used.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `valueState`
     */
    getValueState(): ValueState | keyof typeof ValueState;
    /**
     * Sets the aggregated {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContent(
      /**
       * The content to set
       */
      oContent: Control
    ): this;
    /**
     * Sets a new tooltip for this InPlaceEdit. The tooltip can either be a simple string (which in most cases
     * will be rendered as the `title` attribute of this Element) or an instance of {@link sap.ui.core.TooltipBase}.
     *
     * If a new tooltip is set, any previously set tooltip is deactivated.
     *
     * If a content control is assigned to the InPlaceEdit the tooltip of this control is used. A directly set
     * tooltip to the InPlaceEdit is ignored in this case.
     *
     *
     * @returns InPlaceEdit instance for method chaining
     */
    setTooltip(): this;
    /**
     * Sets a new value for property {@link #getUndoEnabled undoEnabled}.
     *
     * If undo is enabled after changing the text an undo button appears.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUndoEnabled(
      /**
       * New value for property `undoEnabled`
       */
      bUndoEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getValueState valueState}.
     *
     * Visualizes warnings or errors related to the InPlaceEdit. Possible values: Warning, Error, Success. If
     * the content control has a own valueState property this will be used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueState(
      /**
       * New value for property `valueState`
       */
      sValueState?: ValueState | keyof typeof ValueState
    ): this;
  }
  /**
   * Describes the settings that can be provided to the InPlaceEdit constructor.
   *
   * @deprecated (since 1.22) - This control is not required anymore as per central UX requirements. Please
   * use sap.m.Input instead! This control will not be supported anymore.
   */
  export interface $InPlaceEditSettings extends $ControlSettings {
    /**
     * Visualizes warnings or errors related to the InPlaceEdit. Possible values: Warning, Error, Success. If
     * the content control has a own valueState property this will be used.
     */
    valueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * If undo is enabled after changing the text an undo button appears.
     */
    undoEnabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Content control of the InPlaceEdit. The following control is allowed: sap.m.Input, sap.m.Link
     */
    content?: Control;

    /**
     * Event is fired when the text in the field has changed AND the focus leaves the InPlaceEdit or the Enter
     * key is pressed.
     */
    change?: (oEvent: InPlaceEdit$ChangeEvent) => void;
  }

  /**
   * Parameters of the InPlaceEdit#change event.
   */
  export interface InPlaceEdit$ChangeEventParameters {
    /**
     * The new / changed value of the InPlaceEdit.
     */
    newValue?: string;
  }

  /**
   * Event object of the InPlaceEdit#change event.
   */
  export type InPlaceEdit$ChangeEvent = Event<
    InPlaceEdit$ChangeEventParameters,
    InPlaceEdit
  >;
}

declare module "sap/ca/ui/model/format/FormattingLibrary" {
  /**
   * Constructor for FormattingLibrary
   *
   * @deprecated (since 1.28) - This control has been made available in sap.ui.core. Please use classes from
   * package {@link sap.ui.core.format} instead! This control will not be supported anymore.
   */
  const FormattingLibrary: undefined;

  export default FormattingLibrary;
}

declare module "sap/ca/ui/model/format/AmountFormat" {
  import Locale from "sap/ui/core/Locale";

  /**
   * The AmountFormat is a static class for formatting and parsing file size values according to a set of
   * format options.
   *
   * If no pattern is specified a default pattern according to the locale settings is used.
   *
   * @deprecated (since 1.28) - This control has been made available in sap.ui.core. Please use {@link sap.ui.core.format.NumberFormat.getCurrencyInstance }
   * instead! This control will not be supported anymore.
   */
  export default class AmountFormat {
    /**
     * Constructor for AmountFormat - must not be used: To get a AmountFormat instance, please use getInstance.
     */
    constructor();

    /**
     * Convenience static function Format an amount in short Style. Number of decimals for values not "shortified"
     * will be set : Using Decimals if specified else using the standard number of decimal for the given currency
     * if decimals == "preserve", the number of decimals of the source value will be preserved (currency not
     * taken into account).
     *
     *
     * @returns the formatted value
     */
    static FormatAmountShort(
      /**
       * the string containing a formatted value
       */
      oValue: string,

      currencyCode: string,

      decimals: string
    ): string;
    /**
     * Convenience static function Format an amount in short Style with the currency code according to the cldr
     * currency format. Number of decimals for values not "shortified" will be set : Using Decimals if specified
     * else using the standard number of decimal for the given currency If decimals == "preserve", the number
     * of decimals of the source value will be preserved (currency not taken into account).
     *
     *
     * @returns the formatted value
     */
    static FormatAmountShortWithCurrency(
      /**
       * the string containing a formatted value
       */
      sValue: string,

      sCurrencyCode: string,

      decimals: string
    ): string;
    /**
     * Convenience static function Format an amount in standard Style. Number of decimals will be set: Using
     * Decimals if specified else using the standard number of decimal for the given currency if decimals ==
     * "preserve", the number of decimals of the source value will be preserved (currency not taken into account).
     *
     *
     * @returns the formatted value
     */
    static FormatAmountStandard(
      /**
       * the string containing a formatted value
       */
      oValue: string,

      currencyCode: string,

      decimals: string
    ): string;
    /**
     * Convenience static function Format an amount in standard Style with the currency code according to the
     * cldr currency format. Number of decimals will be set: Using decimals if specified else using the standard
     * number of decimal for the given currency if decimals == "preserve", the number of decimals of the source
     * value will be preserved (currency not taken into account).
     *
     *
     * @returns the formatted value
     */
    static FormatAmountStandardWithCurrency(
      /**
       * the string containing a formatted value
       */
      sValue: string,

      sCurrencyCode: string,

      decimals: string
    ): string;
    /**
     * Get a instance of the AmountFormat, which can be used for formatting.
     *
     *
     * @returns instance of the AmountFormat
     */
    static getInstance(
      /**
       * Object which defines the format options
       */
      oFormatOptions?: {
        /**
         * either empty or 'standard or 'short'. If no pattern is given, a locale dependent default pattern of that
         * style is used from the LocaleData class.
         */
        style?: string;
      },
      /**
       * Locale to ask for locale specific texts/settings
       */
      oLocale?: Locale
    ): AmountFormat;
    /**
     * Format an amount according to the given format options.
     *
     *
     * @returns the formatted output value
     */
    format(
      /**
       * the value to format
       */
      oValue: number
    ): string;
    /**
     * Format an amount with the currency code according to the cldr currency format.
     *
     *
     * @returns the formatted value
     */
    formatWithCurrency(
      /**
       * the string containing a formatted value
       */
      sValue: string,
      /**
       * the string containing the currency code
       */
      sCurrencyCode: string
    ): string;
    /**
     * Parse a string which is formatted according to the given format options.
     *
     *
     * @returns the parsed value
     */
    parse(
      /**
       * the string containing a formatted value
       */
      sValue: string
    ): number;
  }
}

declare module "sap/ca/ui/model/format/DateFormat" {
  import Locale from "sap/ui/core/Locale";

  /**
   * The DateFormat is a static class for formatting and parsing date and time values according to a set of
   * format options.
   *
   * It uses sap.ui.core.format.DateFormat to format and parse dates, and adds a new style daysAgo for Date
   * instances. With this style:
   * 	 - For today: "Today" will be displayed (localized)
   * 	 - For yesterday: "1 day ago" will be displayed (localized)
   * 	 - Between 2 days and 6 days in the past: "x days ago" will be displayed (localized)
   * 	 - In the future or more than 6 days in the past: the date will be formatted with a medium style
   *     The daysAgo style can be formatted in UTC.
   *
   * Supported format options are pattern based on Unicode LDML Date Format notation. If no pattern is specified
   * a default pattern according to the locale settings is used.
   *
   * @deprecated (since 1.28) - This control has been made available in sap.ui.core. Please use {@link sap.ui.core.format.DateFormat }
   * instead! This control will not be supported anymore.
   */
  export default class DateFormat {
    /**
     * Constructor for DateFormat - must not be used: To get a DateFormat instance, please use getInstance,
     * getDateTimeInstance or getTimeInstance.
     * See:
     * 	http://unicode.org/reports/tr35/#Date_Field_Symbol_Table
     */
    constructor();

    /**
     * Get a date instance of the DateFormat, which can be used for formatting.
     *
     *
     * @returns date instance of the DateFormat
     */
    static getDateInstance(
      /**
       * Object which defines the format options
       */
      oFormatOptions?: {
        /**
         * a data pattern in LDML format. It is not verified whether the pattern represents only a date.
         */
        pattern?: string;
        /**
         * either empty or 'short, 'medium', 'long' or 'daysAgo'. If no pattern is given, a locale dependent default
         * date pattern of that style is used from the LocaleData class.
         */
        style?: string;
      },
      /**
       * Locale to ask for locale specific texts/settings
       */
      oLocale?: Locale
    ): DateFormat;
    /**
     * Get a datetime instance of the DateFormat, which can be used for formatting.
     *
     *
     * @returns datetime instance of the DateFormat
     */
    static getDateTimeInstance(
      /**
       * Object which defines the format options
       */
      oFormatOptions?: {
        /**
         * a datetime pattern in LDML format. It is not verified whether the pattern represents a full datetime.
         */
        pattern?: string;
        /**
         * either empty or 'short, 'medium' or 'long'. If no pattern is given, a locale dependent default datetime
         * pattern of that style is used from the LocaleData class.
         */
        style?: string;
      },
      /**
       * Locale to ask for locale specific texts/settings
       */
      oLocale?: Locale
    ): DateFormat;
    /**
     * Get a time instance of the DateFormat, which can be used for formatting.
     *
     *
     * @returns time instance of the DateFormat
     */
    static getTimeInstance(
      /**
       * Object which defines the format options
       */
      oFormatOptions?: {
        /**
         * a time pattern in LDML format. It is not verified whether the pattern only represents a time.
         */
        pattern?: string;
        /**
         * either empty or 'short, 'medium' or 'long'. If no pattern is given, a locale dependent default time pattern
         * of that style is used from the LocaleData class.
         */
        style?: string;
      },
      /**
       * Locale to ask for locale specific texts/settings
       */
      oLocale?: Locale
    ): DateFormat;
    /**
     * Format a date according to the given format options.
     *
     * If oValue contains a JSON date ("/Date(milliseconds)/"), it will be converted to a Date before to be
     * formatted.
     *
     *
     * @returns the formatted output value
     */
    format(
      /**
       * the vale to format
       */
      oValue: Date | string,
      /**
       * whether to use UTC
       */
      bUTC: boolean
    ): string;
    /**
     * Parse a string which is formatted according to the given format options. The strings specific to the
     * daysAgo style will not be well-parsed.
     *
     *
     * @returns the parsed value
     */
    parse(
      /**
       * the string containing a formatted date/time value
       */
      sValue: string
    ): Date;
  }
}

declare module "sap/ca/ui/model/format/FileSizeFormat" {
  import FileSize from "sap/ca/ui/model/type/FileSize";

  import Locale from "sap/ui/core/Locale";

  /**
   * The FileSizeFormat is a static class for formatting and parsing file size values according to a set of
   * format options.
   *
   * Simplified logic: display in kB for 1e3 <= bytes < 1e6 display in MB for 1e6 <= bytes < 1e9 ...
   *
   * @deprecated (since 1.28) - This control has been made available in sap.ui.core. Please use {@link sap.ui.core.format.FileSizeFormat }
   * instead! This control will not be supported anymore.
   */
  export default class FileSizeFormat {
    /**
     * Constructor for FileSizeFormat - must not be used: To get a FileSizeFormat instance, please use getInstance.
     */
    constructor();

    /**
     * Get a instance of the FileSizeFormat, which can be used for formatting.
     *
     *
     * @returns instance of the FileSizeFormat
     */
    static getInstance(
      /**
       * Object which defines the format options
       */
      oFormatOptions?: {
        /**
         * number of decimals to use.
         */
        shortDecimals?: number;
      },
      /**
       * Locale to ask for locale specific texts/settings
       */
      oLocale?: Locale
    ): FileSizeFormat;
    /**
     * Format according to the given format options.
     *
     *
     * @returns the formatted output value
     */
    format(
      /**
       * the value to format
       */
      oValue: FileSize
    ): string;
    /**
     * Parse a string which is formatted according to the given format options.
     *
     *
     * @returns the parsed value
     */
    parse(
      /**
       * the string containing a formatted value
       */
      sValue: string
    ): number;
  }
}

declare module "sap/ca/ui/model/format/QuantityFormat" {
  import Locale from "sap/ui/core/Locale";

  /**
   * The QuantityFormat is a static class for formatting and parsing file size values according to a set of
   * format options.
   *
   * If no pattern is specified a default pattern according to the locale settings is used.
   *
   * @deprecated (since 1.28) - There is no replacement for the QuantityFormat in sap.ui.core.format. Please
   * refer to {@link sap.ui.core.format} and set the `minFractionDigits` and `maxFractionDigits` on the formatter
   * as required. This control will not be supported anymore.
   */
  export default class QuantityFormat {
    /**
     * Constructor for QuantityFormat - must not be used: To get a QuantityFormat instance, please use getInstance.
     */
    constructor();

    /**
     * Convenience static function Format an quantity in short Style. Number of decimals will be set : Using
     * Decimals if specified else using the standard number of decimal for the given unit
     *
     *
     * @returns the formatted value
     */
    static FormatQuantityShort(
      /**
       * the string containing a formatted value
       */
      sValue: string,

      unitCode: string,

      decimals: string
    ): string;
    /**
     * Convenience static function Format an quantity in standard Style. Number of decimals will be set : Using
     * Decimals if specified else using the standard number of decimal for the given unit
     *
     *
     * @returns the formatted value
     */
    static FormatQuantityStandard(
      /**
       * the string containing a formatted value
       */
      sValue: string,

      unitCode: string,

      decimals: string
    ): string;
    /**
     * Get a instance of the QuantityFormat, which can be used for formatting.
     *
     *
     * @returns instance of the QuantityFormat
     */
    static getInstance(
      /**
       * Object which defines the format options
       */
      oFormatOptions?: {
        /**
         * either empty or 'standard or 'short'. If no pattern is given, a locale dependent default pattern of that
         * style is used from the LocaleData class.
         */
        style?: string;
      },
      /**
       * Locale to ask for locale specific texts/settings
       */
      oLocale?: Locale
    ): QuantityFormat;
    /**
     * Format a value according to the given format options.
     *
     *
     * @returns the formatted output value
     */
    format(
      /**
       * the value to format
       */
      oValue: object
    ): string;
    /**
     * Parse a string which is formatted according to the given format options.
     *
     *
     * @returns the parsed value
     */
    parse(
      /**
       * the string containing a formatted value
       */
      sValue: string
    ): number;
  }
}

declare module "sap/ca/ui/model/type/Date" {
  import SimpleType from "sap/ui/model/SimpleType";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * This class represents date simple types.
   *
   * @deprecated (since 1.28) - This control has been made available in sap.ui.core. Please use {@link sap.ui.model.type.Date }
   * instead! This control will not be supported anymore.
   */
  export default class Date1 extends SimpleType {
    /**
     * Constructor for a Date type.
     */
    constructor(
      /**
       * options used to create a DateFormat for formatting / parsing. Supports the same options as {@link sap.ca.ui.model.format.DateFormat.getDateInstance DateFormat.getDateInstance}.
       * You can use an extra boolean option UTC to format in UTC ({style: "short", UTC: true}).
       */
      oFormatOptions?: {
        /**
         * additional set of options used to create a second DateFormat object for conversions between string values
         * in the data source (e.g. model) and Date. This second format object is used to convert from a model string
         * to Date before converting the Date to string with the primary format object. Vice versa, this 'source'
         * format is also used to format an already parsed external value (e.g. user input) into the string format
         * expected by the data source. Supports the same set of options as {@link sap.ca.ui.model.format.DateFormat.getDateInstance DateFormat.getDateInstance}.
         */
        source?: object;
      },
      /**
       * value constraints.
       */
      oConstraints?: {
        /**
         * smallest value allowed for this type. Values for constraints must use the same type as configured via
         * `oFormatOptions.source`
         */
        minimum?: Date | string;
        /**
         * largest value allowed for this type. Values for constraints must use the same type as configured via
         * `oFormatOptions.source`
         */
        maximum?: Date | string;
      }
    );

    /**
     * Creates a new subclass of class sap.ca.ui.model.type.Date with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * For a detailed description of `oClassInfo` or `FNMetaImpl` see {@link sap.ui.base.Object.extend Object.extend}.
     *
     *
     * @returns the created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * name of the class to be created
       */
      sClassName: string,
      /**
       * object literal with informations about the class
       */
      oClassInfo?: sap.ClassInfo<T, Date1>,
      /**
       * alternative constructor for a metadata object
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.model.type.Date.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    getOutputPattern(): void;
  }
}

declare module "sap/ca/ui/model/type/DateTime" {
  import Date1 from "sap/ca/ui/model/type/Date";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * This class represents datetime simple types.
   *
   * @deprecated (since 1.28) - This control has been made available in sap.ui.core. Please use {@link sap.ui.model.type.DateTime }
   * instead! This control will not be supported anymore.
   */
  export default class DateTime extends Date1 {
    /**
     * Constructor for a DateTime type.
     */
    constructor(
      /**
       * options used to create a DateFormat for formatting / parsing to/from external values and optionally for
       * a second DateFormat to convert between the data source format (Model) and the internally used JavaScript
       * Date.format. For both DateFormat objects, the same options are supported as for {@link sap.ca.ui.model.format.DateFormat.getDateTimeInstance DateFormat.getDateTimeInstance}.
       * You can use an extra boolean option UTC to format in UTC ({style: "short", UTC: true}). Note that this
       * differs from the base type.
       */
      oFormatOptions?: object,
      /**
       * value constraints. Supports the same kind of constraints as its base type Date, but note the different
       * format options (Date vs. DateTime)
       */
      oConstraints?: object
    );

    /**
     * Creates a new subclass of class sap.ca.ui.model.type.DateTime with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * For a detailed description of `oClassInfo` or `FNMetaImpl` see {@link sap.ui.base.Object.extend Object.extend}.
     *
     *
     * @returns the created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * name of the class to be created
       */
      sClassName: string,
      /**
       * object literal with informations about the class
       */
      oClassInfo?: sap.ClassInfo<T, DateTime>,
      /**
       * alternative constructor for a metadata object
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.model.type.DateTime.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
  }
}

declare module "sap/ca/ui/model/type/FileSize" {
  import SimpleType from "sap/ui/model/SimpleType";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * This class represents file size types.
   *
   * @deprecated (since 1.28) - This control has been made available in sap.ui.core. Please use {@link sap.ui.model.type.FileSize }
   * instead! This control will not be supported anymore.
   */
  export default class FileSize extends SimpleType {
    /**
     * Constructor for a FileSize type.
     */
    constructor(
      /**
       * formatting options. Supports the same options as {@link sap.ui.core.format.NumberFormat.getFloatInstance NumberFormat.getFloatInstance}
       */
      oFormatOptions?: object,
      /**
       * value constraints.
       */
      oConstraint?: object
    );

    /**
     * Creates a new subclass of class sap.ca.ui.model.type.FileSize with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * For a detailed description of `oClassInfo` or `FNMetaImpl` see {@link sap.ui.base.Object.extend Object.extend}.
     *
     *
     * @returns the created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * name of the class to be created
       */
      sClassName: string,
      /**
       * object literal with informations about the class
       */
      oClassInfo?: sap.ClassInfo<T, FileSize>,
      /**
       * alternative constructor for a metadata object
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.model.type.FileSize.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
  }
}

declare module "sap/ca/ui/model/type/Number" {
  import SimpleType from "sap/ui/model/SimpleType";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * This class represents number simple types.
   *
   * @deprecated (since 1.28) - This control has been made available in sap.ui.core. Please use {@link sap.ui.model.type.Float }
   * or sap.ui.model.type.Integer with sap.ui.core.format.NumberFormat instead! This control will not be supported
   * anymore.
   */
  export default class Number1 extends SimpleType {
    /**
     * Constructor for a Number type.
     */
    constructor(
      /**
       * formatting options. Supports the same options as {@link sap.ui.core.format.NumberFormat.getNumberInstance NumberFormat.getNumberInstance}
       */
      oFormatOptions?: object,
      /**
       * value constraints.
       */
      oConstraint?: object
    );

    /**
     * Creates a new subclass of class sap.ca.ui.model.type.Number with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * For a detailed description of `oClassInfo` or `FNMetaImpl` see {@link sap.ui.base.Object.extend Object.extend}.
     *
     *
     * @returns the created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * name of the class to be created
       */
      sClassName: string,
      /**
       * object literal with informations about the class
       */
      oClassInfo?: sap.ClassInfo<T, Number1>,
      /**
       * alternative constructor for a metadata object
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.model.type.Number.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
  }
}

declare module "sap/ca/ui/model/type/Time" {
  import Date1 from "sap/ca/ui/model/type/Date";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * This class represents time simple types.
   *
   * @deprecated (since 1.28) - This control has been made available in sap.ui.core. Please use {@link sap.ui.model.type.Time }
   * instead! This control will not be supported anymore.
   */
  export default class Time extends Date1 {
    /**
     * Constructor for a Time type.
     */
    constructor(
      /**
       * options used to create a DateFormat for formatting / parsing to/from external values and optionally for
       * a second DateFormat to convert between the data source format (Model) and the internally used JavaScript
       * Date.format. For both DateFormat objects, the same options are supported as for {@link sap.ca.ui.model.format.DateFormat.getTimeInstance DateFormat.getTimeInstance}.
       * You can use an extra boolean option UTC to format in UTC ({style: "short", UTC: true}). Note that this
       * differs from the base type.
       */
      oFormatOptions?: object,
      /**
       * value constraints. Supports the same kind of constraints as its base type Date, but note the different
       * format options (Date vs. Time)
       */
      oConstraints?: object
    );

    /**
     * Creates a new subclass of class sap.ca.ui.model.type.Time with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * For a detailed description of `oClassInfo` or `FNMetaImpl` see {@link sap.ui.base.Object.extend Object.extend}.
     *
     *
     * @returns the created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * name of the class to be created
       */
      sClassName: string,
      /**
       * object literal with informations about the class
       */
      oClassInfo?: sap.ClassInfo<T, Time>,
      /**
       * alternative constructor for a metadata object
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.model.type.Time.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
  }
}

declare module "sap/ca/ui/Notes" {
  import { default as List, $ListSettings } from "sap/m/List";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * This control is a List with the ability to render an additional control on top of it to add new notes.
   * The developer is responsible to give the correct template to use to display notes (recommended are either
   * the FeedListItem or the ExpansibleFeedListItem). The developer is also responsible to implement the code
   * to send the notes to the backend system, by responding to the addNote event.
   *
   * @deprecated (since 1.22) - This control has been made available in sap.m. Please use sap.m.FeedInput
   * with sap.m.FeedListItem instead! This control will not be supported anymore.
   */
  export default class Notes extends List {
    /**
     * Constructor for a new Notes.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $NotesSettings
    );
    /**
     * Constructor for a new Notes.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $NotesSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.Notes with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.List.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Notes>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.Notes.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:addNote addNote} event of this `sap.ca.ui.Notes`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.Notes` itself.
     *
     * press event for button
     *
     * (oControlEvent) Event is fired when the user clicks on the control.
     *
     * fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAddNote(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.Notes` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:addNote addNote} event of this `sap.ca.ui.Notes`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.Notes` itself.
     *
     * press event for button
     *
     * (oControlEvent) Event is fired when the user clicks on the control.
     *
     * fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAddNote(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.Notes` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:addNote addNote} event of this `sap.ca.ui.Notes`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAddNote(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:addNote addNote} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAddNote(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getPlaceholder placeholder}.
     *
     * Placeholder text shown when no value available . Default value is "Add note".
     *
     *
     * @returns Value of property `placeholder`
     */
    getPlaceholder(): string;
    /**
     * Gets current value of property {@link #getShowNoteInput showNoteInput}.
     *
     * If set to true, this control will render an additional control to create new notes.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showNoteInput`
     */
    getShowNoteInput(): boolean;
    /**
     * Gets current value of property {@link #getTextMaxLength textMaxLength}.
     *
     * max text input length
     *
     * Default value is `1000`.
     *
     *
     * @returns Value of property `textMaxLength`
     */
    getTextMaxLength(): int;
    /**
     * Sets a new value for property {@link #getPlaceholder placeholder}.
     *
     * Placeholder text shown when no value available . Default value is "Add note".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlaceholder(
      /**
       * New value for property `placeholder`
       */
      sPlaceholder?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShowNoteInput showNoteInput}.
     *
     * If set to true, this control will render an additional control to create new notes.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowNoteInput(
      /**
       * New value for property `showNoteInput`
       */
      bShowNoteInput?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTextMaxLength textMaxLength}.
     *
     * max text input length
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1000`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextMaxLength(
      /**
       * New value for property `textMaxLength`
       */
      iTextMaxLength?: int
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Notes constructor.
   *
   * @deprecated (since 1.22) - This control has been made available in sap.m. Please use sap.m.FeedInput
   * with sap.m.FeedListItem instead! This control will not be supported anymore.
   */
  export interface $NotesSettings extends $ListSettings {
    /**
     * If set to true, this control will render an additional control to create new notes.
     */
    showNoteInput?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * max text input length
     */
    textMaxLength?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Placeholder text shown when no value available . Default value is "Add note".
     */
    placeholder?: string | PropertyBindingInfo;

    /**
     * press event for button
     *
     * (oControlEvent) Event is fired when the user clicks on the control.
     *
     * fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]
     */
    addNote?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Notes#addNote event.
   */
  export interface Notes$AddNoteEventParameters {}

  /**
   * Event object of the Notes#addNote event.
   */
  export type Notes$AddNoteEvent = Event<Notes$AddNoteEventParameters, Notes>;
}

declare module "sap/ca/ui/OverflowContainer" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { CSSSize } from "sap/ui/core/library";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * The OverflowContainer allows the content of a control to be partially displayed before being fully expanded.
   * It will cut its content to a fixed height that can be defined. It is fully suitable within an IconTabBar.
   *
   * @deprecated (since 1.24.1) - OverflowContainer is deprecated as per central UX requirements. This control
   * will not be supported anymore.
   */
  export default class OverflowContainer extends Control {
    /**
     * Constructor for a new OverflowContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $OverflowContainerSettings
    );
    /**
     * Constructor for a new OverflowContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $OverflowContainerSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.OverflowContainer with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, OverflowContainer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.OverflowContainer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Controls to be embedded.
     */
    getContent(): Control[];
    /**
     * Gets current value of property {@link #getExpanded expanded}.
     *
     * This property allows to fully expand the container
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `expanded`
     */
    getExpanded(): boolean;
    /**
     * Gets current value of property {@link #getOverflowHeight overflowHeight}.
     *
     * The height of the container when not expanded. It should be determined by the application. The default
     * value is set to 200px.
     *
     * Default value is `'200px'`.
     *
     *
     * @returns Value of property `overflowHeight`
     */
    getOverflowHeight(): CSSSize;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getExpanded expanded}.
     *
     * This property allows to fully expand the container
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpanded(
      /**
       * New value for property `expanded`
       */
      bExpanded?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getOverflowHeight overflowHeight}.
     *
     * The height of the container when not expanded. It should be determined by the application. The default
     * value is set to 200px.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'200px'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOverflowHeight(
      /**
       * New value for property `overflowHeight`
       */
      sOverflowHeight?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the OverflowContainer constructor.
   *
   * @deprecated (since 1.24.1) - OverflowContainer is deprecated as per central UX requirements. This control
   * will not be supported anymore.
   */
  export interface $OverflowContainerSettings extends $ControlSettings {
    /**
     * The height of the container when not expanded. It should be determined by the application. The default
     * value is set to 200px.
     */
    overflowHeight?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * This property allows to fully expand the container
     */
    expanded?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls to be embedded.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/ca/ui/OverviewTile" {
  import { default as Tile, $TileSettings } from "sap/m/Tile";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { CSSSize, URI } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Display aTile that presents an overview of a customer
   *
   * @deprecated (since 1.24.3) - This control is not required anymore as per central UX requirements. This
   * control will not be supported anymore.
   */
  export default class OverviewTile extends Tile {
    /**
     * Constructor for a new OverviewTile.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $OverviewTileSettings
    );
    /**
     * Constructor for a new OverviewTile.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $OverviewTileSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.OverviewTile with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.Tile.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, OverviewTile>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.OverviewTile.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contactPress contactPress} event of this `sap.ca.ui.OverviewTile`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.OverviewTile` itself.
     *
     * This event is fired when the end user clicks on the contact link.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContactPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.OverviewTile` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:contactPress contactPress} event of this `sap.ca.ui.OverviewTile`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.OverviewTile` itself.
     *
     * This event is fired when the end user clicks on the contact link.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachContactPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.OverviewTile` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:contactPress contactPress} event of this `sap.ca.ui.OverviewTile`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachContactPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:contactPress contactPress} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireContactPress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getAddress address}.
     *
     * This property is used to set the address field in the form of the tile
     *
     * Default value is `'null'`.
     *
     *
     * @returns Value of property `address`
     */
    getAddress(): string;
    /**
     * Gets current value of property {@link #getContact contact}.
     *
     * This property is used to set the contact of the tile
     *
     * Default value is `'null'`.
     *
     *
     * @returns Value of property `contact`
     */
    getContact(): string;
    /**
     * Gets current value of property {@link #getContactActive contactActive}.
     *
     * This property is used to enable an event to be thrown when clicking on the contact's name
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `contactActive`
     */
    getContactActive(): boolean;
    /**
     * Gets current value of property {@link #getLastContact lastContact}.
     *
     * This property is used to set the last contact field in the form of the tile
     *
     * Default value is `'null'`.
     *
     *
     * @returns Value of property `lastContact`
     */
    getLastContact(): string;
    /**
     * Gets current value of property {@link #getNextContact nextContact}.
     *
     * This property is used to set the next contact field in the form of the tile
     *
     * Default value is `'null'`.
     *
     *
     * @returns Value of property `nextContact`
     */
    getNextContact(): string;
    /**
     * Gets current value of property {@link #getOpportunities opportunities}.
     *
     * This property is used to set the opportunities field in the form of the tile
     *
     * Default value is `'null'`.
     *
     *
     * @returns Value of property `opportunities`
     */
    getOpportunities(): string;
    /**
     * Gets current value of property {@link #getRating rating}.
     *
     * This property is used to set the rating field in the form of the tile
     *
     * Default value is `'null'`.
     *
     *
     * @returns Value of property `rating`
     */
    getRating(): string;
    /**
     * Gets current value of property {@link #getRevenue revenue}.
     *
     * This property is used to set the revenue to date field in the form of the tile
     *
     * Default value is `'null'`.
     *
     *
     * @returns Value of property `revenue`
     */
    getRevenue(): string;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * This property is used to set the title of the tile
     *
     * Default value is `'null'`.
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Gets current value of property {@link #getVisible visible}.
     *
     * This property is used to show/hide the tile
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * This property is used to set the width of the control
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * The initialization method
     */
    init(): void;
    /**
     * Sets a new value for property {@link #getAddress address}.
     *
     * This property is used to set the address field in the form of the tile
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'null'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAddress(
      /**
       * New value for property `address`
       */
      sAddress?: string
    ): this;
    /**
     * Sets a new value for property {@link #getContact contact}.
     *
     * This property is used to set the contact of the tile
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'null'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContact(
      /**
       * New value for property `contact`
       */
      sContact?: string
    ): this;
    /**
     * Sets a new value for property {@link #getContactActive contactActive}.
     *
     * This property is used to enable an event to be thrown when clicking on the contact's name
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContactActive(
      /**
       * New value for property `contactActive`
       */
      bContactActive?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * This property is used to set the image of the tile
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'null'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getLastContact lastContact}.
     *
     * This property is used to set the last contact field in the form of the tile
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'null'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLastContact(
      /**
       * New value for property `lastContact`
       */
      sLastContact?: string
    ): this;
    /**
     * Sets a new value for property {@link #getNextContact nextContact}.
     *
     * This property is used to set the next contact field in the form of the tile
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'null'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNextContact(
      /**
       * New value for property `nextContact`
       */
      sNextContact?: string
    ): this;
    /**
     * Sets a new value for property {@link #getOpportunities opportunities}.
     *
     * This property is used to set the opportunities field in the form of the tile
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'null'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOpportunities(
      /**
       * New value for property `opportunities`
       */
      sOpportunities?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRating rating}.
     *
     * This property is used to set the rating field in the form of the tile
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'null'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRating(
      /**
       * New value for property `rating`
       */
      sRating?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRevenue revenue}.
     *
     * This property is used to set the revenue to date field in the form of the tile
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'null'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRevenue(
      /**
       * New value for property `revenue`
       */
      sRevenue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * This property is used to set the title of the tile
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'null'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle?: string
    ): this;
    /**
     * Sets a new value for property {@link #getVisible visible}.
     *
     * This property is used to show/hide the tile
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisible(
      /**
       * New value for property `visible`
       */
      bVisible?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * This property is used to set the width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the OverviewTile constructor.
   *
   * @deprecated (since 1.24.3) - This control is not required anymore as per central UX requirements. This
   * control will not be supported anymore.
   */
  export interface $OverviewTileSettings extends $TileSettings {
    /**
     * This property is used to set the title of the tile
     */
    title?: string | PropertyBindingInfo;

    /**
     * This property is used to set the image of the tile
     */
    icon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * This property is used to set the contact of the tile
     */
    contact?: string | PropertyBindingInfo;

    /**
     * This property is used to set the address field in the form of the tile
     */
    address?: string | PropertyBindingInfo;

    /**
     * This property is used to set the opportunities field in the form of the tile
     */
    opportunities?: string | PropertyBindingInfo;

    /**
     * This property is used to set the rating field in the form of the tile
     */
    rating?: string | PropertyBindingInfo;

    /**
     * This property is used to set the last contact field in the form of the tile
     */
    lastContact?: string | PropertyBindingInfo;

    /**
     * This property is used to set the next contact field in the form of the tile
     */
    nextContact?: string | PropertyBindingInfo;

    /**
     * This property is used to set the revenue to date field in the form of the tile
     */
    revenue?: string | PropertyBindingInfo;

    /**
     * This property is used to show/hide the tile
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * This property is used to set the width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * This property is used to enable an event to be thrown when clicking on the contact's name
     */
    contactActive?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * This event is fired when the end user clicks on the contact link.
     */
    contactPress?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the OverviewTile#contactPress event.
   */
  export interface OverviewTile$ContactPressEventParameters {}

  /**
   * Event object of the OverviewTile#contactPress event.
   */
  export type OverviewTile$ContactPressEvent = Event<
    OverviewTile$ContactPressEventParameters,
    OverviewTile
  >;
}

declare module "sap/ca/ui/PictureItem" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A picture / photo Item for AddPicture and PictureViewer Controls
   *
   * @deprecated (since 1.22) - This control has been made available in sap.m. Please use the sap.m.Carousel
   * instead! This control will not be supported anymore.
   */
  export default class PictureItem extends Control {
    /**
     * Constructor for a new PictureItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $PictureItemSettings
    );
    /**
     * Constructor for a new PictureItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $PictureItemSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.PictureItem with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, PictureItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.PictureItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:loaded loaded} event of this `sap.ca.ui.PictureItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.PictureItem` itself.
     *
     * Fired when the Image is really loaded
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLoaded(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.PictureItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:loaded loaded} event of this `sap.ca.ui.PictureItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.PictureItem` itself.
     *
     * Fired when the Image is really loaded
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLoaded(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.PictureItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:loaded loaded} event of this `sap.ca.ui.PictureItem`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachLoaded(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:loaded loaded} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireLoaded(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * The height of the picture.
     *
     * Default value is `'62px'`.
     *
     * @deprecated (since 1.16.2) - Height is defined by the AddPicture control
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * The original name of the picture.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getSource source}.
     *
     * The content of the picture. Either the uri or base64 content.
     *
     *
     * @returns Value of property `source`
     */
    getSource(): string;
    /**
     * Gets current value of property {@link #getStatus status}.
     *
     * The status of the picture / photo : Added, Deleted, Read
     *
     *
     * @returns Value of property `status`
     */
    getStatus(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the picture.
     *
     * Default value is `'62px'`.
     *
     * @deprecated (since 1.16.2) - Width is defined by the AddPicture control
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Set the File object
     */
    setFile(
      file: File,
      /**
       * Canvas config
       */
      oConfig: Object
    ): void;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * The height of the picture.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'62px'`.
     *
     * @deprecated (since 1.16.2) - Height is defined by the AddPicture control
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * The original name of the picture.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Set the source for the picture, either uri or data url scheme (base64 information).
     */
    setSource(
      /**
       * The URI of the image or the DATA URL scheme. Samples: 1 - "./images/IMG_0095.PNG" 2 - "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABMAAAAKCAYAAABWiWWfAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjExR/NCNwAAAhtJREFUOE+tkF9oUlEcx11pmbnVkw+lvkQwWPXQoMegl57qrZcIpjEqqociiOoloraBIIxRG7UoSNhsq1axGpmatRUEaTljbm56s6b3rnmdXv+k13/ffsfYIPKxH3y53/M953zOl6tYN57y/Q81vUxdVCiHeajtAvRjP9E8IkA5xGPDsFD3m0kq8lr6toz+ydi+iu6wM6tSPRTs658n1Yp9T+LwiTISxSrCmTI63MswPPiBCPlJoQDlAAdbKIvvuTI4yhyLBeweiUFz5xs0g6S70RcbbTGtgs2zhQxShQpOT8TR+zGBvfcjOPNaAJtqDWi/F8ErLguJHrviXkLyVwWPQxmorbNo6Z2b0vaHdXUQm6EvSZQqNYwF0zg6GsWW69N4H83BF8tDzJfR83YJEyEJy9SsrS+IkFjEB9rfdM3/aatlRr8GYqatx49Hn0UIkoxiuQarR4BM8C5HDJ4FCQE+D8dsGhWqyUslZIsVWFzxgOayd8dfILZov+HDfosfR/pn6g3ZJTacWIBIbeqQtAyJfsUFexjHBoPzO6/6Wv8BseC2axEruRL4lIwcvSqXq4gmCuh+ysE6HqW2VZRI8ZUidKfe8bqzk3sagli469wUTgx8xSXbHA51eXH8ZgCHu73Qmd3Y1vkGpr5pdN4KsDy1/aTngLHD2Ww0ORvzjGYnDCYn9KRVb6CM+bW1yZnXm10HCdJKOk9qakT7DfsPyGaTv0W2AAAAAElFTkSuQmCC"
       */
      sValue: string
    ): void;
    /**
     * Sets a new value for property {@link #getStatus status}.
     *
     * The status of the picture / photo : Added, Deleted, Read
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStatus(
      /**
       * New value for property `status`
       */
      sStatus?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the picture.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'62px'`.
     *
     * @deprecated (since 1.16.2) - Width is defined by the AddPicture control
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the PictureItem constructor.
   *
   * @deprecated (since 1.22) - This control has been made available in sap.m. Please use the sap.m.Carousel
   * instead! This control will not be supported anymore.
   */
  export interface $PictureItemSettings extends $ControlSettings {
    /**
     * The status of the picture / photo : Added, Deleted, Read
     */
    status?: string | PropertyBindingInfo;

    /**
     * The content of the picture. Either the uri or base64 content.
     */
    source?: string | PropertyBindingInfo;

    /**
     * The original name of the picture.
     */
    name?: string | PropertyBindingInfo;

    /**
     * The width of the picture.
     *
     * @deprecated (since 1.16.2) - Width is defined by the AddPicture control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The height of the picture.
     *
     * @deprecated (since 1.16.2) - Height is defined by the AddPicture control
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Fired when the Image is really loaded
     */
    loaded?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the PictureItem#loaded event.
   */
  export interface PictureItem$LoadedEventParameters {}

  /**
   * Event object of the PictureItem#loaded event.
   */
  export type PictureItem$LoadedEvent = Event<
    PictureItem$LoadedEventParameters,
    PictureItem
  >;
}

declare module "sap/ca/ui/PictureTile" {
  import { default as CustomTile, $CustomTileSettings } from "sap/m/CustomTile";

  import Event from "sap/ui/base/Event";

  import { CSSSize, ID } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import PictureViewerItem from "sap/ca/ui/PictureViewerItem";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Tile control embedding an image and allowing custom sizing
   *
   * @deprecated (since 1.22) - PictureTile is used in PictureViewer control and is not meant to be consumed
   * outside of PictureViewer usage. PictureViewer was replacing the sap.m.Carousel as it wasn't supporting
   * some versions of MS Internet Explorer. Now, the sap.m.Carousel is fully functional, please use sap.m.Carousel
   * instead. This control will not be supported anymore.
   */
  export default class PictureTile extends CustomTile {
    /**
     * Constructor for a new PictureTile.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $PictureTileSettings
    );
    /**
     * Constructor for a new PictureTile.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $PictureTileSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.PictureTile with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.CustomTile.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, PictureTile>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.PictureTile.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pictureDelete pictureDelete} event of this `sap.ca.ui.PictureTile`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.PictureTile` itself.
     *
     * Fired when the user deletes a picture
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPictureDelete(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.PictureTile` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pictureDelete pictureDelete} event of this `sap.ca.ui.PictureTile`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.PictureTile` itself.
     *
     * Fired when the user deletes a picture
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPictureDelete(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.PictureTile` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:pictureDelete pictureDelete} event of this
     * `sap.ca.ui.PictureTile`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPictureDelete(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:pictureDelete pictureDelete} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePictureDelete(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * height (in pixels) of the picture viewer control.
     *
     * Default value is `'32px'`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * ID of the element which is the current target of the association {@link #getTileContent tileContent},
     * or `null`.
     */
    getTileContent(): ID;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * width (in pixels) of the picture viewer control.
     *
     * Default value is `'32px'`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * height (in pixels) of the picture viewer control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'32px'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Reference to one PictureViewerItem coming from the PictureViewer.
     *
     *
     * @returns `this` to allow method chaining
     */
    setTileContent(
      /**
       * Id of an element which becomes the new target of this `tileContent` association. Alternatively, an element
       * instance may be given.
       */
      vTileContent: string | PictureViewerItem
    ): PictureTile;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * width (in pixels) of the picture viewer control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'32px'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the PictureTile constructor.
   *
   * @deprecated (since 1.22) - PictureTile is used in PictureViewer control and is not meant to be consumed
   * outside of PictureViewer usage. PictureViewer was replacing the sap.m.Carousel as it wasn't supporting
   * some versions of MS Internet Explorer. Now, the sap.m.Carousel is fully functional, please use sap.m.Carousel
   * instead. This control will not be supported anymore.
   */
  export interface $PictureTileSettings extends $CustomTileSettings {
    /**
     * height (in pixels) of the picture viewer control.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * width (in pixels) of the picture viewer control.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Reference to one PictureViewerItem coming from the PictureViewer.
     */
    tileContent?: PictureViewerItem | string;

    /**
     * Fired when the user deletes a picture
     */
    pictureDelete?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the PictureTile#pictureDelete event.
   */
  export interface PictureTile$PictureDeleteEventParameters {}

  /**
   * Event object of the PictureTile#pictureDelete event.
   */
  export type PictureTile$PictureDeleteEvent = Event<
    PictureTile$PictureDeleteEventParameters,
    PictureTile
  >;
}

declare module "sap/ca/ui/PictureViewer" {
  import {
    default as TileContainer,
    $TileContainerSettings,
  } from "sap/m/TileContainer";

  import PictureViewerItem from "sap/ca/ui/PictureViewerItem";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Picture viewer control relying on the TileContainer control
   *
   * @deprecated (since 1.22) - PictureViewer was replacing the Carousel as it wasn't supporting some versions
   * of MS Internet Explorer. Now, the sap.m.Carousel is fully functional, please use sap.m.Carousel instead.
   * This control will not be supported anymore.
   */
  export default class PictureViewer extends TileContainer {
    /**
     * Constructor for a new PictureViewer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $PictureViewerSettings
    );
    /**
     * Constructor for a new PictureViewer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $PictureViewerSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.PictureViewer with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.TileContainer.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, PictureViewer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.PictureViewer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some item `oItem` to the aggregation named `items`.
     *
     * @deprecated - Use aggregation "tiles"
     *
     * @returns `this` to allow method chaining
     */
    addItem(
      /**
       * the item to add; if empty, nothing is inserted
       */
      oItem: PictureViewerItem
    ): PictureViewer;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pictureDeleted pictureDeleted} event of this
     * `sap.ca.ui.PictureViewer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.PictureViewer` itself.
     *
     * Thrown when user delete an image
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPictureDeleted(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.PictureViewer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pictureDeleted pictureDeleted} event of this
     * `sap.ca.ui.PictureViewer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.ca.ui.PictureViewer` itself.
     *
     * Thrown when user delete an image
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPictureDeleted(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.ca.ui.PictureViewer` itself
       */
      oListener?: object
    ): this;
    /**
     * Removes the picture at index `iIndex` from the `items` aggregation.
     *
     *
     * @returns `this` to allow method chaining
     */
    deletePicture(
      /**
       * the `0`-based index of the picture collection to delete; if `iIndex` is out of range or empty, the current
       * image will be deleted.
       */
      iIndex: int
    ): PictureViewer;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:pictureDeleted pictureDeleted} event of this
     * `sap.ca.ui.PictureViewer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPictureDeleted(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:pictureDeleted pictureDeleted} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePictureDeleted(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets the current picture index.
     *
     *
     * @returns the current picture index
     */
    getCurrentPictureIndex(): PictureViewer;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Aggregation of PictureViewerItem that contains either a picture URI or the actual Image control.
     */
    getItems(): PictureViewerItem[];
    /**
     * Gets current value of property {@link #getRemovable removable}.
     *
     * Defines whether or not you can remove a picture
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `removable`
     */
    getRemovable(): boolean;
    /**
     * Gets current value of property {@link #getTileScaling tileScaling}.
     *
     * Percentage of the space occupied by the image in the picture viewer control. Please note that if the
     * factor is too close to 1, the navigation arrows usually displayed in desktop mode will not be available
     *
     * Default value is `0.95`.
     *
     *
     * @returns Value of property `tileScaling`
     */
    getTileScaling(): float;
    /**
     * Checks for the provided `sap.ca.ui.PictureViewerItem` in the aggregation {@link #getItems items}. and
     * returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: PictureViewerItem
    ): int;
    /**
     * Inserts a item into the aggregation named `items`. When adding a new item to the aggregation, a sap.ca.ui.PictureTile
     * is actually created with its own ID and added to the internal TileContainer.
     *
     * @deprecated - Use aggregation "tiles"
     *
     * @returns `this` to allow method chaining
     */
    insertItem(
      /**
       * the item to insert; if empty, nothing is inserted
       */
      oItem: PictureViewerItem,
      /**
       * the `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): PictureViewer;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): PictureViewerItem[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | PictureViewerItem
    ): PictureViewerItem | null;
    /**
     * Select the picture at index `iIndex` from the `items` aggregation.
     *
     *
     * @returns `this` to allow method chaining
     */
    selectPicture(
      /**
       * the `0`-based index of the aggregation to select; for a negative value of `iIndex`, the picture at position
       * 0 is selected; for a value greater than the current size of the aggregation, the selected picture at
       * the last position is selected
       */
      iIndex: int
    ): PictureViewer;
    /**
     * Specify whether or not you can delete a picture. If FALSE the delete button will never be visible. Default
     * value is TRUE
     */
    setRemovable(): void;
    /**
     * Set the percentage of the space occupied by the image in the picture viewer control. Please note that
     * if the factor is too close to 1, the navigation arrows usually displayed in desktop mode will not be
     * available
     */
    setTileScaling(fTileScale: undefined): void;
  }
  /**
   * Describes the settings that can be provided to the PictureViewer constructor.
   *
   * @deprecated (since 1.22) - PictureViewer was replacing the Carousel as it wasn't supporting some versions
   * of MS Internet Explorer. Now, the sap.m.Carousel is fully functional, please use sap.m.Carousel instead.
   * This control will not be supported anymore.
   */
  export interface $PictureViewerSettings extends $TileContainerSettings {
    /**
     * Percentage of the space occupied by the image in the picture viewer control. Please note that if the
     * factor is too close to 1, the navigation arrows usually displayed in desktop mode will not be available
     */
    tileScaling?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether or not you can remove a picture
     */
    removable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregation of PictureViewerItem that contains either a picture URI or the actual Image control.
     */
    items?:
      | PictureViewerItem[]
      | PictureViewerItem
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Thrown when user delete an image
     */
    pictureDeleted?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the PictureViewer#pictureDeleted event.
   */
  export interface PictureViewer$PictureDeletedEventParameters {}

  /**
   * Event object of the PictureViewer#pictureDeleted event.
   */
  export type PictureViewer$PictureDeletedEvent = Event<
    PictureViewer$PictureDeletedEventParameters,
    PictureViewer
  >;
}

declare module "sap/ca/ui/PictureViewerItem" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Image from "sap/m/Image";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Picture viewer control relying on the TileContainer control
   *
   * @deprecated (since 1.22) - PictureViewerItem is used in PictureViewer control and is not meant to be
   * consumed outside of PictureViewer usage. PictureViewer was replacing the Carousel as it wasn't supporting
   * some versions of MS Internet Explorer. Now, the sap.m.Carousel is fully functional, please use sap.m.Carousel
   * instead. This control will not be supported anymore.
   */
  export default class PictureViewerItem extends Control {
    /**
     * Constructor for a new PictureViewerItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $PictureViewerItemSettings
    );
    /**
     * Constructor for a new PictureViewerItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $PictureViewerItemSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.PictureViewerItem with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, PictureViewerItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.PictureViewerItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the image in the aggregation {@link #getImage image}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyImage(): this;
    /**
     * Gets content of aggregation {@link #getImage image}.
     *
     * Pass in an existing Image control to be used inside the PictureViewer
     */
    getImage(): Image;
    /**
     * Gets current value of property {@link #getSrc src}.
     *
     * Image source url.
     *
     *
     * @returns Value of property `src`
     */
    getSrc(): string;
    /**
     * Sets the aggregated {@link #getImage image}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setImage(
      /**
       * The image to set
       */
      oImage: Image
    ): this;
    /**
     * Setter for property `src`.
     *
     * Default value is empty/`undefined`
     *
     *
     * @returns `this` to allow method chaining
     */
    setSrc(
      /**
       * new value for property `src`
       */
      sSrc: string
    ): PictureViewerItem;
  }
  /**
   * Describes the settings that can be provided to the PictureViewerItem constructor.
   *
   * @deprecated (since 1.22) - PictureViewerItem is used in PictureViewer control and is not meant to be
   * consumed outside of PictureViewer usage. PictureViewer was replacing the Carousel as it wasn't supporting
   * some versions of MS Internet Explorer. Now, the sap.m.Carousel is fully functional, please use sap.m.Carousel
   * instead. This control will not be supported anymore.
   */
  export interface $PictureViewerItemSettings extends $ControlSettings {
    /**
     * Image source url.
     */
    src?: string | PropertyBindingInfo;

    /**
     * Pass in an existing Image control to be used inside the PictureViewer
     */
    image?: Image;
  }
}

declare module "sap/ca/ui/utils/busydialog" {
  /**
   * Provides methods to show/remove the waiting/blocking screen in the Fiori style.
   *
   * `sap.ca.ui.utils.busydialog` is a static class, the statement `jQuery.sap.require("sap.ca.ui.utils.busydialog")`
   * needs to be called before the function can be used. Example:
   * ```javascript
   *
   *    jQuery.sap.require("sap.ca.ui.utils.busydialog");
   *
   *    // request the BusyDialog to show the waiting/blocking screen
   *    sap.ca.ui.utils.busydialog.requireBusyDialog({
   *        text:"Loading..." //text is optional
   *    });
   *
   *    // release the BusyDialog to remove the waiting/blocking screen
   *    sap.ca.ui.utils.busydialog.releaseBusyDialog();
   * ```
   *
   *
   * **Note**
   * 	 - this BusyDialog will be shown with 1.5 seconds delay at the moment;
   * 	 - in a possible embedded function calls, you can require this BusyDialog more than once, but you need
   *     to take care to release the BusyDialog correspondingly in pair. (The text will be overwritten.)
   *
   * @deprecated (since 1.26) - this control is deprecated as per central UX requirements. Please use {@link sap.m.BusyDialog }
   * instead.
   */
  interface busydialog {
    /**
     * Destroys the waiting/blocking screen (this method is only recommended if the App developer or the "Unified
     * Shell" has a clean-up strategy and want to release the memory on purpose)
     */
    destroyBusyDialog(): void;
    /**
     * Removes the waiting/blocking screen, and is used in pair with the method "requireBusyDialog"
     */
    releaseBusyDialog(): void;
    /**
     * Shows the waiting/blocking screen
     */
    requireBusyDialog(
      /**
       * settings for the busy dialog: text : {string} (optional) loading text
       */
      oSettings?: object
    ): void;
  }
  const busydialog: busydialog;
  /**
   * @deprecated (since 1.26) - this control is deprecated as per central UX requirements. Please use {@link sap.m.BusyDialog }
   * instead.
   */
  export default busydialog;
}

declare module "sap/ca/ui/ZoomableScrollContainer" {
  import {
    default as ScrollContainer,
    $ScrollContainerSettings,
  } from "sap/m/ScrollContainer";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Based on a ScrollContainer, it allows you to pinch and zoom on mobile devices
   *
   * @deprecated (since 1.22) - ZoomableScrollContainer is used in PictureViewer control and is not meant
   * to be consumed outside of PictureViewer usage. PictureViewer was replacing the Carousel as it wasn't
   * supporting some versions of MS Internet Explorer. Now, the sap.m.Carousel is fully functional, please
   * use sap.m.Carousel instead. This control will not be supported anymore.
   */
  export default class ZoomableScrollContainer extends ScrollContainer {
    /**
     * Constructor for a new ZoomableScrollContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ZoomableScrollContainerSettings
    );
    /**
     * Constructor for a new ZoomableScrollContainer.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ZoomableScrollContainerSettings
    );

    /**
     * Creates a new subclass of class sap.ca.ui.ZoomableScrollContainer with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.ScrollContainer.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ZoomableScrollContainer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ca.ui.ZoomableScrollContainer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getInitialScale initialScale}.
     *
     * Initial scaling factor
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `initialScale`
     */
    getInitialScale(): float;
    /**
     * Gets current value of property {@link #getMaxScale maxScale}.
     *
     * Highest scaling factor allowed
     *
     * Default value is `4`.
     *
     *
     * @returns Value of property `maxScale`
     */
    getMaxScale(): float;
    /**
     * Gets current value of property {@link #getMinScale minScale}.
     *
     * Lowest scaling factor allowed
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `minScale`
     */
    getMinScale(): float;
    /**
     * Gets current value of property {@link #getZoomable zoomable}.
     *
     * Activate or not the zooming functionality. If FALSE, it acts exactly as a basic ScrollContainer.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `zoomable`
     */
    getZoomable(): boolean;
    /**
     * Sets a new value for property {@link #getInitialScale initialScale}.
     *
     * Initial scaling factor
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInitialScale(
      /**
       * New value for property `initialScale`
       */
      fInitialScale?: float
    ): this;
    /**
     * Sets a new value for property {@link #getMaxScale maxScale}.
     *
     * Highest scaling factor allowed
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `4`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxScale(
      /**
       * New value for property `maxScale`
       */
      fMaxScale?: float
    ): this;
    /**
     * Sets a new value for property {@link #getMinScale minScale}.
     *
     * Lowest scaling factor allowed
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinScale(
      /**
       * New value for property `minScale`
       */
      fMinScale?: float
    ): this;
    /**
     * Sets a new value for property {@link #getZoomable zoomable}.
     *
     * Activate or not the zooming functionality. If FALSE, it acts exactly as a basic ScrollContainer.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setZoomable(
      /**
       * New value for property `zoomable`
       */
      bZoomable?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ZoomableScrollContainer constructor.
   *
   * @deprecated (since 1.22) - ZoomableScrollContainer is used in PictureViewer control and is not meant
   * to be consumed outside of PictureViewer usage. PictureViewer was replacing the Carousel as it wasn't
   * supporting some versions of MS Internet Explorer. Now, the sap.m.Carousel is fully functional, please
   * use sap.m.Carousel instead. This control will not be supported anymore.
   */
  export interface $ZoomableScrollContainerSettings
    extends $ScrollContainerSettings {
    /**
     * Activate or not the zooming functionality. If FALSE, it acts exactly as a basic ScrollContainer.
     */
    zoomable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Initial scaling factor
     */
    initialScale?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Lowest scaling factor allowed
     */
    minScale?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Highest scaling factor allowed
     */
    maxScale?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare namespace sap {
  namespace ca {
    /**
     * SAP UI library: Fiori Commons
     *
     * @deprecated (since 1.28) - All controls and helpers in this library meanwhile have been deprecated. Check
     * the individual classes or packages for actual replacements.
     */
    namespace ui {
      /**
       * @deprecated (since 1.26) - The content of this package is deprecated since 1.26 as per central UX requirements.
       * Please use {@link sap.m.Dialog} instead.
       */
      namespace dialog {
        /**
         * Provides methods to show a confirmation dialog in the Fiori style.
         *
         * `sap.ca.ui.dialog.confirmation` is a static class, the statement `jQuery.sap.require("sap.ca.ui.dialog.factory")`
         * needs to be called before the function can be used. Example:
         * ```javascript
         *
         *    jQuery.sap.require("sap.ca.ui.dialog.factory");
         *
         *    // provide your callback function, so that you can get informed if the enduser confirms or cancels the dialog
         *    var fnClose = function(oResult) {
         *        if (oResult) {
         *            console.log("isConfirmed:" + oResult.isConfirmed);
         *            if (oResult.sNote) {
         *                console.log(oResult.sNote);
         *            }
         *        }
         *    }
         *
         *    //open the confirmation dialog
         *    sap.ca.ui.dialog.confirmation.open({
         *        question : "Send your decision on the shopping card submitted by Henry Emerald?",
         *        showNote : true,
         *        title : "Send",
         *        confirmButtonLabel : "Send"
         *    }, fnClose);
         * ```
         *
         *
         * @deprecated (since 1.26) - this control is deprecated per central UX requirements. Please use |@link
         * sap.m.Dialog} instead.
         */
        namespace confirmation {
          /**
           * Opens the confirmation dialog
           */
          function open(
            /**
             * settings for the confirmation dialog The supported settings are: additionalInformation : {array }
             * optional, up-to 4 lines can be shown, every line has the structure: {label: "Leave Type", text: "Vacation"}
             * confirmButtonLabel {string} text for the confirm button noteMandatory :{boolean} optional,
             * default false question : {string} the question/action which the user needs to confirm showNote
             * : {boolean} default true title : {string} title of the dialog
             */
            oSettings?: object,
            /**
             * the function will be called if the confirmation dialog is closed. there are 2 default values can be
             * retrieved: isConfirmed : {boolean} true if the user confirms the action; false if
             * the user cancels the dialog sNote : {string} the note text provided by the user
             */
            fnClose?: Function
          ): void;
        }
      }
      /**
       * Provides methods to show messages with type of **Success**, **Error**, **Warning** and **Information**
       * in a Fiori style.
       *
       * `sap.ca.ui.message` is a static class, the statement `jQuery.sap.require("sap.ca.ui.message.message")`
       * needs to be called before the function can be used. Example:
       * ```javascript
       *
       *    jQuery.sap.require("sap.ca.ui.message.message");
       *
       *    // provide your callback function, if you want to get informed after the user closes the MessageBox
       *    var bIsMsgBoxClosed = false;
       *    var fnClose = function(){
       *        bIsMsgBoxClosed = true;
       *    };
       *
       *    // show the erorr message in a MessageBox
       *    sap.ca.ui.message.showMessageBox({
       *        type: sap.ca.ui.message.Type.ERROR,
       *        message: "No connection can be established to the backend system ABC",
       *        details: "Lorem ipsum dolor sit amet, eum an vidit ..."
       *    }, fnClose);
       * ```
       *
       *
       * @deprecated (since 1.28) - this control is deprecated as per central UX requirements. Please use {@link sap.m.MessageBox }
       * instead.
       */
      namespace message {
        /**
         * Shows the messages with type of Success, Error, Warning, Info, in a Fiori style of MessageBox
         */
        function showMessageBox(
          /**
           * settings for the message box The supported settings are: type : {sap.ca.ui.message.Type}
           * message : {string} short text, the leading and ending white spaces will be removed details
           * : {string} long text (optional), the detailed information will only be shown if the text is available
           * and different to the message text
           */
          oSettings?: object,
          /**
           * the function will be called if the message box is closed
           */
          fnClose?: Function
        ): void;
        /**
         * Shows the success message as a MessageToast
         */
        function showMessageToast(
          /**
           * message to be shown in the MessageToast
           */
          sMessage?: string
        ): void;

        /**
         * Enumeration of supported message types.
         */
        enum Type {}
      }
    }
  }

  interface IUI5DefineDependencyNames {
    "sap/ca/ui/AddPicture": undefined;

    "sap/ca/ui/charts/BarListItem": undefined;

    "sap/ca/ui/charts/BubbleChart": undefined;

    "sap/ca/ui/charts/Chart": undefined;

    "sap/ca/ui/charts/ChartToolBar": undefined;

    "sap/ca/ui/charts/ChartType": undefined;

    "sap/ca/ui/charts/ClusterListItem": undefined;

    "sap/ca/ui/charts/CombinedChart": undefined;

    "sap/ca/ui/charts/HorizontalBarChart": undefined;

    "sap/ca/ui/charts/LineChart": undefined;

    "sap/ca/ui/charts/StackedHorizontalBarChart": undefined;

    "sap/ca/ui/charts/StackedVerticalColumnChart": undefined;

    "sap/ca/ui/charts/VerticalBarChart": undefined;

    "sap/ca/ui/CustomerContext": undefined;

    "sap/ca/ui/CustomerControlListItem": undefined;

    "sap/ca/ui/DatePicker": undefined;

    "sap/ca/ui/ExpansibleFeedListItem": undefined;

    "sap/ca/ui/FileUpload": undefined;

    "sap/ca/ui/GrowingTileContainer": undefined;

    "sap/ca/ui/HierarchicalSelectDialog": undefined;

    "sap/ca/ui/HierarchicalSelectDialogItem": undefined;

    "sap/ca/ui/Hierarchy": undefined;

    "sap/ca/ui/HierarchyItem": undefined;

    "sap/ca/ui/InPlaceEdit": undefined;

    "sap/ca/ui/library": undefined;

    "sap/ca/ui/message/message": undefined;

    "sap/ca/ui/model/format/AmountFormat": undefined;

    "sap/ca/ui/model/format/DateFormat": undefined;

    "sap/ca/ui/model/format/FileSizeFormat": undefined;

    "sap/ca/ui/model/format/QuantityFormat": undefined;

    "sap/ca/ui/model/type/Date": undefined;

    "sap/ca/ui/model/type/DateTime": undefined;

    "sap/ca/ui/model/type/FileSize": undefined;

    "sap/ca/ui/model/type/Number": undefined;

    "sap/ca/ui/model/type/Time": undefined;

    "sap/ca/ui/Notes": undefined;

    "sap/ca/ui/OverflowContainer": undefined;

    "sap/ca/ui/OverviewTile": undefined;

    "sap/ca/ui/PictureItem": undefined;

    "sap/ca/ui/PictureTile": undefined;

    "sap/ca/ui/PictureViewer": undefined;

    "sap/ca/ui/PictureViewerItem": undefined;

    "sap/ca/ui/utils/busydialog": undefined;

    "sap/ca/ui/ZoomableScrollContainer": undefined;
  }
}
