import type { jsonSourceMapType } from "./ManifestLinter.js";
import LinterContext, { CoverageInfo, ResourcePath } from "../LinterContext.js";
import { MESSAGE } from "../messages.js";
import { MessageArgs } from "../MessageArgs.js";
interface ReporterCoverageInfo extends CoverageInfo {
    node: string;
}
export default class ManifestReporter {
    #private;
    constructor(resourcePath: ResourcePath, context: LinterContext, manifest: jsonSourceMapType);
    addMessage<M extends MESSAGE>(id: M, args: MessageArgs[M], node: string): void;
    addMessage<M extends MESSAGE>(id: M, node: string): void;
    addCoverageInfo({ node, message, category }: ReporterCoverageInfo): void;
}
export {};
