import LinterContext, { PositionInfo, ResourcePath } from "../LinterContext.js";
import { RequireDeclaration } from "../xmlTemplate/Parser.js";
import { BindingInfo } from "./lib/BindingParser.js";
export default class BindingLinter {
    #private;
    constructor(resourcePath: ResourcePath, context: LinterContext, isJsBindingString?: boolean);
    checkForGlobalReference(ref: string, requireDeclarations: RequireDeclaration[], position: PositionInfo): void;
    getGlobalReference(ref: string, requireDeclarations: RequireDeclaration[]): string | null;
    lintPropertyBinding(bindingDefinition: string, requireDeclarations: RequireDeclaration[], position: PositionInfo, reportParsingError?: boolean): {
        bindingInfo: BindingInfo | string | undefined;
        errorMessage: string | undefined;
    };
    lintAggregationBinding(bindingDefinition: string, requireDeclarations: RequireDeclaration[], position: PositionInfo): void;
    reportParsingError(message: string, position: PositionInfo): void;
}
