import YamlLinter from "./YamlLinter.js";
export default async function lintUI5Yaml({ context }) {
    const reader = context.getRootReader();
    const ui5YamlResources = await reader.byGlob("/{ui5.yaml,*-ui5.yaml,*.ui5.yaml,ui5-*.yaml}");
    await Promise.all(ui5YamlResources.map(async (resource) => {
        const linter = new YamlLinter(resource.getPath(), await resource.getString(), context);
        await linter.lint();
    }));
}
//# sourceMappingURL=linter.js.map