import type { LintResult } from "./linter/LinterContext.js";
export type { LintResult };
export interface UI5LinterOptions {
    /**
     * List of patterns to lint.
     */
    filePatterns?: string[];
    /**
     * Pattern/files that will be ignored during linting.
     */
    ignorePatterns?: string[];
    /**
     * Provides complementary information for each finding, if available
     * @default false
     */
    details?: boolean;
    /**
     * Automatically fix linter findings
     * @default false
     */
    fix?: boolean;
    /**
     * Path to a ui5lint.config.(cjs|mjs|js) file
     */
    config?: string;
    /**
     * Whether to skip loading of the ui5lint.config.(cjs|mjs|js) config file
     * @default false
     */
    noConfig?: boolean;
    /**
     * Whether to provide a coverage report
     * @default false
     */
    coverage?: boolean;
    /**
     * Path to a ui5.yaml file or an object representation of ui5.yaml
     * @default "./ui5.yaml" (if that file exists)
     */
    ui5Config?: string | object;
    /**
     * Root directory of the project
     * @default process.cwd()
     */
    rootDir?: string;
}
export declare function ui5lint(options?: UI5LinterOptions): Promise<LintResult[]>;
export declare class UI5LinterEngine {
    private sharedLanguageService;
    private lintingInProgress;
    lint(options?: UI5LinterOptions): Promise<LintResult[]>;
}
