// For Library Version: 1.120.5

declare module "sap/ui/generic/app/library" {
  export namespace navigation {
    namespace service {
      /**
       * A static enumeration type which indicates the type of inbound navigation
       *
       * @deprecated (since 1.83.0) - Please use {@link sap.fe.navigation.NavType} instead.
       */
      enum NavType {
        /**
         * Passing iapp-state data within xapp state in addition to existing values
         *
         * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
         */
        hybrid = "undefined",
        /**
         * Back navigation with sap-iapp-state parameter
         */
        iAppState = "undefined",
        /**
         * Initial startup without any navigation or default parameters
         */
        initial = "undefined",
        /**
         * Basic cross-app navigation with URL parameters only (without sap-xapp-state) or initial start with default
         * parameters
         */
        URLParams = "undefined",
        /**
         * Cross-app navigation with sap-xapp-state parameter (and URL parameters), defaulted parameters may be
         * added
         */
        xAppState = "undefined",
      }
      /**
       * A static enumeration type which indicates the conflict resolution method when merging URL parameters
       * into select options
       *
       * @deprecated (since 1.83.0) - Please use {@link sap.fe.navigation.ParamHandlingMode} instead.
       */
      enum ParamHandlingMode {
        /**
         * The conflict resolution adds URL parameters to the SelectionVariant
         */
        InsertInSelOpt = "undefined",
        /**
         * The conflict resolution favors the SelectionVariant over URL parameters
         */
        SelVarWins = "undefined",
        /**
         * The conflict resolution favors the URL parameters over the SelectionVariant. Caution: In case of cross-app
         * navigation a navigation parameter value from the source app is overwritten by a default, if a default
         * is maintained in the launchpad designer for this parameter in the target app!
         */
        URLParamWins = "undefined",
      }
      /**
       * A static enumeration type which indicates whether semantic attributes with values `null`, `undefined`
       * or `""` (empty string) shall be suppressed, before they are mixed in to the selection variant in the
       * method {@link sap.ui.generic.app.navigation.service.NavigationHandler.mixAttributesAndSelectionVariant mixAttributesAndSelectionVariant }
       * of the {@link sap.ui.generic.app.navigation.service.NavigationHandler NavigationHandler}
       *
       * @deprecated (since 1.83.0) - Please use {@link sap.fe.navigation.SuppressionBehavior} instead.
       */
      enum SuppressionBehavior {
        /**
         * Semantic attributes with an empty string are ignored, the remaining attributes are mixed in to the selection
         * variant. Warning! Consider the impact on Boolean variable values!
         */
        ignoreEmptyString = "undefined",
        /**
         * Semantic attributes with a `null` value lead to an {@link sap.fin.central.lib.error.Error error} of type
         * NavigationHandler.INVALID_INPUT
         */
        raiseErrorOnNull = "undefined",
        /**
         * Semantic attributes with an `undefined` value lead to an {@link sap.fin.central.lib.error.Error error }
         * of type NavigationHandler.INVALID_INPUT
         */
        raiseErrorOnUndefined = "undefined",
        /**
         * Standard suppression behavior: semantic attributes with a `null` or an `undefined` value are ignored,
         * the remaining attributes are mixed in to the selection variant
         */
        standard = "undefined",
      }
    }
  }
}

declare module "sap/ui/generic/app/ApplicationController" {
  import BaseController from "sap/ui/generic/app/transaction/BaseController";

  import ODataModel from "sap/ui/model/odata/v2/ODataModel";

  import View from "sap/ui/core/mvc/View";

  import Context from "sap/ui/model/Context";

  import Metadata from "sap/ui/base/Metadata";

  import TransactionController from "sap/ui/generic/app/transaction/TransactionController";

  /**
   * Application Controller.
   *
   * @since 1.32.0
   * @experimental (since 1.32.0)
   */
  export default class ApplicationController extends BaseController {
    /**
     * Constructor for application controller.
     */
    constructor(
      /**
       * The OData model currently used
       */
      oModel: ODataModel,
      /**
       * The current view
       */
      oView: View
    );

    /**
     * Creates a new subclass of class sap.ui.generic.app.ApplicationController with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.generic.app.transaction.BaseController.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ApplicationController>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.generic.app.ApplicationController.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Frees all resources claimed during the life-time of this instance.
     *
     * @experimental (since 1.32.0)
     */
    destroy(): void;
    /**
     * Executes annotated side effects for properties/navigation properties or navigation entities. If no properties
     * or entities are passed then the global side effect (the one without source properties and source entities)
     * will be executed. PreparationAction will be called if there is no global side effect annotation available
     * or if no trigger action is configured in the global side effect.
     *
     *
     * @returns A `Promise` for asynchronous execution of the action. The promise is either already resolved
     * (when nothing needs to be processed) or resolves when the `triggerSubmitChanges()` has been executed.
     */
    executeSideEffects(
      /**
       * The given binding context
       */
      oContext: Context,
      /**
       * An array of properties of the given context or properties in a 1:1 association for those side effects
       * shall be executed. Can be `undefined`.
       */
      aSourceProperties: any[],
      /**
       * An array of entities (navigation properties) with the side effects that shall be executed. Can be `undefined`.
       */
      aSourceEntities: any[],
      /**
       * If not explicitly set to `false` a global model refresh is triggered.
       */
      bForceGlobalRefresh: boolean,
      /**
       * Parameters to control the draft preparation
       */
      mAdditionalParameters: Record<string, any>
    ): Promise<any>;
    /**
     * Creates a context for an action call (OData function import)
     *
     * @since 1.38
     * @experimental
     *
     * @returns A `map` that contains two Promises: `context` which provides the action-specific model context
     * to the resolve function `result` which resolves when the success handler is called and rejects when the
     * error handler is called; The result of the promises is normalized in both cases, error and success.
     */
    getNewActionContext(
      /**
       * Name of the function import that shall be triggered.
       */
      sFunctionName: string,
      /**
       * The given binding context of the object on which the action is called.
       */
      oEntityContext: object,
      /**
       * Parameters to control the behavior of the request.
       */
      mParameters: Record<string, any>
    ): Record<string, any>;
    /**
     * Returns the current transaction controller instance.
     *
     *
     * @returns The transaction controller instance
     */
    getTransactionController(): TransactionController;
    /**
     * Invokes an action for every provided context where the properties are taken as input from. The changes
     * are submitted directly to the back-end.
     *
     *
     * @returns A `Promise` for asynchronous execution of the action
     */
    invokeActions(
      /**
       * The name of the function or action that shall be triggered.
       */
      sFunctionName: string,
      /**
       * The given binding contexts where the parameters of the action shall be filled from.
       */
      aContexts: any[],
      /**
       * Parameters to control the behavior of the request.
       */
      mParameters: {
        /**
         * Property denotes how invocations of the same action on multiple instances are grouped. This is an optional
         * parameter. If parameter set to "com.sap.vocabularies.UI.v1.OperationGroupingType/ChangeSet" every action
         * call is sent in same changeset else a new changeset. Default value of this property is set to "com.sap.vocabularies.UI.v1.OperationGroupingType/Isolated".
         */
        operationGrouping: string;
      }
    ): Promise<any>;
    /**
     * Notifies the application controller of a change of a property. Please note that the method is not meant
     * for productive use currently. It is experimental.
     *
     * @experimental (since 1.32.0)
     *
     * @returns A `Promise` for asynchronous execution of the action
     */
    propertyChanged(
      /**
       * The path to the changed property
       */
      sPath: string,
      /**
       * The binding context in which the change occurred
       */
      oContext: object
    ): Promise<any>;
    /**
     * Registers a change for the given group id.
     *
     * @experimental (since 1.32.0)
     */
    registerGroupChange(
      /**
       * The group id where changes were done
       */
      sGroupId: string
    ): void;
    /**
     * Registers the given view with the Application Controller.
     *
     * @experimental (since 1.32.0)
     */
    registerView(
      /**
       * The view to be registered
       */
      oView: View
    ): void;
  }
}

declare module "sap/ui/generic/app/navigation/service/NavError" {
  import NavError1 from "sap/fe/navigation/NavError";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * An object that provides error handling information during runtime.
   *
   * @deprecated (since 1.83.0) - Please use {@link sap.fe.navigation.NavError} instead.
   */
  export default class NavError extends NavError1 {
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.fe.navigation.NavError#constructor sap.fe.navigation.NavError }
     * can be used.
     */
    constructor(
      /**
       * The code for an internal error of a consumer that allows you to track the source locations
       */
      sErrorCode: string
    );

    /**
     * Creates a new subclass of class sap.ui.generic.app.navigation.service.NavError with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.fe.navigation.NavError.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, NavError>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.generic.app.navigation.service.NavError.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Returns the error code with which the instance has been created.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns The error code of the error
     */
    getErrorCode(): string;
  }
}

declare module "sap/ui/generic/app/navigation/service/NavigationHandler" {
  import NavigationHandler1 from "sap/fe/navigation/NavigationHandler";

  import ODataModel from "sap/ui/model/odata/v2/ODataModel";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Creates a new NavigationHandler class by providing the required environment.
   *  The `NavigationHandler` supports the verification of sensitive information. All properties that are
   * part of `selectionVariant` and `valueTexts` will be verified if they are annotated as `com.sap.vocabularies.PersonalData.v1.IsPotentiallySensitive`
   * or `com.sap.vocabularies.UI.v1.ExcludeFromNavigationContext` and will be removed before the data is persisted
   * as the app state.
   *  Also, all properties annotated as `com.sap.vocabularies.Analytics.v1.Measure` will be removed from the
   * data stored as the xapp state.
   *  To verify the information to be removed, the `NavigationHandler` requires an unnamed model of type {@link sap.ui.model.odata.v2.ODataModel }
   * on component level. It is possible to set such a model using the `setModel` method.
   *  **Note:** The check for excluded data requires that the OData metadata has already been loaded completely.
   *  If the OData metadata model has not been loaded completely, all properties are removed from the application
   * context.
   *  **Note:** This class requires that the UShell {@link sap.ushell.services.CrossApplicationNavigation }
   * is available and initialized.
   *
   * @deprecated (since 1.83.0) - Please use {@link sap.fe.navigation.NavigationHandler} instead.
   */
  export default class NavigationHandler extends NavigationHandler1 {
    constructor(
      /**
       * UI5 controller that contains a router and a component; typically the main controller of your application,
       * for example, a subclass of the sap.ca.scfld.md.controller.BaseFullscreenController if scaffolding is
       * used
       */
      oController: object,
      /**
       * Mode to be used to handle conflicts when merging URL parameters and the SelectionVariant class, see {@link sap.ui.generic.app.navigation.service.ParamHandlingMode}
       */
      sParamHandlingMode?: string
    );

    /**
     * The method creates a context url based on provided data. This context url can either be used as {@link sap.ui.generic.app.navigation.service.NavigationHandler#setParameterContextUrl ParameterContextUrl }
     * or {@link sap.ui.generic.app.navigation.service.NavigationHandler#setFilterContextUrl FilterContextUrl}
     *
     * @since 1.60.2
     * @deprecated (since 1.83.0)
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns context url for the given entities
     */
    static constructContextUrl(
      /**
       * used for url determination
       */
      sEntitySetName: string,
      /**
       * used for url determination. If omitted, the NavigationHandler model is used.
       */
      oModel?: ODataModel
    ): string;
    /**
     * Creates a new subclass of class sap.ui.generic.app.navigation.service.NavigationHandler with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.fe.navigation.NavigationHandler.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, NavigationHandler>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.generic.app.navigation.service.NavigationHandler.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Gets the application specific technical parameters. Technical parameters will not be added to the selection
     * variant passed to the application. As a default the following values are considered as technical parameters:
     *
     * 	 - `sap-system`
     * 	 - `sap-ushell-defaultedParameterNames`
     * 	 - `"hcpApplicationId"`
     *
     * @deprecated (since 1.83.0)
     *
     * @returns Containing the technical parameters.
     */
    static getTechnicalParameters(): any[];
    /**
     * Combines the given parameters and selection variant into a new selection variant containing properties
     * from both, with the parameters overriding existing properties in the selection variant. The new selection
     * variant does not contain any parameters. All parameters are merged into select options. The output of
     * this function, converted to a JSON string, can be used for the {@link #.navigate NavigationHandler.navigate }
     * method.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns Instance of {@link sap.ui.generic.app.navigation.service.SelectionVariant}
     */
    static mixAttributesAndSelectionVariant(
      /**
       * Object containing key/value pairs
       */
      mSemanticAttributes: object,
      /**
       * The selection variant in string format as provided by the SmartFilterBar control
       */
      sSelectionVariant: string,
      /**
       * Indicates whether semantic attributes with special values (see {@link sap.ui.generic.app.navigation.service.SuppressionBehavior suppression behavior})
       * must be suppressed before they are combined with the selection variant; several {@link sap.ui.generic.app.navigation.service.SuppressionBehavior suppression behaviors }
       * can be combined with the bitwise OR operator (|)
       */
      iSuppressionBehavior?: int
    ): object;
    /**
     * Triggers a cross-app navigation after saving the inner and the cross-app states. Since 1.52.0 the navigation
     * mode based on `sap-ushell-next-navmode` is taken into account. If set to `explace` the inner app state
     * will not be changed. **Note:** The `sNavMode` argument can be used to overwrite the SAP Fiori launchpad
     * default navigation for opening a URL in-place or ex-place.
     *
     * @deprecated (since 1.83.0) -
     *  **Node:** If the `oExternalAppData` parameter is not supplied, the external app data will be calculated
     * based on the `oInnerAppData` data.
     *  SmartFilterBar control **Parameters:**   {object} **oError**
     * Error object (instance of {@link sap.ui.generic.app.navigation.service.NavError}) that describes
     * which kind of error occurred  {string} **oError.errorCode**
     * Code to identify the error  {string} **oError.type** Severity
     * of the error (info/warning/error)  {array} **oError.params**
     * An array of objects (typically strings) that describe additional value parameters required for generating
     * the message
     */
    static navigate(
      /**
       * Name of the semantic object of the target app
       */
      sSemanticObject: string,
      /**
       * Name of the action of the target app
       */
      sActionName: string,
      /**
       * Navigation parameters as an object with key/value pairs or as a string representation of such an object.
       * If passed as an object, the properties are not checked against the `IsPotentialSensitive` or `Measure`
       * type.
       */
      vNavigationParameters: object | string,
      /**
       * Object for storing current state of the app
       */
      oInnerAppData: {
        /**
         * Stringified JSON object as returned, for example, from getDataSuiteFormat() of the SmartFilterBar control
         */
        selectionVariant?: string;
        /**
         * ID of the SmartTable variant
         */
        tableVariantId?: string;
        /**
         * Object that can be used to store arbitrary data
         */
        customData?: object;
        /**
         * Object containing the current ui state of the app
         */
        presentationVariant?: object;
        /**
         * Object containing value descriptions
         */
        valueTexts?: object;
        /**
         * Object containing semanticDates filter information
         */
        semanticDates?: object;
      },
      /**
       * Callback that is called if an error occurs during navigation
       */
      fnOnError: Function,
      /**
       * Object for storing the state which will be forwarded to the target component.
       */
      oExternalAppData: {
        /**
         * Object containing the current ui state of the app which will be forwarded to the target component.
         */
        presentationVariant?: object;
        /**
         * Object containing value descriptions which will be forwarded to the target component.
         */
        valueTexts?: object;
        /**
         * Stringified JSON object, which will be forwarded to the target component. If not provided the selectionVariant
         * will be constructed based on the vNavigationParameters.
         */
        selectionVariant?: object;
      },
      /**
       * Argument is used to overwrite the FLP-configured target for opening a URL. If used, only the `explace`
       * or `inplace` values are allowed. Any other value will lead to an exception `NavigationHandler.INVALID_NAV_MODE`.
       */
      sNavMode?: string
    ): void;
    /**
     * Triggers a cross-app navigation after saving the inner and the cross-app states. Since 1.52.0 the navigation
     * mode based on `sap-ushell-next-navmode` is taken into account. If set to `explace` the inner app state
     * will not be changed. **Note:** The `sNavMode` argument can be used to overwrite the SAP Fiori launchpad
     * default navigation for opening a URL in-place or ex-place.
     *
     * @deprecated (since 1.83.0) -
     *  **Node:** If the `oExternalAppData` parameter is not supplied, the external app data will be calculated
     * based on the `oInnerAppData` data.
     *  SmartFilterBar control **Parameters:**   {object} **oError**
     * Error object (instance of {@link sap.ui.generic.app.navigation.service.NavError}) that describes
     * which kind of error occurred  {string} **oError.errorCode**
     * Code to identify the error  {string} **oError.type** Severity
     * of the error (info/warning/error)  {array} **oError.params**
     * An array of objects (typically strings) that describe additional value parameters required for generating
     * the message
     */
    static navigate(
      /**
       * Name of the semantic object of the target app
       */
      sSemanticObject: string,
      /**
       * Name of the action of the target app
       */
      sActionName: string,
      /**
       * Navigation parameters as an object with key/value pairs or as a string representation of such an object.
       * If passed as an object, the properties are not checked against the `IsPotentialSensitive` or `Measure`
       * type.
       */
      vNavigationParameters: object | string,
      /**
       * Object for storing current state of the app
       */
      oInnerAppData: {
        /**
         * Stringified JSON object as returned, for example, from getDataSuiteFormat() of the SmartFilterBar control
         */
        selectionVariant?: string;
        /**
         * ID of the SmartTable variant
         */
        tableVariantId?: string;
        /**
         * Object that can be used to store arbitrary data
         */
        customData?: object;
        /**
         * Object containing the current ui state of the app
         */
        presentationVariant?: object;
        /**
         * Object containing value descriptions
         */
        valueTexts?: object;
        /**
         * Object containing semanticDates filter information
         */
        semanticDates?: object;
      },
      /**
       * Object for storing the state which will be forwarded to the target component.
       */
      oExternalAppData: {
        /**
         * Object containing the current ui state of the app which will be forwarded to the target component.
         */
        presentationVariant?: object;
        /**
         * Object containing value descriptions which will be forwarded to the target component.
         */
        valueTexts?: object;
        /**
         * Stringified JSON object, which will be forwarded to the target component. If not provided the selectionVariant
         * will be constructed based on the vNavigationParameters.
         */
        selectionVariant?: object;
      },
      /**
       * Argument is used to overwrite the FLP-configured target for opening a URL. If used, only the `explace`
       * or `inplace` values are allowed. Any other value will lead to an exception `NavigationHandler.INVALID_NAV_MODE`.
       */
      sNavMode?: string
    ): void;
    /**
     * Triggers a cross-app navigation after saving the inner and the cross-app states. Since 1.52.0 the navigation
     * mode based on `sap-ushell-next-navmode` is taken into account. If set to `explace` the inner app state
     * will not be changed. **Note:** The `sNavMode` argument can be used to overwrite the SAP Fiori launchpad
     * default navigation for opening a URL in-place or ex-place.
     *
     * @deprecated (since 1.83.0) -
     *  **Node:** If the `oExternalAppData` parameter is not supplied, the external app data will be calculated
     * based on the `oInnerAppData` data.
     *  SmartFilterBar control **Parameters:**   {object} **oError**
     * Error object (instance of {@link sap.ui.generic.app.navigation.service.NavError}) that describes
     * which kind of error occurred  {string} **oError.errorCode**
     * Code to identify the error  {string} **oError.type** Severity
     * of the error (info/warning/error)  {array} **oError.params**
     * An array of objects (typically strings) that describe additional value parameters required for generating
     * the message
     */
    static navigate(
      /**
       * Name of the semantic object of the target app
       */
      sSemanticObject: string,
      /**
       * Name of the action of the target app
       */
      sActionName: string,
      /**
       * Navigation parameters as an object with key/value pairs or as a string representation of such an object.
       * If passed as an object, the properties are not checked against the `IsPotentialSensitive` or `Measure`
       * type.
       */
      vNavigationParameters: object | string,
      /**
       * Callback that is called if an error occurs during navigation
       */
      fnOnError: Function,
      /**
       * Object for storing the state which will be forwarded to the target component.
       */
      oExternalAppData: {
        /**
         * Object containing the current ui state of the app which will be forwarded to the target component.
         */
        presentationVariant?: object;
        /**
         * Object containing value descriptions which will be forwarded to the target component.
         */
        valueTexts?: object;
        /**
         * Stringified JSON object, which will be forwarded to the target component. If not provided the selectionVariant
         * will be constructed based on the vNavigationParameters.
         */
        selectionVariant?: object;
      },
      /**
       * Argument is used to overwrite the FLP-configured target for opening a URL. If used, only the `explace`
       * or `inplace` values are allowed. Any other value will lead to an exception `NavigationHandler.INVALID_NAV_MODE`.
       */
      sNavMode?: string
    ): void;
    /**
     * Triggers a cross-app navigation after saving the inner and the cross-app states. Since 1.52.0 the navigation
     * mode based on `sap-ushell-next-navmode` is taken into account. If set to `explace` the inner app state
     * will not be changed. **Note:** The `sNavMode` argument can be used to overwrite the SAP Fiori launchpad
     * default navigation for opening a URL in-place or ex-place.
     *
     * @deprecated (since 1.83.0) -
     *  **Node:** If the `oExternalAppData` parameter is not supplied, the external app data will be calculated
     * based on the `oInnerAppData` data.
     *  SmartFilterBar control **Parameters:**   {object} **oError**
     * Error object (instance of {@link sap.ui.generic.app.navigation.service.NavError}) that describes
     * which kind of error occurred  {string} **oError.errorCode**
     * Code to identify the error  {string} **oError.type** Severity
     * of the error (info/warning/error)  {array} **oError.params**
     * An array of objects (typically strings) that describe additional value parameters required for generating
     * the message
     */
    static navigate(
      /**
       * Name of the semantic object of the target app
       */
      sSemanticObject: string,
      /**
       * Name of the action of the target app
       */
      sActionName: string,
      /**
       * Object for storing current state of the app
       */
      oInnerAppData: {
        /**
         * Stringified JSON object as returned, for example, from getDataSuiteFormat() of the SmartFilterBar control
         */
        selectionVariant?: string;
        /**
         * ID of the SmartTable variant
         */
        tableVariantId?: string;
        /**
         * Object that can be used to store arbitrary data
         */
        customData?: object;
        /**
         * Object containing the current ui state of the app
         */
        presentationVariant?: object;
        /**
         * Object containing value descriptions
         */
        valueTexts?: object;
        /**
         * Object containing semanticDates filter information
         */
        semanticDates?: object;
      },
      /**
       * Callback that is called if an error occurs during navigation
       */
      fnOnError: Function,
      /**
       * Object for storing the state which will be forwarded to the target component.
       */
      oExternalAppData: {
        /**
         * Object containing the current ui state of the app which will be forwarded to the target component.
         */
        presentationVariant?: object;
        /**
         * Object containing value descriptions which will be forwarded to the target component.
         */
        valueTexts?: object;
        /**
         * Stringified JSON object, which will be forwarded to the target component. If not provided the selectionVariant
         * will be constructed based on the vNavigationParameters.
         */
        selectionVariant?: object;
      },
      /**
       * Argument is used to overwrite the FLP-configured target for opening a URL. If used, only the `explace`
       * or `inplace` values are allowed. Any other value will lead to an exception `NavigationHandler.INVALID_NAV_MODE`.
       */
      sNavMode?: string
    ): void;
    /**
     * Triggers a cross-app navigation after saving the inner and the cross-app states. Since 1.52.0 the navigation
     * mode based on `sap-ushell-next-navmode` is taken into account. If set to `explace` the inner app state
     * will not be changed. **Note:** The `sNavMode` argument can be used to overwrite the SAP Fiori launchpad
     * default navigation for opening a URL in-place or ex-place.
     *
     * @deprecated (since 1.83.0) -
     *  **Node:** If the `oExternalAppData` parameter is not supplied, the external app data will be calculated
     * based on the `oInnerAppData` data.
     *  SmartFilterBar control **Parameters:**   {object} **oError**
     * Error object (instance of {@link sap.ui.generic.app.navigation.service.NavError}) that describes
     * which kind of error occurred  {string} **oError.errorCode**
     * Code to identify the error  {string} **oError.type** Severity
     * of the error (info/warning/error)  {array} **oError.params**
     * An array of objects (typically strings) that describe additional value parameters required for generating
     * the message
     */
    static navigate(
      /**
       * Name of the semantic object of the target app
       */
      sSemanticObject: string,
      /**
       * Name of the action of the target app
       */
      sActionName: string,
      /**
       * Navigation parameters as an object with key/value pairs or as a string representation of such an object.
       * If passed as an object, the properties are not checked against the `IsPotentialSensitive` or `Measure`
       * type.
       */
      vNavigationParameters: object | string,
      /**
       * Object for storing the state which will be forwarded to the target component.
       */
      oExternalAppData: {
        /**
         * Object containing the current ui state of the app which will be forwarded to the target component.
         */
        presentationVariant?: object;
        /**
         * Object containing value descriptions which will be forwarded to the target component.
         */
        valueTexts?: object;
        /**
         * Stringified JSON object, which will be forwarded to the target component. If not provided the selectionVariant
         * will be constructed based on the vNavigationParameters.
         */
        selectionVariant?: object;
      },
      /**
       * Argument is used to overwrite the FLP-configured target for opening a URL. If used, only the `explace`
       * or `inplace` values are allowed. Any other value will lead to an exception `NavigationHandler.INVALID_NAV_MODE`.
       */
      sNavMode?: string
    ): void;
    /**
     * Triggers a cross-app navigation after saving the inner and the cross-app states. Since 1.52.0 the navigation
     * mode based on `sap-ushell-next-navmode` is taken into account. If set to `explace` the inner app state
     * will not be changed. **Note:** The `sNavMode` argument can be used to overwrite the SAP Fiori launchpad
     * default navigation for opening a URL in-place or ex-place.
     *
     * @deprecated (since 1.83.0) -
     *  **Node:** If the `oExternalAppData` parameter is not supplied, the external app data will be calculated
     * based on the `oInnerAppData` data.
     *  SmartFilterBar control **Parameters:**   {object} **oError**
     * Error object (instance of {@link sap.ui.generic.app.navigation.service.NavError}) that describes
     * which kind of error occurred  {string} **oError.errorCode**
     * Code to identify the error  {string} **oError.type** Severity
     * of the error (info/warning/error)  {array} **oError.params**
     * An array of objects (typically strings) that describe additional value parameters required for generating
     * the message
     */
    static navigate(
      /**
       * Name of the semantic object of the target app
       */
      sSemanticObject: string,
      /**
       * Name of the action of the target app
       */
      sActionName: string,
      /**
       * Object for storing current state of the app
       */
      oInnerAppData: {
        /**
         * Stringified JSON object as returned, for example, from getDataSuiteFormat() of the SmartFilterBar control
         */
        selectionVariant?: string;
        /**
         * ID of the SmartTable variant
         */
        tableVariantId?: string;
        /**
         * Object that can be used to store arbitrary data
         */
        customData?: object;
        /**
         * Object containing the current ui state of the app
         */
        presentationVariant?: object;
        /**
         * Object containing value descriptions
         */
        valueTexts?: object;
        /**
         * Object containing semanticDates filter information
         */
        semanticDates?: object;
      },
      /**
       * Object for storing the state which will be forwarded to the target component.
       */
      oExternalAppData: {
        /**
         * Object containing the current ui state of the app which will be forwarded to the target component.
         */
        presentationVariant?: object;
        /**
         * Object containing value descriptions which will be forwarded to the target component.
         */
        valueTexts?: object;
        /**
         * Stringified JSON object, which will be forwarded to the target component. If not provided the selectionVariant
         * will be constructed based on the vNavigationParameters.
         */
        selectionVariant?: object;
      },
      /**
       * Argument is used to overwrite the FLP-configured target for opening a URL. If used, only the `explace`
       * or `inplace` values are allowed. Any other value will lead to an exception `NavigationHandler.INVALID_NAV_MODE`.
       */
      sNavMode?: string
    ): void;
    /**
     * Triggers a cross-app navigation after saving the inner and the cross-app states. Since 1.52.0 the navigation
     * mode based on `sap-ushell-next-navmode` is taken into account. If set to `explace` the inner app state
     * will not be changed. **Note:** The `sNavMode` argument can be used to overwrite the SAP Fiori launchpad
     * default navigation for opening a URL in-place or ex-place.
     *
     * @deprecated (since 1.83.0) -
     *  **Node:** If the `oExternalAppData` parameter is not supplied, the external app data will be calculated
     * based on the `oInnerAppData` data.
     *  SmartFilterBar control **Parameters:**   {object} **oError**
     * Error object (instance of {@link sap.ui.generic.app.navigation.service.NavError}) that describes
     * which kind of error occurred  {string} **oError.errorCode**
     * Code to identify the error  {string} **oError.type** Severity
     * of the error (info/warning/error)  {array} **oError.params**
     * An array of objects (typically strings) that describe additional value parameters required for generating
     * the message
     */
    static navigate(
      /**
       * Name of the semantic object of the target app
       */
      sSemanticObject: string,
      /**
       * Name of the action of the target app
       */
      sActionName: string,
      /**
       * Callback that is called if an error occurs during navigation
       */
      fnOnError: Function,
      /**
       * Object for storing the state which will be forwarded to the target component.
       */
      oExternalAppData: {
        /**
         * Object containing the current ui state of the app which will be forwarded to the target component.
         */
        presentationVariant?: object;
        /**
         * Object containing value descriptions which will be forwarded to the target component.
         */
        valueTexts?: object;
        /**
         * Stringified JSON object, which will be forwarded to the target component. If not provided the selectionVariant
         * will be constructed based on the vNavigationParameters.
         */
        selectionVariant?: object;
      },
      /**
       * Argument is used to overwrite the FLP-configured target for opening a URL. If used, only the `explace`
       * or `inplace` values are allowed. Any other value will lead to an exception `NavigationHandler.INVALID_NAV_MODE`.
       */
      sNavMode?: string
    ): void;
    /**
     * Triggers a cross-app navigation after saving the inner and the cross-app states. Since 1.52.0 the navigation
     * mode based on `sap-ushell-next-navmode` is taken into account. If set to `explace` the inner app state
     * will not be changed. **Note:** The `sNavMode` argument can be used to overwrite the SAP Fiori launchpad
     * default navigation for opening a URL in-place or ex-place.
     *
     * @deprecated (since 1.83.0) -
     *  **Node:** If the `oExternalAppData` parameter is not supplied, the external app data will be calculated
     * based on the `oInnerAppData` data.
     *  SmartFilterBar control **Parameters:**   {object} **oError**
     * Error object (instance of {@link sap.ui.generic.app.navigation.service.NavError}) that describes
     * which kind of error occurred  {string} **oError.errorCode**
     * Code to identify the error  {string} **oError.type** Severity
     * of the error (info/warning/error)  {array} **oError.params**
     * An array of objects (typically strings) that describe additional value parameters required for generating
     * the message
     */
    static navigate(
      /**
       * Name of the semantic object of the target app
       */
      sSemanticObject: string,
      /**
       * Name of the action of the target app
       */
      sActionName: string,
      /**
       * Object for storing the state which will be forwarded to the target component.
       */
      oExternalAppData: {
        /**
         * Object containing the current ui state of the app which will be forwarded to the target component.
         */
        presentationVariant?: object;
        /**
         * Object containing value descriptions which will be forwarded to the target component.
         */
        valueTexts?: object;
        /**
         * Stringified JSON object, which will be forwarded to the target component. If not provided the selectionVariant
         * will be constructed based on the vNavigationParameters.
         */
        selectionVariant?: object;
      },
      /**
       * Argument is used to overwrite the FLP-configured target for opening a URL. If used, only the `explace`
       * or `inplace` values are allowed. Any other value will lead to an exception `NavigationHandler.INVALID_NAV_MODE`.
       */
      sNavMode?: string
    ): void;
    /**
     * Parses the incoming URL and returns a Promise. If this method detects a back navigation, the inner app
     * state is returned in the resolved Promise. Otherwise startup parameters will be merged into the app state
     * provided by cross app navigation, and a combined app state will be returned. The conflict resolution
     * can be influenced with sParamHandlingMode defined in the constructor.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns A Promise object to monitor when all the actions of the function have been executed. If the
     * execution is successful, the extracted app state, the startup parameters, and the type of navigation
     * are returned, see also the example above. The app state is an object that contains the following information:
     *
     * 	 - `oAppData.oSelectionVariant`: An instance of {@link sap.ui.generic.app.navigation.service.SelectionVariant }
     *     containing only parameters/select options that are related to navigation
     * 	 - `oAppData.selectionVariant`: The navigation-related selection variant as a JSON-formatted string
     *
     * 	 - `oAppData.oDefaultedSelectionVariant`: An instance of {@link sap.ui.generic.app.navigation.service.SelectionVariant }
     *     containing only the parameters/select options that are set by user default data
     * 	 - `oAppData.bNavSelVarHasDefaultsOnly`: A Boolean flag that indicates whether only defaulted parameters
     *     and no navigation parameters are present.
     *  **Note:** If no navigation parameters are available, `bNavSelVarHasDefaultsOnly` is set to `true`, even
     * though parameters without default might be available as well.  If the navigation-related selection
     * variant is empty, it is replaced by a copy of the defaulted selection variant.
     *  The navigation type is an enumeration type of type {@link sap.ui.generic.app.navigation.service.NavType }
     * (possible values are initial, URLParams, xAppState, and iAppState).
     *  **Note:** If the navigation type is {@link sap.ui.generic.app.navigation.service.NavType.iAppState }
     * oAppData has two additional properties
     * 	 - `oAppData.tableVariantId`
     * 	 - `oAppData.customData`  which return the inner app data as stored in {@link #.navigate navigate }
     *     or {@link #.storeInnerAppState storeInnerAppState}. `oAppData.oDefaultedSelectionVariant` is an empty
     *     selection variant and `oAppData.bNavSelVarHasDefaultsOnly` is `false` in this case.
     *  **Note:** If the navigation type is {@link sap.ui.generic.app.navigation.service.NavType.initial} oAppData
     * is an empty object!
     *  If an error occurs, an error object of type {@link sap.ui.generic.app.navigation.service.NavError},
     * URL parameters (if available) and the type of navigation are returned.
     */
    static parseNavigation(): object;
    /**
     * Processes navigation-related tasks related to beforePopoverOpens event handling for the SmartLink control
     * and returns a Promise object. In particular, the following tasks are performed before the SmartLink popover
     * can be opened:
     * 	 - If `mInnerAppData` is provided, this inner app state is saved for back navigation at a later time.
     *
     * 	 - The table event parameters (semantic attributes) and the selection variant data are combined by calling
     *     the method {@link #.mixAttributesAndSelectionVariant mixAttributesAndSelectionVariant}.
     * 	 - The combined data is saved as the cross app state to be handed over to the target app, and the corresponding
     *     sap-xapp-state key is set in the URL.
     * 	 - All single selections ("including equal") of the combined selection data are passed to the SmartLink
     *     popover as semantic attributes.
     * 	 - The method `oTableEventParameters.open()` is called. Note that this does not really open the popover,
     *     but the SmartLink control proceeds with firing the event `navigationTargetsObtained`.
     *
     * @deprecated (since 1.83.0) -
     *  **Node:** If the `oExternalAppData` parameter is not supplied, the external app data will be calculated
     * based on the `mInnerAppData` data.
     *
     *
     * @returns A Promise object to monitor when all actions of the function have been executed; if the execution
     * is successful, the modified oTableEventParameters is returned; if an error occurs, an error object of
     * type {@link sap.ui.generic.app.navigation.service.NavError} is returned
     */
    static processBeforeSmartLinkPopoverOpens(
      /**
       * The parameters made available by the SmartTable control when the SmartLink control has been clicked,
       * an instance of a PopOver object
       */
      oTableEventParameters: object,
      /**
       * Stringified JSON object as returned, for example, from getDataSuiteFormat() of the SmartFilterBar control
       */
      sSelectionVariant: string,
      /**
       * Object containing the current state of the app. If provided, opening the Popover is deferred until the
       * inner app data is saved in a consistent way.
       */
      mInnerAppData?: {
        /**
         * Stringified JSON object as returned, for example, from getDataSuiteFormat() of the the SmartFilterBar
         * control; if provided, the selection is merged into the semantic attributes
         */
        selectionVariant?: string;
        /**
         * ID of the SmartTable variant
         */
        tableVariantId?: string;
        /**
         * Object that can be used to store additional app-specific data
         */
        customData?: object;
        /**
         * Object containing the current ui presentationVariantof the app
         */
        presentationVariant?: object;
        /**
         * Object containing value descriptions
         */
        valueTexts?: object;
        /**
         * Object containing semanticDates filter information
         */
        semanticDates?: object;
      },
      /**
       * Object containing the state which will be passed to the target screen.
       */
      oExternalAppData?: {
        /**
         * Object containing selectionVariant, which will be passed to the target screen. If not set the sSelectionVariant
         * will be used.
         */
        selectionVariant?: object;
        /**
         * Object containing the current ui presentationVariant of the app, which will be passed to the target screen
         */
        presentationVariant?: object;
        /**
         * Object containing value descriptions, which will be passed to the target screen
         */
        valueTexts?: object;
      }
    ): object;
    /**
     * Changes the URL according to the current sAppStateKey. As an reaction route change event will be triggered.
     *
     * @deprecated (since 1.83.0)
     */
    static replaceHash(
      /**
       * the new app state key.
       */
      sAppStateKey: string
    ): void;
    /**
     * Sets the model that is used for verification of sensitive information. If the model is not set, the unnamed
     * component model is used for the verification of sensitive information.
     *
     * @since 1.60.0
     * @deprecated (since 1.83.0)
     */
    static setModel(
      /**
       * for checking sensitive information
       */
      oModel: ODataModel
    ): void;
    /**
     * Sets the application specific technical parameters. Technical parameters will not be added to the selection
     * variant passed to the application. As a default the following values are considered as technical parameters:
     *
     * 	 - `sap-system`
     * 	 - `sap-ushell-defaultedParameterNames`
     * 	 - `"hcpApplicationId"`
     *
     * @deprecated (since 1.83.0)
     */
    static setTechnicalParameters(
      /**
       * list of parameter names to be considered as technical parameters. `null` or `undefined` may be used to
       * reset the complete list.
       */
      aTechnicalParameters: any[]
    ): void;
    /**
     * Changes the URL according to the current app state and stores the app state for later retrieval.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns A Promise object to monitor when all the actions of the function have been executed; if the
     * execution is successful, the app state key is returned; if an error occurs, an object of type {@link sap.ui.generic.app.navigation.service.NavError }
     * is returned
     */
    static storeInnerAppState(
      /**
       * Object containing the current state of the app
       */
      mInnerAppData: {
        /**
         * Stringified JSON object as returned, for example, from getDataSuiteFormat() of the SmartFilterBar control
         */
        selectionVariant: string;
        /**
         * ID of the SmartTable variant
         */
        tableVariantId?: string;
        /**
         * Object that can be used to store additional app-specific data
         */
        customData?: object;
        /**
         * Object containing the current ui state of the app
         */
        presentationVariant?: object;
        /**
         * Object containing value descriptions
         */
        valueTexts?: object;
        /**
         * Object containing semanticDates filter information
         */
        semanticDates?: object;
      },
      /**
       * If set to false, the inner app hash will not be replaced until storing is successful; do not set to false
       * if you cannot react to the resolution of the Promise, for example, when calling the beforeLinkPressed
       * event
       */
      bImmediateHashReplace?: boolean
    ): object;
    /**
     * Changes the URL according to the current app state and stores the app state for later retrieval.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns An object containing the appStateId and a promise object to monitor when all the actions of
     * the function have been executed; Please note that the appStateKey may be undefined or empty.
     */
    static storeInnerAppStateWithImmediateReturn(
      /**
       * Object containing the current state of the app
       */
      mInnerAppData: {
        /**
         * Stringified JSON object as returned, for example, from getDataSuiteFormat() of the SmartFilterBar control
         */
        selectionVariant: string;
        /**
         * ID of the SmartTable variant
         */
        tableVariantId?: string;
        /**
         * Object that can be used to store additional app-specific data
         */
        customData?: object;
        /**
         * Object containing the current ui state of the app
         */
        presentationVariant?: object;
        /**
         * Object containing value descriptions
         */
        valueTexts?: object;
        /**
         * Object containing semanticDates filter information
         */
        semanticDates?: object;
      },
      /**
       * If set to false, the inner app hash will not be replaced until storing is successful; do not set to false
       * if you cannot react to the resolution of the Promise, for example, when calling the beforeLinkPressed
       * event. **Note:**If not provided it will be treated as set to false. **Note:**If set to true, the calling
       * instance has to ensure that a follow-on call to `replaceHash` will take place!
       */
      bImmediateHashReplace?: boolean
    ): Object;
  }
}

declare module "sap/ui/generic/app/navigation/service/PresentationVariant" {
  import PresentationVariant1 from "sap/fe/navigation/PresentationVariant";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Creates a new instance of a PresentationVariant class. If no parameter is passed, an new empty instance
   * is created whose ID has been set to `""`. Passing a JSON-serialized string complying to the Selection
   * Variant Specification will parse it, and the newly created instance will contain the same information.
   *
   * @deprecated (since 1.83.0) - Please use {@link sap.fe.navigation.PresentationVariant} instead.
   */
  export default class PresentationVariant extends PresentationVariant1 {
    constructor(
      /**
       * If of type `string`, the selection variant is JSON-formatted; if of type `object`, the object represents
       * a selection variant
       */
      vPresentationVariant?: string | object
    );

    /**
     * Creates a new subclass of class sap.ui.generic.app.navigation.service.PresentationVariant with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.fe.navigation.PresentationVariant.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, PresentationVariant>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Gets the chart visualization property.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns mProperties to be used for the chart visualization.
     */
    static getChartVisualization(): Record<string, any>;
    /**
     * Gets the current context URL intended for the query.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns The current context URL for the query
     */
    static getContextUrl(): string;
    /**
     * Returns the identification of the selection variant.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns The identification of the selection variant as made available during construction
     */
    static getID(): string;
    /**
     * Returns a metadata object for class sap.ui.generic.app.navigation.service.PresentationVariant.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Gets the more trivial properties. Basically all properties with the exception of the Visualization.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns The current properties.
     */
    static getProperties(): Record<string, any>;
    /**
     * Gets the table visualization property.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns mProperties to be used for the table visualization.
     */
    static getTableVisualization(): Record<string, any>;
    /**
     * Returns the current text / description of this selection variant.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns the current description of this selection variant.
     */
    static getText(): string;
    /**
     * Returns `true` if the presentation variant does not contain any properties. nor ranges.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns If set to `true` there are no current properties set; `false` otherwise.
     */
    static isEmpty(): boolean;
    /**
     * Sets the chart visualization property.
     *
     * @deprecated (since 1.83.0)
     */
    static setChartVisualization(
      /**
       * to be used for the chart visualization.
       */
      mProperties: Record<string, any>
    ): void;
    /**
     * Sets the context URL.
     *
     * @deprecated (since 1.83.0)
     */
    static setContextUrl(
      /**
       * The URL of the context
       */
      sURL: string
    ): void;
    /**
     * Sets the identification of the selection variant.
     *
     * @deprecated (since 1.83.0)
     */
    static setID(
      /**
       * The new identification of the selection variant
       */
      sId: string
    ): void;
    /**
     * Sets the more trivial properties. Basically all properties with the exception of the Visualization.
     *
     * @deprecated (since 1.83.0)
     */
    static setProperties(
      /**
       * properties to be used.
       */
      mProperties: Record<string, any>
    ): void;
    /**
     * Sets the table visualization property.
     *
     * @deprecated (since 1.83.0)
     */
    static setTableVisualization(
      /**
       * to be used for the table visualization.
       */
      mProperties: Record<string, any>
    ): void;
    /**
     * Sets the text / description of the selection variant.
     *
     * @deprecated (since 1.83.0)
     */
    static setText(
      /**
       * The new description to be used
       */
      sNewText: string
    ): void;
    /**
     * Returns the external representation of the selection variant as JSON object.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns The external representation of this instance as a JSON object
     */
    static toJSONObject(): object;
    /**
     * Serializes this instance into a JSON-formatted string.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns The JSON-formatted representation of this instance in stringified format
     */
    static toJSONString(): string;
  }
}

declare module "sap/ui/generic/app/navigation/service/SelectionVariant" {
  import SelectionVariant1 from "sap/fe/navigation/SelectionVariant";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Creates a new instance of a SelectionVariant class. If no parameter is passed, an new empty instance
   * is created whose ID has been set to `""`. Passing a JSON-serialized string complying to the Selection
   * Variant Specification will parse it, and the newly created instance will contain the same information.
   *
   * @deprecated (since 1.83.0) - Please use {@link sap.fe.navigation.SelectionVariant} instead.
   */
  export default class SelectionVariant extends SelectionVariant1 {
    constructor(
      /**
       * If of type `string`, the selection variant is JSON-formatted; if of type `object`, the object represents
       * a selection variant
       */
      vSelectionVariant?: string | object
    );

    /**
     * Sets the value of a parameter called `sName` to the new value `sValue`. If the parameter has already
     * been set before, its value is overwritten.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns This instance to allow method chaining
     */
    static addParameter(
      /**
       * The name of the parameter to be set; the `null` value is not allowed
       */
      sName: string,
      /**
       * The value of the parameter to be set
       */
      sValue: string
    ): object;
    /**
     * Adds a new range to the list of select options for a given parameter.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns This instance to allow method chaining.
     */
    static addSelectOption(
      /**
       * The name of the property for which the selection range is added
       */
      sPropertyName: string,
      /**
       * The sign of the range (**I**nclude or **E**xclude)
       */
      sSign: string,
      /**
       * The option of the range (**EQ** for "equals", **NE** for "not equals", **LE** for "less or equals", **GE**
       * for "greater or equals", **LT** for "less than" (and not equals), **GT** for "greater than" (and not
       * equals), **BT** for "between", or **CP** for "contains pattern" (ABAP-styled pattern matching with the
       * asterisk as wildcard)
       */
      sOption: string,
      /**
       * The single value or the lower boundary of the interval; the `null` value is not allowed
       */
      sLow: string,
      /**
       * Set only if sOption is **BT**: the upper boundary of the interval; must be `undefined` or `null` in all
       * other cases
       */
      sHigh?: string
    ): object;
    /**
     * Creates a new subclass of class sap.ui.generic.app.navigation.service.SelectionVariant with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.fe.navigation.SelectionVariant.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SelectionVariant>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Gets the current context URL intended for the filters.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns The current context URL for the filters
     */
    static getFilterContextUrl(): string;
    /**
     * Returns the identification of the selection variant.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns The identification of the selection variant as made available during construction
     */
    static getID(): string;
    /**
     * Returns a metadata object for class sap.ui.generic.app.navigation.service.SelectionVariant.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Returns the value of the parameter called `sName` if it has been set. If the parameter has never been
     * set or has been removed, `undefined` is returned.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns The value of parameter `sName`; returning the value `null` not possible
     */
    static getParameter(
      /**
       * The name of the parameter to be returned
       */
      sName: string
    ): string;
    /**
     * Gets the current context URL intended for the parameters.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns The current context URL for the parameters
     */
    static getParameterContextUrl(): string;
    /**
     * Returns the set of parameter names available in this selection variant
     *
     * @deprecated (since 1.83.0)
     *
     * @returns the list of parameter names which are valid
     */
    static getParameterNames(): any[];
    /**
     * Returns the names of the parameter and select option properties available for this instance.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns The list of parameter and select option property names available for this instance
     */
    static getPropertyNames(): any[];
    /**
     * Returns the set of select options/ranges available for a given property name.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns If `sPropertyName` is an invalid name of a property or no range exists, `undefined` is returned;
     * otherwise, an immutable array of ranges is returned. Each entry of the array is an object with the following
     * properties:
     * 	 - `Sign`: The sign of the range
     * 	 - `Option`: The option of the range
     * 	 - `Low`: The low value of the range; returning value `null` is not possible
     * 	 - `High`: The high value of the range; if this value is not necessary, `null` is used  For further
     *     information about the meaning of the attributes, refer to method `addSelectOption`.
     */
    static getSelectOption(
      /**
       * The name of the property for which the set of select options/ranges is returned
       */
      sPropertyName: string
    ): any[];
    /**
     * Returns the names of the properties available for this instance.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns The list of property names available for this instance
     */
    static getSelectOptionsPropertyNames(): any[];
    /**
     * Returns the current text / description of this selection variant.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns the current description of this selection variant.
     */
    static getText(): string;
    /**
     * First tries to retrieve the set of select options/ranges available for `sName` as property name. If successful,
     * this array of selections is being returned. If it fails, an attempt to find a parameter, whose name is
     * `sName`, is made. If the latter succeeds, the single value is converted to fit into an array of selections
     * to make it type compatible with ranges. This array is then returned.  If neither a select option
     * nor a parameter could be found, `undefined` is returned.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns The ranges in the select options for the specified property or a range-converted representation
     * of a parameter is returned. If both lookups fail, `undefined` is returned.  The returned ranges
     * have the format:
     * 	 - `Sign`: The sign of the range
     * 	 - `Option`: The option of the range
     * 	 - `Low`: The low value of the range; returning the value `null` is not possible
     * 	 - `High`: The high value of the range; if this value is not necessary, `null` (but does exist)
     *     For further information on the meaning of the attributes, refer to method {@link #.addSelectOption addSelectOption}.
     */
    static getValue(
      /**
       * The name of the attribute for which the value is retrieved
       */
      sName: string
    ): any[];
    /**
     * Returns `true` if the selection variant does neither contain parameters nor ranges.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns If set to `true` there are no parameters and no select options available in the selection variant;
     * `false` otherwise.
     */
    static isEmpty(): boolean;
    /**
     * Adds a set of select options to the list of select options for a given parameter.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns This instance to allow method chaining
     */
    static massAddSelectOption(
      /**
       * The name of the property for which the set of select options is added
       */
      sPropertyName: string,
      /**
       * Set of select options to be added
       */
      aSelectOptions: any[]
    ): object;
    /**
     * Removes a parameter called `sName` from the selection variant.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns This instance to allow method chaining
     */
    static removeParameter(
      /**
       * The name of the parameter to be removed
       */
      sName: string
    ): object;
    /**
     * Removes a select option called `sName` from the selection variant.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns This instance to allow method chaining.
     */
    static removeSelectOption(
      /**
       * The name of the select option to be removed
       */
      sName: string
    ): object;
    /**
     * Renames a parameter called `sNameOld` to `sNameNew`. If a parameter or a select option with the name
     * `sNameNew` already exist, an error is thrown. If a parameter with the name `sNameOld` does not exist,
     * nothing is changed.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns This instance to allow method chaining
     */
    static renameParameter(
      /**
       * The current name of the parameter to be renamed
       */
      sNameOld: string,
      /**
       * The new name of the parameter
       */
      sNameNew: string
    ): object;
    /**
     * Renames a select option called `sNameOld` to `sNameNew`. If a select option or a parameter with the name
     * `sNameNew` already exist, an error is thrown. If a select option with the name `sNameOld` does not exist,
     * nothing is changed.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns This instance to allow method chaining
     */
    static renameSelectOption(
      /**
       * The current name of the select option property to be renamed
       */
      sNameOld: string,
      /**
       * The new name of the select option property
       */
      sNameNew: string
    ): object;
    /**
     * Sets the context URL intended for the filters.
     *
     * @deprecated (since 1.83.0)
     */
    static setFilterContextUrl(
      /**
       * The URL of the filters
       */
      sURL: string
    ): void;
    /**
     * Sets the identification of the selection variant.
     *
     * @deprecated (since 1.83.0)
     */
    static setID(
      /**
       * The new identification of the selection variant
       */
      sId: string
    ): void;
    /**
     * Sets the context URL intended for the parameters.
     *
     * @deprecated (since 1.83.0)
     */
    static setParameterContextUrl(
      /**
       * The URL of the parameter context
       */
      sURL: string
    ): void;
    /**
     * Sets the text / description of the selection variant.
     *
     * @deprecated (since 1.83.0)
     */
    static setText(
      /**
       * The new description to be used
       */
      sNewText: string
    ): void;
    /**
     * Returns the external representation of the selection variant as JSON object.
     *
     * @deprecated (since 1.83.0)
     *
     * @returns The external representation of this instance as a JSON object
     */
    static toJSONObject(): object;
    /**
     * Serializes this instance into a JSON-formatted string
     *
     * @deprecated (since 1.83.0)
     *
     * @returns The JSON-formatted representation of this instance in stringified format
     */
    static toJSONString(): string;
  }
}

declare module "sap/ui/generic/app/transaction/BaseController" {
  import EventProvider from "sap/ui/base/EventProvider";

  import ODataModel from "sap/ui/model/odata/ODataModel";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Common base class for `sap.ui.generic.app.transaction.TransactionController` and `sap.ui.generic.app.transaction.DraftController`,
   * which offers basic functionality to invoke OData functions and actions as well as OData CRUD functions
   * in general.
   *
   * @since 1.30.0
   */
  export default class BaseController extends EventProvider {
    /**
     * Constructor for base class for controller instances.
     */
    constructor(
      /**
       * The OData model currently used
       */
      oModel: ODataModel,
      /**
       * Optional HTTP request queue
       */
      oQueue: /* was: sap.ui.generic.app.util.Queue */ any,
      /**
       * Delayed draft timer object
       */
      oDraftMergeTimer: Object
    );

    /**
     * Creates a new subclass of class sap.ui.generic.app.transaction.BaseController with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.EventProvider.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BaseController>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.generic.app.transaction.BaseController.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Attaches event handler `fnFunction` to the `fatalError` event.
     */
    attachFatalError(
      /**
       * The function to call when the event occurs
       */
      fnFunction: Function,
      /**
       * Object on which to call the given function
       */
      oListener?: object
    ): void;
    /**
     * Frees all resources claimed during the life-time of this instance.
     */
    destroy(): void;
    /**
     * Detaches event handler `fnFunction` from the `fatalError` event.
     */
    detachFatalError(
      /**
       * The function to call when the event occurs
       */
      fnFunction: Function,
      /**
       * Object on which to call the given function
       */
      oListener?: object
    ): void;
    /**
     * Checks for client messages.
     *
     *
     * @returns If client-side messages exist a rejected promise is returned, `null` otherwise
     */
    hasClientMessages(): Promise<any>;
    /**
     * Triggers submitting the currently tracked changes to the back-end.
     *
     *
     * @returns A `Promise` for asynchronous execution of the submit
     */
    triggerSubmitChanges(
      /**
       * Parameters to control the submit behavior
       */
      mParameters: {
        /**
         * If set to `true`, the current user interface is not blocked by a busy animation
         */
        noBlockUI: boolean;
        /**
         * If set to `true`, no success and error messages are shown
         */
        noShowResponse: boolean;
        /**
         * If set to `true`, the success message is not shown in a toast
         */
        noShowSuccessToast: boolean;
        /**
         * An optional success message
         */
        successMsg: string;
        /**
         * An optional error message
         */
        failedMsg: string;
      }
    ): Promise<any>;
  }
}

declare module "sap/ui/generic/app/transaction/DraftContext" {
  import BaseObject from "sap/ui/base/Object";

  import ODataModel from "sap/ui/model/odata/ODataModel";

  import Metadata from "sap/ui/base/Metadata";

  import Context from "sap/ui/model/Context";

  /**
   * The class provides access to information on draft handling that is available in the OData service's metadata
   * as it interprets draft-specific annotations.
   *
   * @since 1.30.0
   */
  export default class DraftContext extends BaseObject {
    /**
     * Constructor for meta-model access class.
     */
    constructor(
      /**
       * The OData model currently used
       */
      oModel: ODataModel
    );

    /**
     * Creates a new subclass of class sap.ui.generic.app.transaction.DraftContext with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DraftContext>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.generic.app.transaction.DraftContext.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Checks whether an OData property is annotated with UpdateOnChange. The method is used in context of a
     * validation success event.
     *
     * @deprecated (since 1.32.0)
     *
     * @returns `true`, if the property is annotated with UpdateOnChange, `false` otherwise
     */
    checkUpdateOnChange(
      /**
       * The name of the entity set
       */
      sEntitySet: string,
      /**
       * The name of the property
       */
      sProperty: string
    ): boolean;
    /**
     * Frees all resources claimed during the life-time of this instance.
     */
    destroy(): void;
    /**
     * Returns the name of the function import to be used.
     *
     *
     * @returns The name of the function import to be used
     */
    getODataDraftFunctionImportName(
      /**
       * The given binding context
       */
      oContext: Context,
      /**
       * The draft function import
       */
      sDraftFunctionImport: string
    ): string;
    /**
     * Returns the semantic keys for a given entity set.
     *
     *
     * @returns The semantic keys
     */
    getSemanticKey(
      /**
       * The given entity set
       */
      sEntitySet: string
    ): any[];
    /**
     * Checks whether an entity set is draft-enabled. The entity set name is derived from the given binding
     * context
     *
     *
     * @returns `true`, if a given entity set is draft-enabled, `false` otherwise
     */
    hasDraft(
      /**
       * The given binding context
       */
      oContext: Context
    ): boolean;
    /**
     * Checks whether administrative data for a given draft is available.
     *
     *
     * @returns `true`, if administrative data is available, `false` otherwise
     */
    hasDraftAdministrativeData(
      /**
       * The name of the entity set
       */
      sEntitySet: string
    ): boolean;
    /**
     * Checks whether an entity set has a draft preparation action. The entity set name is derived from the
     * given binding context.
     *
     *
     * @returns `true`, if a given entity set has a draft preparation action, `false` otherwise
     */
    hasDraftPreparationAction(
      /**
       * The given binding context
       */
      oContext: Context
    ): boolean;
    /**
     * Checks whether an entity set is draft root. The entity set name is derived from the given binding context.
     *
     *
     * @returns `true`, if a given entity set is draft root, `false` otherwise
     */
    hasDraftRoot(
      /**
       * The given binding context
       */
      oContext: Context
    ): boolean;
    /**
     * Checks whether an entity set has a draft validation function. The entity set name is derived from the
     * given binding context.
     *
     *
     * @returns `true`, if a given entity set has a draft validation function, `false` otherwise
     */
    hasDraftValidationFunction(
      /**
       * The given binding context
       */
      oContext: Context
    ): boolean;
    /**
     * Checks if the parameter "PreserveChanges" is supported by the edit function. If the edit action is triggered
     * with the parameter set to `true` the ABAP application infrastructure will respond with HTTP response
     * code 409 if unsaved changes (from another user) exist.
     *
     * @since 1.38
     *
     * @returns `true`, if "PreserveChanges" is supported
     */
    hasPreserveChanges(): boolean;
    /**
     * Checks whether a sibling entity for a given entity set is available.
     *
     *
     * @returns `true`, if sibling entity is available, `false` otherwise
     */
    hasSiblingEntity(
      /**
       * The name of the entity set
       */
      sEntitySet: string
    ): boolean;
    /**
     * Checks whether a given entity set is draft-enabled.
     *
     *
     * @returns `true`, if a given entity set is draft-enabled, `false` otherwise
     */
    isDraftEnabled(
      /**
       * The name of the entity set
       */
      sEntitySet: string
    ): boolean;
    /**
     * Checks whether a given entity set is a draft root.
     *
     *
     * @returns `true`, if a given entity set is draft root, `false` otherwise
     */
    isDraftRoot(
      /**
       * The name of the entity set
       */
      sEntitySet: string
    ): boolean;
    /**
     * Checks whether a given key is a semantic key.
     *
     *
     * @returns `true`, if a given key is a semantic key, `false` otherwise
     */
    isSemanticKey(
      /**
       * The name of the entity set
       */
      sEntitySet: string,
      /**
       * The given key
       */
      oKeys: object
    ): boolean;
    /**
     * Checks whether a given key is a technical key.
     *
     *
     * @returns `true`, if a given key is a technical key, `false` otherwise
     */
    isTechnicalKey(
      /**
       * The name of the entity set
       */
      sEntitySet: string,
      /**
       * The given key
       */
      oKeys: object
    ): boolean;
  }
}

declare module "sap/ui/generic/app/transaction/DraftController" {
  import BaseController from "sap/ui/generic/app/transaction/BaseController";

  import ODataModel from "sap/ui/model/odata/ODataModel";

  import Context from "sap/ui/model/Context";

  import DraftContext from "sap/ui/generic/app/transaction/DraftContext";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Gives access to runtime draft handling for applications. Assuming state-less communication, each single
   * data modification request (or change set in an OData $batch request) is a "mini-transaction", which saves
   * data to the database. The class implements the transactional interaction patterns specified for OData
   * services that support draft documents and provides methods for draft-specific actions, for example validate,
   * prepare, activate.
   *
   * Additionally, it handles transactional request processing, ensures concurrency control and correct ETag
   * handling. It provides access to the simple interaction patterns of runtime handling for drafts according
   * to the draft specification. These can be combined as required by client applications. Additionally, error
   * handling is provided to notify client implementations of error situations. The event `fatalError` is
   * thrown, if fatal errors occur during execution of OData requests.
   *
   * @since 1.30.0
   */
  export default class DraftController extends BaseController {
    /**
     * Constructor for a new draft controller instance.
     */
    constructor(
      /**
       * The OData model currently used
       */
      oModel: ODataModel,
      /**
       * Optional HTTP request queue
       */
      oQueue: /* was: sap.ui.generic.app.util.Queue */ any,
      /**
       * Delayed draft timer object
       */
      oDraftMergeTimer: Object
    );

    /**
     * Creates a new subclass of class sap.ui.generic.app.transaction.DraftController with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.generic.app.transaction.BaseController.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DraftController>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.generic.app.transaction.DraftController.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Submits changes to the back-end and activates a draft entity in the back-end.
     *
     *
     * @returns A `Promise` for asynchronous execution
     */
    activateDraftEntity(
      /**
       * The given binding context
       */
      oContext: Context,
      /**
       * Set to `true` to activate the draft even if warnings exist
       */
      bIsLenient: boolean,
      /**
       * Comma separated navigation properties which needs to be expanded with the root context of the active
       * instance
       */
      sExpand: string
    ): Promise<any>;
    /**
     * Submits changes to the back-end and activates a draft entity in the back-end.
     *
     *
     * @returns A `Promise` for asynchronous execution
     */
    activateDraftEntity(
      /**
       * The given binding context
       */
      oContext: Context,
      /**
       * Comma separated navigation properties which needs to be expanded with the root context of the active
       * instance
       */
      sExpand: string
    ): Promise<any>;
    /**
     * Creates an edit draft in the back-end. Additionally, possible changes that have been collected on the
     * client are sent to the back-end.
     *
     *
     * @returns A `Promise` for asynchronous execution
     */
    createEditDraftEntity(
      /**
       * The given binding context
       */
      oContext: Context,
      /**
       * Set to `true` to avoid the creation of a new draft when unsaved changes exist in the back-end
       */
      bPreserveChanges?: boolean,
      /**
       * indicates whether root needs to expanded
       */
      sRootExpand?: string
    ): Promise<any>;
    /**
     * Creates a new edit draft on the client and sends it to the back-end. Additionally, possible changes that
     * have been collected on the client are sent to the back-end.
     *
     *
     * @returns A `Promise` for asynchronous execution of the request
     */
    createNewDraftEntity(
      /**
       * The name of the entity set
       */
      sEntitySet: string,
      /**
       * Path identifying the new entity instance
       */
      sPath: string,
      /**
       * An array that specifies a set of properties or the entry
       */
      vPredefinedValues?: any[] | object,
      /**
       * information whether the canonicalRequest parameter should be set for the create request
       */
      bCanonicalRequest?: boolean,
      /**
       * parameters to be passed to the function
       */
      oParameters?: {
        /**
         * indicates whether root needs to expanded
         */
        sRootExpand?: boolean;
        /**
         * controller object required to create ActionUtil instance
         */
        oController?: object;
        /**
         * applicationController object required to create ActionUtil instance
         */
        oApplicationController?: object;
        /**
         * manifest entry indicating whether newAction has to be used for draft creation
         */
        bUseNewActionForCreate?: boolean;
        /**
         * callback to set the busy indicator
         */
        fnSetBusy?: Function;
      }
    ): Promise<any>;
    /**
     * Frees all resources claimed during the life-time of this instance.
     */
    destroy(): void;
    /**
     * Returns the current draft context instance. If no instance exists, it is created lazily.
     *
     *
     * @returns The current draft context instance
     */
    getDraftContext(): DraftContext;
    /**
     * Retrieves a possibly existing draft entity for the given active entity using the binding context of the
     * active entity from the back-end.
     *
     * @since 1.32.0
     *
     * @returns A `Promise` for asynchronous execution
     */
    getDraftForActiveEntity(
      /**
       * The binding context of the active entity
       */
      oContext: Context
    ): Promise<any>;
    /**
     * Checks whether an entity has an active entity associated.
     *
     * @since 1.32.0
     *
     * @returns `true`, if an active entity exists, `false` otherwise
     */
    hasActiveEntity(
      /**
       * The given binding context
       */
      oContext: Context
    ): boolean;
    /**
     * Checks whether an entity set is active. The entity set name is derived from the given binding context
     *
     *
     * @returns `true`, if a given entity set is active, `false` otherwise
     */
    isActiveEntity(
      /**
       * The given binding context
       */
      oContext: Context
    ): boolean;
    /**
     * Submits changes to the back-end and prepares an existing draft entity in the back-end for later activation
     * by invoking the preparation action.
     *
     *
     * @returns A `Promise` for asynchronous execution
     */
    prepareDraftEntity(
      /**
       * The given binding context
       */
      oContext: Context
    ): Promise<any>;
    /**
     * Submits changes to the back-end and prepares a draft entity in the back-end for later activation by invoking
     * the preparation action.
     *
     *
     * @returns A `Promise` for asynchronous execution
     */
    saveAndPrepareDraftEntity(
      /**
       * The given binding context
       */
      oContext: Context,
      /**
       * Parameters to control the behavior of the request
       */
      mParameters: Record<string, any>
    ): Promise<any>;
    /**
     * Submits changes to the back-end and prepares an existing draft entity in the back-end for later activation
     * by invoking the validation action.
     *
     *
     * @returns A `Promise` for asynchronous execution
     */
    validateDraftEntity(
      /**
       * The given binding context
       */
      oContext: Context
    ): Promise<any>;
  }
}

declare module "sap/ui/generic/app/transaction/TransactionController" {
  import BaseController from "sap/ui/generic/app/transaction/BaseController";

  import ODataModel from "sap/ui/model/odata/ODataModel";

  import Context from "sap/ui/model/Context";

  import DraftController from "sap/ui/generic/app/transaction/DraftController";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * Assuming state-less communication, each single data modification request (or change set in an OData $batch
   * request) is a "mini-transaction", which saves data to the database. The class allows you to submit changes,
   * invoke actions, OData CRUD operations in general, and trigger client-side validations. It ensures concurrency
   * control and correct ETag handling.
   *
   * The class gives access to runtime draft handling for applications. Additionally error handling capabilities
   * are provided to notify client implementations of error situations. The event `fatalError` is thrown,
   * if fatal errors occur during execution of OData requests.
   *
   * @since 1.30.0
   */
  export default class TransactionController extends BaseController {
    /**
     * Constructor for a new transaction controller instance.
     */
    constructor(
      /**
       * The OData model currently used
       */
      oModel: ODataModel,
      /**
       * Optional HTTP request queue
       */
      oQueue: /* was: sap.ui.generic.app.util.Queue */ any,
      /**
       * Optional configuration parameters
       */
      mParams: {
        /**
         * Suppresses creation of batch groups
         */
        noBatchGroups: boolean;
      },
      /**
       * Delayed draft timer object
       */
      oDraftMergeTimer: Object
    );

    /**
     * Creates a new subclass of class sap.ui.generic.app.transaction.TransactionController with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.generic.app.transaction.BaseController.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, TransactionController>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.ui.generic.app.transaction.TransactionController.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Submits changes to the backend system and deletes a group of entities in the backend system. These entities
     * can be both draft or active entities.
     *
     * @since 1.38
     * @experimental
     *
     * @returns A `Promise` that receives an array with the responses of the delete requests. The `Promise`
     * resolves when at least one request was successful and rejects when all delete requests have been rejected/aborted.
     */
    deleteEntities(
      /**
       * Binding contexts or paths (strings) which identify the entities
       */
      aEntities: any[],
      /**
       * Parameters that control the behavior of the request
       */
      mParameters: Record<string, any>
    ): Promise<any>;
    /**
     * Submits changes to the backend system and deletes an entity in the backend system. This entity can be
     * either a draft or an active entity.
     *
     *
     * @returns A `Promise` for asynchronous execution
     */
    deleteEntity(
      /**
       * Binding context or path of the entity
       */
      vEntity: Context | string,
      /**
       * Parameters that control the behavior of the request
       */
      mParameters: Record<string, any>
    ): Promise<any>;
    /**
     * Frees all resources claimed during the life-time of this instance.
     */
    destroy(): void;
    /**
     * Prepares an entity for editing. If the entity is active and draft enabled, a new draft document is created.
     * If not, the control is automatically returned to the caller of the method by returning a resolved promise.
     *
     *
     * @returns A `Promise` for asynchronous execution
     */
    editEntity(
      /**
       * The given binding context
       */
      oContext: Context,
      /**
       * Set to `true` to avoid the creation of a new draft when unsaved changes exist in the back-end
       */
      bPreserveChanges?: boolean,
      /**
       * indicates whether root needs to expanded
       */
      sRootExpand?: string
    ): Promise<any>;
    /**
     * Returns the current draft controller instance.
     *
     *
     * @returns The draft controller instance
     */
    getDraftController(): DraftController;
    /**
     * Resets changes that have been tracked by the current instance of `sap.ui.model.odata.v2.ODataModel`.
     * These changes have been created by invoking the `setProperty` method of `sap.ui.model.odata.v2.ODataModel`.
     */
    resetChanges(): void;
    /**
     * Multi edit handling.
     *
     *
     * @returns A `Promise` which resolves if the given promises have been executed with at least one successfully.
     * It rejects if all given promises were rejected.
     */
    updateMultipleEntities(
      /**
       * contains path and data to be updated for all selected contexts.
       */
      aContextToBeUpdated: any[]
    ): Promise<any>;
  }
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/ui/generic/app/ApplicationController": undefined;

    "sap/ui/generic/app/library": undefined;

    "sap/ui/generic/app/navigation/service/NavError": undefined;

    "sap/ui/generic/app/navigation/service/NavigationHandler": undefined;

    "sap/ui/generic/app/navigation/service/PresentationVariant": undefined;

    "sap/ui/generic/app/navigation/service/SelectionVariant": undefined;

    "sap/ui/generic/app/transaction/BaseController": undefined;

    "sap/ui/generic/app/transaction/DraftContext": undefined;

    "sap/ui/generic/app/transaction/DraftController": undefined;

    "sap/ui/generic/app/transaction/TransactionController": undefined;
  }
}
