import LinterContext, { PositionInfo } from "../LinterContext.js";
import { TranspileResult } from "../LinterContext.js";
import { ApiExtract } from "../../utils/ApiExtract.js";
import ControllerByIdInfo from "./ControllerByIdInfo.js";
import { Tag as SaxTag } from "sax-wasm";
export type Namespace = string;
export interface NamespaceDeclaration {
    localName: string | null;
    namespace: Namespace;
}
export declare const enum NodeKind {
    Unknown = 0,
    Control = 1,
    Aggregation = 2,
    FragmentDefinition = 4,
    Template = 8,
    Xhtml = 16,// Should generally be ignored
    Svg = 32
}
export interface Position {
    line: number;
    column: number;
}
export interface NodeDeclaration {
    kind: NodeKind;
    name: string;
    namespace: Namespace;
    start: Position;
    end: Position;
}
export interface ControlDeclaration extends NodeDeclaration {
    kind: NodeKind.Control;
    properties: Set<PropertyDeclaration>;
    aggregations: Map<string, AggregationDeclaration>;
    variableName?: string;
}
export interface AggregationDeclaration extends NodeDeclaration {
    kind: NodeKind.Aggregation;
    owner: ControlDeclaration;
    controls: ControlDeclaration[];
}
export interface FragmentDefinitionDeclaration extends NodeDeclaration {
    kind: NodeKind.FragmentDefinition;
    controls: Set<ControlDeclaration>;
}
interface AttributeDeclaration {
    name: string;
    value: string;
    localNamespace?: string;
    start: Position;
    end: Position;
}
type PropertyDeclaration = AttributeDeclaration;
export interface RequireExpression extends AttributeDeclaration {
    declarations: RequireDeclaration[];
}
export interface RequireDeclaration {
    moduleName?: string;
    variableName: string;
}
export default class Parser {
    #private;
    constructor(resourcePath: string, apiExtract: ApiExtract, context: LinterContext, controllerByIdInfo: ControllerByIdInfo);
    pushTag(tag: SaxTag): void;
    popTag(_tag: SaxTag): void;
    generate(): TranspileResult;
    _findParentNode(kindFilter: number): NodeDeclaration | null;
    _addNamespace(namespace: NamespaceDeclaration, level: number): void;
    _resolveNamespace(localName: string | null): Namespace | undefined;
    _removeNamespacesForLevel(level: number): void;
    _addDefaultAggregation(owner: ControlDeclaration, control: ControlDeclaration): void;
    _parseRequireAttribute(attrValue: string): RequireDeclaration[];
    _createNode(tag: SaxTag): NodeDeclaration;
    _handleUi5LibraryNamespace(moduleName: string, namespace: Namespace, attributes: Map<string, AttributeDeclaration>, tag: SaxTag): ControlDeclaration | AggregationDeclaration | FragmentDefinitionDeclaration;
    _handleTemplatingNamespace(tagName: string, namespace: Namespace, attributes: Map<string, AttributeDeclaration>, tag: SaxTag): NodeDeclaration;
    _checkGlobalReference(value: string, { line, column }: PositionInfo): void;
}
export {};
