/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.maven.shared;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.apache.commons.lang.RepeatableArgumentMatcher;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class MavenSharedStringUtilsRecipes
extends Recipe {
    public String getDisplayName() {
        return "`MavenSharedStringUtils` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `org.openrewrite.apache.maven.shared.MavenSharedStringUtils`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbbreviateRecipe(), new CapitaliseRecipe(), new DefaultStringRecipe(), new DefaultStringFallbackRecipe(), new DeleteWhitespaceRecipe(), new EqualsIgnoreCaseRecipe(), new EqualsRecipe(), new LowercaseRecipe(), new ReplaceRecipe(), new ReverseRecipe(), new SplitRecipe(), new StripRecipe(), new TrimRecipe(), new UppercaseRecipe()});
    }

    @NullMarked
    public static class AbbreviateRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.abbreviate(String, int)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Maven Shared `StringUtils.abbreviate(String str, int maxWidth)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.maven.shared.utils.StringUtils.abbreviate(#{s:any(java.lang.String)}, #{width:any(int)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"maven-shared-utils-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(1))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)}.length() <= #{width:any(int)} ? #{s} : #{s}.substring(0, #{width} - 3) + \"...\"").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils abbreviate(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CapitaliseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.capitalise(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Maven Shared `StringUtils.capitalise(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.maven.shared.utils.StringUtils.capitalise(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"maven-shared-utils-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null || #{s}.isEmpty() ? #{s} : Character.toTitleCase(#{s}.charAt(0)) + #{s}.substring(1)").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils capitalise(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DefaultStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.defaultString(Object)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Maven Shared `StringUtils.defaultString(Object obj)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.maven.shared.utils.StringUtils.defaultString(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"maven-shared-utils-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects.toString(#{s:any(java.lang.String)}, \"\")").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils defaultString(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DefaultStringFallbackRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.defaultString(Object, String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Maven Shared `StringUtils.defaultString(Object obj, String nullDefault)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.maven.shared.utils.StringUtils.defaultString(#{s:any(java.lang.String)}, #{nullDefault:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"maven-shared-utils-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects.toString(#{s:any(java.lang.String)}, #{nullDefault:any(java.lang.String)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils defaultString(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DeleteWhitespaceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.deleteWhitespace(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Maven Shared `StringUtils.deleteWhitespace(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.maven.shared.utils.StringUtils.deleteWhitespace(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"maven-shared-utils-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)}.replaceAll(\"\\\\s+\", \"\")").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils deleteWhitespace(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EqualsIgnoreCaseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.equalsIgnoreCase(String, String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Maven Shared `StringUtils.equalsIgnoreCase(String str1, String str2)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.maven.shared.utils.StringUtils.equalsIgnoreCase(#{s:any(java.lang.String)}, #{other:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"maven-shared-utils-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(1))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null ? #{other:any(java.lang.String)} == null : #{s}.equalsIgnoreCase(#{other})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils equalsIgnoreCase(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EqualsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.equals(String, String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Maven Shared `StringUtils.equals(String str1, String str2)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.maven.shared.utils.StringUtils.equals(#{s:any(java.lang.String)}, #{other:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"maven-shared-utils-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects.equals(#{s:any(java.lang.String)}, #{other:any(java.lang.String)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils equals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LowercaseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.lowerCase(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Maven Shared `StringUtils.lowerCase(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.maven.shared.utils.StringUtils.lowerCase(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"maven-shared-utils-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null ? null : #{s}.toLowerCase()").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils lowerCase(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplaceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.replace(String, String, String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Maven Shared `StringUtils.replace(String text, String searchString, String replacement)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.maven.shared.utils.StringUtils.replace(#{s:any(java.lang.String)}, #{search:any(java.lang.String)}, #{replacement:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"maven-shared-utils-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(1))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(2))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null || #{s}.isEmpty() || #{search:any(java.lang.String)} == null || #{search}.isEmpty() || #{replacement:any(java.lang.String)} == null ? #{s} : #{s}.replace(#{search}, #{replacement})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils replace(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReverseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.reverse(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Maven Shared `StringUtils.reverse(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.maven.shared.utils.StringUtils.reverse(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"maven-shared-utils-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null ? null : new StringBuffer(#{s}).reverse().toString()").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils reverse(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SplitRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.split(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Maven Shared `StringUtils.split(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.maven.shared.utils.StringUtils.split(#{s:any(java.lang.String)})").bindType("java.lang.String[]").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"maven-shared-utils-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)}.split(\"\\\\s+\")").bindType("java.lang.String[]").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils split(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StripRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.strip(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Maven Shared `StringUtils.strip(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.maven.shared.utils.StringUtils.strip(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"maven-shared-utils-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null ? null : #{s}.trim()").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils strip(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class TrimRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.trim(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Maven Shared `StringUtils.trim(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.maven.shared.utils.StringUtils.trim(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"maven-shared-utils-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null ? null : #{s}.trim()").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils trim(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class UppercaseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.upperCase(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Maven Shared `StringUtils.upperCase(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.maven.shared.utils.StringUtils.upperCase(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"maven-shared-utils-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null ? null : #{s}.toUpperCase()").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils upperCase(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

