/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.android;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.gradle.UpdateGradleWrapper;
import org.openrewrite.gradle.UpgradeDependencyVersion;

public final class UpgradeAndroidGradlePluginVersion
extends Recipe {
    @Option(displayName="Android Gradle Plugin (AGP) version", description="The version of the Android Gradle Plugin to use.", example="8.6.x")
    private final String agpVersion;
    @Option(displayName="Gradle Wrapper version", description="The version of the Gradle Wrapper to use.", example="(8.7, 9]")
    private final String gradleWrapperVersion;

    public String getDisplayName() {
        return "Upgrade Android Gradle Plugin (AGP) version";
    }

    public String getDescription() {
        return "Upgrade Android Gradle Plugin (AGP) version and update the Gradle Wrapper version. Compatible versions are published in the [AGP release notes](https://developer.android.com/build/releases/gradle-plugin).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new UpgradeDependencyVersion("com.android.tools.build", "gradle", this.agpVersion, null), new UpdateGradleWrapper(this.gradleWrapperVersion, null, null, null, null));
    }

    @Generated
    public UpgradeAndroidGradlePluginVersion(String agpVersion, String gradleWrapperVersion) {
        this.agpVersion = agpVersion;
        this.gradleWrapperVersion = gradleWrapperVersion;
    }

    @Generated
    public String getAgpVersion() {
        return this.agpVersion;
    }

    @Generated
    public String getGradleWrapperVersion() {
        return this.gradleWrapperVersion;
    }

    @Generated
    public String toString() {
        return "UpgradeAndroidGradlePluginVersion(agpVersion=" + this.getAgpVersion() + ", gradleWrapperVersion=" + this.getGradleWrapperVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeAndroidGradlePluginVersion)) {
            return false;
        }
        UpgradeAndroidGradlePluginVersion other = (UpgradeAndroidGradlePluginVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$agpVersion = this.getAgpVersion();
        String other$agpVersion = other.getAgpVersion();
        if (this$agpVersion == null ? other$agpVersion != null : !this$agpVersion.equals(other$agpVersion)) {
            return false;
        }
        String this$gradleWrapperVersion = this.getGradleWrapperVersion();
        String other$gradleWrapperVersion = other.getGradleWrapperVersion();
        return !(this$gradleWrapperVersion == null ? other$gradleWrapperVersion != null : !this$gradleWrapperVersion.equals(other$gradleWrapperVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpgradeAndroidGradlePluginVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $agpVersion = this.getAgpVersion();
        result = result * 59 + ($agpVersion == null ? 43 : $agpVersion.hashCode());
        String $gradleWrapperVersion = this.getGradleWrapperVersion();
        result = result * 59 + ($gradleWrapperVersion == null ? 43 : $gradleWrapperVersion.hashCode());
        return result;
    }
}

