/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.isolated;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.RecipeRun;
import org.openrewrite.Result;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markup;
import org.openrewrite.marker.SearchResult;

public class ResultsContainer {
    final Path projectRoot;
    final RecipeRun recipeRun;
    final List<Result> generated = new ArrayList<Result>();
    final List<Result> deleted = new ArrayList<Result>();
    final List<Result> moved = new ArrayList<Result>();
    final List<Result> refactoredInPlace = new ArrayList<Result>();

    public ResultsContainer(Path projectRoot, @Nullable RecipeRun recipeRun) {
        this.projectRoot = projectRoot;
        this.recipeRun = recipeRun;
        if (recipeRun != null) {
            for (Result result : recipeRun.getResults()) {
                if (result.getBefore() == null && result.getAfter() == null) continue;
                if (result.getBefore() == null && result.getAfter() != null) {
                    this.generated.add(result);
                    continue;
                }
                if (result.getBefore() != null && result.getAfter() == null) {
                    this.deleted.add(result);
                    continue;
                }
                if (result.getBefore() != null && !result.getBefore().getSourcePath().equals(result.getAfter().getSourcePath())) {
                    this.moved.add(result);
                    continue;
                }
                if (result.diff(Paths.get("", new String[0]), (PrintOutputCapture.MarkerPrinter)new FencedMarkerPrinter(), Boolean.valueOf(true)).isEmpty()) continue;
                this.refactoredInPlace.add(result);
            }
        }
    }

    @Nullable
    public Throwable getFirstException() {
        Iterator iterator;
        for (Result result : this.generated) {
            iterator = result.getRecipeErrors().iterator();
            if (!iterator.hasNext()) continue;
            Throwable recipeError = (Throwable)iterator.next();
            return recipeError;
        }
        for (Result result : this.deleted) {
            iterator = result.getRecipeErrors().iterator();
            if (!iterator.hasNext()) continue;
            Throwable recipeError = (Throwable)iterator.next();
            return recipeError;
        }
        for (Result result : this.moved) {
            iterator = result.getRecipeErrors().iterator();
            if (!iterator.hasNext()) continue;
            Throwable recipeError = (Throwable)iterator.next();
            return recipeError;
        }
        for (Result result : this.refactoredInPlace) {
            iterator = result.getRecipeErrors().iterator();
            if (!iterator.hasNext()) continue;
            Throwable recipeError = (Throwable)iterator.next();
            return recipeError;
        }
        return null;
    }

    public Path getProjectRoot() {
        return this.projectRoot;
    }

    public boolean isNotEmpty() {
        return !this.generated.isEmpty() || !this.deleted.isEmpty() || !this.moved.isEmpty() || !this.refactoredInPlace.isEmpty();
    }

    public List<Path> newlyEmptyDirectories() {
        LinkedHashSet<Path> maybeEmptyDirectories = new LinkedHashSet<Path>();
        for (Result result : this.moved) {
            assert (result.getBefore() != null);
            maybeEmptyDirectories.add(this.projectRoot.resolve(result.getBefore().getSourcePath()).getParent());
        }
        for (Result result : this.deleted) {
            assert (result.getBefore() != null);
            maybeEmptyDirectories.add(this.projectRoot.resolve(result.getBefore().getSourcePath()).getParent());
        }
        if (maybeEmptyDirectories.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Path> emptyDirectories = new ArrayList<Path>(maybeEmptyDirectories.size());
        for (Path maybeEmptyDirectory : maybeEmptyDirectories) {
            try {
                Stream<Path> contents = Files.list(maybeEmptyDirectory);
                try {
                    if (contents.findAny().isPresent()) continue;
                    Files.delete(maybeEmptyDirectory);
                }
                finally {
                    if (contents == null) continue;
                    contents.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return emptyDirectories;
    }

    private static class FencedMarkerPrinter
    implements PrintOutputCapture.MarkerPrinter {
        private FencedMarkerPrinter() {
        }

        public String beforeSyntax(Marker marker, Cursor cursor, UnaryOperator<String> commentWrapper) {
            return marker instanceof SearchResult || marker instanceof Markup ? "{{" + marker.getId() + "}}" : "";
        }

        public String afterSyntax(Marker marker, Cursor cursor, UnaryOperator<String> commentWrapper) {
            return marker instanceof SearchResult || marker instanceof Markup ? "{{" + marker.getId() + "}}" : "";
        }
    }
}

