/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0003J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0016\u001a\u00020\u0003R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/openrewrite/gradle/GradleSourceSetSpec;", "", "name", "", "(Ljava/lang/String;)V", "javaSources", "", "getJavaSources", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "propertiesFiles", "", "getPropertiesFiles", "()Ljava/util/Map;", "build", "dir", "Ljava/io/File;", "java", "", "source", "propertiesFile", "text", "plugin"})
public final class GradleSourceSetSpec {
    @NotNull
    private final String name;
    @NotNull
    private final List<String> javaSources;
    @NotNull
    private final Map<String, String> propertiesFiles;

    public GradleSourceSetSpec(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.javaSources = new ArrayList();
        this.propertiesFiles = new LinkedHashMap();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<String> getJavaSources() {
        return this.javaSources;
    }

    public final void java(@Language(value="java") @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.javaSources.add(StringsKt.trimIndent((String)source));
    }

    @NotNull
    public final Map<String, String> getPropertiesFiles() {
        return this.propertiesFiles;
    }

    public final void propertiesFile(@NotNull String name, @Language(value="properties") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.propertiesFiles.put(name, text);
    }

    @NotNull
    public final GradleSourceSetSpec build(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        dir.mkdirs();
        for (String string : this.javaSources) {
            File file;
            String string2;
            if (StringsKt.startsWith$default((String)string, (String)"package", (boolean)false, (int)2, null)) {
                MatchResult matchResult = Regex.find$default((Regex)new Regex("package\\s+([a-zA-Z0-9.]+);", RegexOption.MULTILINE), (CharSequence)string, (int)0, (int)2, null);
                Intrinsics.checkNotNull((Object)matchResult);
                string2 = (String)matchResult.getGroupValues().get(1);
            } else {
                string2 = "";
            }
            String peckage = StringsKt.replace$default((String)string2, (String)".", (String)"/", (boolean)false, (int)4, null);
            MatchResult matchResult = Regex.find$default((Regex)new Regex(".+(class|interface|enum)\\s+([a-zA-Z0-9-_]+).+", RegexOption.MULTILINE), (CharSequence)string, (int)0, (int)2, null);
            Intrinsics.checkNotNull((Object)matchResult);
            String clazz = (String)matchResult.getGroupValues().get(2);
            File $this$build_u24lambda_u2d0 = file = new File(dir, this.name + "/java/" + peckage + '/' + clazz + ".java");
            boolean bl = false;
            $this$build_u24lambda_u2d0.getParentFile().mkdirs();
            FilesKt.writeText$default((File)$this$build_u24lambda_u2d0, (String)string, null, (int)2, null);
        }
        if (!this.propertiesFiles.isEmpty()) {
            for (Map.Entry entry : this.propertiesFiles.entrySet()) {
                File file;
                File $this$build_u24lambda_u2d1 = file = new File(dir, this.name + "/resources/" + (String)entry.getKey());
                boolean bl = false;
                $this$build_u24lambda_u2d1.getParentFile().mkdirs();
                FilesKt.writeText$default((File)$this$build_u24lambda_u2d1, (String)((String)entry.getValue()), null, (int)2, null);
            }
        }
        return this;
    }
}

