/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.trait.member;

import fj.data.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.Cursor;
import org.openrewrite.analysis.trait.Top;
import org.openrewrite.analysis.trait.member.Method;
import org.openrewrite.analysis.trait.util.TraitErrors;
import org.openrewrite.analysis.trait.variable.Parameter;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

class MethodDeclarationMethod
extends Top.Base
implements Method {
    Cursor cursor;
    J.MethodDeclaration methodDeclaration;
    private final AtomicReference<Object> parameters = new AtomicReference();

    @Override
    public String getName() {
        return this.methodDeclaration.getSimpleName();
    }

    @Override
    public Option<JavaType> getReturnType() {
        if (this.methodDeclaration.getReturnTypeExpression() == null) {
            return Option.some((Object)JavaType.Primitive.Void);
        }
        return Option.fromNull((Object)this.methodDeclaration.getReturnTypeExpression().getType());
    }

    @Override
    public Option<JavaType.Method> getMethodType() {
        return Option.fromNull((Object)this.methodDeclaration.getMethodType());
    }

    @Override
    public UUID getId() {
        return this.methodDeclaration.getId();
    }

    private static List<Parameter> collectParameters(final Cursor cursor, J.MethodDeclaration methodDeclaration) {
        assert (cursor.getValue() == methodDeclaration);
        ArrayList parameters = new ArrayList(methodDeclaration.getParameters().size());
        new JavaVisitor<List<Parameter>>(){
            {
                this.setCursor(cursor);
            }

            public J visitVariable(J.VariableDeclarations.NamedVariable variable, List<Parameter> parameters) {
                parameters.add((Parameter)Parameter.viewOf(this.getCursor()).on(TraitErrors::doThrow));
                return variable;
            }
        }.visit(methodDeclaration.getParameters(), parameters);
        return Collections.unmodifiableList(parameters);
    }

    public MethodDeclarationMethod(Cursor cursor, J.MethodDeclaration methodDeclaration) {
        this.cursor = cursor;
        this.methodDeclaration = methodDeclaration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Parameter> getParameters() {
        Object $value = this.parameters.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.parameters;
            synchronized (atomicReference) {
                $value = this.parameters.get();
                if ($value == null) {
                    List<Parameter> actualValue = MethodDeclarationMethod.collectParameters(this.cursor, this.methodDeclaration);
                    $value = actualValue == null ? this.parameters : actualValue;
                    this.parameters.set($value);
                }
            }
        }
        return (List)($value == this.parameters ? null : $value);
    }
}

