/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.search;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.analysis.InvocationMatcher;
import org.openrewrite.analysis.controlflow.Guard;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.analysis.dataflow.DataFlowSpec;
import org.openrewrite.analysis.dataflow.Dataflow;
import org.openrewrite.analysis.search.UsesInvocation;
import org.openrewrite.analysis.trait.expr.BinaryExpr;
import org.openrewrite.analysis.trait.expr.Literal;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;

public class UriCreatedWithHttpScheme
extends Recipe {
    private static final InvocationMatcher URI_CREATE = InvocationMatcher.fromMethodMatcher("java.net.URI create(..)");
    private static final MethodMatcher STRING_REPLACE = new MethodMatcher("java.lang.String replace(..)");
    private static final DataFlowSpec INSECURE_URI_CREATE = new DataFlowSpec(){

        @Override
        public boolean isSource(DataFlowNode srcNode) {
            return (Boolean)srcNode.asExpr(Literal.class).bind(Literal::getValue).map(v -> v.toString().startsWith("http://")).orSome((Object)false);
        }

        @Override
        public boolean isSink(DataFlowNode sinkNode) {
            return URI_CREATE.advanced().isAnyArgument(sinkNode.getCursor());
        }

        @Override
        public boolean isAdditionalFlowStep(DataFlowNode srcNode, DataFlowNode sinkNode) {
            return (Boolean)sinkNode.asExpr(BinaryExpr.class).bind(srcNode.asExpr(), binary -> src -> binary.getLeft().equals(src)).orSome((Object)false);
        }

        @Override
        public boolean isBarrierGuard(Guard guard, boolean branch) {
            return STRING_REPLACE.matches(guard.getExpression());
        }
    };
    final String displayName = "URIs created with an HTTP scheme";
    final String description = "This is a sample recipe demonstrating a simple application of local data flow analysis.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesInvocation(URI_CREATE), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                J.Literal l = super.visitLiteral(literal, (Object)ctx);
                if (Dataflow.startingAt(this.getCursor()).findSinks(INSECURE_URI_CREATE).isSome()) {
                    return l.withValue((Object)l.getValue().toString().replace("http://", "https://")).withValueSource(l.getValueSource().replace("http://", "https://"));
                }
                return l;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

