/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.controlflow;

import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.openrewrite.analysis.controlflow.ControlFlowDotFileGenerator;
import org.openrewrite.analysis.controlflow.ControlFlowNode;
import org.openrewrite.analysis.controlflow.ControlFlowSummary;
import org.openrewrite.internal.lang.Nullable;

final class ControlFlowSummaryDotVisualizer
implements ControlFlowDotFileGenerator {
    ControlFlowSummaryDotVisualizer() {
    }

    @Override
    public String visualizeAsDotfile(String name, boolean darkMode, ControlFlowSummary summary) {
        ControlFlowNode node;
        StringBuilder sb = new StringBuilder("digraph ").append(name).append(" {\n");
        sb.append("    rankdir = TB;\n");
        sb.append("    edge [fontname=Arial];");
        if (darkMode) {
            sb.append("\n    graph [bgcolor=black];\n    node [color=white, fontcolor=whitesmoke];\n    edge [fontname=Arial; color=whitesmoke];");
        }
        IdentityHashMap<ControlFlowNode, Integer> abstractToVisualNodeMapping = new IdentityHashMap<ControlFlowNode, Integer>(summary.getAllNodes().size());
        List nodeToNodeText = summary.getAllNodes().stream().map(NodeToNodeText::new).sorted().collect(Collectors.toList());
        int vizSrc = -1;
        int vizSink = -1;
        for (int i = 0; i < nodeToNodeText.size(); ++i) {
            ControlFlowNode.GraphTerminator terminator;
            NodeToNodeText toNodeText = (NodeToNodeText)nodeToNodeText.get(i);
            node = toNodeText.node;
            String nodeText = toNodeText.nodeText;
            abstractToVisualNodeMapping.put(node, i);
            if (node instanceof ControlFlowNode.GraphTerminator && (terminator = (ControlFlowNode.GraphTerminator)((Object)node)).getGraphType() == ControlFlowNode.GraphType.METHOD_BODY_OR_STATIC_INITIALIZER_OR_INSTANCE_INITIALIZER) {
                if (node instanceof ControlFlowNode.Start) {
                    vizSrc = i;
                } else if (node instanceof ControlFlowNode.End) {
                    vizSink = i;
                }
            }
            String shape = ControlFlowSummaryDotVisualizer.getShape(node);
            String fontName = ControlFlowSummaryDotVisualizer.getFont(node);
            sb.append("\n    ").append(i).append(" [shape=").append(shape).append(", label=\"").append(nodeText).append("\", fontname=\"").append(fontName).append("\"];");
        }
        for (NodeToNodeText toNodeText : nodeToNodeText) {
            node = toNodeText.node;
            if (node instanceof ControlFlowNode.ConditionNode) {
                ControlFlowNode.ConditionNode cn = (ControlFlowNode.ConditionNode)node;
                sb.append("\n    ").append(abstractToVisualNodeMapping.get(node)).append(" -> ").append(abstractToVisualNodeMapping.get(cn.getTruthySuccessor()));
                if (!cn.isAlwaysFalse()) {
                    sb.append(" [label=\"True\", ");
                    if (darkMode) {
                        sb.append("color=\"darkgreen\" fontcolor=\"darkgreen\"];");
                    } else {
                        sb.append("color=\"green3\" fontcolor=\"green3\"];");
                    }
                } else {
                    sb.append(" [label=\"Unreachable\", color=\"grey\" fontcolor=\"grey\" style=dashed];");
                }
                sb.append("\n    ").append(abstractToVisualNodeMapping.get(node)).append(" -> ").append(abstractToVisualNodeMapping.get(cn.getFalsySuccessor()));
                if (!cn.isAlwaysTrue()) {
                    sb.append(" [label=\"False\", color=\"red\" fontcolor=\"red\"];");
                    continue;
                }
                sb.append(" [label=\"Unreachable\", color=\"grey\" fontcolor=\"grey\" style=dashed];");
                continue;
            }
            for (ControlFlowNode successor : node.getSuccessors()) {
                sb.append("\n    ").append(abstractToVisualNodeMapping.get(node)).append(" -> ").append(abstractToVisualNodeMapping.get(successor)).append(";");
            }
        }
        if (vizSrc != -1 && vizSink != -1) {
            sb.append("\n    {rank=\"src\";").append(vizSrc).append("};\n");
            sb.append("    {rank=\"sink\";").append(vizSink).append("};");
        }
        sb.append('\n').append('}');
        return sb.toString();
    }

    private static String getShape(ControlFlowNode node) {
        if (node instanceof ControlFlowNode.Start || node instanceof ControlFlowNode.End) {
            ControlFlowNode.GraphTerminator graphTerminator = (ControlFlowNode.GraphTerminator)((Object)node);
            if (ControlFlowNode.GraphType.METHOD_BODY_OR_STATIC_INITIALIZER_OR_INSTANCE_INITIALIZER == graphTerminator.getGraphType()) {
                return "circle";
            }
            return "oval";
        }
        if (node instanceof ControlFlowNode.ConditionNode) {
            return "diamond";
        }
        return "box";
    }

    private static String getFont(ControlFlowNode node) {
        if (node instanceof ControlFlowNode.Start || node instanceof ControlFlowNode.End) {
            return "Arial";
        }
        return "Courier";
    }

    private static final class NodeToNodeText
    implements Comparable<NodeToNodeText> {
        private static Comparator<NodeToNodeText> comparator = Comparator.comparingInt(NodeToNodeText::comparingType).thenComparing(NodeToNodeText::getNodeText);
        private final @NonNull ControlFlowNode node;
        private final String nodeText;

        NodeToNodeText(ControlFlowNode node) {
            this.node = node;
            this.nodeText = node instanceof ControlFlowNode.BasicBlock ? node.toVisualizerString().replace("\"", "\\\"").replace("\n", "\\l") + "\\l" : node.toVisualizerString().replace("\"", "\\\"");
        }

        @Override
        public int compareTo(@NonNull NodeToNodeText o) {
            if (this.equals(o)) {
                return 0;
            }
            return comparator.compare(this, o);
        }

        private int comparingType() {
            if (this.node instanceof ControlFlowNode.Start) {
                ControlFlowNode.Start start = (ControlFlowNode.Start)this.node;
                if (ControlFlowNode.GraphType.METHOD_BODY_OR_STATIC_INITIALIZER_OR_INSTANCE_INITIALIZER == start.getGraphType()) {
                    return -2;
                }
                return -1;
            }
            if (this.node instanceof ControlFlowNode.End) {
                ControlFlowNode.End end = (ControlFlowNode.End)this.node;
                if (ControlFlowNode.GraphType.METHOD_BODY_OR_STATIC_INITIALIZER_OR_INSTANCE_INITIALIZER == end.getGraphType()) {
                    return 2;
                }
                return 1;
            }
            return 0;
        }

        @Generated
        public @NonNull ControlFlowNode getNode() {
            return this.node;
        }

        @Generated
        public String getNodeText() {
            return this.nodeText;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NodeToNodeText)) {
                return false;
            }
            NodeToNodeText other = (NodeToNodeText)o;
            ControlFlowNode this$node = this.getNode();
            ControlFlowNode other$node = other.getNode();
            if (this$node == null ? other$node != null : !this$node.equals(other$node)) {
                return false;
            }
            String this$nodeText = this.getNodeText();
            String other$nodeText = other.getNodeText();
            return !(this$nodeText == null ? other$nodeText != null : !this$nodeText.equals(other$nodeText));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ControlFlowNode $node = this.getNode();
            result = result * 59 + ($node == null ? 43 : $node.hashCode());
            String $nodeText = this.getNodeText();
            result = result * 59 + ($nodeText == null ? 43 : $nodeText.hashCode());
            return result;
        }

        @org.openrewrite.internal.lang.NonNull
        @Generated
        public String toString() {
            return "ControlFlowSummaryDotVisualizer.NodeToNodeText(node=" + this.getNode() + ", nodeText=" + this.getNodeText() + ")";
        }
    }
}

