/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Result;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AbstractRewriteMojo;
import org.openrewrite.maven.ConfigurableRewriteMojo;

public class AbstractRewriteDryRunMojo
extends AbstractRewriteMojo {
    @Nullable
    @Parameter(property="reportOutputDirectory")
    private String reportOutputDirectory;
    @Parameter(property="failOnDryRunResults", defaultValue="false")
    private boolean failOnDryRunResults;

    public void execute() throws MojoExecutionException {
        if (this.rewriteSkip) {
            this.getLog().info((CharSequence)"Skipping execution");
            this.putState(ConfigurableRewriteMojo.State.SKIPPED);
            return;
        }
        this.putState(ConfigurableRewriteMojo.State.TO_BE_PROCESSED);
        if (!this.runPerSubmodule && !this.allProjectsMarked()) {
            this.getLog().info((CharSequence)("REWRITE: Delaying execution to the end of multi-module project for " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion()));
            return;
        }
        ExecutionContext ctx = this.executionContext();
        AbstractRewriteMojo.ResultsContainer results = this.listResults(ctx);
        RuntimeException firstException = results.getFirstException();
        if (firstException != null) {
            this.getLog().error((CharSequence)"The recipe produced an error. Please report this to the recipe author.");
            throw firstException;
        }
        if (results.isNotEmpty()) {
            for (Result result : results.generated) {
                assert (result.getAfter() != null);
                this.getLog().warn((CharSequence)("These recipes would generate a new file " + result.getAfter().getSourcePath() + ":"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.deleted) {
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("These recipes would delete a file " + result.getBefore().getSourcePath() + ":"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.moved) {
                assert (result.getBefore() != null);
                assert (result.getAfter() != null);
                this.getLog().warn((CharSequence)("These recipes would move a file from " + result.getBefore().getSourcePath() + " to " + result.getAfter().getSourcePath() + ":"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.refactoredInPlace) {
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("These recipes would make changes to " + result.getBefore().getSourcePath() + ":"));
                this.logRecipesThatMadeChanges(result);
            }
            Path outPath = this.reportOutputDirectory != null ? Paths.get(this.reportOutputDirectory, new String[0]) : (this.runPerSubmodule ? Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("rewrite") : Paths.get(this.mavenSession.getTopLevelProject().getBuild().getDirectory(), new String[0]).resolve("rewrite"));
            try {
                Files.createDirectories(outPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create the folder [ " + outPath + "].", e);
            }
            Path patchFile = outPath.resolve("rewrite.patch");
            try (BufferedWriter writer = Files.newBufferedWriter(patchFile, new OpenOption[0]);){
                Stream.concat(Stream.concat(results.generated.stream(), results.deleted.stream()), Stream.concat(results.moved.stream(), results.refactoredInPlace.stream())).map(Result::diff).forEach(diff -> {
                    try {
                        writer.write(diff + "\n");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to generate rewrite result.", e);
            }
            this.getLog().warn((CharSequence)"Patch file available:");
            this.getLog().warn((CharSequence)("    " + patchFile.normalize()));
            this.getLog().warn((CharSequence)"Run 'mvn rewrite:run' to apply the recipes.");
            if (this.failOnDryRunResults) {
                throw new MojoExecutionException("Applying recipes would make changes. See logs for more details.");
            }
        } else {
            this.getLog().info((CharSequence)"Applying recipes would make no changes. No patch file generated.");
        }
        this.putState(ConfigurableRewriteMojo.State.PROCESSED);
    }
}

