/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.tree.J;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.marker.Generated;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.OperatingSystemProvenance;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.ResourceParser;
import org.openrewrite.maven.cache.CompositeMavenPomCache;
import org.openrewrite.maven.cache.InMemoryMavenPomCache;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.cache.RocksdbMavenPomCache;
import org.openrewrite.maven.internal.RawRepositories;
import org.openrewrite.maven.tree.ProfileActivation;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingExecutionContextView;
import org.openrewrite.xml.tree.Xml;

public class MavenMojoProjectParser {
    @Nullable
    static MavenPomCache pomCache;
    private final Log logger;
    private final AtomicBoolean firstWarningLogged = new AtomicBoolean(false);
    private final Path baseDir;
    private final boolean pomCacheEnabled;
    @Nullable
    private final String pomCacheDirectory;
    private final boolean skipMavenParsing;
    private final BuildTool buildTool;
    private final Collection<String> exclusions;
    private final Collection<String> plainTextMasks;
    private final int sizeThresholdMb;
    private final MavenSession mavenSession;
    private final SettingsDecrypter settingsDecrypter;
    private final boolean runPerSubmodule;
    private final boolean parseAdditionalResources;

    @Deprecated
    public MavenMojoProjectParser(Log logger, Path baseDir, boolean pomCacheEnabled, @Nullable String pomCacheDirectory, RuntimeInformation runtime, boolean skipMavenParsing, Collection<String> exclusions, Collection<String> plainTextMasks, int sizeThresholdMb, MavenSession session, SettingsDecrypter settingsDecrypter, boolean runPerSubmodule) {
        this(logger, baseDir, pomCacheEnabled, pomCacheDirectory, runtime, skipMavenParsing, exclusions, plainTextMasks, sizeThresholdMb, session, settingsDecrypter, runPerSubmodule, false);
    }

    public MavenMojoProjectParser(Log logger, Path baseDir, boolean pomCacheEnabled, @Nullable String pomCacheDirectory, RuntimeInformation runtime, boolean skipMavenParsing, Collection<String> exclusions, Collection<String> plainTextMasks, int sizeThresholdMb, MavenSession session, SettingsDecrypter settingsDecrypter, boolean runPerSubmodule, boolean parseAdditionalResources) {
        this.logger = logger;
        this.baseDir = baseDir;
        this.pomCacheEnabled = pomCacheEnabled;
        this.pomCacheDirectory = pomCacheDirectory;
        this.skipMavenParsing = skipMavenParsing;
        this.buildTool = new BuildTool(Tree.randomId(), BuildTool.Type.Maven, runtime.getMavenVersion());
        this.exclusions = exclusions;
        this.plainTextMasks = plainTextMasks;
        this.sizeThresholdMb = sizeThresholdMb;
        this.mavenSession = session;
        this.settingsDecrypter = settingsDecrypter;
        this.runPerSubmodule = runPerSubmodule;
        this.parseAdditionalResources = parseAdditionalResources;
    }

    public Stream<SourceFile> listSourceFiles(MavenProject mavenProject, List<NamedStyles> styles, ExecutionContext ctx) throws DependencyResolutionRequiredException, MojoExecutionException {
        if (this.runPerSubmodule) {
            List<Marker> projectProvenance = this.generateProvenance(mavenProject);
            Xml.Document maven = this.parseMaven(mavenProject, projectProvenance, ctx);
            return this.listSourceFiles(mavenProject, maven, projectProvenance, styles, ctx);
        }
        Map<MavenProject, List<Marker>> projectProvenances = this.mavenSession.getProjects().stream().collect(Collectors.toMap(Function.identity(), this::generateProvenance));
        Map<MavenProject, Xml.Document> projectMap = this.parseMaven(this.mavenSession.getProjects(), projectProvenances, ctx);
        return this.mavenSession.getProjects().stream().flatMap(project -> {
            List projectProvenance = (List)projectProvenances.get(project);
            try {
                return this.listSourceFiles((MavenProject)project, (Xml.Document)projectMap.get(project), projectProvenance, styles, ctx);
            }
            catch (DependencyResolutionRequiredException | MojoExecutionException e) {
                throw (RuntimeException)MavenMojoProjectParser.sneakyThrow(e);
            }
        });
    }

    public Stream<SourceFile> listSourceFiles(MavenProject mavenProject, @Nullable Xml.Document maven, List<Marker> projectProvenance, List<NamedStyles> styles, ExecutionContext ctx) throws DependencyResolutionRequiredException, MojoExecutionException {
        Object mavenSourceEncoding;
        Stream<Object> sourceFiles = Stream.empty();
        HashSet<Path> alreadyParsed = new HashSet<Path>();
        if (maven != null) {
            sourceFiles = Stream.of(maven);
            alreadyParsed.add(this.baseDir.resolve(maven.getSourcePath()));
        }
        if ((mavenSourceEncoding = mavenProject.getProperties().get("project.build.sourceEncoding")) != null) {
            ParsingExecutionContextView.view((ExecutionContext)ctx).setCharset(Charset.forName(mavenSourceEncoding.toString()));
        }
        JavaParser.Builder javaParserBuilder = JavaParser.fromJavaVersion().styles(styles).logCompilationWarningsAndErrors(false);
        KotlinParser.Builder kotlinParserBuilder = KotlinParser.builder();
        ResourceParser rp = new ResourceParser(this.baseDir, this.logger, this.exclusions, this.plainTextMasks, this.sizeThresholdMb, this.pathsToOtherMavenProjects(mavenProject), javaParserBuilder.clone(), kotlinParserBuilder.clone());
        sourceFiles = Stream.concat(sourceFiles, this.processMainSources(mavenProject, javaParserBuilder.clone(), kotlinParserBuilder.clone(), rp, projectProvenance, alreadyParsed, ctx));
        sourceFiles = Stream.concat(sourceFiles, this.processTestSources(mavenProject, javaParserBuilder.clone(), kotlinParserBuilder.clone(), rp, projectProvenance, alreadyParsed, ctx));
        Collection exclusionMatchers = this.exclusions.stream().map(pattern -> this.baseDir.getFileSystem().getPathMatcher("glob:" + pattern)).collect(Collectors.toList());
        sourceFiles = sourceFiles.map(sourceFile -> {
            if (sourceFile instanceof J.CompilationUnit) {
                for (PathMatcher excluded : exclusionMatchers) {
                    if (!excluded.matches(sourceFile.getSourcePath())) continue;
                    return null;
                }
            }
            return sourceFile;
        }).filter(Objects::nonNull);
        if (this.parseAdditionalResources) {
            int sourcesParsedBefore = alreadyParsed.size();
            Stream parsedResourceFiles = rp.parse(mavenProject.getBasedir().toPath(), alreadyParsed).map(this.addProvenance(this.baseDir, projectProvenance, null));
            this.logDebug(mavenProject, "Parsed " + (alreadyParsed.size() - sourcesParsedBefore) + " additional files found within the project.");
            sourceFiles = Stream.concat(sourceFiles, parsedResourceFiles);
        }
        return sourceFiles.map(this::logParseErrors);
    }

    private SourceFile logParseErrors(SourceFile source) {
        if (source instanceof ParseError) {
            if (this.firstWarningLogged.compareAndSet(false, true)) {
                this.logger.warn((CharSequence)("There were problems parsing some source files" + (this.mavenSession.getRequest().isShowErrors() ? "" : ", run with --errors to see full stack traces")));
            }
            this.logger.warn((CharSequence)("There were problems parsing " + source.getSourcePath()));
        }
        return source;
    }

    public List<Marker> generateProvenance(MavenProject mavenProject) {
        String javaRuntimeVersion = System.getProperty("java.specification.version");
        String javaVendor = System.getProperty("java.vm.vendor");
        String sourceCompatibility = null;
        String targetCompatibility = null;
        Plugin compilerPlugin = mavenProject.getPlugin("org.apache.maven.plugins:maven-compiler-plugin");
        if (compilerPlugin != null && compilerPlugin.getConfiguration() instanceof Xpp3Dom) {
            Xpp3Dom dom = (Xpp3Dom)compilerPlugin.getConfiguration();
            Xpp3Dom release = dom.getChild("release");
            if (release != null && StringUtils.isNotEmpty((String)release.getValue()) && !release.getValue().contains("${")) {
                sourceCompatibility = release.getValue();
                targetCompatibility = release.getValue();
            } else {
                Xpp3Dom target;
                Xpp3Dom source = dom.getChild("source");
                if (source != null && StringUtils.isNotEmpty((String)source.getValue()) && !source.getValue().contains("${")) {
                    sourceCompatibility = source.getValue();
                }
                if ((target = dom.getChild("target")) != null && StringUtils.isNotEmpty((String)target.getValue()) && !target.getValue().contains("${")) {
                    targetCompatibility = target.getValue();
                }
            }
        }
        if (sourceCompatibility == null || targetCompatibility == null) {
            String propertiesReleaseCompatibility = (String)mavenProject.getProperties().get("maven.compiler.release");
            if (propertiesReleaseCompatibility != null) {
                sourceCompatibility = propertiesReleaseCompatibility;
                targetCompatibility = propertiesReleaseCompatibility;
            } else {
                String propertiesSourceCompatibility = (String)mavenProject.getProperties().get("maven.compiler.source");
                if (sourceCompatibility == null && propertiesSourceCompatibility != null) {
                    sourceCompatibility = propertiesSourceCompatibility;
                }
                String propertiesTargetCompatibility = (String)mavenProject.getProperties().get("maven.compiler.target");
                if (targetCompatibility == null && propertiesTargetCompatibility != null) {
                    targetCompatibility = propertiesTargetCompatibility;
                }
            }
        }
        if (sourceCompatibility == null) {
            sourceCompatibility = javaRuntimeVersion;
        }
        if (targetCompatibility == null) {
            targetCompatibility = sourceCompatibility;
        }
        BuildEnvironment buildEnvironment = BuildEnvironment.build(System::getenv);
        return Stream.of(buildEnvironment, this.gitProvenance(this.baseDir, buildEnvironment), OperatingSystemProvenance.current(), this.buildTool, new JavaVersion(Tree.randomId(), javaRuntimeVersion, javaVendor, sourceCompatibility, targetCompatibility), new JavaProject(Tree.randomId(), mavenProject.getName(), new JavaProject.Publication(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion()))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Stream<SourceFile> processMainSources(MavenProject mavenProject, JavaParser.Builder<? extends JavaParser, ?> javaParserBuilder, KotlinParser.Builder kotlinParserBuilder, ResourceParser resourceParser, List<Marker> projectProvenance, Set<Path> alreadyParsed, ExecutionContext ctx) throws DependencyResolutionRequiredException, MojoExecutionException {
        List<Path> generatedSourcePaths = MavenMojoProjectParser.listJavaSources(mavenProject.getBasedir().toPath().resolve(mavenProject.getBuild().getDirectory()));
        List mainJavaSources = Stream.concat(generatedSourcePaths.stream(), MavenMojoProjectParser.listJavaSources(mavenProject.getBasedir().toPath().resolve(mavenProject.getBuild().getSourceDirectory())).stream()).collect(Collectors.toList());
        alreadyParsed.addAll(mainJavaSources);
        String kotlinSourceDir = this.getKotlinDirectory(mavenProject.getBuild().getSourceDirectory());
        List mainKotlinSources = kotlinSourceDir != null ? MavenMojoProjectParser.listKotlinSources(mavenProject.getBasedir().toPath().resolve(kotlinSourceDir)) : Collections.emptyList();
        alreadyParsed.addAll(mainKotlinSources);
        this.logInfo(mavenProject, "Parsing source files");
        List<Path> dependencies = mavenProject.getCompileClasspathElements().stream().distinct().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        JavaTypeCache typeCache = new JavaTypeCache();
        javaParserBuilder.classpath(dependencies).typeCache(typeCache);
        kotlinParserBuilder.classpath(dependencies).typeCache(new JavaTypeCache());
        Stream cus = Stream.of(javaParserBuilder).map(JavaParser.Builder::build).flatMap(parser -> parser.parse((Iterable)mainJavaSources, this.baseDir, ctx));
        Stream kcus = Stream.of(kotlinParserBuilder).map(KotlinParser.Builder::build).flatMap(parser -> parser.parse((Iterable)mainKotlinSources, this.baseDir, ctx));
        ArrayList<Marker> mainProjectProvenance = new ArrayList<Marker>(projectProvenance);
        mainProjectProvenance.add((Marker)MavenMojoProjectParser.sourceSet("main", dependencies, typeCache));
        Stream parsedJava = cus.map(this.addProvenance(this.baseDir, mainProjectProvenance, generatedSourcePaths));
        this.logDebug(mavenProject, "Scanned " + mainJavaSources.size() + " java source files in main scope.");
        Stream parsedKotlin = kcus.map(this.addProvenance(this.baseDir, mainProjectProvenance, generatedSourcePaths));
        this.logDebug(mavenProject, "Scanned " + mainKotlinSources.size() + " kotlin source files in main scope.");
        Path buildDirectory = this.baseDir.relativize(Paths.get(mavenProject.getBuild().getDirectory(), new String[0]));
        Stream<SourceFile> sourceFiles = Stream.concat(parsedJava, parsedKotlin).filter(s -> !s.getSourcePath().startsWith(buildDirectory));
        int sourcesParsedBefore = alreadyParsed.size();
        Stream parsedResourceFiles = resourceParser.parse(mavenProject.getBasedir().toPath().resolve("src/main/resources"), alreadyParsed).map(this.addProvenance(this.baseDir, mainProjectProvenance, null));
        this.logDebug(mavenProject, "Scanned " + (alreadyParsed.size() - sourcesParsedBefore) + " resource files in main scope.");
        sourceFiles = Stream.concat(sourceFiles, parsedResourceFiles);
        return sourceFiles;
    }

    private Stream<SourceFile> processTestSources(MavenProject mavenProject, JavaParser.Builder<? extends JavaParser, ?> javaParserBuilder, KotlinParser.Builder kotlinParserBuilder, ResourceParser resourceParser, List<Marker> projectProvenance, Set<Path> alreadyParsed, ExecutionContext ctx) throws DependencyResolutionRequiredException, MojoExecutionException {
        List<Path> testDependencies = mavenProject.getTestClasspathElements().stream().distinct().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        JavaTypeCache typeCache = new JavaTypeCache();
        javaParserBuilder.classpath(testDependencies).typeCache(typeCache);
        kotlinParserBuilder.classpath(testDependencies).typeCache(new JavaTypeCache());
        List<Path> testJavaSources = MavenMojoProjectParser.listJavaSources(mavenProject.getBasedir().toPath().resolve(mavenProject.getBuild().getTestSourceDirectory()));
        alreadyParsed.addAll(testJavaSources);
        String kotlinSourceDir = this.getKotlinDirectory(mavenProject.getBuild().getSourceDirectory());
        List testKotlinSources = kotlinSourceDir != null ? MavenMojoProjectParser.listKotlinSources(mavenProject.getBasedir().toPath().resolve(kotlinSourceDir)) : Collections.emptyList();
        alreadyParsed.addAll(testKotlinSources);
        Stream cus = Stream.of(javaParserBuilder).map(JavaParser.Builder::build).flatMap(parser -> parser.parse((Iterable)testJavaSources, this.baseDir, ctx));
        Stream kcus = Stream.of(kotlinParserBuilder).map(KotlinParser.Builder::build).flatMap(parser -> parser.parse((Iterable)testKotlinSources, this.baseDir, ctx));
        ArrayList<Marker> markers = new ArrayList<Marker>(projectProvenance);
        markers.add((Marker)MavenMojoProjectParser.sourceSet("test", testDependencies, typeCache));
        Stream parsedJava = cus.map(this.addProvenance(this.baseDir, markers, null));
        this.logDebug(mavenProject, "Scanned " + testJavaSources.size() + " java source files in test scope.");
        Stream parsedKotlin = kcus.map(this.addProvenance(this.baseDir, markers, null));
        this.logDebug(mavenProject, "Scanned " + testKotlinSources.size() + " kotlin source files in main scope.");
        Stream<SourceFile> sourceFiles = Stream.concat(parsedJava, parsedKotlin);
        int sourcesParsedBefore = alreadyParsed.size();
        Stream parsedResourceFiles = resourceParser.parse(mavenProject.getBasedir().toPath().resolve("src/test/resources"), alreadyParsed).map(this.addProvenance(this.baseDir, markers, null));
        this.logDebug(mavenProject, "Scanned " + (alreadyParsed.size() - sourcesParsedBefore) + " resource files in test scope.");
        sourceFiles = Stream.concat(sourceFiles, parsedResourceFiles);
        return sourceFiles;
    }

    @Nullable
    private String getKotlinDirectory(@Nullable String sourceDirectory) {
        File[] subdirectories;
        if (sourceDirectory == null) {
            return null;
        }
        File directory = new File(sourceDirectory);
        File parentDirectory = directory.getParentFile();
        if (parentDirectory != null && (subdirectories = parentDirectory.listFiles(File::isDirectory)) != null) {
            for (File subdirectory : subdirectories) {
                if (!subdirectory.getName().equals("kotlin")) continue;
                return subdirectory.getAbsolutePath();
            }
        }
        return null;
    }

    @NotNull
    private static JavaSourceSet sourceSet(String name, List<Path> dependencies, JavaTypeCache typeCache) {
        return JavaSourceSet.build((String)name, dependencies, (JavaTypeCache)typeCache, (boolean)false);
    }

    @Nullable
    public Xml.Document parseMaven(MavenProject mavenProject, List<Marker> projectProvenance, ExecutionContext ctx) {
        return this.parseMaven(Collections.singletonList(mavenProject), Collections.singletonMap(mavenProject, projectProvenance), ctx).get(mavenProject);
    }

    public Map<MavenProject, Xml.Document> parseMaven(List<MavenProject> mavenProjects, Map<MavenProject, List<Marker>> projectProvenances, ExecutionContext ctx) {
        List<String> activeProfiles;
        if (this.skipMavenParsing) {
            this.logger.info((CharSequence)"Skipping Maven parsing...");
            return Collections.emptyMap();
        }
        MavenProject topLevelProject = this.mavenSession.getTopLevelProject();
        this.logInfo(topLevelProject, "Resolving Poms...");
        LinkedHashSet allPoms = new LinkedHashSet();
        mavenProjects.forEach(p -> this.collectPoms((MavenProject)p, allPoms));
        for (MavenProject mavenProject : mavenProjects) {
            this.mavenSession.getProjectDependencyGraph().getUpstreamProjects(mavenProject, true).forEach(p -> this.collectPoms((MavenProject)p, allPoms));
        }
        MavenParser.Builder mavenParserBuilder = MavenParser.builder().mavenConfig(this.baseDir.resolve(".mvn/maven.config"));
        MavenSettings settings = this.buildSettings();
        MavenExecutionContextView mavenExecutionContext = MavenExecutionContextView.view((ExecutionContext)ctx);
        mavenExecutionContext.setMavenSettings(settings, new String[0]);
        if (this.pomCacheEnabled) {
            mavenExecutionContext.setPomCache(MavenMojoProjectParser.getPomCache(this.pomCacheDirectory, this.logger));
        }
        if (!(activeProfiles = topLevelProject.getActiveProfiles().stream().map(Profile::getId).collect(Collectors.toList())).isEmpty()) {
            mavenParserBuilder.activeProfiles(activeProfiles.toArray(new String[0]));
        }
        List mavens = mavenParserBuilder.build().parse(allPoms, this.baseDir, ctx).collect(Collectors.toList());
        if (this.logger.isDebugEnabled()) {
            this.logDebug(topLevelProject, "Base directory : '" + this.baseDir + "'");
            if (allPoms.isEmpty()) {
                this.logDebug(topLevelProject, "There were no collected pom paths.");
            } else {
                for (Path path : allPoms) {
                    this.logDebug(topLevelProject, "  Collected Maven POM : '" + path + "'");
                }
            }
            if (mavens.isEmpty()) {
                this.logDebug(topLevelProject, "There were no parsed maven source files.");
            } else {
                for (SourceFile source : mavens) {
                    this.logDebug(topLevelProject, "  Maven Source : '" + this.baseDir.resolve(source.getSourcePath()) + "'");
                }
            }
        }
        Map projectsByPath = mavenProjects.stream().collect(Collectors.toMap(MavenMojoProjectParser::pomPath, Function.identity()));
        HashMap<MavenProject, Xml.Document> projectMap = new HashMap<MavenProject, Xml.Document>();
        for (SourceFile document : mavens) {
            Path path = this.baseDir.resolve(document.getSourcePath());
            MavenProject mavenProject = (MavenProject)projectsByPath.get(path);
            if (mavenProject == null) continue;
            if (document instanceof Xml.Document) {
                projectMap.put(mavenProject, (Xml.Document)document);
                continue;
            }
            if (!(document instanceof ParseError)) continue;
            this.logError(mavenProject, "Parse error in Maven Project File '" + path + "': " + document);
        }
        for (MavenProject mavenProject : mavenProjects) {
            if (projectMap.get(mavenProject) != null) continue;
            this.logError(mavenProject, "Parse resulted in no Maven source files. Maven Project File '" + mavenProject.getFile().toPath() + "'");
            return Collections.emptyMap();
        }
        for (MavenProject mavenProject : mavenProjects) {
            Xml.Document document = (Xml.Document)projectMap.get(mavenProject);
            List provenance = projectProvenances.getOrDefault(mavenProject, Collections.emptyList());
            Markers markers = document.getMarkers();
            for (Marker marker : provenance) {
                markers = markers.addIfAbsent(marker);
            }
            projectMap.put(mavenProject, document.withMarkers(markers));
        }
        return projectMap;
    }

    private void collectPoms(MavenProject project, Set<Path> paths) {
        paths.add(MavenMojoProjectParser.pomPath(project));
        if (project.getCollectedProjects() != null) {
            for (MavenProject child : project.getCollectedProjects()) {
                Path path = MavenMojoProjectParser.pomPath(child);
                if (paths.contains(path)) continue;
                this.collectPoms(child, paths);
            }
        }
        for (MavenProject parent = project.getParent(); parent != null && parent.getFile() != null; parent = parent.getParent()) {
            Path path = MavenMojoProjectParser.pomPath(parent);
            if (paths.contains(path)) continue;
            this.collectPoms(parent, paths);
        }
    }

    private static Path pomPath(MavenProject mavenProject) {
        Path normalPom;
        Path pomPath = mavenProject.getFile().toPath();
        if (pomPath.endsWith(".flattened-pom.xml")) {
            return mavenProject.getBasedir().toPath().resolve("pom.xml");
        }
        if (pomPath.endsWith(".tycho-consumer-pom.xml") && Files.isReadable(normalPom = mavenProject.getBasedir().toPath().resolve("pom.xml")) && Files.isRegularFile(normalPom, new LinkOption[0])) {
            return normalPom;
        }
        return pomPath;
    }

    private static MavenPomCache getPomCache(@Nullable String pomCacheDirectory, Log logger) {
        block7: {
            if (pomCache == null) {
                if (MavenMojoProjectParser.isJvm64Bit()) {
                    try {
                        if (pomCacheDirectory == null) {
                            pomCache = new CompositeMavenPomCache((MavenPomCache)new InMemoryMavenPomCache(), (MavenPomCache)new RocksdbMavenPomCache(Paths.get(System.getProperty("user.home"), new String[0])));
                            break block7;
                        }
                        pomCache = new CompositeMavenPomCache((MavenPomCache)new InMemoryMavenPomCache(), (MavenPomCache)new RocksdbMavenPomCache(Paths.get(pomCacheDirectory, new String[0])));
                    }
                    catch (Throwable e) {
                        logger.warn((CharSequence)"Unable to initialize RocksdbMavenPomCache, falling back to InMemoryMavenPomCache");
                        logger.debug(e);
                    }
                } else {
                    logger.warn((CharSequence)"RocksdbMavenPomCache is not supported on 32-bit JVM. falling back to InMemoryMavenPomCache");
                }
            }
        }
        if (pomCache == null) {
            pomCache = new InMemoryMavenPomCache();
        }
        return pomCache;
    }

    private static boolean isJvm64Bit() {
        return !"32".equals(System.getProperty("sun.arch.data.model", "64"));
    }

    public MavenSettings buildSettings() {
        MavenExecutionRequest mer = this.mavenSession.getRequest();
        MavenSettings.Profiles profiles = new MavenSettings.Profiles();
        profiles.setProfiles(mer.getProfiles().stream().map(p -> new MavenSettings.Profile(p.getId(), p.getActivation() == null ? null : new ProfileActivation(Boolean.valueOf(p.getActivation().isActiveByDefault()), p.getActivation().getJdk(), p.getActivation().getProperty() == null ? null : new ProfileActivation.Property(p.getActivation().getProperty().getName(), p.getActivation().getProperty().getValue())), MavenMojoProjectParser.buildRawRepositories(p.getRepositories()))).collect(Collectors.toList()));
        MavenSettings.ActiveProfiles activeProfiles = new MavenSettings.ActiveProfiles();
        activeProfiles.setActiveProfiles(mer.getActiveProfiles());
        MavenSettings.Mirrors mirrors = new MavenSettings.Mirrors();
        mirrors.setMirrors(mer.getMirrors().stream().map(m -> new MavenSettings.Mirror(m.getId(), m.getUrl(), m.getMirrorOf(), null, null)).collect(Collectors.toList()));
        MavenSettings.Servers servers = new MavenSettings.Servers();
        servers.setServers(mer.getServers().stream().map(s -> {
            DefaultSettingsDecryptionRequest decryptionRequest = new DefaultSettingsDecryptionRequest(s);
            SettingsDecryptionResult decryptionResult = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)decryptionRequest);
            return new MavenSettings.Server(s.getId(), s.getUsername(), decryptionResult.getServer().getPassword(), null);
        }).collect(Collectors.toList()));
        return new MavenSettings(mer.getLocalRepositoryPath().toString(), profiles, activeProfiles, mirrors, servers);
    }

    @Nullable
    private static RawRepositories buildRawRepositories(@Nullable List<Repository> repositoriesToMap) {
        if (repositoriesToMap == null) {
            return null;
        }
        RawRepositories rawRepositories = new RawRepositories();
        List transformedRepositories = repositoriesToMap.stream().map(r -> new RawRepositories.Repository(r.getId(), r.getUrl(), r.getReleases() == null ? null : new RawRepositories.ArtifactPolicy(Boolean.toString(r.getReleases().isEnabled())), r.getSnapshots() == null ? null : new RawRepositories.ArtifactPolicy(Boolean.toString(r.getSnapshots().isEnabled())))).collect(Collectors.toList());
        rawRepositories.setRepositories(transformedRepositories);
        return rawRepositories;
    }

    private Set<Path> pathsToOtherMavenProjects(MavenProject mavenProject) {
        return this.mavenSession.getProjects().stream().filter(o -> o != mavenProject).map(o -> o.getBasedir().toPath()).collect(Collectors.toSet());
    }

    private <T extends SourceFile> UnaryOperator<T> addProvenance(Path baseDir, List<Marker> provenance, @Nullable Collection<Path> generatedSources) {
        return s -> {
            Markers markers = s.getMarkers();
            for (Marker marker : provenance) {
                markers = markers.addIfAbsent(marker);
            }
            if (generatedSources != null && generatedSources.contains(baseDir.resolve(s.getSourcePath()))) {
                markers = markers.addIfAbsent((Marker)new Generated(Tree.randomId()));
            }
            return (SourceFile)s.withMarkers(markers);
        };
    }

    private static List<Path> listJavaSources(Path sourceDirectory) throws MojoExecutionException {
        return MavenMojoProjectParser.listSources(sourceDirectory, ".java");
    }

    private static List<Path> listKotlinSources(Path sourceDirectory) throws MojoExecutionException {
        return MavenMojoProjectParser.listSources(sourceDirectory, ".kt");
    }

    private static List<Path> listSources(Path sourceDirectory, String extension) throws MojoExecutionException {
        List<Path> list;
        block9: {
            if (!Files.exists(sourceDirectory, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> files = Files.find(sourceDirectory, 16, (f, a) -> !a.isDirectory() && f.toString().endsWith(extension), new FileVisitOption[0]);
            try {
                list = files.collect(Collectors.toList());
                if (files == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to list source files of " + extension, (Exception)e);
                }
            }
            files.close();
        }
        return list;
    }

    @Nullable
    private GitProvenance gitProvenance(Path baseDir, @Nullable BuildEnvironment buildEnvironment) {
        try {
            return GitProvenance.fromProjectDirectory((Path)baseDir, (BuildEnvironment)buildEnvironment);
        }
        catch (Exception e) {
            this.logger.debug((CharSequence)"Unable to determine git provenance", (Throwable)e);
            return null;
        }
    }

    private void logError(MavenProject mavenProject, String message) {
        this.logger.error((CharSequence)("Project [" + mavenProject.getName() + "] " + message));
    }

    private void logInfo(MavenProject mavenProject, String message) {
        this.logger.info((CharSequence)("Project [" + mavenProject.getName() + "] " + message));
    }

    private void logDebug(MavenProject mavenProject, String message) {
        this.logger.debug((CharSequence)("Project [" + mavenProject.getName() + "] " + message));
    }

    private static <E extends Throwable> E sneakyThrow(Throwable e) throws E {
        return (E)e;
    }
}

