/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Result;
import org.openrewrite.maven.AbstractRewriteMojo;
import org.openrewrite.maven.ChangePluginConfiguration;
import org.openrewrite.maven.ChangePluginDependencies;
import org.openrewrite.maven.ChangePluginExecutions;
import org.openrewrite.maven.MavenMojoProjectParser;
import org.openrewrite.xml.tree.Xml;

@Mojo(name="configure", threadSafe=true)
@Execute
public class ConfigureMojo
extends AbstractRewriteMojo {
    @Parameter(property="groupId", defaultValue="org.openrewrite.maven")
    protected String groupId;
    @Parameter(property="artifactId", defaultValue="rewrite-maven-plugin")
    protected String artifactId;
    @Nullable
    @Parameter(property="configuration")
    protected String configuration;
    @Nullable
    @Parameter(property="dependencies")
    protected String dependencies;
    @Nullable
    @Parameter(property="executionPhase")
    protected String executionPhase;
    @Nullable
    @Parameter(property="executionGoals")
    protected String executionGoals;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path baseDir = this.getBuildRoot();
        ExecutionContext ctx = this.executionContext();
        Xml.Document maven = new MavenMojoProjectParser(this.getLog(), baseDir, this.pomCacheEnabled, this.pomCacheDirectory, this.runtime, this.skipMavenParsing, this.getExclusions(), this.getPlainTextMasks(), this.sizeThresholdMb, this.mavenSession, this.settingsDecrypter).parseMaven(this.project, Collections.emptyList(), ctx);
        List<Xml.Document> poms = Arrays.asList(maven);
        List results = new ChangePluginConfiguration(this.groupId, this.artifactId, this.getConfiguration()).doNext((Recipe)new ChangePluginDependencies(this.groupId, this.artifactId, this.dependencies)).doNext((Recipe)new ChangePluginExecutions(this.groupId, this.artifactId, this.getExecutions())).run(poms).getResults();
        if (results.isEmpty()) {
            this.getLog().warn((CharSequence)("No changes made to plugin " + this.artifactId + " configuration"));
            return;
        }
        Result result = (Result)results.get(0);
        assert (result.getBefore() != null);
        assert (result.getAfter() != null);
        Charset charset = result.getAfter().getCharset() == null ? StandardCharsets.UTF_8 : result.getAfter().getCharset();
        try (BufferedWriter sourceFileWriter = Files.newBufferedWriter(baseDir.resolve(result.getBefore().getSourcePath()), charset, new OpenOption[0]);){
            sourceFileWriter.write(new String(result.getAfter().printAll().getBytes(charset), charset));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.getLog().info((CharSequence)("Changed " + this.artifactId + " in " + this.project.getFile().getPath()));
    }

    @Nullable
    protected String getConfiguration() {
        Set<String> activeRecipes = this.getActiveRecipes();
        if (this.configuration == null && !activeRecipes.isEmpty()) {
            this.configuration = "<activeRecipes>\n" + activeRecipes.stream().map(it -> "<recipe>" + it + "</recipe>").collect(Collectors.joining("\n")) + "\n</activeRecipes>";
        }
        return this.configuration;
    }

    @Nullable
    protected String getExecutions() {
        String executions = null;
        if (this.executionPhase != null && this.executionGoals != null) {
            executions = "<execution>\n<phase>" + this.executionPhase + "</phase>\n<goals>\n" + Arrays.stream(this.executionGoals.split(",")).map(it -> "<goal>" + it + "</goal>").collect(Collectors.joining("\n")) + "\n</goals>\n</execution>";
        }
        return executions;
    }
}

