/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.repository.RepositorySystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactResolver.class);
    private final RepositorySystem repositorySystem;
    private final ArtifactRepository localRepository;
    private final List<ArtifactRepository> remoteRepositories;

    public ArtifactResolver(RepositorySystem repositorySystem, MavenSession session) {
        this.repositorySystem = repositorySystem;
        this.localRepository = session.getLocalRepository();
        this.remoteRepositories = session.getCurrentProject().getRemoteArtifactRepositories();
    }

    public Artifact createArtifact(String coordinates) throws MojoExecutionException {
        String[] parts = coordinates.split(":");
        if (parts.length < 3) {
            throw new MojoExecutionException("Must include at least groupId:artifactId:version in artifact coordinates" + coordinates);
        }
        return this.repositorySystem.createArtifact(parts[0], parts[1], parts[2], "runtime", "jar");
    }

    public Set<Artifact> resolveArtifactsAndDependencies(Set<Artifact> artifacts) throws MojoExecutionException {
        if (artifacts.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Artifact> resultArtifacts = new HashSet<Artifact>();
        Artifact artifact = artifacts.iterator().next();
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(artifact).setArtifactDependencies(artifacts).setLocalRepository(this.localRepository).setRemoteRepositories(this.remoteRepositories).setResolveTransitively(true).setResolveRoot(true);
        ArtifactResolutionResult resolution = this.repositorySystem.resolve(request);
        if (!resolution.isSuccess()) {
            if (resolution.hasMissingArtifacts()) {
                LOG.warn("Missing artifacts for {}: {}", (Object)artifact.getId(), (Object)resolution.getMissingArtifacts());
            }
            resolution.getExceptions().forEach(e -> LOG.warn("Failed to resolve artifacts and/or dependencies for {}: {}", (Object)artifact.getId(), (Object)e.getMessage()));
            throw new MojoExecutionException("Failed to resolve requested artifacts transitive dependencies.");
        }
        resultArtifacts.addAll(resolution.getArtifacts());
        return resultArtifacts;
    }
}

