/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.style.Autodetect;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.marker.Generated;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.ResourceParser;
import org.openrewrite.maven.cache.CompositeMavenPomCache;
import org.openrewrite.maven.cache.InMemoryMavenPomCache;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.cache.RocksdbMavenPomCache;
import org.openrewrite.maven.internal.RawRepositories;
import org.openrewrite.maven.tree.ProfileActivation;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.xml.tree.Xml;

public class MavenMojoProjectParser {
    @Nullable
    static MavenPomCache pomCache;
    static JavaTypeCache typeCache;
    private final Log logger;
    private final Path baseDir;
    private final boolean pomCacheEnabled;
    @Nullable
    private final String pomCacheDirectory;
    private final boolean skipMavenParsing;
    private final BuildTool buildTool;
    private final Collection<String> exclusions;
    private final int sizeThresholdMb;
    private final MavenSession mavenSession;
    private final SettingsDecrypter settingsDecrypter;

    public MavenMojoProjectParser(Log logger, Path baseDir, boolean pomCacheEnabled, @Nullable String pomCacheDirectory, RuntimeInformation runtime, boolean skipMavenParsing, Collection<String> exclusions, int sizeThresholdMb, MavenSession session, SettingsDecrypter settingsDecrypter) {
        this.logger = logger;
        this.baseDir = baseDir;
        this.pomCacheEnabled = pomCacheEnabled;
        this.pomCacheDirectory = pomCacheDirectory;
        this.skipMavenParsing = skipMavenParsing;
        this.buildTool = new BuildTool(Tree.randomId(), BuildTool.Type.Maven, runtime.getMavenVersion());
        this.exclusions = exclusions;
        this.sizeThresholdMb = sizeThresholdMb;
        this.mavenSession = session;
        this.settingsDecrypter = settingsDecrypter;
    }

    public List<SourceFile> listSourceFiles(MavenProject mavenProject, Iterable<NamedStyles> styles, ExecutionContext ctx) throws DependencyResolutionRequiredException, MojoExecutionException {
        List<Marker> projectProvenance = this.generateProvenance(mavenProject);
        List<SourceFile> sourceFiles = new ArrayList<Object>();
        HashSet<Path> alreadyParsed = new HashSet<Path>();
        this.logInfo(mavenProject, "Resolving Poms...");
        Xml.Document maven = this.parseMaven(mavenProject, projectProvenance, ctx);
        if (maven != null) {
            sourceFiles.add((SourceFile)maven);
            alreadyParsed.add(this.baseDir.resolve(maven.getSourcePath()));
        }
        JavaParser javaParser = JavaParser.fromJavaVersion().styles(styles).typeCache(typeCache).logCompilationWarningsAndErrors(false).build();
        ResourceParser rp = new ResourceParser(this.baseDir, this.logger, this.exclusions, this.sizeThresholdMb, this.pathsToOtherMavenProjects(mavenProject));
        sourceFiles.addAll(this.processMainSources(mavenProject, javaParser, rp, projectProvenance, alreadyParsed, styles, ctx));
        sourceFiles.addAll(this.processTestSources(mavenProject, javaParser, rp, projectProvenance, alreadyParsed, styles, ctx));
        Collection exclusionMatchers = this.exclusions.stream().map(pattern -> this.baseDir.getFileSystem().getPathMatcher("glob:" + pattern)).collect(Collectors.toList());
        sourceFiles = ListUtils.map(sourceFiles, sourceFile -> {
            if (sourceFile instanceof J.CompilationUnit) {
                for (PathMatcher excluded : exclusionMatchers) {
                    if (!excluded.matches(sourceFile.getSourcePath())) continue;
                    return null;
                }
            }
            return sourceFile;
        });
        List parsedResourceFiles = ListUtils.map(rp.parse(mavenProject.getBasedir().toPath(), alreadyParsed), MavenMojoProjectParser.addProvenance(this.baseDir, projectProvenance, null));
        this.logDebug(mavenProject, "Parsed " + parsedResourceFiles.size() + " additional files found within the project.");
        sourceFiles.addAll(parsedResourceFiles);
        return sourceFiles;
    }

    private List<Marker> generateProvenance(MavenProject mavenProject) {
        String propertiesTargetCompatibility;
        String javaRuntimeVersion = System.getProperty("java.runtime.version");
        String javaVendor = System.getProperty("java.vm.vendor");
        String sourceCompatibility = javaRuntimeVersion;
        String targetCompatibility = javaRuntimeVersion;
        String propertiesSourceCompatibility = (String)mavenProject.getProperties().get("maven.compiler.source");
        if (propertiesSourceCompatibility != null) {
            sourceCompatibility = propertiesSourceCompatibility;
        }
        if ((propertiesTargetCompatibility = (String)mavenProject.getProperties().get("maven.compiler.target")) != null) {
            targetCompatibility = propertiesTargetCompatibility;
        }
        BuildEnvironment buildEnvironment = BuildEnvironment.build(System::getenv);
        return Stream.of(buildEnvironment, this.gitProvenance(this.baseDir, buildEnvironment), this.buildTool, new JavaVersion(Tree.randomId(), javaRuntimeVersion, javaVendor, sourceCompatibility, targetCompatibility), new JavaProject(Tree.randomId(), mavenProject.getName(), new JavaProject.Publication(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion()))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<SourceFile> processMainSources(MavenProject mavenProject, JavaParser javaParser, ResourceParser resourceParser, List<Marker> projectProvenance, Set<Path> alreadyParsed, Iterable<NamedStyles> styles, ExecutionContext ctx) throws DependencyResolutionRequiredException, MojoExecutionException {
        List<Path> generatedSourcePaths = MavenMojoProjectParser.listJavaSources(mavenProject.getBuild().getDirectory());
        List mainJavaSources = Stream.concat(generatedSourcePaths.stream(), MavenMojoProjectParser.listJavaSources(mavenProject.getBuild().getSourceDirectory()).stream()).collect(Collectors.toList());
        alreadyParsed.addAll(mainJavaSources);
        this.logInfo(mavenProject, "Parsing Source Files");
        List dependencies = mavenProject.getCompileClasspathElements().stream().distinct().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        javaParser.setClasspath(dependencies);
        javaParser.setSourceSet("main");
        List parsedJava = ListUtils.map(this.maybeAutodetectStyles(javaParser.parse(mainJavaSources, this.baseDir, ctx), styles), MavenMojoProjectParser.addProvenance(this.baseDir, projectProvenance, generatedSourcePaths));
        this.logDebug(mavenProject, "Parsed " + parsedJava.size() + " java source files in main scope.");
        Path buildDirectory = this.baseDir.relativize(Paths.get(mavenProject.getBuild().getDirectory(), new String[0]));
        List sourceFiles = parsedJava.stream().filter(s -> !s.getSourcePath().startsWith(buildDirectory)).collect(Collectors.toList());
        List parsedResourceFiles = ListUtils.map(resourceParser.parse(mavenProject.getBasedir().toPath().resolve("src/main/resources"), alreadyParsed), MavenMojoProjectParser.addProvenance(this.baseDir, ListUtils.concat(projectProvenance, (Object)javaParser.getSourceSet(ctx)), null));
        this.logDebug(mavenProject, "Parsed " + parsedResourceFiles.size() + " resource files in main scope.");
        sourceFiles.addAll(parsedResourceFiles);
        return sourceFiles.isEmpty() ? Collections.emptyList() : sourceFiles;
    }

    private List<SourceFile> processTestSources(MavenProject mavenProject, JavaParser javaParser, ResourceParser resourceParser, List<Marker> projectProvenance, Set<Path> alreadyParsed, Iterable<NamedStyles> styles, ExecutionContext ctx) throws DependencyResolutionRequiredException, MojoExecutionException {
        List testDependencies = mavenProject.getTestClasspathElements().stream().distinct().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        javaParser.setClasspath(testDependencies);
        javaParser.setSourceSet("test");
        List<Path> testJavaSources = MavenMojoProjectParser.listJavaSources(mavenProject.getBuild().getTestSourceDirectory());
        alreadyParsed.addAll(testJavaSources);
        List parsedJava = ListUtils.map(this.maybeAutodetectStyles(javaParser.parse(testJavaSources, this.baseDir, ctx), styles), MavenMojoProjectParser.addProvenance(this.baseDir, projectProvenance, null));
        this.logDebug(mavenProject, "Parsed " + parsedJava.size() + " java source files in test scope.");
        ArrayList sourceFiles = new ArrayList(parsedJava);
        List parsedResourceFiles = ListUtils.map(resourceParser.parse(mavenProject.getBasedir().toPath().resolve("src/test/resources"), alreadyParsed), MavenMojoProjectParser.addProvenance(this.baseDir, ListUtils.concat(projectProvenance, (Object)javaParser.getSourceSet(ctx)), null));
        this.logDebug(mavenProject, "Parsed " + parsedResourceFiles.size() + " resource files in test scope.");
        sourceFiles.addAll(parsedResourceFiles);
        return sourceFiles.isEmpty() ? Collections.emptyList() : sourceFiles;
    }

    @Nullable
    public Xml.Document parseMaven(MavenProject mavenProject, List<Marker> projectProvenance, ExecutionContext ctx) {
        Xml.Document maven;
        List<String> activeProfiles;
        J.clearCaches();
        if (this.skipMavenParsing) {
            this.logger.info((CharSequence)"Skipping Maven parsing...");
            return null;
        }
        Set<Path> allPoms = this.collectPoms(mavenProject, new HashSet<Path>());
        this.mavenSession.getProjectDependencyGraph().getUpstreamProjects(mavenProject, true).forEach(p -> this.collectPoms((MavenProject)p, allPoms));
        MavenParser.Builder mavenParserBuilder = MavenParser.builder().mavenConfig(this.baseDir.resolve(".mvn/maven.config"));
        MavenSettings settings = this.buildSettings();
        MavenExecutionContextView mavenExecutionContext = MavenExecutionContextView.view((ExecutionContext)ctx);
        mavenExecutionContext.setMavenSettings(settings, new String[0]);
        if (this.pomCacheEnabled) {
            mavenExecutionContext.setPomCache(MavenMojoProjectParser.getPomCache(this.pomCacheDirectory, this.logger));
        }
        if (!(activeProfiles = mavenProject.getActiveProfiles().stream().map(Profile::getId).collect(Collectors.toList())).isEmpty()) {
            mavenParserBuilder.activeProfiles(activeProfiles.toArray(new String[0]));
        }
        List mavens = mavenParserBuilder.build().parse(allPoms, this.baseDir, ctx);
        if (this.logger.isDebugEnabled()) {
            this.logDebug(mavenProject, "Base Directory : '" + this.baseDir + "'");
            if (allPoms.isEmpty()) {
                this.logDebug(mavenProject, "There were no collected pom paths.");
            } else {
                for (Path path : allPoms) {
                    this.logDebug(mavenProject, "  Collected Pom : '" + path + "'");
                }
            }
            if (mavens.isEmpty()) {
                this.logDebug(mavenProject, "There were no parsed maven source files.");
            } else {
                for (Xml.Document source : mavens) {
                    this.logDebug(mavenProject, "  Maven Source : '" + this.baseDir.resolve(source.getSourcePath()) + "'");
                }
            }
        }
        if ((maven = (Xml.Document)mavens.stream().filter(o -> mavenProject.getFile().toPath().equals(this.baseDir.resolve(o.getSourcePath()))).findFirst().orElse(null)) == null) {
            this.logError(mavenProject, "Parse resulted in no Maven source files. Maven Project File '" + mavenProject.getFile().toPath() + "'");
            return null;
        }
        for (Marker marker : projectProvenance) {
            maven = maven.withMarkers(maven.getMarkers().addIfAbsent(marker));
        }
        return maven;
    }

    private Set<Path> collectPoms(MavenProject project, Set<Path> paths) {
        paths.add(project.getFile().toPath());
        if (project.getCollectedProjects() != null) {
            for (MavenProject child : project.getCollectedProjects()) {
                Path path = child.getFile().toPath();
                if (paths.contains(path)) continue;
                this.collectPoms(child, paths);
            }
        }
        for (MavenProject parent = project.getParent(); parent != null && parent.getFile() != null; parent = parent.getParent()) {
            Path path = parent.getFile().toPath();
            if (paths.contains(path)) continue;
            this.collectPoms(parent, paths);
        }
        return paths;
    }

    private static MavenPomCache getPomCache(@Nullable String pomCacheDirectory, Log logger) {
        block7: {
            if (pomCache == null) {
                if (MavenMojoProjectParser.isJvm64Bit()) {
                    try {
                        if (pomCacheDirectory == null) {
                            pomCache = new CompositeMavenPomCache((MavenPomCache)new InMemoryMavenPomCache(), (MavenPomCache)new RocksdbMavenPomCache(Paths.get(System.getProperty("user.home"), new String[0])));
                            break block7;
                        }
                        pomCache = new CompositeMavenPomCache((MavenPomCache)new InMemoryMavenPomCache(), (MavenPomCache)new RocksdbMavenPomCache(Paths.get(pomCacheDirectory, new String[0])));
                    }
                    catch (Exception e) {
                        logger.warn((CharSequence)"Unable to initialize RocksdbMavenPomCache, falling back to InMemoryMavenPomCache");
                        logger.debug((Throwable)e);
                    }
                } else {
                    logger.warn((CharSequence)"RocksdbMavenPomCache is not supported on 32-bit JVM. falling back to InMemoryMavenPomCache");
                }
            }
        }
        if (pomCache == null) {
            pomCache = new InMemoryMavenPomCache();
        }
        return pomCache;
    }

    private static boolean isJvm64Bit() {
        return !System.getProperty("sun.arch.data.model", "64").equals("32");
    }

    private MavenSettings buildSettings() {
        MavenExecutionRequest mer = this.mavenSession.getRequest();
        MavenSettings.Profiles profiles = new MavenSettings.Profiles();
        profiles.setProfiles(mer.getProfiles().stream().map(p -> new MavenSettings.Profile(p.getId(), p.getActivation() == null ? null : new ProfileActivation(Boolean.valueOf(p.getActivation().isActiveByDefault()), p.getActivation().getJdk(), p.getActivation().getProperty() == null ? null : new ProfileActivation.Property(p.getActivation().getProperty().getName(), p.getActivation().getProperty().getValue())), MavenMojoProjectParser.buildRawRepositories(p.getRepositories()))).collect(Collectors.toList()));
        MavenSettings.ActiveProfiles activeProfiles = new MavenSettings.ActiveProfiles();
        activeProfiles.setActiveProfiles(mer.getActiveProfiles());
        MavenSettings.Mirrors mirrors = new MavenSettings.Mirrors();
        mirrors.setMirrors(mer.getMirrors().stream().map(m -> new MavenSettings.Mirror(m.getId(), m.getUrl(), m.getMirrorOf(), null, null)).collect(Collectors.toList()));
        MavenSettings.Servers servers = new MavenSettings.Servers();
        servers.setServers(mer.getServers().stream().map(s -> {
            DefaultSettingsDecryptionRequest decryptionRequest = new DefaultSettingsDecryptionRequest(s);
            SettingsDecryptionResult decryptionResult = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)decryptionRequest);
            return new MavenSettings.Server(s.getId(), s.getUsername(), decryptionResult.getServer().getPassword());
        }).collect(Collectors.toList()));
        return new MavenSettings(mer.getLocalRepositoryPath().toString(), profiles, activeProfiles, mirrors, servers);
    }

    @Nullable
    private static RawRepositories buildRawRepositories(@Nullable List<Repository> repositoriesToMap) {
        if (repositoriesToMap == null) {
            return null;
        }
        RawRepositories rawRepositories = new RawRepositories();
        List transformedRepositories = repositoriesToMap.stream().map(r -> new RawRepositories.Repository(r.getId(), r.getUrl(), r.getReleases() == null ? null : new RawRepositories.ArtifactPolicy(Boolean.valueOf(r.getReleases().isEnabled())), r.getSnapshots() == null ? null : new RawRepositories.ArtifactPolicy(Boolean.valueOf(r.getSnapshots().isEnabled())))).collect(Collectors.toList());
        rawRepositories.setRepositories(transformedRepositories);
        return rawRepositories;
    }

    private Set<Path> pathsToOtherMavenProjects(MavenProject mavenProject) {
        return this.mavenSession.getProjects().stream().filter(o -> o != mavenProject).map(o -> o.getBasedir().toPath()).collect(Collectors.toSet());
    }

    private List<J.CompilationUnit> maybeAutodetectStyles(List<J.CompilationUnit> sourceFiles, @Nullable Iterable<NamedStyles> styles) {
        if (styles != null && styles.spliterator().getExactSizeIfKnown() > 0L) {
            return sourceFiles;
        }
        Autodetect autodetect = Autodetect.detect(sourceFiles);
        return ListUtils.map(sourceFiles, cu -> {
            List markers = ListUtils.concat((List)ListUtils.map((List)cu.getMarkers().getMarkers(), m -> m instanceof NamedStyles ? null : m), (Object)autodetect);
            return cu.withMarkers(cu.getMarkers().withMarkers(markers));
        });
    }

    private static <S extends SourceFile> UnaryOperator<S> addProvenance(Path baseDir, List<Marker> provenance, @Nullable Collection<Path> generatedSources) {
        return s -> {
            for (Marker marker : provenance) {
                s = s.withMarkers(s.getMarkers().addIfAbsent(marker));
            }
            if (generatedSources != null && generatedSources.contains(baseDir.resolve(s.getSourcePath()))) {
                s = s.withMarkers(s.getMarkers().addIfAbsent((Marker)new Generated(Tree.randomId())));
            }
            return s;
        };
    }

    private static List<Path> listJavaSources(String sourceDirectory) throws MojoExecutionException {
        List<Path> list;
        block9: {
            File sourceDirectoryFile = new File(sourceDirectory);
            if (!sourceDirectoryFile.exists()) {
                return Collections.emptyList();
            }
            Path sourceRoot = sourceDirectoryFile.toPath();
            Stream<Path> files = Files.find(sourceRoot, 16, (f, a) -> !a.isDirectory() && f.toString().endsWith(".java"), new FileVisitOption[0]);
            try {
                list = files.collect(Collectors.toList());
                if (files == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to list Java source files", (Exception)e);
                }
            }
            files.close();
        }
        return list;
    }

    public void resetTypeCache() {
        typeCache.clear();
    }

    @Nullable
    private GitProvenance gitProvenance(Path baseDir, @Nullable BuildEnvironment buildEnvironment) {
        try {
            return GitProvenance.fromProjectDirectory((Path)baseDir, (BuildEnvironment)buildEnvironment);
        }
        catch (Exception e) {
            this.logger.debug((CharSequence)"Unable to determine git provenance", (Throwable)e);
            return null;
        }
    }

    private void logError(MavenProject mavenProject, String message) {
        this.logger.error((CharSequence)("Project [" + mavenProject.getName() + "] " + message));
    }

    private void logInfo(MavenProject mavenProject, String message) {
        this.logger.info((CharSequence)("Project [" + mavenProject.getName() + "] " + message));
    }

    private void logDebug(MavenProject mavenProject, String message) {
        this.logger.debug((CharSequence)("Project [" + mavenProject.getName() + "] " + message));
    }

    static {
        typeCache = new JavaTypeCache();
    }
}

