/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.puppycrawl.tools.checkstyle.Checker;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Validated;
import org.openrewrite.config.ClasspathScanningLoader;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.java.style.CheckstyleConfigLoader;
import org.openrewrite.marker.Generated;
import org.openrewrite.maven.ArtifactResolver;
import org.openrewrite.maven.ConfigurableRewriteMojo;
import org.openrewrite.maven.MavenMojoProjectParser;
import org.openrewrite.maven.MeterRegistryProvider;

public abstract class AbstractRewriteMojo
extends ConfigurableRewriteMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Component
    protected RuntimeInformation runtime;
    @Component
    protected SettingsDecrypter settingsDecrypter;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    private static final String RECIPE_NOT_FOUND_EXCEPTION_MSG = "Could not find recipe '%s' among available recipes";

    protected Environment environment() throws MojoExecutionException {
        File rewriteConfig;
        Environment.Builder env = Environment.builder((Properties)this.project.getProperties());
        if (this.getRecipeArtifactCoordinates().isEmpty()) {
            env.scanRuntimeClasspath(new String[0]).scanUserHome();
        } else {
            env.load((ResourceLoader)new ClasspathScanningLoader(this.project.getProperties(), (ClassLoader)this.getRecipeClassloader()));
        }
        Path absoluteConfigLocation = Paths.get(this.configLocation, new String[0]);
        if (!absoluteConfigLocation.isAbsolute()) {
            absoluteConfigLocation = this.project.getBasedir().toPath().resolve(this.configLocation);
        }
        if ((rewriteConfig = absoluteConfigLocation.toFile()).exists()) {
            try (FileInputStream is = new FileInputStream(rewriteConfig);){
                env.load((ResourceLoader)new YamlResourceLoader((InputStream)is, rewriteConfig.toURI(), this.project.getProperties()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to load rewrite configuration", (Exception)e);
            }
        }
        return env.build();
    }

    protected ExecutionContext executionContext() {
        return new InMemoryExecutionContext(t -> {
            this.getLog().warn((CharSequence)t.getMessage());
            this.getLog().debug(t);
        });
    }

    protected Path getBaseDir() {
        Path localRepositoryFolder = Paths.get(this.mavenSession.getLocalRepository().getBasedir(), new String[0]).normalize();
        HashSet<Path> baseFolders = new HashSet<Path>();
        for (MavenProject project : this.mavenSession.getAllProjects()) {
            this.collectBasePaths(project, baseFolders, localRepositoryFolder);
        }
        if (!baseFolders.isEmpty()) {
            ArrayList<Path> sortedPaths = new ArrayList<Path>(new ArrayList<Path>(baseFolders));
            Collections.sort(sortedPaths);
            return (Path)sortedPaths.get(0);
        }
        return Paths.get(this.mavenSession.getExecutionRootDirectory(), new String[0]);
    }

    private void collectBasePaths(MavenProject project, Set<Path> paths, Path localRepository) {
        Path baseDir;
        Path path = baseDir = project.getBasedir() == null ? null : project.getBasedir().toPath().normalize();
        if (baseDir == null || baseDir.startsWith(localRepository) || paths.contains(baseDir)) {
            return;
        }
        paths.add(baseDir);
        for (MavenProject parent = project.getParent(); parent != null && parent.getBasedir() != null; parent = parent.getParent()) {
            this.collectBasePaths(parent, paths, localRepository);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResultsContainer listResults() throws MojoExecutionException {
        try (MeterRegistryProvider meterRegistryProvider = new MeterRegistryProvider(this.getLog(), this.metricsUri, this.metricsUsername, this.metricsPassword);){
            Object checkstyleConfRaw;
            List styles;
            Environment env;
            Path baseDir;
            block27: {
                Metrics.addRegistry((MeterRegistry)meterRegistryProvider.registry());
                baseDir = this.getBaseDir();
                this.getLog().info((CharSequence)String.format("Using active recipe(s) %s", this.getActiveRecipes()));
                this.getLog().info((CharSequence)String.format("Using active styles(s) %s", this.getActiveStyles()));
                if (this.getActiveRecipes().isEmpty()) {
                    ResultsContainer resultsContainer = new ResultsContainer(baseDir, Collections.emptyList());
                    return resultsContainer;
                }
                env = this.environment();
                styles = env.activateStyles(this.getActiveStyles());
                try {
                    Plugin checkstylePlugin = this.project.getPlugin("org.apache.maven.plugins:maven-checkstyle-plugin");
                    if (this.checkstyleConfigFile != null && !this.checkstyleConfigFile.isEmpty()) {
                        styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((Path)Paths.get(this.checkstyleConfigFile, new String[0]), Collections.emptyMap()));
                        break block27;
                    }
                    if (checkstylePlugin == null || !((checkstyleConfRaw = checkstylePlugin.getConfiguration()) instanceof Xpp3Dom)) break block27;
                    Xpp3Dom xmlCheckstyleConf = (Xpp3Dom)checkstyleConfRaw;
                    Xpp3Dom xmlConfigLocation = xmlCheckstyleConf.getChild("configLocation");
                    if (xmlConfigLocation == null) {
                        try (InputStream is = Checker.class.getResourceAsStream("/sun_checks.xml");){
                            if (is != null) {
                                styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((InputStream)is, Collections.emptyMap()));
                            }
                            break block27;
                        }
                    }
                    Path configPath = Paths.get(xmlConfigLocation.getValue(), new String[0]);
                    styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((Path)configPath, Collections.emptyMap()));
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)"Unable to parse checkstyle configuration. Checkstyle will not inform rewrite execution.", (Throwable)e);
                }
            }
            Recipe recipe = env.activateRecipes(this.getActiveRecipes());
            if (recipe.getRecipeList().size() == 0) {
                this.getLog().warn((CharSequence)"No recipes were activated. Activate a recipe with <activeRecipes><recipe>com.fully.qualified.RecipeClassName</recipe></activeRecipes> in this plugin's <configuration> in your pom.xml, or on the command line with -Drewrite.activeRecipes=com.fully.qualified.RecipeClassName");
                checkstyleConfRaw = new ResultsContainer(baseDir, Collections.emptyList());
                return checkstyleConfRaw;
            }
            this.getLog().info((CharSequence)"Validating active recipes...");
            Collection validated = recipe.validateAll();
            List<Validated.Invalid> failedValidations = validated.stream().map(Validated::failures).flatMap(Collection::stream).collect(Collectors.toList());
            if (!failedValidations.isEmpty()) {
                failedValidations.forEach(failedValidation -> this.getLog().error((CharSequence)("Recipe validation error in " + failedValidation.getProperty() + ": " + failedValidation.getMessage()), failedValidation.getException()));
                if (this.failOnInvalidActiveRecipes) {
                    throw new MojoExecutionException("Recipe validation errors detected as part of one or more activeRecipe(s). Please check error logs.");
                }
                this.getLog().error((CharSequence)"Recipe validation errors detected as part of one or more activeRecipe(s). Execution will continue regardless.");
            }
            ExecutionContext ctx = this.executionContext();
            MavenMojoProjectParser projectParser = new MavenMojoProjectParser(this.getLog(), baseDir, this.pomCacheEnabled, this.pomCacheDirectory, this.runtime, this.skipMavenParsing, this.getExclusions(), this.sizeThresholdMb, this.mavenSession, this.settingsDecrypter);
            ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
            if (this.runPerSubmodule) {
                projectParser.resetTypeCache();
                sourceFiles.addAll(projectParser.listSourceFiles(this.project, styles, ctx));
            } else {
                for (MavenProject projectIndex : this.mavenSession.getProjects()) {
                    sourceFiles.addAll(projectParser.listSourceFiles(projectIndex, styles, ctx));
                }
            }
            this.getLog().info((CharSequence)"Running recipe(s)...");
            List<Result> results = recipe.run(sourceFiles, ctx).stream().filter(source -> {
                if (source.getBefore() != null) {
                    return !source.getBefore().getMarkers().findFirst(Generated.class).isPresent();
                }
                return true;
            }).collect(Collectors.toList());
            Metrics.removeRegistry((MeterRegistry)meterRegistryProvider.registry());
            ResultsContainer resultsContainer = new ResultsContainer(baseDir, results);
            return resultsContainer;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Dependency resolution required", (Exception)((Object)e));
        }
    }

    protected URLClassLoader getRecipeClassloader() throws MojoExecutionException {
        ArtifactResolver resolver = new ArtifactResolver(this.repositorySystem, this.mavenSession);
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        for (String coordinate : this.getRecipeArtifactCoordinates()) {
            artifacts.add(resolver.createArtifact(coordinate));
        }
        Set<Artifact> resolvedArtifacts = resolver.resolveArtifactsAndDependencies(artifacts);
        HashSet<URL> urls = new HashSet<URL>();
        for (Artifact artifact : resolvedArtifacts) {
            try {
                urls.add(artifact.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Failed to resolve artifacts from rewrite.recipeArtifactCoordinates", (Exception)e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]), AbstractRewriteMojo.class.getClassLoader());
    }

    protected void logRecipesThatMadeChanges(Result result) {
        String indent = "    ";
        String prefix = "    ";
        for (RecipeDescriptor recipeDescriptor : result.getRecipeDescriptorsThatMadeChanges()) {
            this.logRecipe(recipeDescriptor, prefix);
            prefix = prefix + indent;
        }
    }

    private void logRecipe(RecipeDescriptor rd, String prefix) {
        String opts;
        StringBuilder recipeString = new StringBuilder(prefix + rd.getName());
        if (!rd.getOptions().isEmpty() && !(opts = rd.getOptions().stream().map(option -> {
            if (option.getValue() != null) {
                return option.getName() + "=" + option.getValue();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.joining(", "))).isEmpty()) {
            recipeString.append(": {").append(opts).append("}");
        }
        this.getLog().warn((CharSequence)recipeString.toString());
        for (RecipeDescriptor rchild : rd.getRecipeList()) {
            this.logRecipe(rchild, prefix + "    ");
        }
    }

    public static RecipeDescriptor getRecipeDescriptor(String recipe, Collection<RecipeDescriptor> recipeDescriptors) throws MojoExecutionException {
        return recipeDescriptors.stream().filter(r -> r.getName().equalsIgnoreCase(recipe)).findAny().orElseThrow(() -> new MojoExecutionException(String.format(RECIPE_NOT_FOUND_EXCEPTION_MSG, recipe)));
    }

    public static class ResultsContainer {
        final Path projectRoot;
        final List<Result> generated = new ArrayList<Result>();
        final List<Result> deleted = new ArrayList<Result>();
        final List<Result> moved = new ArrayList<Result>();
        final List<Result> refactoredInPlace = new ArrayList<Result>();

        public ResultsContainer(Path projectRoot, Collection<Result> results) {
            this.projectRoot = projectRoot;
            for (Result result : results) {
                if (result.getBefore() == null && result.getAfter() == null) continue;
                if (result.getBefore() == null && result.getAfter() != null) {
                    this.generated.add(result);
                    continue;
                }
                if (result.getBefore() != null && result.getAfter() == null) {
                    this.deleted.add(result);
                    continue;
                }
                if (result.getBefore() != null && result.getAfter() != null && !result.getBefore().getSourcePath().equals(result.getAfter().getSourcePath())) {
                    this.moved.add(result);
                    continue;
                }
                this.refactoredInPlace.add(result);
            }
        }

        public Path getProjectRoot() {
            return this.projectRoot;
        }

        public boolean isNotEmpty() {
            return !this.generated.isEmpty() || !this.deleted.isEmpty() || !this.moved.isEmpty() || !this.refactoredInPlace.isEmpty();
        }
    }
}

