/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.openrewrite.Result;
import org.openrewrite.maven.AbstractRewriteMojo;
import org.openrewrite.maven.MavenOptsHelper;

public class AbstractRewriteRunMojo
extends AbstractRewriteMojo {
    public void execute() throws MojoExecutionException {
        MavenOptsHelper.checkAndLogMissingJvmModuleExports(this.getLog());
        if (!this.runPerSubmodule && !this.project.getId().equals(((MavenProject)this.mavenSession.getProjects().get(this.mavenSession.getProjects().size() - 1)).getId())) {
            return;
        }
        AbstractRewriteMojo.ResultsContainer results = this.listResults();
        if (results.isNotEmpty()) {
            for (Result result : results.generated) {
                assert (result.getAfter() != null);
                this.getLog().warn((CharSequence)("Generated new file " + result.getAfter().getSourcePath().normalize() + " by:"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.deleted) {
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("Deleted file " + result.getBefore().getSourcePath().normalize() + " by:"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.moved) {
                assert (result.getAfter() != null);
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("File has been moved from " + result.getBefore().getSourcePath().normalize() + " to " + result.getAfter().getSourcePath().normalize() + " by:"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.refactoredInPlace) {
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("Changes have been made to " + result.getBefore().getSourcePath().normalize() + " by:"));
                this.logRecipesThatMadeChanges(result);
            }
            this.getLog().warn((CharSequence)"Please review and commit the results.");
            try {
                Path originalLocation;
                BufferedWriter sourceFileWriter;
                for (Result result : results.generated) {
                    assert (result.getAfter() != null);
                    sourceFileWriter = Files.newBufferedWriter(results.getProjectRoot().resolve(result.getAfter().getSourcePath()), new OpenOption[0]);
                    try {
                        Charset charset = result.getAfter().getCharset();
                        sourceFileWriter.write(new String(result.getAfter().printAll().getBytes(charset), charset));
                    }
                    finally {
                        if (sourceFileWriter == null) continue;
                        sourceFileWriter.close();
                    }
                }
                for (Result result : results.deleted) {
                    assert (result.getBefore() != null);
                    originalLocation = results.getProjectRoot().resolve(result.getBefore().getSourcePath()).normalize();
                    boolean deleteSucceeded = originalLocation.toFile().delete();
                    if (deleteSucceeded) continue;
                    throw new IOException("Unable to delete file " + originalLocation.toAbsolutePath());
                }
                for (Result result : results.moved) {
                    assert (result.getBefore() != null);
                    originalLocation = results.getProjectRoot().resolve(result.getBefore().getSourcePath());
                    File originalParentDir = originalLocation.toFile().getParentFile();
                    boolean deleteSucceeded = originalLocation.toFile().delete();
                    if (!deleteSucceeded) {
                        throw new IOException("Unable to delete file " + originalLocation.toAbsolutePath());
                    }
                    assert (result.getAfter() != null);
                    Path afterLocation = results.getProjectRoot().resolve(result.getAfter().getSourcePath());
                    File afterParentDir = afterLocation.toFile().getParentFile();
                    if (afterParentDir.exists() && afterParentDir.getAbsolutePath().equalsIgnoreCase(originalParentDir.getAbsolutePath()) && !afterParentDir.getAbsolutePath().equals(originalParentDir.getAbsolutePath())) {
                        if (!originalParentDir.renameTo(afterParentDir)) {
                            throw new RuntimeException("Unable to rename directory from " + originalParentDir.getAbsolutePath() + " To: " + afterParentDir.getAbsolutePath());
                        }
                    } else if (!afterParentDir.exists() && !afterParentDir.mkdirs()) {
                        throw new RuntimeException("Unable to create directory " + afterParentDir.getAbsolutePath());
                    }
                    BufferedWriter sourceFileWriter2 = Files.newBufferedWriter(afterLocation, new OpenOption[0]);
                    try {
                        Charset charset = result.getAfter().getCharset();
                        sourceFileWriter2.write(new String(result.getAfter().printAll().getBytes(charset), charset));
                    }
                    finally {
                        if (sourceFileWriter2 == null) continue;
                        sourceFileWriter2.close();
                    }
                }
                for (Result result : results.refactoredInPlace) {
                    assert (result.getBefore() != null);
                    sourceFileWriter = Files.newBufferedWriter(results.getProjectRoot().resolve(result.getBefore().getSourcePath()), new OpenOption[0]);
                    try {
                        assert (result.getAfter() != null);
                        Charset charset = result.getAfter().getCharset();
                        sourceFileWriter.write(new String(result.getAfter().printAll().getBytes(charset), charset));
                    }
                    finally {
                        if (sourceFileWriter == null) continue;
                        sourceFileWriter.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to rewrite source files", e);
            }
        }
    }
}

