/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.style.Autodetect;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.marker.Generated;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.ResourceParser;
import org.openrewrite.maven.cache.CompositeMavenPomCache;
import org.openrewrite.maven.cache.InMemoryMavenPomCache;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.cache.RocksdbMavenPomCache;
import org.openrewrite.maven.internal.RawRepositories;
import org.openrewrite.maven.tree.ProfileActivation;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.xml.tree.Xml;

public class MavenMojoProjectParser {
    @Nullable
    static MavenPomCache pomCache;
    private final Log logger;
    private final Path baseDir;
    private final MavenProject mavenProject;
    private final List<Marker> projectProvenance;
    private final boolean pomCacheEnabled;
    @Nullable
    private final String pomCacheDirectory;
    private final boolean skipMavenParsing;
    private final Collection<String> exclusions;
    private final int sizeThresholdMb;
    private final MavenSession mavenSession;
    private final SettingsDecrypter settingsDecrypter;

    public MavenMojoProjectParser(Log logger, Path baseDir, boolean pomCacheEnabled, @Nullable String pomCacheDirectory, MavenProject mavenProject, RuntimeInformation runtime, boolean skipMavenParsing, Collection<String> exclusions, int thresholdMb, MavenSession session, SettingsDecrypter settingsDecrypter) {
        String propertiesTargetCompatibility;
        this.logger = logger;
        this.baseDir = baseDir;
        this.mavenProject = mavenProject;
        this.pomCacheEnabled = pomCacheEnabled;
        this.pomCacheDirectory = pomCacheDirectory;
        this.skipMavenParsing = skipMavenParsing;
        this.exclusions = exclusions;
        this.sizeThresholdMb = thresholdMb;
        this.mavenSession = session;
        this.settingsDecrypter = settingsDecrypter;
        String javaRuntimeVersion = System.getProperty("java.runtime.version");
        String javaVendor = System.getProperty("java.vm.vendor");
        String sourceCompatibility = javaRuntimeVersion;
        String targetCompatibility = javaRuntimeVersion;
        String propertiesSourceCompatibility = (String)mavenProject.getProperties().get("maven.compiler.source");
        if (propertiesSourceCompatibility != null) {
            sourceCompatibility = propertiesSourceCompatibility;
        }
        if ((propertiesTargetCompatibility = (String)mavenProject.getProperties().get("maven.compiler.target")) != null) {
            targetCompatibility = propertiesTargetCompatibility;
        }
        this.projectProvenance = Stream.of(this.gitProvenance(baseDir), new BuildTool(Tree.randomId(), BuildTool.Type.Maven, runtime.getMavenVersion()), new JavaVersion(Tree.randomId(), javaRuntimeVersion, javaVendor, sourceCompatibility, targetCompatibility), new JavaProject(Tree.randomId(), mavenProject.getName(), new JavaProject.Publication(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion()))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private GitProvenance gitProvenance(Path baseDir) {
        try {
            return GitProvenance.fromProjectDirectory((Path)baseDir);
        }
        catch (Exception e) {
            this.logger.debug((CharSequence)"Unable to determine git provenance", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public Xml.Document parseMaven(ExecutionContext ctx) {
        List<String> activeProfiles;
        J.clearCaches();
        if (this.skipMavenParsing) {
            this.logger.info((CharSequence)"Skipping Maven parsing...");
            return null;
        }
        ArrayList<Path> allPoms = new ArrayList<Path>();
        allPoms.add(this.mavenProject.getFile().toPath());
        if (this.mavenProject.getCollectedProjects() != null) {
            this.mavenProject.getCollectedProjects().stream().filter(collectedProject -> collectedProject != this.mavenProject).map(collectedProject -> collectedProject.getFile().toPath()).forEach(allPoms::add);
        }
        for (MavenProject parent = this.mavenProject.getParent(); parent != null && parent.getFile() != null; parent = parent.getParent()) {
            allPoms.add(parent.getFile().toPath());
        }
        MavenParser.Builder mavenParserBuilder = MavenParser.builder().mavenConfig(this.baseDir.resolve(".mvn/maven.config"));
        MavenSettings settings = this.buildSettings();
        MavenExecutionContextView mavenExecutionContext = MavenExecutionContextView.view((ExecutionContext)ctx);
        mavenExecutionContext.setMavenSettings(settings, new String[0]);
        if (this.pomCacheEnabled) {
            mavenExecutionContext.setPomCache(MavenMojoProjectParser.getPomCache(this.pomCacheDirectory, this.logger));
        }
        if (!(activeProfiles = this.mavenProject.getActiveProfiles().stream().map(Profile::getId).collect(Collectors.toList())).isEmpty()) {
            mavenParserBuilder.activeProfiles(activeProfiles.toArray(new String[0]));
        }
        Xml.Document maven = (Xml.Document)mavenParserBuilder.build().parse(allPoms, this.baseDir, ctx).iterator().next();
        for (Marker marker : this.projectProvenance) {
            maven = maven.withMarkers(maven.getMarkers().addIfAbsent(marker));
        }
        return maven;
    }

    private static MavenPomCache getPomCache(@Nullable String pomCacheDirectory, Log logger) {
        block7: {
            if (pomCache == null) {
                if (MavenMojoProjectParser.isJvm64Bit()) {
                    try {
                        if (pomCacheDirectory == null) {
                            pomCache = new CompositeMavenPomCache((MavenPomCache)new InMemoryMavenPomCache(), (MavenPomCache)new RocksdbMavenPomCache(Paths.get(System.getProperty("user.home"), new String[0])));
                            break block7;
                        }
                        pomCache = new CompositeMavenPomCache((MavenPomCache)new InMemoryMavenPomCache(), (MavenPomCache)new RocksdbMavenPomCache(Paths.get(pomCacheDirectory, new String[0])));
                    }
                    catch (Exception e) {
                        logger.warn((CharSequence)"Unable to initialize RocksdbMavenPomCache, falling back to InMemoryMavenPomCache");
                        logger.debug((Throwable)e);
                    }
                } else {
                    logger.warn((CharSequence)"RocksdbMavenPomCache is not supported on 32-bit JVM. falling back to InMemoryMavenPomCache");
                }
            }
        }
        if (pomCache == null) {
            pomCache = new InMemoryMavenPomCache();
        }
        return pomCache;
    }

    private static boolean isJvm64Bit() {
        return !System.getProperty("sun.arch.data.model", "64").equals("32");
    }

    private MavenSettings buildSettings() {
        MavenExecutionRequest mer = this.mavenSession.getRequest();
        MavenSettings.Profiles profiles = new MavenSettings.Profiles();
        profiles.setProfiles(mer.getProfiles().stream().map(p -> new MavenSettings.Profile(p.getId(), p.getActivation() == null ? null : new ProfileActivation(Boolean.valueOf(p.getActivation().isActiveByDefault()), p.getActivation().getJdk(), p.getActivation().getProperty() == null ? null : new ProfileActivation.Property(p.getActivation().getProperty().getName(), p.getActivation().getProperty().getValue())), MavenMojoProjectParser.buildRawRepositories(p.getRepositories()))).collect(Collectors.toList()));
        MavenSettings.ActiveProfiles activeProfiles = new MavenSettings.ActiveProfiles();
        activeProfiles.setActiveProfiles(mer.getActiveProfiles());
        MavenSettings.Mirrors mirrors = new MavenSettings.Mirrors();
        mirrors.setMirrors(mer.getMirrors().stream().map(m -> new MavenSettings.Mirror(m.getId(), m.getUrl(), m.getMirrorOf(), null, null)).collect(Collectors.toList()));
        MavenSettings.Servers servers = new MavenSettings.Servers();
        servers.setServers(mer.getServers().stream().map(s -> {
            DefaultSettingsDecryptionRequest decryptionRequest = new DefaultSettingsDecryptionRequest(s);
            SettingsDecryptionResult decryptionResult = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)decryptionRequest);
            return new MavenSettings.Server(s.getId(), s.getUsername(), decryptionResult.getServer().getPassword());
        }).collect(Collectors.toList()));
        return new MavenSettings(profiles, activeProfiles, mirrors, servers);
    }

    @Nullable
    private static RawRepositories buildRawRepositories(@Nullable List<Repository> repositoriesToMap) {
        if (repositoriesToMap == null) {
            return null;
        }
        RawRepositories rawRepositories = new RawRepositories();
        List transformedRepositories = repositoriesToMap.stream().map(r -> new RawRepositories.Repository(r.getId(), r.getUrl(), r.getReleases() == null ? null : new RawRepositories.ArtifactPolicy(Boolean.valueOf(r.getReleases().isEnabled())), r.getSnapshots() == null ? null : new RawRepositories.ArtifactPolicy(Boolean.valueOf(r.getSnapshots().isEnabled())))).collect(Collectors.toList());
        rawRepositories.setRepositories(transformedRepositories);
        return rawRepositories;
    }

    public List<SourceFile> listSourceFiles(Iterable<NamedStyles> styles, ExecutionContext ctx) throws DependencyResolutionRequiredException, MojoExecutionException {
        HashSet<Path> alreadyParsed = new HashSet<Path>();
        JavaParser javaParser = JavaParser.fromJavaVersion().styles(styles).logCompilationWarningsAndErrors(false).build();
        List<Path> generatedSourcePaths = MavenMojoProjectParser.listJavaSources(this.mavenProject.getBuild().getDirectory());
        List mainJavaSources = Stream.concat(generatedSourcePaths.stream(), MavenMojoProjectParser.listJavaSources(this.mavenProject.getBuild().getSourceDirectory()).stream()).collect(Collectors.toList());
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        Xml.Document maven = this.parseMaven(ctx);
        if (maven != null) {
            sourceFiles.add((SourceFile)maven);
            alreadyParsed.add(this.baseDir.resolve(maven.getSourcePath()));
        }
        this.logger.info((CharSequence)"Parsing Java main files...");
        List dependencies = this.mavenProject.getCompileClasspathElements().stream().distinct().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        javaParser.setClasspath(dependencies);
        javaParser.setSourceSet("main");
        sourceFiles.addAll(ListUtils.map(this.maybeAutodetectStyles(javaParser.parse(mainJavaSources, this.baseDir, ctx), styles), MavenMojoProjectParser.addProvenance(this.baseDir, this.projectProvenance, generatedSourcePaths)));
        ResourceParser rp = new ResourceParser(this.logger, this.exclusions, this.sizeThresholdMb);
        sourceFiles.addAll(ListUtils.map(rp.parse(this.baseDir, this.mavenProject.getBasedir().toPath().resolve("src/main/resources"), alreadyParsed), MavenMojoProjectParser.addProvenance(this.baseDir, ListUtils.concat(this.projectProvenance, (Object)javaParser.getSourceSet(ctx)), null)));
        this.logger.info((CharSequence)"Parsing Java test files...");
        List testDependencies = this.mavenProject.getTestClasspathElements().stream().distinct().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        javaParser.setClasspath(testDependencies);
        javaParser.setSourceSet("test");
        sourceFiles.addAll(ListUtils.map(this.maybeAutodetectStyles(javaParser.parse(MavenMojoProjectParser.listJavaSources(this.mavenProject.getBuild().getTestSourceDirectory()), this.baseDir, ctx), styles), MavenMojoProjectParser.addProvenance(this.baseDir, this.projectProvenance, null)));
        sourceFiles.addAll(ListUtils.map(rp.parse(this.baseDir, this.mavenProject.getBasedir().toPath().resolve("src/test/resources"), alreadyParsed), MavenMojoProjectParser.addProvenance(this.baseDir, ListUtils.concat(this.projectProvenance, (Object)javaParser.getSourceSet(ctx)), null)));
        sourceFiles.addAll(ListUtils.map(rp.parse(this.baseDir, this.mavenProject.getBasedir().toPath(), alreadyParsed), MavenMojoProjectParser.addProvenance(this.baseDir, this.projectProvenance, null)));
        return sourceFiles;
    }

    private List<J.CompilationUnit> maybeAutodetectStyles(List<J.CompilationUnit> sourceFiles, @Nullable Iterable<NamedStyles> styles) {
        if (styles != null) {
            return sourceFiles;
        }
        Autodetect autodetect = Autodetect.detect(sourceFiles);
        List<Autodetect> namedStyles = Collections.singletonList(autodetect);
        ImportLayoutStyle importLayout = (ImportLayoutStyle)NamedStyles.merge(ImportLayoutStyle.class, namedStyles);
        SpacesStyle spacesStyle = (SpacesStyle)NamedStyles.merge(SpacesStyle.class, namedStyles);
        TabsAndIndentsStyle tabsStyle = (TabsAndIndentsStyle)NamedStyles.merge(TabsAndIndentsStyle.class, namedStyles);
        return ListUtils.map(sourceFiles, cu -> {
            List markers = ListUtils.concat((List)ListUtils.map((List)cu.getMarkers().getMarkers(), m -> m instanceof NamedStyles ? null : m), (Object)autodetect);
            return cu.withMarkers(cu.getMarkers().withMarkers(markers));
        });
    }

    private static <S extends SourceFile> UnaryOperator<S> addProvenance(Path baseDir, List<Marker> provenance, @Nullable Collection<Path> generatedSources) {
        return s -> {
            for (Marker marker : provenance) {
                s = s.withMarkers(s.getMarkers().addIfAbsent(marker));
            }
            if (generatedSources != null && generatedSources.contains(baseDir.resolve(s.getSourcePath()))) {
                s = s.withMarkers(s.getMarkers().addIfAbsent((Marker)new Generated(Tree.randomId())));
            }
            return s;
        };
    }

    public static List<Path> listJavaSources(String sourceDirectory) throws MojoExecutionException {
        List<Path> list;
        block9: {
            File sourceDirectoryFile = new File(sourceDirectory);
            if (!sourceDirectoryFile.exists()) {
                return Collections.emptyList();
            }
            Path sourceRoot = sourceDirectoryFile.toPath();
            Stream<Path> files = Files.find(sourceRoot, 16, (f, a) -> !a.isDirectory() && f.toString().endsWith(".java"), new FileVisitOption[0]);
            try {
                list = files.collect(Collectors.toList());
                if (files == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to list Java source files", (Exception)e);
                }
            }
            files.close();
        }
        return list;
    }
}

