/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Result;
import org.openrewrite.maven.AbstractRewriteMojo;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.RemovePlugin;

@Mojo(name="remove", threadSafe=true)
@Execute
public class RemoveMojo
extends AbstractRewriteMojo {
    @Parameter(property="groupId", defaultValue="org.openrewrite.maven")
    protected String groupId;
    @Parameter(property="artifactId", defaultValue="rewrite-maven-plugin")
    protected String artifactId;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path baseDir = this.getBaseDir();
        ExecutionContext ctx = this.executionContext();
        MavenParser mp = MavenParser.builder().mavenConfig(baseDir.resolve(".mvn/maven.config")).build();
        List poms = mp.parse(Collections.singleton(this.project.getFile().toPath()), baseDir, ctx);
        Result result = (Result)new RemovePlugin(this.groupId, this.artifactId).run(poms).get(0);
        assert (result.getBefore() != null);
        assert (result.getAfter() != null);
        try (BufferedWriter sourceFileWriter = Files.newBufferedWriter(baseDir.resolve(result.getBefore().getSourcePath()), new OpenOption[0]);){
            sourceFileWriter.write(result.getAfter().printAll());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.getLog().info((CharSequence)("Removed " + this.artifactId + " from " + this.project.getFile().getPath()));
    }
}

