/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.puppycrawl.tools.checkstyle.Checker;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.style.CheckstyleConfigLoader;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.MeterRegistryProvider;
import org.openrewrite.maven.cache.InMemoryMavenPomCache;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.cache.RocksdbMavenPomCache;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.YamlVisitor;

public abstract class AbstractRewriteMojo
extends AbstractMojo {
    @Parameter(property="configLocation", defaultValue="${maven.multiModuleProjectDirectory}/rewrite.yml")
    String configLocation;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Component
    protected RuntimeInformation runtime;
    @Parameter(property="activeRecipes")
    protected Set<String> activeRecipes = Collections.emptySet();
    @Parameter(property="activeStyles")
    protected Set<String> activeStyles = Collections.emptySet();
    @Nullable
    @Parameter(property="metricsUri")
    private String metricsUri;
    @Nullable
    @Parameter(property="metricsUsername")
    private String metricsUsername;
    @Nullable
    @Parameter(property="metricsPassword")
    private String metricsPassword;
    @Parameter(property="pomCacheEnabled", defaultValue="true")
    private boolean pomCacheEnabled;
    @Nullable
    @Parameter(property="pomCacheDirectory")
    private String pomCacheDirectory;
    @Nullable
    @Parameter(property="checkstyleConfigFile")
    private String checkstyleConfigFile;
    @Parameter(property="failOnInvalidActiveRecipes", defaultValue="false")
    private boolean failOnInvalidActiveRecipes;
    private static final String RECIPE_NOT_FOUND_EXCEPTION_MSG = "Could not find recipe '%s' among available recipes";
    protected boolean suppressWarnings = false;

    protected Environment environment() throws MojoExecutionException {
        File rewriteConfig;
        Environment.Builder env = Environment.builder((Properties)this.project.getProperties()).scanRuntimeClasspath(new String[0]).scanUserHome();
        Path absoluteConfigLocation = Paths.get(this.configLocation, new String[0]);
        if (!absoluteConfigLocation.isAbsolute()) {
            absoluteConfigLocation = this.project.getBasedir().toPath().resolve(this.configLocation);
        }
        if ((rewriteConfig = absoluteConfigLocation.toFile()).exists()) {
            try (FileInputStream is = new FileInputStream(rewriteConfig);){
                env.load((ResourceLoader)new YamlResourceLoader((InputStream)is, rewriteConfig.toURI(), this.project.getProperties()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to load rewrite configuration", (Exception)e);
            }
        }
        return env.build();
    }

    protected ExecutionContext executionContext() {
        return new InMemoryExecutionContext(t -> {
            if (!this.suppressWarnings) {
                this.getLog().warn((CharSequence)t.getMessage());
            }
            this.getLog().debug(t);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Maven parseMaven(Path baseDir, ExecutionContext ctx) {
        MavenSettings settings;
        Path mavenSettings;
        ArrayList<Path> allPoms = new ArrayList<Path>();
        allPoms.add(this.project.getFile().toPath());
        if (this.project.getCollectedProjects() != null) {
            this.project.getCollectedProjects().stream().filter(collectedProject -> collectedProject != this.project).map(collectedProject -> collectedProject.getFile().toPath()).forEach(allPoms::add);
        }
        for (MavenProject parent = this.project.getParent(); parent != null && parent.getFile() != null; parent = parent.getParent()) {
            allPoms.add(parent.getFile().toPath());
        }
        MavenParser.Builder mavenParserBuilder = MavenParser.builder().mavenConfig(baseDir.resolve(".mvn/maven.config"));
        if (this.pomCacheEnabled) {
            try {
                if (this.pomCacheDirectory == null) {
                    mavenParserBuilder.cache((MavenPomCache)new RocksdbMavenPomCache(Paths.get(System.getProperty("user.home"), new String[0])));
                } else {
                    mavenParserBuilder.cache((MavenPomCache)new RocksdbMavenPomCache(Paths.get(this.pomCacheDirectory, new String[0])));
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"Unable to initialize RocksdbMavenPomCache, falling back to InMemoryMavenPomCache");
                this.getLog().debug((Throwable)e);
                mavenParserBuilder.cache((MavenPomCache)new InMemoryMavenPomCache());
            }
        }
        if ((mavenSettings = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".m2/settings.xml")).toFile().exists() && (settings = MavenSettings.parse((Parser.Input)new Parser.Input(mavenSettings, () -> {
            try {
                return Files.newInputStream(mavenSettings, new OpenOption[0]);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Unable to load Maven settings from user home directory. Skipping.", (Throwable)e);
                return null;
            }
        }), (ExecutionContext)ctx)) != null) {
            new MavenExecutionContextView(ctx).setMavenSettings(settings, new String[0]);
            if (settings.getActiveProfiles() != null) {
                mavenParserBuilder.activeProfiles(settings.getActiveProfiles().getActiveProfiles().toArray(new String[0]));
            }
        }
        try {
            this.suppressWarnings = true;
            Maven maven = (Maven)mavenParserBuilder.build().parse(allPoms, baseDir, ctx).iterator().next();
            return maven;
        }
        finally {
            this.suppressWarnings = false;
        }
    }

    protected Path getBaseDir() {
        Object maybeMultiModuleDir = System.getProperties().get("maven.multiModuleProjectDirectory");
        try {
            if (maybeMultiModuleDir instanceof String) {
                return Paths.get((String)maybeMultiModuleDir, new String[0]).toRealPath(new LinkOption[0]);
            }
            return this.project.getBasedir().toPath().toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResultsContainer listResults() throws MojoExecutionException {
        try (MeterRegistryProvider meterRegistryProvider = new MeterRegistryProvider(this.getLog(), this.metricsUri, this.metricsUsername, this.metricsPassword);){
            List styles;
            Environment env;
            Path baseDir;
            block32: {
                Metrics.addRegistry((MeterRegistry)meterRegistryProvider.registry());
                baseDir = this.getBaseDir();
                this.getLog().info((CharSequence)String.format("Using active recipe(s) %s", this.activeRecipes));
                this.getLog().info((CharSequence)String.format("Using active styles(s) %s", this.activeStyles));
                if (this.activeRecipes.isEmpty()) {
                    ResultsContainer resultsContainer = new ResultsContainer(baseDir, Collections.emptyList());
                    return resultsContainer;
                }
                env = this.environment();
                styles = env.activateStyles(this.activeStyles);
                try {
                    Object checkstyleConfRaw;
                    Plugin checkstylePlugin = this.project.getPlugin("org.apache.maven.plugins:maven-checkstyle-plugin");
                    if (this.checkstyleConfigFile != null && !this.checkstyleConfigFile.isEmpty()) {
                        styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((Path)Paths.get(this.checkstyleConfigFile, new String[0]), Collections.emptyMap()));
                        break block32;
                    }
                    if (checkstylePlugin == null || !((checkstyleConfRaw = checkstylePlugin.getConfiguration()) instanceof Xpp3Dom)) break block32;
                    Xpp3Dom xmlCheckstyleConf = (Xpp3Dom)checkstyleConfRaw;
                    Xpp3Dom xmlConfigLocation = xmlCheckstyleConf.getChild("configLocation");
                    if (xmlConfigLocation == null) {
                        try (InputStream is = Checker.class.getResourceAsStream("/sun_checks.xml");){
                            if (is != null) {
                                styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((InputStream)is, Collections.emptyMap()));
                            }
                            break block32;
                        }
                    }
                    Path configPath = Paths.get(xmlConfigLocation.getValue(), new String[0]);
                    styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((Path)configPath, Collections.emptyMap()));
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)"Unable to parse checkstyle configuration. Checkstyle will not inform rewrite execution.", (Throwable)e);
                }
            }
            Recipe recipe = env.activateRecipes(this.activeRecipes);
            this.getLog().info((CharSequence)"Validating active recipes...");
            Collection validated = recipe.validateAll();
            List<Validated.Invalid> failedValidations = validated.stream().map(Validated::failures).flatMap(Collection::stream).collect(Collectors.toList());
            if (!failedValidations.isEmpty()) {
                failedValidations.forEach(failedValidation -> this.getLog().error((CharSequence)("Recipe validation error in " + failedValidation.getProperty() + ": " + failedValidation.getMessage()), failedValidation.getException()));
                if (this.failOnInvalidActiveRecipes) {
                    throw new MojoExecutionException("Recipe validation errors detected as part of one or more activeRecipe(s). Please check error logs.");
                }
                this.getLog().error((CharSequence)"Recipe validation errors detected as part of one or more activeRecipe(s). Execution will continue regardless.");
            }
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)styles).logCompilationWarningsAndErrors(false).build();
            ExecutionContext ctx = this.executionContext();
            this.getLog().info((CharSequence)"Parsing Java main files...");
            ArrayList mainJavaSourceFiles = new ArrayList(512);
            List dependencies = this.project.getCompileClasspathElements().stream().distinct().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
            javaParser.setClasspath(dependencies);
            mainJavaSourceFiles.addAll(javaParser.parse(AbstractRewriteMojo.listJavaSources(this.project.getBuild().getSourceDirectory()), baseDir, ctx));
            HashSet<Path> mainResources = new HashSet<Path>(512);
            for (Resource resource : this.project.getBuild().getResources()) {
                this.addToResources(ctx, mainResources, resource);
            }
            List<Marker> projectProvenance = this.getJavaProvenance();
            JavaSourceSet mainProvenance = JavaSourceSet.build((String)"main", dependencies, (ExecutionContext)ctx);
            ArrayList<Maven> sourceFiles = new ArrayList<Maven>(ListUtils.map(mainJavaSourceFiles, this.addProvenance(projectProvenance, mainProvenance)));
            this.getLog().info((CharSequence)"Parsing Java test files...");
            ArrayList testJavaSourceFiles = new ArrayList(512);
            List testDependencies = this.project.getTestClasspathElements().stream().distinct().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
            javaParser.setClasspath(testDependencies);
            testJavaSourceFiles.addAll(javaParser.parse(AbstractRewriteMojo.listJavaSources(this.project.getBuild().getTestSourceDirectory()), baseDir, ctx));
            HashSet<Path> testResources = new HashSet<Path>(512);
            for (Resource resource : this.project.getBuild().getTestResources()) {
                this.addToResources(ctx, testResources, resource);
            }
            JavaSourceSet testProvenance = JavaSourceSet.build((String)"test", dependencies, (ExecutionContext)ctx);
            sourceFiles.addAll(ListUtils.map(testJavaSourceFiles, this.addProvenance(projectProvenance, testProvenance)));
            ArrayList otherMainSourceFiles = new ArrayList(512);
            ArrayList otherTestSourceFiles = new ArrayList(512);
            HashSet recipeTypes = new HashSet();
            this.discoverRecipeTypes(recipe, recipeTypes);
            if (recipeTypes.contains(YamlVisitor.class)) {
                this.getLog().info((CharSequence)"Parsing YAML files...");
                YamlParser yamlParser = new YamlParser();
                otherMainSourceFiles.addAll(yamlParser.parse((Iterable)mainResources.stream().filter(it -> it.getFileName().toString().endsWith(".yml") || it.getFileName().toString().endsWith(".yaml")).collect(Collectors.toList()), baseDir, ctx));
                otherTestSourceFiles.addAll(yamlParser.parse((Iterable)testResources.stream().filter(it -> it.getFileName().toString().endsWith(".yml") || it.getFileName().toString().endsWith(".yaml")).collect(Collectors.toList()), baseDir, ctx));
            } else {
                this.getLog().info((CharSequence)"Skipping YAML files because there are no active YAML recipes.");
            }
            if (recipeTypes.contains(PropertiesVisitor.class)) {
                this.getLog().info((CharSequence)"Parsing properties files...");
                PropertiesParser propertiesParser = new PropertiesParser();
                otherMainSourceFiles.addAll(propertiesParser.parse((Iterable)mainResources.stream().filter(it -> it.getFileName().toString().endsWith(".properties")).collect(Collectors.toList()), baseDir, ctx));
                otherTestSourceFiles.addAll(propertiesParser.parse((Iterable)testResources.stream().filter(it -> it.getFileName().toString().endsWith(".properties")).collect(Collectors.toList()), baseDir, ctx));
            } else {
                this.getLog().info((CharSequence)"Skipping properties files because there are no active properties recipes.");
            }
            if (recipeTypes.contains(XmlVisitor.class)) {
                this.getLog().info((CharSequence)"Parsing XML files...");
                XmlParser xmlParser = new XmlParser();
                otherMainSourceFiles.addAll(xmlParser.parse((Iterable)mainResources.stream().filter(it -> it.getFileName().toString().endsWith(".xml")).collect(Collectors.toList()), baseDir, ctx));
                otherTestSourceFiles.addAll(xmlParser.parse((Iterable)testResources.stream().filter(it -> it.getFileName().toString().endsWith(".xml")).collect(Collectors.toList()), baseDir, ctx));
            } else {
                this.getLog().info((CharSequence)"Skipping XML files because there are no active XML recipes.");
            }
            sourceFiles.addAll(ListUtils.map(otherMainSourceFiles, this.addProvenance(projectProvenance, mainProvenance)));
            sourceFiles.addAll(ListUtils.map(otherTestSourceFiles, this.addProvenance(projectProvenance, testProvenance)));
            if (recipeTypes.contains(MavenVisitor.class)) {
                this.getLog().info((CharSequence)"Parsing POM...");
                Maven pomAst = this.parseMaven(baseDir, ctx);
                sourceFiles.add(pomAst.withMarkers(pomAst.getMarkers().withMarkers(ListUtils.concatAll((List)pomAst.getMarkers().getMarkers(), projectProvenance))));
            } else {
                this.getLog().info((CharSequence)"Skipping Maven POM files because there are no active Maven recipes.");
            }
            this.getLog().info((CharSequence)"Running recipe(s)...");
            List results = recipe.run(sourceFiles, ctx);
            Metrics.removeRegistry((MeterRegistry)meterRegistryProvider.registry());
            ResultsContainer resultsContainer = new ResultsContainer(baseDir, results);
            return resultsContainer;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Dependency resolution required", (Exception)((Object)e));
        }
    }

    private List<Marker> getJavaProvenance() {
        String propertiesTargetCompatibility;
        String javaRuntimeVersion = System.getProperty("java.runtime.version");
        String javaVendor = System.getProperty("java.vm.vendor");
        String sourceCompatibility = javaRuntimeVersion;
        String targetCompatibility = javaRuntimeVersion;
        String propertiesSourceCompatibility = (String)this.project.getProperties().get("maven.compiler.source");
        if (propertiesSourceCompatibility != null) {
            sourceCompatibility = propertiesSourceCompatibility;
        }
        if ((propertiesTargetCompatibility = (String)this.project.getProperties().get("maven.compiler.target")) != null) {
            targetCompatibility = propertiesTargetCompatibility;
        }
        return Arrays.asList(new BuildTool(Tree.randomId(), BuildTool.Type.Maven, this.runtime.getMavenVersion()), new JavaVersion(Tree.randomId(), javaRuntimeVersion, javaVendor, sourceCompatibility, targetCompatibility), new JavaProject(Tree.randomId(), this.project.getName(), new JavaProject.Publication(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion())));
    }

    private <S extends SourceFile> UnaryOperator<S> addProvenance(List<Marker> projectProvenance, JavaSourceSet sourceSet) {
        return s -> {
            for (Marker marker : projectProvenance) {
                s = s.withMarkers(s.getMarkers().addIfAbsent(marker));
            }
            s = s.withMarkers(s.getMarkers().addIfAbsent((Marker)sourceSet));
            return s;
        };
    }

    private void discoverRecipeTypes(Recipe recipe, Set<Class<?>> recipeTypes) {
        for (Recipe next : recipe.getRecipeList()) {
            this.discoverRecipeTypes(next, recipeTypes);
        }
        try {
            Method getVisitor = recipe.getClass().getDeclaredMethod("getVisitor", new Class[0]);
            getVisitor.setAccessible(true);
            Object visitor = getVisitor.invoke((Object)recipe, new Object[0]);
            if (visitor instanceof MavenVisitor) {
                recipeTypes.add(MavenVisitor.class);
            } else if (visitor instanceof JavaVisitor) {
                recipeTypes.add(JavaVisitor.class);
            } else if (visitor instanceof PropertiesVisitor) {
                recipeTypes.add(PropertiesVisitor.class);
            } else if (visitor instanceof XmlVisitor) {
                recipeTypes.add(XmlVisitor.class);
            } else if (visitor instanceof YamlVisitor) {
                recipeTypes.add(YamlVisitor.class);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private void addToResources(ExecutionContext ctx, Set<Path> resources, Resource resource) {
        File file = new File(resource.getDirectory());
        if (file.exists()) {
            BiPredicate<Path, BasicFileAttributes> predicate = (p, bfa) -> bfa.isRegularFile() && Stream.of("yml", "yaml", "properties", "xml").anyMatch(type -> p.getFileName().toString().endsWith((String)type));
            try {
                Files.find(file.toPath(), 999, predicate, new FileVisitOption[0]).forEach(resources::add);
            }
            catch (IOException e) {
                ctx.getOnError().accept(e);
            }
        }
    }

    protected static List<Path> listJavaSources(String sourceDirectory) throws MojoExecutionException {
        File sourceDirectoryFile = new File(sourceDirectory);
        if (!sourceDirectoryFile.exists()) {
            return Collections.emptyList();
        }
        Path sourceRoot = sourceDirectoryFile.toPath();
        try {
            return Files.walk(sourceRoot, new FileVisitOption[0]).filter(f -> !Files.isDirectory(f, new LinkOption[0]) && f.toFile().getName().endsWith(".java")).map(it -> {
                try {
                    return it.toRealPath(new LinkOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to list Java source files", (Exception)e);
        }
    }

    protected void logRecipesThatMadeChanges(Result result) {
        for (Recipe recipe : result.getRecipesThatMadeChanges()) {
            this.getLog().warn((CharSequence)("    " + recipe.getName()));
        }
    }

    public static RecipeDescriptor getRecipeDescriptor(String recipe, Collection<RecipeDescriptor> recipeDescriptors) throws MojoExecutionException {
        return recipeDescriptors.stream().filter(r -> r.getName().equalsIgnoreCase(recipe)).findAny().orElseThrow(() -> new MojoExecutionException(String.format(RECIPE_NOT_FOUND_EXCEPTION_MSG, recipe)));
    }

    public static class ResultsContainer {
        final Path projectRoot;
        final List<Result> generated = new ArrayList<Result>();
        final List<Result> deleted = new ArrayList<Result>();
        final List<Result> moved = new ArrayList<Result>();
        final List<Result> refactoredInPlace = new ArrayList<Result>();

        public ResultsContainer(Path projectRoot, Collection<Result> results) {
            this.projectRoot = projectRoot;
            for (Result result : results) {
                if (result.getBefore() == null && result.getAfter() == null) continue;
                if (result.getBefore() == null && result.getAfter() != null) {
                    this.generated.add(result);
                    continue;
                }
                if (result.getBefore() != null && result.getAfter() == null) {
                    this.deleted.add(result);
                    continue;
                }
                if (result.getBefore() != null && !result.getBefore().getSourcePath().equals(result.getAfter().getSourcePath())) {
                    this.moved.add(result);
                    continue;
                }
                this.refactoredInPlace.add(result);
            }
        }

        public Path getProjectRoot() {
            return this.projectRoot;
        }

        public boolean isNotEmpty() {
            return !this.generated.isEmpty() || !this.deleted.isEmpty() || !this.moved.isEmpty() || !this.refactoredInPlace.isEmpty();
        }
    }
}

