/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.openrewrite.Recipe;
import org.openrewrite.config.Environment;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AbstractRewriteMojo;

@Mojo(name="discover", threadSafe=true)
public class RewriteDiscoverMojo
extends AbstractRewriteMojo {
    @Nullable
    @Parameter(property="recipe")
    String recipeFilter;
    @Parameter(property="rewrite.discover.verbose", defaultValue="false")
    boolean verbose;
    @Parameter(property="rewrite.discover.recursive", defaultValue="false")
    boolean recursive;

    public void execute() throws MojoExecutionException {
        Environment env = this.environment();
        if (this.recipeFilter != null) {
            RecipeDescriptor recipeDescriptor = env.listRecipeDescriptors().stream().filter(r -> r.getName().equalsIgnoreCase(this.recipeFilter)).findAny().orElse(null);
            if (recipeDescriptor == null) {
                this.getLog().info((CharSequence)("Recipe " + this.recipeFilter + " not found."));
            } else {
                this.logRecipeDescriptor(recipeDescriptor, this.verbose, this.recursive);
            }
            return;
        }
        Collection recipesByName = env.listRecipes();
        this.getLog().info((CharSequence)("Found " + this.activeRecipes.size() + " active recipes and " + recipesByName.size() + " activatable recipes."));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Active Recipes:");
        for (String activeRecipe : this.activeRecipes) {
            this.getLog().info((CharSequence)("    " + activeRecipe));
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Activatable Recipes:");
        for (Recipe recipe : recipesByName) {
            this.getLog().info((CharSequence)("    " + recipe.getName()));
        }
        this.getLog().info((CharSequence)"");
        if (this.verbose) {
            this.getLog().info((CharSequence)"Descriptors:");
            for (RecipeDescriptor recipeDescriptor : env.listRecipeDescriptors()) {
                this.logRecipeDescriptor(recipeDescriptor, this.verbose, this.recursive);
            }
        }
    }

    private void logRecipeDescriptor(RecipeDescriptor recipeDescriptor, boolean verbose, boolean recursive) {
        if (verbose) {
            this.getLog().info((CharSequence)("    Name: " + recipeDescriptor.getName()));
            this.getLog().info((CharSequence)("    Display name: " + recipeDescriptor.getDisplayName()));
            this.getLog().info((CharSequence)("    Description: " + recipeDescriptor.getDescription()));
            if (!recipeDescriptor.getTags().isEmpty()) {
                this.getLog().info((CharSequence)("    Tags: " + String.join((CharSequence)",", recipeDescriptor.getTags())));
            }
        } else {
            this.getLog().info((CharSequence)("    " + recipeDescriptor.getName()));
        }
        if (!recipeDescriptor.getOptions().isEmpty()) {
            if (verbose) {
                this.getLog().info((CharSequence)"    Options:");
            }
            for (OptionDescriptor optionDescriptor : recipeDescriptor.getOptions()) {
                StringBuilder optionBuilder = new StringBuilder(optionDescriptor.getName()).append(": ").append(optionDescriptor.getType());
                if (optionDescriptor.isRequired()) {
                    optionBuilder.append("!");
                }
                this.getLog().info((CharSequence)("        " + optionBuilder));
                if (!verbose) continue;
                this.getLog().info((CharSequence)("        Display name: " + optionDescriptor.getDisplayName()));
                this.getLog().info((CharSequence)("        Description: " + optionDescriptor.getDescription()));
                this.getLog().info((CharSequence)"");
            }
        }
        if (!recipeDescriptor.getRecipeList().isEmpty()) {
            if (verbose) {
                this.getLog().info((CharSequence)"    Recipe list:");
            }
            for (RecipeDescriptor r : recipeDescriptor.getRecipeList()) {
                this.logNestedRecipeDescriptor(r, verbose, recursive, "        ");
            }
            if (verbose) {
                this.getLog().info((CharSequence)"");
            }
        }
        if (!verbose || recipeDescriptor.getOptions().isEmpty() && recipeDescriptor.getRecipeList().isEmpty()) {
            this.getLog().info((CharSequence)"");
        }
    }

    private void logNestedRecipeDescriptor(RecipeDescriptor recipeDescriptor, boolean verbose, boolean recursive, String indent) {
        if (verbose) {
            this.getLog().info((CharSequence)(indent + "Name: " + recipeDescriptor.getName()));
            this.getLog().info((CharSequence)(indent + "Display name: " + recipeDescriptor.getDisplayName()));
            this.getLog().info((CharSequence)(indent + "Description: " + recipeDescriptor.getDescription()));
            if (!recipeDescriptor.getTags().isEmpty()) {
                this.getLog().info((CharSequence)(indent + "Tags: " + String.join((CharSequence)",", recipeDescriptor.getTags())));
            }
        } else {
            this.getLog().info((CharSequence)(indent + recipeDescriptor.getName()));
        }
        if (!recipeDescriptor.getOptions().isEmpty()) {
            if (verbose) {
                this.getLog().info((CharSequence)(indent + "Options:"));
            }
            for (OptionDescriptor optionDescriptor : recipeDescriptor.getOptions()) {
                this.getLog().info((CharSequence)(indent + "    " + optionDescriptor.getName() + ": " + optionDescriptor.getValue()));
            }
            if (verbose) {
                this.getLog().info((CharSequence)"");
            }
        }
        if (recursive && !recipeDescriptor.getRecipeList().isEmpty()) {
            if (verbose) {
                this.getLog().info((CharSequence)(indent + "Recipe list:"));
            }
            for (RecipeDescriptor nestedRecipeDescriptor : recipeDescriptor.getRecipeList()) {
                this.logNestedRecipeDescriptor(nestedRecipeDescriptor, verbose, true, indent + "    ");
            }
            if (verbose) {
                this.getLog().info((CharSequence)"");
            }
        }
        if (!verbose || recipeDescriptor.getOptions().isEmpty() && recipeDescriptor.getRecipeList().isEmpty()) {
            this.getLog().info((CharSequence)"");
        }
    }
}

