/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.openrewrite.Result;
import org.openrewrite.maven.AbstractRewriteMojo;

@Mojo(name="dryRun", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES)
@Execute(phase=LifecyclePhase.PROCESS_TEST_CLASSES)
public class RewriteDryRunMojo
extends AbstractRewriteMojo {
    public void execute() throws MojoExecutionException {
        AbstractRewriteMojo.ResultsContainer results = this.listResults();
        if (results.isNotEmpty()) {
            for (Result result : results.generated) {
                assert (result.getAfter() != null);
                this.getLog().warn((CharSequence)("Applying fixes would generate new file " + result.getAfter().getSourcePath() + " by:"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.deleted) {
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("Applying fixes would delete file " + result.getBefore().getSourcePath() + " by:"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.moved) {
                assert (result.getBefore() != null);
                assert (result.getAfter() != null);
                this.getLog().warn((CharSequence)("Applying fixes would move file from " + result.getBefore().getSourcePath() + " to " + result.getAfter().getSourcePath() + " by:"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.refactoredInPlace) {
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("Applying fixes would make results to " + result.getBefore().getSourcePath() + " by:"));
                this.logRecipesThatMadeChanges(result);
            }
            this.getLog().warn((CharSequence)"Run 'mvn rewrite:run' to apply the fixes. Afterwards, review and commit the results.");
        }
    }
}

