/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.openrewrite.Result;
import org.openrewrite.maven.AbstractRewriteMojo;

@Mojo(name="fix", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
@Execute(phase=LifecyclePhase.PROCESS_TEST_CLASSES)
public class RewriteFixMojo
extends AbstractRewriteMojo {
    public void execute() throws MojoExecutionException {
        AbstractRewriteMojo.ResultsContainer results = this.listResults();
        if (results.isNotEmpty()) {
            for (Result result : results.generated) {
                assert (result.getAfter() != null);
                this.getLog().warn((CharSequence)("Generated new file " + result.getAfter().getSourcePath().normalize() + " by:"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.deleted) {
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("Deleted file " + result.getBefore().getSourcePath().normalize() + " by:"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.moved) {
                assert (result.getAfter() != null);
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("File has been moved from " + result.getBefore().getSourcePath().normalize() + " to " + result.getAfter().getSourcePath().normalize() + " by:"));
                this.logRecipesThatMadeChanges(result);
            }
            for (Result result : results.refactoredInPlace) {
                assert (result.getBefore() != null);
                this.getLog().warn((CharSequence)("Changes have been made to " + result.getBefore().getSourcePath().normalize() + " by:"));
                this.logRecipesThatMadeChanges(result);
            }
            this.getLog().warn((CharSequence)"Please review and commit the results.");
            try {
                boolean deleteSucceeded;
                Path originalLocation;
                BufferedWriter sourceFileWriter;
                for (Result result : results.generated) {
                    assert (result.getAfter() != null);
                    sourceFileWriter = Files.newBufferedWriter(results.getProjectRoot().resolve(result.getAfter().getSourcePath()), new OpenOption[0]);
                    try {
                        sourceFileWriter.write(result.getAfter().print());
                    }
                    finally {
                        if (sourceFileWriter == null) continue;
                        sourceFileWriter.close();
                    }
                }
                for (Result result : results.deleted) {
                    assert (result.getBefore() != null);
                    originalLocation = results.getProjectRoot().resolve(result.getBefore().getSourcePath()).normalize();
                    deleteSucceeded = originalLocation.toFile().delete();
                    if (deleteSucceeded) continue;
                    throw new IOException("Unable to delete file " + originalLocation.toAbsolutePath());
                }
                for (Result result : results.moved) {
                    assert (result.getBefore() != null);
                    originalLocation = results.getProjectRoot().resolve(result.getBefore().getSourcePath());
                    deleteSucceeded = originalLocation.toFile().delete();
                    if (!deleteSucceeded) {
                        throw new IOException("Unable to delete file " + originalLocation.toAbsolutePath());
                    }
                    assert (result.getAfter() != null);
                    Path afterLocation = results.getProjectRoot().resolve(result.getAfter().getSourcePath());
                    File parentDir = afterLocation.toFile().getParentFile();
                    parentDir.mkdirs();
                    BufferedWriter sourceFileWriter2 = Files.newBufferedWriter(afterLocation, new OpenOption[0]);
                    try {
                        sourceFileWriter2.write(result.getAfter().print());
                    }
                    finally {
                        if (sourceFileWriter2 == null) continue;
                        sourceFileWriter2.close();
                    }
                }
                for (Result result : results.refactoredInPlace) {
                    assert (result.getBefore() != null);
                    sourceFileWriter = Files.newBufferedWriter(results.getProjectRoot().resolve(result.getBefore().getSourcePath()), new OpenOption[0]);
                    try {
                        assert (result.getAfter() != null);
                        sourceFileWriter.write(result.getAfter().print());
                    }
                    finally {
                        if (sourceFileWriter == null) continue;
                        sourceFileWriter.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to rewrite source files", e);
            }
        }
    }
}

