/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.openrewrite.Environment;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeSerializer;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;
import org.openrewrite.maven.AbstractRewriteMojo;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.utilities.PrintMavenAsCycloneDxBom;

@Mojo(name="publish", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class RewritePublishMojo
extends AbstractRewriteMojo {
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(name="skipCycloneDxBom", property="skipCycloneDxBom", defaultValue="false")
    private boolean skipCycloneDxBom;

    public void execute() throws MojoExecutionException {
        Environment env = this.environment();
        File rewriteJar = this.buildAstJar(env);
        this.projectHelper.attachArtifact(this.project, rewriteJar, "ast");
        if (!this.skipCycloneDxBom) {
            File cycloneDxBom = this.buildCycloneDxBom();
            this.projectHelper.attachArtifact(this.project, "xml", "cyclonedx", cycloneDxBom);
        }
    }

    private File buildAstJar(Environment env) throws MojoExecutionException {
        boolean created;
        ArrayList<Path> javaSources = new ArrayList<Path>();
        javaSources.addAll(this.listJavaSources(this.project.getBuild().getSourceDirectory()));
        javaSources.addAll(this.listJavaSources(this.project.getBuild().getTestSourceDirectory()));
        List dependencies = this.project.getArtifacts().stream().map(d -> d.getFile().toPath()).collect(Collectors.toList());
        List sourceFiles = JavaParser.fromJavaVersion().styles((Iterable)env.styles((Iterable)this.activeStyles)).classpath(dependencies).logCompilationWarningsAndErrors(false).build().parse(javaSources, this.project.getBasedir().toPath());
        File outputDir = new File(this.project.getBuild().getDirectory());
        if (!outputDir.exists() && !(created = outputDir.mkdir())) {
            throw new MojoExecutionException("Unable to create directory to write ast.jar into: " + outputDir);
        }
        File rewriteJar = new File(outputDir, this.project.getArtifactId() + "-" + this.project.getVersion() + "-ast.jar");
        TreeSerializer serializer = new TreeSerializer();
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(rewriteJar));){
            for (J.CompilationUnit cu : sourceFiles) {
                ZipEntry entry = new ZipEntry(Paths.get(cu.getSourcePath().toString(), new String[0]).toString());
                zos.putNextEntry(entry);
                zos.write(serializer.write((SourceFile)cu));
                zos.closeEntry();
            }
            zos.flush();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write AST JAR", (Exception)e);
        }
        return rewriteJar;
    }

    private File buildCycloneDxBom() {
        ArrayList<Path> allPoms = new ArrayList<Path>();
        allPoms.add(this.project.getFile().toPath());
        for (MavenProject parent = this.project.getParent(); parent != null && parent.getFile() != null; parent = parent.getParent()) {
            allPoms.add(parent.getFile().toPath());
        }
        try {
            Maven pomAst = (Maven)MavenParser.builder().resolveOptional(Boolean.valueOf(false)).build().parse(allPoms, this.project.getBasedir().toPath()).iterator().next();
            File cycloneDxBom = new File(this.project.getBuild().getDirectory(), this.project.getArtifactId() + "-" + this.project.getVersion() + "-cyclonedx.xml");
            Files.write(cycloneDxBom.toPath(), ((String)new PrintMavenAsCycloneDxBom().visit((Tree)pomAst)).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return cycloneDxBom;
        }
        catch (Throwable t) {
            this.getLog().warn((CharSequence)"Unable to produce CycloneDX BOM", t);
            return null;
        }
    }
}

