/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.micrometer.prometheus.rsocket.PrometheusRSocketClient;
import io.prometheus.client.CollectorRegistry;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import io.rsocket.transport.netty.client.WebsocketClientTransport;
import java.net.URI;
import java.time.Duration;
import java.util.Base64;
import org.apache.maven.plugin.logging.Log;
import org.openrewrite.maven.MavenLoggingMeterRegistry;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.TcpClient;
import reactor.util.retry.Retry;

public class MeterRegistryProvider
implements AutoCloseable {
    private final Log log;
    private final String uriString;
    private final String username;
    private final String password;
    private PrometheusRSocketClient metricsClient;
    private MeterRegistry registry;

    public MeterRegistryProvider(Log log, String uriString, String username, String password) {
        this.log = log;
        this.uriString = uriString;
        this.username = username;
        this.password = password;
    }

    public MeterRegistry registry() {
        this.registry = this.buildRegistry();
        return this.registry;
    }

    private MeterRegistry buildRegistry() {
        if (this.uriString == null) {
            return new CompositeMeterRegistry();
        }
        if (this.uriString.equals("LOG")) {
            return new MavenLoggingMeterRegistry(this.log);
        }
        try {
            TcpClientTransport clientTransport;
            URI uri = URI.create(this.uriString);
            PrometheusMeterRegistry registry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT, new CollectorRegistry(), Clock.SYSTEM);
            switch (uri.getScheme()) {
                case "ephemeral": 
                case "https": 
                case "wss": {
                    TcpClient tcpClient = TcpClient.create().secure().host(uri.getHost()).port(uri.getPort() == -1 ? 443 : uri.getPort());
                    clientTransport = this.getWebsocketClientTransport(tcpClient);
                    break;
                }
                case "http": 
                case "ws": {
                    TcpClient tcpClient = TcpClient.create().host(uri.getHost()).port(uri.getPort() == -1 ? 80 : uri.getPort());
                    clientTransport = this.getWebsocketClientTransport(tcpClient);
                    break;
                }
                case "tcp": {
                    clientTransport = TcpClientTransport.create((String)uri.getHost(), (int)uri.getPort());
                    break;
                }
                default: {
                    this.log.warn((CharSequence)("Unable to publish metrics. Unrecognized scheme " + uri.getScheme()));
                    return new CompositeMeterRegistry();
                }
            }
            this.metricsClient = PrometheusRSocketClient.build((MeterRegistry)registry, () -> ((PrometheusMeterRegistry)registry).scrape(), (ClientTransport)clientTransport).retry((Retry)Retry.backoff((long)Long.MAX_VALUE, (Duration)Duration.ofSeconds(1L)).maxBackoff(Duration.ofSeconds(3L))).connect();
            return registry;
        }
        catch (Throwable t) {
            this.log.warn((CharSequence)"Unable to publish metrics", t);
            return new CompositeMeterRegistry();
        }
    }

    private ClientTransport getWebsocketClientTransport(TcpClient tcpClient) {
        HttpClient httpClient = HttpClient.from((TcpClient)tcpClient).wiretap(true);
        if (this.username != null && this.password != null) {
            httpClient = httpClient.headers(h -> h.add("Authorization", (Object)("Basic: " + Base64.getUrlEncoder().encodeToString((this.username + ":" + this.password).getBytes()))));
        }
        return WebsocketClientTransport.create((HttpClient)httpClient, (String)"/");
    }

    @Override
    public void close() {
        if (this.metricsClient != null) {
            try {
                this.metricsClient.pushAndClose().block(Duration.ofSeconds(3L));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.registry != null) {
            this.registry.close();
        }
    }
}

