/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.openrewrite.Change;
import org.openrewrite.maven.AbstractRewriteMojo;

@Mojo(name="warn", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES)
@Execute(phase=LifecyclePhase.PROCESS_TEST_CLASSES)
public class RewriteWarnMojo
extends AbstractRewriteMojo {
    public void execute() throws MojoExecutionException {
        AbstractRewriteMojo.ChangesContainer changes = this.listChanges();
        if (!changes.isEmpty()) {
            for (Change change : changes.generated) {
                this.getLog().warn((CharSequence)("Applying fixes would generate new file " + change.getFixed().getSourcePath() + " by:"));
                this.logVisitorsThatMadeChanges(change);
            }
            for (Change change : changes.deleted) {
                this.getLog().warn((CharSequence)("Applying fixes would delete file " + change.getOriginal().getSourcePath() + " by:"));
                this.logVisitorsThatMadeChanges(change);
            }
            for (Change change : changes.moved) {
                this.getLog().warn((CharSequence)("Applying fixes would move file from " + change.getOriginal().getSourcePath() + " to " + change.getFixed().getSourcePath() + " by:"));
                this.logVisitorsThatMadeChanges(change);
            }
            for (Change change : changes.refactoredInPlace) {
                this.getLog().warn((CharSequence)("Applying fixes would make changes to " + change.getOriginal().getSourcePath() + " by:"));
                this.logVisitorsThatMadeChanges(change);
            }
            this.getLog().warn((CharSequence)"Run 'mvn rewrite:fix' to apply the fixes. Afterwards, review and commit the changes.");
        }
    }
}

