/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.openrewrite.Change;
import org.openrewrite.java.tree.J;
import org.openrewrite.maven.AbstractRewriteMojo;

@Mojo(name="warn", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
@Execute(phase=LifecyclePhase.PROCESS_SOURCES)
public class RewriteWarnMojo
extends AbstractRewriteMojo {
    public void execute() throws MojoExecutionException {
        List<Change<J.CompilationUnit>> changes = this.listChanges();
        if (!changes.isEmpty()) {
            for (Change<J.CompilationUnit> change : changes) {
                this.getLog().warn((CharSequence)("Changes are suggested to " + ((J.CompilationUnit)change.getOriginal()).getSourcePath() + " by:"));
                for (String rule : change.getRulesThatMadeChanges()) {
                    this.getLog().warn((CharSequence)("   " + rule));
                }
            }
            this.getLog().warn((CharSequence)"Run 'mvn rewrite:fix' to apply the fixes. Afterwards, review and commit the changes.");
        }
    }
}

