/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;
import org.openrewrite.config.ProfileConfiguration;
import org.openrewrite.maven.MavenProfileProperty;

public class MavenProfileConfiguration {
    @Parameter(property="name", defaultValue="default")
    String name;
    @Parameter(property="include")
    private Set<String> include;
    @Parameter(property="exclude")
    private Set<String> exclude;
    @Parameter(property="extend")
    private Set<String> extend;
    @Parameter(property="configure")
    List<MavenProfileProperty> configure;

    public ProfileConfiguration toProfileConfiguration() {
        ProfileConfiguration profile = new ProfileConfiguration();
        if (this.name != null) {
            profile.setName(this.name);
        }
        if (this.include != null) {
            profile.setInclude(this.include);
        }
        if (this.exclude != null) {
            profile.setExclude(this.exclude);
        }
        if (this.extend != null) {
            profile.setExtend(this.extend);
        }
        if (this.configure != null) {
            profile.setConfigure(this.configure.stream().collect(Collectors.toMap(prop -> prop.visitor + "." + prop.key, prop -> prop.value)));
        }
        return profile;
    }
}

