/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.marker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.plugins.PluginManager;
import org.gradle.invocation.DefaultGradle;
import org.gradle.plugin.use.PluginId;
import org.gradle.util.GradleVersion;
import org.openrewrite.Tree;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradlePluginDescriptor;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

public final class GradleProjectBuilder {
    private static final Map<GroupArtifact, GroupArtifact> groupArtifactCache = new ConcurrentHashMap<GroupArtifact, GroupArtifact>();
    private static final Map<GroupArtifactVersion, GroupArtifactVersion> groupArtifactVersionCache = new ConcurrentHashMap<GroupArtifactVersion, GroupArtifactVersion>();
    private static final Map<ResolvedGroupArtifactVersion, ResolvedGroupArtifactVersion> resolvedGroupArtifactVersionCache = new ConcurrentHashMap<ResolvedGroupArtifactVersion, ResolvedGroupArtifactVersion>();
    private static final Map<GroupArtifactVersion, org.openrewrite.maven.tree.Dependency> requestedCache = new ConcurrentHashMap<GroupArtifactVersion, org.openrewrite.maven.tree.Dependency>();

    private GradleProjectBuilder() {
    }

    public static GradleProject gradleProject(Project project) {
        HashSet<MavenRepository> pluginRepositories = new HashSet<MavenRepository>();
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.4")) >= 0) {
            SettingsInternal settings = ((DefaultGradle)project.getGradle()).getSettings();
            pluginRepositories.addAll(GradleProjectBuilder.mapRepositories((List<ArtifactRepository>)settings.getBuildscript().getRepositories()));
        }
        pluginRepositories.addAll(GradleProjectBuilder.mapRepositories((List<ArtifactRepository>)project.getBuildscript().getRepositories()));
        return new GradleProject(Tree.randomId(), project.getName(), project.getPath(), GradleProjectBuilder.pluginDescriptors(project.getPluginManager()), GradleProjectBuilder.mapRepositories((List<ArtifactRepository>)project.getRepositories()), new ArrayList<MavenRepository>(pluginRepositories), GradleProjectBuilder.dependencyConfigurations(project.getConfigurations()));
    }

    private static List<MavenRepository> mapRepositories(List<ArtifactRepository> repositories) {
        return repositories.stream().filter(MavenArtifactRepository.class::isInstance).map(MavenArtifactRepository.class::cast).map(repo -> MavenRepository.builder().id(repo.getName()).uri(repo.getUrl().toString()).releases(true).snapshots(true).build()).collect(Collectors.toList());
    }

    public static List<GradlePluginDescriptor> pluginDescriptors(@Nullable PluginManager pluginManager) {
        if (pluginManager instanceof PluginManagerInternal) {
            return GradleProjectBuilder.pluginDescriptors((PluginManagerInternal)pluginManager);
        }
        return Collections.emptyList();
    }

    public static List<GradlePluginDescriptor> pluginDescriptors(PluginManagerInternal pluginManager) {
        return pluginManager.getPluginContainer().stream().map(plugin -> new GradlePluginDescriptor(plugin.getClass().getName(), GradleProjectBuilder.pluginIdForClass(pluginManager, plugin.getClass()))).collect(Collectors.toList());
    }

    @Nullable
    private static String pluginIdForClass(PluginManagerInternal pluginManager, Class<?> pluginClass) {
        try {
            Method findPluginIdForClass = PluginManagerInternal.class.getMethod("findPluginIdForClass", Class.class);
            Optional maybePluginId = (Optional)findPluginIdForClass.invoke((Object)pluginManager, pluginClass);
            return maybePluginId.map(PluginId::getId).orElse(null);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    private static GroupArtifact groupArtifact(org.openrewrite.maven.tree.Dependency dep) {
        return groupArtifactCache.computeIfAbsent(new GroupArtifact(dep.getGroupId(), dep.getArtifactId()), it -> it);
    }

    private static GroupArtifact groupArtifact(ResolvedDependency dep) {
        return groupArtifactCache.computeIfAbsent(new GroupArtifact(dep.getModuleGroup(), dep.getModuleName()), it -> it);
    }

    private static GroupArtifactVersion groupArtifactVersion(ResolvedDependency dep) {
        return groupArtifactVersionCache.computeIfAbsent(new GroupArtifactVersion(dep.getModuleGroup(), dep.getModuleName(), GradleProjectBuilder.unspecifiedToNull(dep.getModuleVersion())), it -> it);
    }

    private static GroupArtifactVersion groupArtifactVersion(Dependency dep) {
        return groupArtifactVersionCache.computeIfAbsent(new GroupArtifactVersion(dep.getGroup(), dep.getName(), GradleProjectBuilder.unspecifiedToNull(dep.getVersion())), it -> it);
    }

    private static ResolvedGroupArtifactVersion resolvedGroupArtifactVersion(ResolvedDependency dep) {
        return resolvedGroupArtifactVersionCache.computeIfAbsent(new ResolvedGroupArtifactVersion(null, dep.getModuleGroup(), dep.getModuleName(), dep.getModuleVersion(), null), it -> it);
    }

    @Nullable
    private static String unspecifiedToNull(@Nullable String maybeUnspecified) {
        if ("unspecified".equals(maybeUnspecified)) {
            return null;
        }
        return maybeUnspecified;
    }

    private static Map<String, GradleDependencyConfiguration> dependencyConfigurations(ConfigurationContainer configurationContainer) {
        HashMap<String, GradleDependencyConfiguration> results = new HashMap<String, GradleDependencyConfiguration>();
        ArrayList configurations = new ArrayList(configurationContainer);
        for (Configuration conf : configurations) {
            List<org.openrewrite.maven.tree.Dependency> requested = conf.getAllDependencies().stream().map(dep -> GradleProjectBuilder.dependency(dep, conf)).collect(Collectors.toList());
            try {
                List<org.openrewrite.maven.tree.ResolvedDependency> resolved;
                Map<GroupArtifact, org.openrewrite.maven.tree.Dependency> gaToRequested = requested.stream().collect(Collectors.toMap(GradleProjectBuilder::groupArtifact, dep -> dep, (a, b) -> a));
                if (conf.isCanBeResolved()) {
                    ResolvedConfiguration resolvedConf = conf.getResolvedConfiguration();
                    Map<GroupArtifact, ResolvedDependency> gaToResolved = resolvedConf.getFirstLevelModuleDependencies().stream().collect(Collectors.toMap(GradleProjectBuilder::groupArtifact, dep -> dep, (a, b) -> a));
                    resolved = GradleProjectBuilder.resolved(gaToRequested, gaToResolved);
                } else {
                    resolved = Collections.emptyList();
                }
                GradleDependencyConfiguration dc = new GradleDependencyConfiguration(conf.getName(), conf.getDescription(), conf.isTransitive(), conf.isCanBeResolved(), conf.isCanBeConsumed(), Collections.emptyList(), requested, resolved);
                results.put(conf.getName(), dc);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to parse dependencies from configuration " + conf.getName(), e);
            }
        }
        for (Configuration conf : configurations) {
            GradleDependencyConfiguration dc;
            if (conf.getExtendsFrom().isEmpty() || (dc = (GradleDependencyConfiguration)results.get(conf.getName())) == null) continue;
            List<GradleDependencyConfiguration> extendsFrom = conf.getExtendsFrom().stream().map(it -> (GradleDependencyConfiguration)results.get(it.getName())).collect(Collectors.toList());
            dc.unsafeSetExtendsFrom(extendsFrom);
        }
        return results;
    }

    private static org.openrewrite.maven.tree.Dependency dependency(Dependency dep, Configuration configuration) {
        GroupArtifactVersion gav = GradleProjectBuilder.groupArtifactVersion(dep);
        return requestedCache.computeIfAbsent(gav, it -> org.openrewrite.maven.tree.Dependency.builder().gav(gav).type("jar").scope(configuration.getName()).exclusions(Collections.emptyList()).build());
    }

    private static List<org.openrewrite.maven.tree.ResolvedDependency> resolved(Map<GroupArtifact, org.openrewrite.maven.tree.Dependency> gaToRequested, Map<GroupArtifact, ResolvedDependency> gaToResolved) {
        HashMap resolvedCache = new HashMap();
        return gaToResolved.entrySet().stream().map(entry -> {
            GroupArtifact ga = (GroupArtifact)entry.getKey();
            ResolvedDependency resolved = (ResolvedDependency)entry.getValue();
            ResolvedGroupArtifactVersion resolvedGav = GradleProjectBuilder.resolvedGroupArtifactVersion(resolved);
            org.openrewrite.maven.tree.ResolvedDependency resolvedDependency = (org.openrewrite.maven.tree.ResolvedDependency)resolvedCache.get(resolvedGav);
            if (resolvedDependency == null) {
                resolvedDependency = org.openrewrite.maven.tree.ResolvedDependency.builder().gav(resolvedGav).requested(gaToRequested.getOrDefault(ga, GradleProjectBuilder.dependency(resolved))).dependencies(resolved.getChildren().stream().map(child -> GradleProjectBuilder.resolved(child, 1, resolvedCache)).collect(Collectors.toList())).licenses(Collections.emptyList()).depth(0).build();
                resolvedCache.put(resolvedGav, resolvedDependency);
            }
            return resolvedDependency;
        }).collect(Collectors.toList());
    }

    private static org.openrewrite.maven.tree.Dependency dependency(ResolvedDependency dep) {
        GroupArtifactVersion gav = GradleProjectBuilder.groupArtifactVersion(dep);
        return requestedCache.computeIfAbsent(gav, it -> org.openrewrite.maven.tree.Dependency.builder().gav(gav).type("jar").scope(dep.getConfiguration()).exclusions(Collections.emptyList()).build());
    }

    private static org.openrewrite.maven.tree.ResolvedDependency resolved(ResolvedDependency dep, int depth, Map<ResolvedGroupArtifactVersion, org.openrewrite.maven.tree.ResolvedDependency> resolvedCache) {
        ResolvedGroupArtifactVersion resolvedGav = GradleProjectBuilder.resolvedGroupArtifactVersion(dep);
        org.openrewrite.maven.tree.ResolvedDependency resolvedDependency = resolvedCache.get(resolvedGav);
        if (resolvedDependency == null) {
            ArrayList dependencies = new ArrayList();
            resolvedDependency = org.openrewrite.maven.tree.ResolvedDependency.builder().gav(resolvedGav).requested(GradleProjectBuilder.dependency(dep)).dependencies(dependencies).licenses(Collections.emptyList()).depth(depth).build();
            resolvedCache.put(resolvedGav, resolvedDependency);
            dep.getChildren().forEach(child -> dependencies.add(GradleProjectBuilder.resolved(child, depth + 1, resolvedCache)));
        }
        return resolvedDependency;
    }

    public static void clearCaches() {
        requestedCache.clear();
        groupArtifactCache.clear();
        groupArtifactVersionCache.clear();
        resolvedGroupArtifactVersionCache.clear();
    }
}

