/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.marker;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.toolingapi.Dependency;
import org.openrewrite.gradle.toolingapi.ResolvedDependency;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

public final class GradleDependencyConfiguration
implements Serializable {
    private final String name;
    @Nullable
    private final String description;
    private final boolean isTransitive;
    private final boolean isCanBeResolved;
    private List<GradleDependencyConfiguration> extendsFrom;
    private final List<org.openrewrite.maven.tree.Dependency> requested;
    private final List<org.openrewrite.maven.tree.ResolvedDependency> resolved;

    public static GradleDependencyConfiguration fromToolingModel(org.openrewrite.gradle.toolingapi.GradleDependencyConfiguration config) {
        return new GradleDependencyConfiguration(config.getName(), config.getDescription(), false, true, config.getExtendsFrom().stream().map(GradleDependencyConfiguration::fromToolingModel).collect(Collectors.toList()), config.getRequested().stream().map(GradleDependencyConfiguration::fromToolingModel).collect(Collectors.toList()), config.getResolved().stream().map(GradleDependencyConfiguration::fromToolingModel).collect(Collectors.toList()));
    }

    void unsafeSetExtendsFrom(List<GradleDependencyConfiguration> extendsFrom) {
        this.extendsFrom = extendsFrom;
    }

    private static org.openrewrite.maven.tree.ResolvedDependency fromToolingModel(ResolvedDependency dep) {
        return org.openrewrite.maven.tree.ResolvedDependency.builder().repository(GradleProject.fromToolingModel(dep.getRepository())).gav(GradleDependencyConfiguration.fromToolingModel(dep.getGav())).requested(GradleDependencyConfiguration.fromToolingModel(dep.getRequested())).dependencies(dep.getDependencies().stream().map(GradleDependencyConfiguration::fromToolingModel).collect(Collectors.toList())).licenses(Collections.emptyList()).depth(dep.getDepth()).build();
    }

    private static org.openrewrite.maven.tree.Dependency fromToolingModel(Dependency dep) {
        return org.openrewrite.maven.tree.Dependency.builder().gav(GradleDependencyConfiguration.fromToolingModel(dep.getGav())).scope(dep.getScope()).type(dep.getType()).exclusions(dep.getExclusions().stream().map(GradleDependencyConfiguration::fromToolingModel).collect(Collectors.toList())).optional(dep.getOptional()).build();
    }

    private static GroupArtifact fromToolingModel(org.openrewrite.gradle.toolingapi.GroupArtifact ga) {
        return new GroupArtifact(ga.getGroupId(), ga.getArtifactId());
    }

    private static GroupArtifactVersion fromToolingModel(org.openrewrite.gradle.toolingapi.GroupArtifactVersion gav) {
        return new GroupArtifactVersion(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
    }

    private static ResolvedGroupArtifactVersion fromToolingModel(org.openrewrite.gradle.toolingapi.ResolvedGroupArtifactVersion gav) {
        return new ResolvedGroupArtifactVersion(null, gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), gav.getDatedSnapshotVersion());
    }

    public GradleDependencyConfiguration(String name, String description, boolean isTransitive, boolean isCanBeResolved, List<GradleDependencyConfiguration> extendsFrom, List<org.openrewrite.maven.tree.Dependency> requested, List<org.openrewrite.maven.tree.ResolvedDependency> resolved) {
        this.name = name;
        this.description = description;
        this.isTransitive = isTransitive;
        this.isCanBeResolved = isCanBeResolved;
        this.extendsFrom = extendsFrom;
        this.requested = requested;
        this.resolved = resolved;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isTransitive() {
        return this.isTransitive;
    }

    public boolean isCanBeResolved() {
        return this.isCanBeResolved;
    }

    public List<GradleDependencyConfiguration> getExtendsFrom() {
        return this.extendsFrom;
    }

    public List<org.openrewrite.maven.tree.Dependency> getRequested() {
        return this.requested;
    }

    public List<org.openrewrite.maven.tree.ResolvedDependency> getResolved() {
        return this.resolved;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleDependencyConfiguration)) {
            return false;
        }
        GradleDependencyConfiguration other = (GradleDependencyConfiguration)o;
        if (this.isTransitive() != other.isTransitive()) {
            return false;
        }
        if (this.isCanBeResolved() != other.isCanBeResolved()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<GradleDependencyConfiguration> this$extendsFrom = this.getExtendsFrom();
        List<GradleDependencyConfiguration> other$extendsFrom = other.getExtendsFrom();
        if (this$extendsFrom == null ? other$extendsFrom != null : !((Object)this$extendsFrom).equals(other$extendsFrom)) {
            return false;
        }
        List<org.openrewrite.maven.tree.Dependency> this$requested = this.getRequested();
        List<org.openrewrite.maven.tree.Dependency> other$requested = other.getRequested();
        if (this$requested == null ? other$requested != null : !((Object)this$requested).equals(other$requested)) {
            return false;
        }
        List<org.openrewrite.maven.tree.ResolvedDependency> this$resolved = this.getResolved();
        List<org.openrewrite.maven.tree.ResolvedDependency> other$resolved = other.getResolved();
        return !(this$resolved == null ? other$resolved != null : !((Object)this$resolved).equals(other$resolved));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTransitive() ? 79 : 97);
        result = result * 59 + (this.isCanBeResolved() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<GradleDependencyConfiguration> $extendsFrom = this.getExtendsFrom();
        result = result * 59 + ($extendsFrom == null ? 43 : ((Object)$extendsFrom).hashCode());
        List<org.openrewrite.maven.tree.Dependency> $requested = this.getRequested();
        result = result * 59 + ($requested == null ? 43 : ((Object)$requested).hashCode());
        List<org.openrewrite.maven.tree.ResolvedDependency> $resolved = this.getResolved();
        result = result * 59 + ($resolved == null ? 43 : ((Object)$resolved).hashCode());
        return result;
    }

    public String toString() {
        return "GradleDependencyConfiguration(name=" + this.getName() + ", description=" + this.getDescription() + ", isTransitive=" + this.isTransitive() + ", isCanBeResolved=" + this.isCanBeResolved() + ", extendsFrom=" + this.getExtendsFrom() + ", requested=" + this.getRequested() + ", resolved=" + this.getResolved() + ")";
    }

    public GradleDependencyConfiguration withName(String name) {
        return this.name == name ? this : new GradleDependencyConfiguration(name, this.description, this.isTransitive, this.isCanBeResolved, this.extendsFrom, this.requested, this.resolved);
    }

    public GradleDependencyConfiguration withDescription(String description) {
        return this.description == description ? this : new GradleDependencyConfiguration(this.name, description, this.isTransitive, this.isCanBeResolved, this.extendsFrom, this.requested, this.resolved);
    }

    public GradleDependencyConfiguration withTransitive(boolean isTransitive) {
        return this.isTransitive == isTransitive ? this : new GradleDependencyConfiguration(this.name, this.description, isTransitive, this.isCanBeResolved, this.extendsFrom, this.requested, this.resolved);
    }

    public GradleDependencyConfiguration withCanBeResolved(boolean isCanBeResolved) {
        return this.isCanBeResolved == isCanBeResolved ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, isCanBeResolved, this.extendsFrom, this.requested, this.resolved);
    }

    public GradleDependencyConfiguration withExtendsFrom(List<GradleDependencyConfiguration> extendsFrom) {
        return this.extendsFrom == extendsFrom ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, extendsFrom, this.requested, this.resolved);
    }

    public GradleDependencyConfiguration withRequested(List<org.openrewrite.maven.tree.Dependency> requested) {
        return this.requested == requested ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.extendsFrom, requested, this.resolved);
    }

    public GradleDependencyConfiguration withResolved(List<org.openrewrite.maven.tree.ResolvedDependency> resolved) {
        return this.resolved == resolved ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.extendsFrom, this.requested, resolved);
    }
}

