/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.marker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradlePluginDescriptor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.MavenRepository;

public final class GradleProject
implements Marker {
    private final UUID id;
    private final String name;
    private final String path;
    private final List<GradlePluginDescriptor> plugins;
    private final List<MavenRepository> mavenRepositories;
    private final Map<String, GradleDependencyConfiguration> nameToConfiguration;

    public GradleDependencyConfiguration getConfiguration(String name) {
        return this.nameToConfiguration.get(name);
    }

    public List<GradleDependencyConfiguration> getConfigurations() {
        return new ArrayList<GradleDependencyConfiguration>(this.nameToConfiguration.values());
    }

    @Nullable
    public Dependency findDependency(String configuration, String groupId, String artifactId) {
        return this.nameToConfiguration.get(configuration).getRequested().stream().filter(d -> StringUtils.matchesGlob((String)d.getGav().getGroupId(), (String)groupId) && StringUtils.matchesGlob((String)d.getGav().getArtifactId(), (String)artifactId)).findFirst().orElse(null);
    }

    public GradleProject(UUID id, String name, String path, List<GradlePluginDescriptor> plugins, List<MavenRepository> mavenRepositories, Map<String, GradleDependencyConfiguration> nameToConfiguration) {
        this.id = id;
        this.name = name;
        this.path = path;
        this.plugins = plugins;
        this.mavenRepositories = mavenRepositories;
        this.nameToConfiguration = nameToConfiguration;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public List<GradlePluginDescriptor> getPlugins() {
        return this.plugins;
    }

    public List<MavenRepository> getMavenRepositories() {
        return this.mavenRepositories;
    }

    public Map<String, GradleDependencyConfiguration> getNameToConfiguration() {
        return this.nameToConfiguration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleProject)) {
            return false;
        }
        GradleProject other = (GradleProject)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        List<GradlePluginDescriptor> this$plugins = this.getPlugins();
        List<GradlePluginDescriptor> other$plugins = other.getPlugins();
        if (this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins)) {
            return false;
        }
        List<MavenRepository> this$mavenRepositories = this.getMavenRepositories();
        List<MavenRepository> other$mavenRepositories = other.getMavenRepositories();
        if (this$mavenRepositories == null ? other$mavenRepositories != null : !((Object)this$mavenRepositories).equals(other$mavenRepositories)) {
            return false;
        }
        Map<String, GradleDependencyConfiguration> this$nameToConfiguration = this.getNameToConfiguration();
        Map<String, GradleDependencyConfiguration> other$nameToConfiguration = other.getNameToConfiguration();
        return !(this$nameToConfiguration == null ? other$nameToConfiguration != null : !((Object)this$nameToConfiguration).equals(other$nameToConfiguration));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        List<GradlePluginDescriptor> $plugins = this.getPlugins();
        result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
        List<MavenRepository> $mavenRepositories = this.getMavenRepositories();
        result = result * 59 + ($mavenRepositories == null ? 43 : ((Object)$mavenRepositories).hashCode());
        Map<String, GradleDependencyConfiguration> $nameToConfiguration = this.getNameToConfiguration();
        result = result * 59 + ($nameToConfiguration == null ? 43 : ((Object)$nameToConfiguration).hashCode());
        return result;
    }

    public String toString() {
        return "GradleProject(id=" + this.getId() + ", name=" + this.getName() + ", path=" + this.getPath() + ", plugins=" + this.getPlugins() + ", mavenRepositories=" + this.getMavenRepositories() + ", nameToConfiguration=" + this.getNameToConfiguration() + ")";
    }

    public GradleProject withId(UUID id) {
        return this.id == id ? this : new GradleProject(id, this.name, this.path, this.plugins, this.mavenRepositories, this.nameToConfiguration);
    }

    public GradleProject withName(String name) {
        return this.name == name ? this : new GradleProject(this.id, name, this.path, this.plugins, this.mavenRepositories, this.nameToConfiguration);
    }

    public GradleProject withPath(String path) {
        return this.path == path ? this : new GradleProject(this.id, this.name, path, this.plugins, this.mavenRepositories, this.nameToConfiguration);
    }

    public GradleProject withPlugins(List<GradlePluginDescriptor> plugins) {
        return this.plugins == plugins ? this : new GradleProject(this.id, this.name, this.path, plugins, this.mavenRepositories, this.nameToConfiguration);
    }

    public GradleProject withMavenRepositories(List<MavenRepository> mavenRepositories) {
        return this.mavenRepositories == mavenRepositories ? this : new GradleProject(this.id, this.name, this.path, this.plugins, mavenRepositories, this.nameToConfiguration);
    }

    public GradleProject withNameToConfiguration(Map<String, GradleDependencyConfiguration> nameToConfiguration) {
        return this.nameToConfiguration == nameToConfiguration ? this : new GradleProject(this.id, this.name, this.path, this.plugins, this.mavenRepositories, nameToConfiguration);
    }
}

