/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.butterfly;

import edu.mit.simile.butterfly.Butterfly;
import edu.mit.simile.butterfly.ButterflyModule;
import edu.mit.simile.butterfly.MountPoint;
import edu.mit.simile.butterfly.Zone;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ButterflyMounter {
    private static final Logger logger = LoggerFactory.getLogger((String)"butterfly.mounter");
    private ButterflyModule rootModule;
    private Map<MountPoint, ButterflyModule> modulesByMountPoint = new HashMap<MountPoint, ButterflyModule>();
    private Map<String, Set<ButterflyModule>> modulesByMountPath = new HashMap<String, Set<ButterflyModule>>();
    private Zone rootZone;
    public static final String ROOT_ZONE = "root";
    private LinkedHashMap<String, Zone> zonesByName = new LinkedHashMap();
    private LinkedHashMap<String, Zone> zonesByContext = new LinkedHashMap();

    public void register(MountPoint mountPoint, ButterflyModule module) {
        module.setMountPoint(mountPoint);
        if (mountPoint.equals(MountPoint.ROOT)) {
            this.rootModule = module;
        }
        this.modulesByMountPoint.put(mountPoint, module);
        String mountPath = mountPoint.getMountPoint();
        Set<ButterflyModule> modules = this.modulesByMountPath.get(mountPath);
        if (modules == null) {
            modules = new HashSet<ButterflyModule>();
            this.modulesByMountPath.put(mountPath, modules);
        }
        modules.add(module);
    }

    public boolean isRegistered(MountPoint mountPoint) {
        return this.modulesByMountPoint.containsKey(mountPoint);
    }

    public ButterflyModule getRootModule() {
        return this.rootModule;
    }

    public ButterflyModule getModule(String path, Zone zone) {
        ButterflyModule m = null;
        String p = path;
        while (m == null) {
            int index = p.lastIndexOf(47);
            if (index >= 0) {
                String leader = p.substring(0, index + 1);
                Set<ButterflyModule> mods = this.modulesByMountPath.get(leader);
                if (mods != null) {
                    if (mods.size() == 1) {
                        m = mods.iterator().next();
                    } else {
                        for (ButterflyModule mod : mods) {
                            String z = mod.getMountPoint().getZone();
                            if (z == null) {
                                m = mod;
                                continue;
                            }
                            if (!z.equals(zone.getName())) continue;
                            m = mod;
                            break;
                        }
                    }
                }
                if (m != null) continue;
                p = leader.substring(0, leader.length() - 1);
                continue;
            }
            m = this.rootModule;
        }
        return m;
    }

    public Set<String> getMountPaths() {
        return this.modulesByMountPath.keySet();
    }

    public void setDefaultZone(String name) {
        this.rootZone = this.zonesByName.get(name);
    }

    public void registerZone(String name, String zoneURL) {
        if (zoneURL.charAt(zoneURL.length() - 1) == '/') {
            zoneURL = zoneURL.substring(0, zoneURL.length() - 1);
        }
        logger.trace("Register Zone: {} -> {}", (Object)name, (Object)zoneURL);
        Zone z = new Zone(name, zoneURL);
        this.zonesByName.put(name, z);
        this.zonesByContext.put(zoneURL, z);
    }

    public Zone getZone(HttpServletRequest request) {
        logger.trace("> getZone");
        Zone zone = null;
        String zoneHeader = request.getHeader("X-Context-Path");
        if (zoneHeader != null) {
            String context = Butterfly.getTrueContextPath(request, true);
            logger.debug("absolute context: {}", (Object)context);
            zone = this.zonesByContext.get(context);
            if (zone == null) {
                context = Butterfly.getTrueContextPath(request, false);
                logger.debug("relative context: {}", (Object)context);
                zone = this.zonesByContext.get(context);
            }
        }
        if (zone == null) {
            logger.debug("defaulting to root zone");
            zone = this.rootZone;
        }
        logger.trace("< getZone -> {}");
        return zone;
    }

    public int size() {
        return this.zonesByName.size();
    }
}

