/*
 * Decompiled with CFR 0.152.
 */
package com.colloquial.arithcode.ppm;

import com.colloquial.arithcode.ppm.ByteBuffer;
import com.colloquial.arithcode.ppm.ByteSet;
import com.colloquial.arithcode.ppm.Converter;

final class PPMNode {
    final byte _byte;
    private short _count = 1;
    private short _numberOfOutcomes;
    PPMNode _firstChild;
    PPMNode _nextSibling;
    private static final int MIN_COUNT = 128;
    private static final int MAX_INDIVIDUAL_COUNT = 8192;

    PPMNode(byte b, PPMNode nextSibling) {
        this._byte = b;
        this._nextSibling = nextSibling;
    }

    PPMNode(byte b) {
        this(b, null);
    }

    boolean isDeterministic(ByteSet excludedBytes) {
        return this._firstChild._nextSibling == null;
    }

    boolean isChildless(ByteSet excludedBytes) {
        PPMNode node = this._firstChild;
        while (node != null) {
            if (!excludedBytes.contains(node._byte)) {
                return false;
            }
            node = node._nextSibling;
        }
        return true;
    }

    int totalCount(ByteSet excludedBytes) {
        int count = this._numberOfOutcomes;
        PPMNode child = this._firstChild;
        while (child != null) {
            if (!excludedBytes.contains(child._byte)) {
                count += child._count;
            }
            child = child._nextSibling;
        }
        return count;
    }

    void interval(int i, ByteSet excludedBytes, int[] result) {
        this.interval(Converter.integerToByte(i), excludedBytes, result);
    }

    private void interval(byte b, ByteSet excludedBytes, int[] result) {
        result[0] = 0;
        PPMNode dtrNode = this._firstChild;
        while (dtrNode != null) {
            if (!excludedBytes.contains(dtrNode._byte)) {
                if (dtrNode._byte == b) {
                    result[1] = result[0] + dtrNode._count;
                    result[2] = result[1] + this._numberOfOutcomes;
                    dtrNode = dtrNode._nextSibling;
                    while (dtrNode != null) {
                        if (!excludedBytes.contains(dtrNode._byte)) {
                            result[2] = result[2] + dtrNode._count;
                        }
                        dtrNode = dtrNode._nextSibling;
                    }
                    return;
                }
                result[0] = result[0] + dtrNode._count;
            }
            dtrNode = dtrNode._nextSibling;
        }
    }

    void intervalEscape(ByteSet excludedBytes, int[] result) {
        result[2] = result[1] = this.totalCount(excludedBytes);
        result[0] = result[1] - this._numberOfOutcomes;
    }

    void increment(ByteBuffer buffer) {
        if (buffer.length() > 0) {
            this.increment(buffer.bytes(), buffer.offset(), buffer.length());
        }
    }

    boolean hasDaughter(int i) {
        return this.hasDaughter(Converter.integerToByte(i));
    }

    private boolean hasDaughter(byte b) {
        PPMNode dtrNode = this._firstChild;
        while (dtrNode != null) {
            if (dtrNode._byte == b) {
                return true;
            }
            dtrNode = dtrNode._nextSibling;
        }
        return false;
    }

    int pointToSymbol(int midCount, ByteSet excludedBytes) {
        int highCount = 0;
        PPMNode child = this._firstChild;
        while (child != null) {
            if (!excludedBytes.contains(child._byte) && (highCount += child._count) > midCount) {
                return Converter.byteToInteger(child._byte);
            }
            child = child._nextSibling;
        }
        return -2;
    }

    void complete(byte[] bytes, int offset, int length) {
        PPMNode node = this;
        while (length > 0) {
            node._numberOfOutcomes = (short)(node._numberOfOutcomes + 1);
            node = node._firstChild = new PPMNode(bytes[offset]);
            ++offset;
            --length;
        }
    }

    void increment(byte[] bytes, int offset, int length) {
        if (this._firstChild == null) {
            this._numberOfOutcomes = (short)(this._numberOfOutcomes + 1);
            this._firstChild = new PPMNode(bytes[offset]);
            if (length > 1) {
                this._firstChild.complete(bytes, offset + 1, length - 1);
            }
            return;
        }
        PPMNode previousChild = null;
        PPMNode child = this._firstChild;
        while (true) {
            if (child._byte == bytes[offset]) {
                if (length > 1) {
                    child.increment(bytes, offset + 1, length - 1);
                }
                if (previousChild != null) {
                    previousChild._nextSibling = child._nextSibling;
                    child._nextSibling = this._firstChild;
                    this._firstChild = child;
                }
                if ((child._count = (short)(child._count + 1)) > 8192) {
                    this.rescale();
                }
                return;
            }
            if (child._nextSibling == null) {
                this._numberOfOutcomes = (short)(this._numberOfOutcomes + 1);
                this._firstChild = new PPMNode(bytes[offset], this._firstChild);
                if (length > 1) {
                    this._firstChild.complete(bytes, offset + 1, length - 1);
                }
                return;
            }
            previousChild = child;
            child = child._nextSibling;
        }
    }

    private void rescale() {
        this._numberOfOutcomes = (short)((this._numberOfOutcomes + 1) / 2);
        this._firstChild = this._firstChild.rescaleSiblings();
    }

    private PPMNode rescaleSiblings() {
        this._count = (short)(this._count >> 1);
        if (this._nextSibling == null) {
            return this._count < 128 ? null : this;
        }
        if (this._count < 128) {
            return this._nextSibling.rescaleSiblings();
        }
        this._nextSibling = this._nextSibling.rescaleSiblings();
        return this;
    }
}

