/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.util;

import java.io.IOException;
import java.io.InputStream;

public class TrackingInputStream
extends InputStream {
    private final InputStream is;
    protected long bytesRead;

    public TrackingInputStream(InputStream is) {
        this.is = is;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public int read() throws IOException {
        return (int)this.track(this.is.read());
    }

    @Override
    public int read(byte[] b) throws IOException {
        return (int)this.track(this.is.read(b));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return (int)this.track(this.is.read(b, off, len));
    }

    @Override
    public long skip(long n) throws IOException {
        return this.track(this.is.skip(n));
    }

    @Override
    public void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    protected long track(long bytesRead) {
        if (bytesRead > 0L) {
            this.bytesRead += bytesRead;
        }
        return bytesRead;
    }
}

