/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.refine.model.Recon;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;

public class SerializationFilters {
    public static PropertyFilter noFilter = new BaseFilter();
    public static PropertyFilter reconCandidateFilter = new BaseFilter(){

        @Override
        public void serializeAsField(Object obj, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
            if (this.include(writer)) {
                if (!writer.getName().equals("c") || !(obj instanceof Recon)) {
                    writer.serializeAsField(obj, jgen, provider);
                    return;
                }
                Recon recon = (Recon)obj;
                if (recon.judgment == Recon.Judgment.None) {
                    writer.serializeAsField(obj, jgen, provider);
                }
            } else if (!jgen.canOmitFields()) {
                writer.serializeAsOmittedField(obj, jgen, provider);
            }
        }
    };

    static class BaseFilter
    extends SimpleBeanPropertyFilter {
        BaseFilter() {
        }

        public void serializeAsField(Object obj, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
            if (this.include(writer)) {
                writer.serializeAsField(obj, jgen, provider);
            } else if (!jgen.canOmitFields()) {
                writer.serializeAsOmittedField(obj, jgen, provider);
            }
        }

        protected boolean include(BeanPropertyWriter writer) {
            return true;
        }

        protected boolean include(PropertyWriter writer) {
            return true;
        }
    }

    public static class LocalDateDeserializer
    extends StdDeserializer<LocalDateTime> {
        private static final long serialVersionUID = 93872874L;

        public LocalDateDeserializer() {
            super(LocalDateTime.class);
        }

        public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return ParsingUtilities.stringToLocalDate(p.getValueAsString());
        }
    }

    public static class OffsetDateDeserializer
    extends StdDeserializer<OffsetDateTime> {
        private static final long serialVersionUID = 93872874L;

        public OffsetDateDeserializer() {
            super(OffsetDateTime.class);
        }

        public OffsetDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return ParsingUtilities.stringToDate(p.getValueAsString());
        }
    }

    public static class InstantDeserializer
    extends StdDeserializer<Instant> {
        private static final long serialVersionUID = 93872874L;

        public InstantDeserializer() {
            super(Instant.class);
        }

        public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Instant.parse(p.getValueAsString());
        }
    }

    public static class InstantSerializer
    extends StdSerializer<Instant> {
        private static final long serialVersionUID = 93872874L;

        public InstantSerializer() {
            super(Instant.class);
        }

        public void serialize(Instant arg0, JsonGenerator gen, SerializerProvider s) throws IOException {
            gen.writeString(arg0.toString());
        }
    }

    public static class LocalDateSerializer
    extends StdSerializer<LocalDateTime> {
        private static final long serialVersionUID = 93872874L;

        public LocalDateSerializer() {
            super(LocalDateTime.class);
        }

        public void serialize(LocalDateTime arg0, JsonGenerator gen, SerializerProvider s) throws IOException {
            gen.writeString(ParsingUtilities.localDateToString(arg0));
        }
    }

    public static class OffsetDateSerializer
    extends StdSerializer<OffsetDateTime> {
        private static final long serialVersionUID = 93872874L;

        public OffsetDateSerializer() {
            super(OffsetDateTime.class);
        }

        public void serialize(OffsetDateTime arg0, JsonGenerator gen, SerializerProvider s) throws IOException {
            gen.writeString(ParsingUtilities.dateToString(arg0));
        }
    }

    public static class DoubleSerializer
    extends StdSerializer<Double> {
        private static final long serialVersionUID = 132345L;

        public DoubleSerializer() {
            super(Double.class);
        }

        public void serialize(Double arg0, JsonGenerator gen, SerializerProvider s) throws IOException {
            if (Double.valueOf(arg0.longValue()).equals(arg0)) {
                gen.writeNumber(arg0.longValue());
            } else {
                gen.writeNumber(arg0.doubleValue());
            }
        }
    }
}

