/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.util;

import com.google.refine.RefineServlet;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    static final Logger logger = LoggerFactory.getLogger((String)"http-client");
    private final RequestConfig defaultRequestConfig;
    private HttpClientBuilder httpClientBuilder;
    private CloseableHttpClient httpClient;
    private int _delay;
    private int _retryInterval;
    private HttpHost proxy;
    private int proxyPort;
    private String proxyHost;
    private Pattern nonProxyHosts;
    private DefaultProxyRoutePlanner routePlanner;

    public HttpClient() {
        this(0);
    }

    public HttpClient(int delay) {
        this(delay, Math.max(delay, 200));
    }

    public HttpClient(int delay, int retryInterval) {
        this._delay = delay;
        this._retryInterval = retryInterval;
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(60, TimeUnit.SECONDS).build();
        connManager.setDefaultSocketConfig(socketConfig);
        this.defaultRequestConfig = RequestConfig.custom().setConnectTimeout(60L, TimeUnit.SECONDS).setConnectionRequestTimeout(60L, TimeUnit.SECONDS).build();
        this.httpClientBuilder = HttpClients.custom().setUserAgent(RefineServlet.getUserAgent()).setDefaultRequestConfig(this.defaultRequestConfig).setConnectionManager((HttpClientConnectionManager)connManager).setRetryStrategy((HttpRequestRetryStrategy)new ExponentialBackoffRetryStrategy(3, TimeValue.ofMilliseconds((long)this._retryInterval))).addRequestInterceptorFirst(new HttpRequestInterceptor(){
            private long nextRequestTime = System.currentTimeMillis();

            public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
                long delay = this.nextRequestTime - System.currentTimeMillis();
                if (delay > 0L) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.nextRequestTime = System.currentTimeMillis() + (long)HttpClient.this._delay;
            }
        });
        if ("true".equals(System.getProperty("java.net.useSystemProxies"))) {
            logger.info("Use system defined proxy for http connections");
            this.httpClient = this.httpClientBuilder.useSystemProperties().build();
            return;
        }
        this.proxyHost = System.getProperty("http.proxyHost");
        this.proxyPort = Integer.parseInt(System.getProperty("http.proxyPort", "0"));
        if (this.proxyHost != null && this.proxyPort != 0) {
            this.proxy = new HttpHost("http", this.proxyHost, this.proxyPort);
            logger.info("Use provided proxy " + this.proxy.toString() + " for http connections");
            String strNonProxyHosts = System.getProperty("http.nonProxyHosts");
            this.nonProxyHosts = HttpClient.fromHostsToPattern(strNonProxyHosts);
            if (this.nonProxyHosts != null) {
                logger.info("except for hosts matching " + strNonProxyHosts);
            }
            if (this.proxy != null) {
                this.routePlanner = new DefaultProxyRoutePlanner(this.proxy){

                    protected HttpHost determineProxy(HttpHost target, HttpContext context) throws HttpException {
                        String host = target.getHostName();
                        if (HttpClient.this.nonProxyHosts != null && HttpClient.this.nonProxyHosts.matcher(host).matches()) {
                            return null;
                        }
                        return HttpClient.this.proxy;
                    }
                };
                this.httpClientBuilder.setRoutePlanner((HttpRoutePlanner)this.routePlanner);
            }
        }
        this.httpClient = this.httpClientBuilder.build();
    }

    protected static Pattern fromHostsToPattern(String hostsList) {
        if (hostsList == null) {
            return null;
        }
        String[] hosts = hostsList.split("\\|");
        CharSequence[] rHosts = new String[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            String p = hosts[i];
            rHosts[i] = p.startsWith("*") && p.endsWith("*") ? ".*" + Pattern.quote(p.substring(1, p.length() - 2)) + ".*" : (p.startsWith("*") ? ".*" + Pattern.quote(p.substring(1)) : (p.endsWith("*") ? Pattern.quote(p.substring(0, p.length() - 1)) + ".*" : Pattern.quote(p)));
        }
        return Pattern.compile(String.join((CharSequence)"|", rHosts));
    }

    public String getAsString(final String urlString, Header[] headers) throws IOException {
        HttpClientResponseHandler<String> responseHandler = new HttpClientResponseHandler<String>(){

            public String handleResponse(ClassicHttpResponse response) throws IOException {
                int status = response.getCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    if (entity == null) {
                        throw new IOException("No content found in " + urlString);
                    }
                    try {
                        return EntityUtils.toString((HttpEntity)entity);
                    }
                    catch (ParseException ex) {
                        throw new ClientProtocolException((Throwable)ex);
                    }
                }
                throw new ClientProtocolException(String.format("HTTP error %d : %s for URL %s", status, response.getReasonPhrase(), urlString));
            }
        };
        return this.getResponse(urlString, headers, responseHandler);
    }

    public String getResponse(String urlString, Header[] headers, HttpClientResponseHandler<String> responseHandler) throws IOException {
        HttpGet httpGet = new HttpGet(urlString);
        if (headers != null && headers.length > 0) {
            httpGet.setHeaders(headers);
        }
        httpGet.setConfig(this.defaultRequestConfig);
        return (String)this.httpClient.execute((ClassicHttpRequest)httpGet, responseHandler);
    }

    public String postNameValue(String serviceUrl, String name, String value) throws IOException {
        HttpPost request = new HttpPost(serviceUrl);
        List<BasicNameValuePair> body = Collections.singletonList(new BasicNameValuePair(name, value));
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(body, StandardCharsets.UTF_8));
        try (CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)request);){
            String reasonPhrase = response.getReasonPhrase();
            int statusCode = response.getCode();
            if (statusCode >= 400) {
                throw new IOException(String.format("HTTP error %d : %s for URL %s", statusCode, reasonPhrase, request.getRequestUri()));
            }
            String string = ParsingUtilities.inputStreamToString(response.getEntity().getContent());
            return string;
        }
    }

    class ExponentialBackoffRetryStrategy
    extends DefaultHttpRequestRetryStrategy {
        private final TimeValue defaultInterval;

        public ExponentialBackoffRetryStrategy(int maxRetries, TimeValue defaultRetryInterval) {
            super(maxRetries, defaultRetryInterval);
            this.defaultInterval = defaultRetryInterval;
        }

        public TimeValue getRetryInterval(HttpResponse response, int execCount, HttpContext context) {
            TimeValue interval = super.getRetryInterval(response, execCount, context);
            if (interval.compareTo(this.defaultInterval) == 0) {
                interval = TimeValue.of((long)Double.valueOf(Math.pow(2.0, execCount - 1) * (double)this.defaultInterval.getDuration()).longValue(), (TimeUnit)this.defaultInterval.getTimeUnit());
                logger.warn("Retrying HTTP request after " + interval.toString());
                return interval;
            }
            logger.warn("Retrying HTTP request after " + interval.toString());
            return interval;
        }

        public boolean handleAsIdempotent(HttpRequest request) {
            return true;
        }
    }
}

