/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.sorting;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.sorting.Criterion;
import java.text.CollationKey;
import java.text.Collator;

public class StringCriterion
extends Criterion {
    @JsonProperty(value="caseSensitive")
    public boolean caseSensitive;
    @JsonIgnore
    Collator collator = Collator.getInstance();

    public StringCriterion() {
        this.collator.setDecomposition(2);
    }

    @Override
    public Criterion.KeyMaker createKeyMaker() {
        this.collator.setStrength(this.caseSensitive ? 3 : 1);
        return new Criterion.KeyMaker(){

            @Override
            protected Object makeKey(Object value) {
                return StringCriterion.this.collator.getCollationKey(ExpressionUtils.isNonBlankData(value) && !(value instanceof String) ? value.toString() : (String)value);
            }

            @Override
            public int compareKeys(Object key1, Object key2) {
                return ((CollationKey)key1).compareTo((CollationKey)key2);
            }
        };
    }

    @Override
    public String getValueType() {
        return "string";
    }
}

