/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.sorting;

import com.google.refine.expr.EvalError;
import com.google.refine.model.Project;
import com.google.refine.sorting.Criterion;
import com.google.refine.sorting.SortingConfig;
import java.util.List;

public abstract class BaseSorter {
    protected Criterion[] _criteria;
    protected Criterion.KeyMaker[] _keyMakers;
    protected ComparatorWrapper[] _comparatorWrappers;
    protected List<Object[]> _keys;

    public void initializeFromConfig(Project project, SortingConfig config) {
        this._criteria = config.getCriteria();
        int count = this._criteria.length;
        this._keyMakers = new Criterion.KeyMaker[count];
        this._comparatorWrappers = new ComparatorWrapper[count];
        for (int i = 0; i < count; ++i) {
            this._keyMakers[i] = this._criteria[i].createKeyMaker();
            this._comparatorWrappers[i] = new ComparatorWrapper(i);
        }
    }

    public boolean hasCriteria() {
        return this._criteria != null && this._criteria.length > 0;
    }

    protected abstract Object makeKey(Project var1, Criterion.KeyMaker var2, Criterion var3, Object var4, int var5);

    protected Object[] makeKeys(Project project, Object o, int index) {
        Object[] keys = new Object[this._keyMakers.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.makeKey(project, this._keyMakers[i], this._criteria[i], o, index);
        }
        return keys;
    }

    protected int compare(Project project, Object o1, int i1, Object o2, int i2) {
        int c = 0;
        for (int i = 0; c == 0 && i < this._comparatorWrappers.length; ++i) {
            c = this._comparatorWrappers[i].compare(project, o1, i1, o2, i2);
        }
        return c;
    }

    public class ComparatorWrapper {
        public final int criterionIndex;
        protected final int multiplier;

        public ComparatorWrapper(int criterionIndex) {
            this.criterionIndex = criterionIndex;
            this.multiplier = BaseSorter.this._criteria[criterionIndex].reverse ? -1 : 1;
        }

        public Object getKey(Project project, Object o, int index) {
            while (index >= BaseSorter.this._keys.size()) {
                BaseSorter.this._keys.add(null);
            }
            Object[] keys = BaseSorter.this._keys.get(index);
            if (keys == null) {
                keys = BaseSorter.this.makeKeys(project, o, index);
                BaseSorter.this._keys.set(index, keys);
            }
            return keys[this.criterionIndex];
        }

        public int compare(Project project, Object o1, int i1, Object o2, int i2) {
            Criterion c = BaseSorter.this._criteria[this.criterionIndex];
            Object key1 = this.getKey(project, o1, i1);
            Object key2 = this.getKey(project, o2, i2);
            if (key1 == null) {
                if (key2 == null) {
                    return 0;
                }
                if (key2 instanceof EvalError) {
                    return c.blankPosition - c.errorPosition;
                }
                return c.blankPosition;
            }
            if (key1 instanceof EvalError) {
                if (key2 == null) {
                    return c.errorPosition - c.blankPosition;
                }
                if (key2 instanceof EvalError) {
                    return 0;
                }
                return c.errorPosition;
            }
            if (key2 == null) {
                return -c.blankPosition;
            }
            if (key2 instanceof EvalError) {
                return -c.errorPosition;
            }
            return BaseSorter.this._keyMakers[this.criterionIndex].compareKeys(key1, key2) * this.multiplier;
        }
    }
}

