/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.process;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.history.HistoryEntry;
import com.google.refine.history.HistoryProcess;
import com.google.refine.process.Process;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ProcessManager {
    @JsonProperty(value="processes")
    protected List<Process> _processes = Collections.synchronizedList(new LinkedList());
    @JsonIgnore
    protected List<Exception> _latestExceptions = null;

    @JsonProperty(value="exceptions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ExceptionMessage> getJsonExceptions() {
        if (this._latestExceptions != null) {
            return this._latestExceptions.stream().map(e -> new ExceptionMessage((Exception)e)).collect(Collectors.toList());
        }
        return null;
    }

    public HistoryEntry queueProcess(Process process) throws Exception {
        if (process.isImmediate() && this._processes.size() == 0) {
            this._latestExceptions = null;
            return process.performImmediate();
        }
        this._processes.add(process);
        this.update();
        return null;
    }

    public boolean queueProcess(HistoryProcess process) throws Exception {
        if (process.isImmediate() && this._processes.size() == 0) {
            this._latestExceptions = null;
            return process.performImmediate() != null;
        }
        this._processes.add(process);
        this.update();
        return false;
    }

    public boolean hasPending() {
        return this._processes.size() > 0;
    }

    public void onDoneProcess(Process p) {
        this._processes.remove(p);
        this.update();
    }

    public void onFailedProcess(Process p, Exception exception) {
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        exceptions.add(exception);
        this.onFailedProcess(p, exceptions);
    }

    public void onFailedProcess(Process p, List<Exception> exceptions) {
        this._latestExceptions = exceptions;
        this._processes.remove(p);
    }

    public void cancelAll() {
        for (Process p : this._processes) {
            if (p.isImmediate() || !p.isRunning()) continue;
            p.cancel();
        }
        this._processes.clear();
        this._latestExceptions = null;
    }

    protected void update() {
        while (this._processes.size() > 0) {
            Process p = this._processes.get(0);
            if (p.isImmediate()) {
                this._latestExceptions = null;
                try {
                    p.performImmediate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this._processes.remove(0);
                continue;
            }
            if (p.isDone()) {
                this._processes.remove(0);
                continue;
            }
            if (p.isRunning()) break;
            this._latestExceptions = null;
            p.startPerforming(this);
            break;
        }
    }

    public static class ExceptionMessage {
        @JsonProperty(value="message")
        public final String message;

        public ExceptionMessage(Exception e) {
            this.message = e.getLocalizedMessage();
        }
    }
}

