/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.preference;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.preference.PreferenceValue;
import com.google.refine.preference.TopList;
import com.google.refine.util.ParsingUtilities;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PreferenceStore {
    public static final String USER_METADATA_KEY = "userMetadata";
    private boolean dirty = false;
    protected Map<String, Object> _prefs = new HashMap<String, Object>();

    public void put(String key, Object value) {
        if (value == null) {
            this._prefs.remove(key);
        } else {
            this._prefs.put(key, value);
        }
        this.dirty = true;
    }

    public Object get(String key) {
        return this._prefs.get(key);
    }

    @JsonIgnore
    public Set<String> getKeys() {
        return this._prefs.keySet();
    }

    @JsonIgnore
    public boolean isDirty() {
        return this.dirty;
    }

    @JsonProperty(value="makeClean")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer markAsClean() {
        this.dirty = false;
        return null;
    }

    @JsonProperty(value="entries")
    public void setEntries(JsonNode entries) {
        Iterator i = entries.fieldNames();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (entries.get(key) == null) continue;
            JsonNode o = entries.get(key);
            Object loaded = PreferenceStore.loadObject(o);
            if (loaded == null && "scripting.starred-expressions".contentEquals(key)) {
                loaded = new TopList(10);
            }
            this._prefs.put(key, loaded);
        }
        this.dirty = false;
    }

    @JsonProperty(value="entries")
    public Map<String, Object> getEntries() {
        return this._prefs;
    }

    public static Object loadObject(JsonNode o) {
        try {
            if (o instanceof ObjectNode) {
                ObjectNode obj2 = (ObjectNode)o;
                return ParsingUtilities.mapper.treeToValue((TreeNode)obj2, PreferenceValue.class);
            }
            if (o instanceof ArrayNode) {
                return o;
            }
            return ParsingUtilities.mapper.treeToValue((TreeNode)o, Object.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

