/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.refine.model.AbstractOperation;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.UnknownOperation;
import java.io.IOException;

public class OperationResolver
extends TypeIdResolverBase {
    protected TypeFactory factory = TypeFactory.defaultInstance();

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }

    public String idFromValue(Object instance) {
        return ((AbstractOperation)instance).getOperationId();
    }

    public String idFromValueAndType(Object instance, Class<?> type) {
        String id = OperationRegistry.s_opClassToName.get(type);
        if (id != null) {
            return id;
        }
        return ((AbstractOperation)instance).getOperationId();
    }

    public JavaType typeFromId(DatabindContext context, String id) throws IOException {
        Class<? extends AbstractOperation> opClass = OperationRegistry.resolveOperationId(id);
        if (opClass == null) {
            opClass = UnknownOperation.class;
        }
        return this.factory.constructSimpleType(opClass, new JavaType[0]);
    }
}

