/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations;

import com.google.refine.model.AbstractOperation;
import edu.mit.simile.butterfly.ButterflyModule;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class OperationRegistry {
    public static final Map<String, List<Class<? extends AbstractOperation>>> s_opNameToClass = new HashMap<String, List<Class<? extends AbstractOperation>>>();
    public static final Map<Class<? extends AbstractOperation>, String> s_opClassToName = new HashMap<Class<? extends AbstractOperation>, String>();

    public static void registerOperation(ButterflyModule module, String name, Class<? extends AbstractOperation> klass) {
        String key = module.getName() + "/" + name;
        s_opClassToName.put(klass, key);
        List<Class<? extends AbstractOperation>> classes = s_opNameToClass.get(key);
        if (classes == null) {
            classes = new LinkedList<Class<? extends AbstractOperation>>();
            s_opNameToClass.put(key, classes);
        }
        classes.add(klass);
    }

    public static Class<? extends AbstractOperation> resolveOperationId(String op) {
        List<Class<? extends AbstractOperation>> classes;
        if (!((String)op).contains("/")) {
            op = "core/" + (String)op;
        }
        if ((classes = s_opNameToClass.get(op)) != null && classes.size() > 0) {
            return classes.get(classes.size() - 1);
        }
        return null;
    }
}

